/****************************************************************************
** $Id: indexcleaner.h,v 1.1.2.1 2003/05/19 02:53:32 mueller Exp $
**
** Copyright (C) 2002 Carsten Pfeiffer <pfeiffer@kde.org>
**
****************************************************************************/

#ifndef INDEXCLEANER_H
#define INDEXCLEANER_H

#include <qobject.h>
#include <qstringlist.h>

class KProcess;

namespace KMrml
{
    class Config;
}

namespace KMrmlConfig
{
    class IndexCleaner : public QObject
    {
        Q_OBJECT

    public:
        IndexCleaner( const QStringList& dirs, const KMrml::Config *config,
                      QObject *parent = 0, const char *name = 0 );
        ~IndexCleaner();

        void start();

    signals:
        void advance( int value );
        void finished();

    private slots:
        void slotExited( KProcess * );

    private:
        int m_stepSize;
        void startNext();

        QStringList m_dirs;
        const KMrml::Config *m_config;
        KProcess *m_process;
    };

}


#endif // INDEXCLEANER_H
