/*     
 **********************************************************************
 *     recmgr.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */

#ifndef _RECORDMGR_H
#define _RECORDMGR_H

struct record 
{
	void *reserved;
	struct sblive_hw *sb_hw;
	u32 recpos;
	u32 recbufsize;
	u32 bufsizereg;
	u8 *recbuffer;
	u32 physaddx;
	u32 samplingrate;
	int is_stereo;
	int is16bit;
	int fSetRecSrc;
	u32 recsrc;
	u32 prevadcidx;
	int pong;
};

/* Recording resources */
#define WAVERECORD_AC97        0x00000001
#define WAVERECORD_E8K         0x00000002

int recmgrInit(struct record *);
int recmgrStartRecord(struct record *);
int recmgrStopRecord(struct record *);
int recmgrSetControl(struct record *, u32, u32);
int recmgrGetPos(struct record *, u32 *);
u32 recmgrGetRecIdx(struct sblive_hw *);


#endif /* _RECORDMGR_H */
