/*
 *   Copyright (c) International Business Machines Corp., 2000-2002
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#ifndef H_FSCKMSGT
#define H_FSCKMSGT

#ifndef _JFS_XCHKDMP
#include "xfsck.h"
#endif

/*
 * The following array contains the text for JFS fsck messages
 *
 * NOTE: the message contained in position i in this array
 *
 *	o is processed according to contents of position i in the
 *	  message protocol array (fsckmsgp.h)
 *
 *	o is translated to the local language in position i+50 in the
 *    JFS message file (source: jfs.txt  binary: jfs.msg, jfsh.msg)
 *	  if and only if it also appears in jfs.txt.
 *
 */

char *MsgText[]={
/*  0*/
    "Operation was successful.\n"
/*  1*/
   ,"FSCK  All observed inconsistencies have been repaired.\n"
/*  2*/
   ,"FSCK  Invalid data format detected in root directory.\n"
/*  3*/
   ,"FSCK  A combination of Minimum Free Blocks and Total Usable Blocks which is inval\
id for the filesystem size was detected in the superblock (%s).\n"
/*  4*/
   ,"FSCK  Invalid block number(s) (%s) detected for file system object %s%s%s.\n"
/*  5*/
   ,"FSCK  File system object %s%s%s has a corrupt backward sibling chain.\n"
/*  6*/
   ,"FSCK  File system object %s%s%s has a corrupt forward sibling chain.\n"
/*  7*/
   ,"FSCK  Inode %s%s has unrecognized type.\n"
/*  8*/
   ,"FSCK  File system object %s%s%s has invalid descriptor (%s).\n"
/*  9*/
   ,"FSCK  Inode %s%s has incorrect link count.\n"
/* 10*/
   ,"FSCK  Directory inode %s%s refers to a nonexistent inode %s%s (entry %s).\n"
/* 11*/
   ,"FSCK  Error (%s,%s) writing to the fsck service log (%s,%s,%s,%s).  \
Continuing.\n"
/* 12*/
   ,"FSCK  The boot sector has been refreshed.\n"
/* 13*/
   ,"FSCK  File system object %s%s%s has corrupt data (%s).\n"
/* 14*/
   ,"FSCK  Invalid data (%s) detected in the superblock (%s).\n"
/* 15*/
   ,"FSCK  Invalid allocation group size in the superblock (%s).\n"
/* 16*/
   ,"FSCK  Invalid filesystem block size in the superblock (%s).\n"
/* 17*/
   ,"FSCK  Invalid filesystem size in the superblock (%s).\n"
/* 18*/
   ,"FSCK  Superblock is corrupt and cannot be repaired \nsince both primary and seconda\
ry copies are corrupt.  \n\nFSCK CANNOT CONTINUE.\n"
/* 19*/
   ,"FSCK  Primary superblock is corrupt and cannot be repaired without write access. \
Continuing. \n"
/* 20*/
   ,"XCHKLOG Unsupported XCHKLOG parameter:   %s\n"
/* 21 */
   ,"FSCK  Invalid magic number in the superblock (%s).\n"
/* 22 */
   ,"FSCK  Invalid version number in the superblock (%s).\n"
/* 23*/
   ,"FSCK  Incorrect maxbud AG detected in Block Map Control Page.\n"
/* 24*/
   ,"FSCK  Incorrect number of free blocks detected in Block Map Control Page.\n"
/* 25*/
   ,"FSCK  In superblock (%s) filesystem block size smaller than volume block size.\n"
/* 26*/
   ,"FSCK  Invalid format detected in Root directory.\n"
/* 27*/
   ,"FSCK  Device parm defaulting to current volume: %s\n"
/* 28*/
   ,"FSCK  Unable to write to boot sector Master Boot Record.  Continuing.\n"
/* 29*/
   ,"FSCK  Secondary file/directory allocation structure (%s) is not a \
correct redundant copy of primary structure.\n"
/* 30*/
   ,"FSCK  Unable to replicate primary file/directory allocation structure \
(%s) to secondary.  FUTURE RECOVERY CAPABILITY IS COMPROMISED.\n"
/* 31*/
   ,"XCHKLOG  fsck service log selected:  MOST RECENT\n"
/* 32*/
   ,"FSCK  MINOR: Cannot create directory lost+found in root directory.  mkdir \
lost+found in the root directory then run fsck with the -f parameter to reconnect\
lost files and/or directories.\n"
/* 33*/
   ,"FSCK  Fileset object %s%s%s:  No paths found.\n"
/* 34*/
   ,"FSCK  The path(s) refer to an unallocated file.\n"
/* 35*/
   ,"XCHKLOG  fsck service log selected:  PREVIOUS\n"
/* 36*/
   ,"FSCK  The path(s) refer to an unallocated file. Will remove.\n"
/* 37*/
   ,"FSCK  Unable to repair primary inode allocation structure (%s). Continuing.\n"
/* 38*/
   ,"FSCK  Root directory has a corrupt tree.\n"
/* 39*/
   ,"FSCK  Initialized tree created for root directory.\n"
/* 40*/
   ,"FSCK  Unable to read primary superblock.\n"
/* 41 */
   ,"fsck service log: INVALID LOG RECORD: SKIPPING ONE OR MORE LOG RECORDS.\n"
/* 42 */
   ,"FSCK  processing started: %s\n"
/* 43*/
   ,"\n********************************************************** \n\n"
/* 44*/
   ,"FSCK  Unable to write primary superblock.\n"
/* 45*/
   ,"FSCK  Fatal error (%s,%s) accessing the filesystem (%s,%s,%s,%s).\n"
/* 46*/
   ,"FSCK  Multiple parent directories for directory %s%s.\n"
/* 47*/
   ,"FSCK  External journal log not supported.\n"
/* 48*/
   ,"FSCK  Duplicate reference to %s block(s) beginning at offset %s found in \
file system object %s%s%s.\n"
/* 49*/
   ,"FSCK  File set metadata inode %s%s is corrupt.\n"
/* 50*/
   ,"FSCK  Fatal error (%s,%s) accessing the workspace (%s,%s,%s,%s).\n"
/* 51*/
   ,"FSCK  Insufficient dynamic storage available for required workspace \
(%s,%s). FSCK CANNOT CONTINUE\n"
/* 52*/
   ,"FSCK  IOCtl(...DSK_GETDEVICEPARAMS...) returned rc = %s\n"
/* 53*/
   ,"FSCK  Filesystem is currently mounted.\n"
/* 54*/
   ,"FSCK  Invalid data (%s) detected in file system object %s%s%s.\n"
/* 55*/
   ,"FSCK  Block size in bytes:  %s\n"
/* 56*/
   ,"FSCK  Filesystem size in blocks:  %s\n"
/* 57*/
   ,"FSCK  Filesystem Summary:\n"
/* 58*/
   ,"FSCK    Blocks in use for inodes:  %s\n"
/* 59*/
   ,"FSCK    Inode count:  %s\n"
/* 60*/
   ,"FSCK    File count:  %s\n"
/* 61 */
   ,"FSCK    Directory count:  %s\n"
/* 62 */
   ,"FSCK  Inode %s%s has references to cross linked blocks.\n"
/* 63*/
   ,"FSCK    Block count:  %s\n"
/* 64*/
   ,"FSCK    Free block count:  %s\n"
/* 65*/
   ,"FSCK  Directory inode %s%s entry %s refers to an illegal inode %s%s.\n"
/* 66*/
   ,"Usage: xchklog [-f filename] [-p] [-V] <device>\n"
/* 67*/
   ,"FSCK  Unable to get path for link from directory %s%s to fileset object %s%s%s.\n"
/* 68*/
   ,"FSCK  Format error in Extended Attributes Space or descriptor.\n"
/* 69*/
   ,"FSCK  Discrepancies detected in the Free Inode Extent List for Allocation \
Group %s%s. (%s)\n"
/* 70*/
   ,"FSCK  MINOR: Unable to reconnect file inode %s%s.  Continuing.\n"
/* 71*/
   ,"FSCK  Directory %s%s entry \"..\" refers to an incorrect parent directory (%s%s).\n"
/* 72*/
   ,"FSCK  Directory inode %s%s entry \"..\" reference to incorrect inode \
corrected.\n"
/* 73*/
   ,"FSCK  Storage allocated to inode %s%s has been cleared.\n"
/* 74*/
   ,"FSCK  Storage allocated to extended attributes for inode \
%s%s has been cleared.\n"
/* 75*/
   ,"FSCK  File inode %s%s has been reconnected to /lost+found/.\n"
/* 76*/
   ,"FSCK  Link count for inode %s%s has been adjusted/corrected.\n"
/* 77*/
   ,"FSCK  IOCtl(...DSK_LOCKDRIVE...) returned rc = %s\n"
/* 78*/
   ,"FSCK  No paths were found for inode %s%s.\n"
/* 79*/
   ,"FSCK  File system object %s%s%s is linked as: %s\n"
/* 80*/
   ,"FSCK  Directory inode %s%s entry reference to inode %s%s removed.\n"
/* 81 */
   ,"FSCK  Invalid fwsp length detected in the superblock (%s).\n"
/* 82 */
   ,"FSCK  Invalid fwsp address detected in the superblock (%s).\n"
/* 83*/
   ,"FSCK  Open(...READONLY...) returned rc = %s\n"
/* 84*/
   ,"FSCK  MINOR: Insufficient dynamic storage to validate extended attributes \
format.\n"
/* 85*/
   ,"FSCK  logredo failed (rc=%s).  fsck continuing.\n"
/* 86*/
   ,"FSCK  logredo returned rc = %s\n"
/* 87*/
   ,"FSCK  Unable to create a lost+found directory in root  because root already \
contains a non-directory object named lost+found.  Rename the existing lost+found \
object in root, mkdir lost+found in the root directory, then run fsck with the \
-f parameter to reconnect lost files and/or directories.\n"
/* 88*/
   ,"FSCK  Checking a mounted filesystem does not produce dependable results.\n"
/* 89*/
   ,"FSCK **** Filesystem was modified. ****\n"
/* 90*/
   ,"FSCK  ujfs_redeterminemedia() returned rc = %s\n"
/* 91*/
   ,"FSCK  Superblock marked.\n"
/* 92*/
   ,"FSCK  %s blocks are missing.\n"
/* 93*/
   ,"FSCK  Unable to write to boot sector.  Continuing.\n"
/* 94*/
   ,"FSCK  No \\lost+found directory found in the filesystem.\n"
/* 95*/
   ,"FSCK  Incorrect link counts detected in the aggregate.\n"
/* 96*/
   ,"FSCK  The Inode Allocation Map control information has an incorrect number of \
backed inodes value for AG %s%s.\n"
/* 97*/
   ,"FSCK  The Inode Allocation Map control information has an incorrect number of \
free inodes value for AG %s%s.\n"
/* 98*/
   ,"FSCK  Unrecoverable error reading %s from %s. FSCK CANNOT CONTINUE.\n"
/* 99*/
   ,"FSCK **Phase 0 - Replay Journal Log\n"
/*100*/
   ,"FSCK **Phase 1 - Check Blocks, Files/Directories, and  Directory Entries\n"
/*101 */
   ,"FSCK **Phase 2 - Count links\n"
/*102 */
   ,"FSCK **Phase 3 - Duplicate Block Rescan and Directory Connectedness\n"
/*103*/
   ,"FSCK **Phase 4 - Report Problems\n"
/*104*/
   ,"FSCK **Phase 5 - Check Connectivity\n"
/*105*/
   ,"FSCK **Phase 6 - Perform Approved Corrections\n"
/*106*/
   ,"FSCK **Phase 7 - Rebuild File/Directory Allocation Maps\n"
/*107*/
   ,"FSCK **Phase 8 - Rebuild Disk Allocation Maps\n"
/*108*/
   ,"FSCK **Phase 9 - Reformat File System Log\n"
/*109*/
   ,"FSCK  Directory has entry for unallocated file %s%s. Will remove.\n"
/*110*/
   ,"FSCK  FATAL ERROR (%s,%s) ON READ Aggregate Inode Table (%s) first extent.\n"
/*111*/
   ,"FSCK  Format error in Extended Attributes Space or descriptor. Will clear.\n"
/*112*/
   ,"FSCK  The extent descriptor for inodes %s through %s is invalid.  (Inode Allocation Map %s%s,\
Inode Allocation Group %s, Extent Index %s).\n"
/*113*/
   ,"FSCK  Extended attributes for file set object %s%s%s have an invalid format.\n"
/*114*/
   ,"FSCK  Superblock marked dirty because repairs are about to be written.\n"
/*115*/
   ,"FSCK Mutually exclusive 'check READ ONLY' and 'fix file system' options specified.\n"
/*116*/
   ,"FSCK   *undefined* \n"
/*117*/
   ,"FSCK Unrecognized FSCK -f parameter value detected:   %s\n"
/*118*/
   ,"FSCK Unsupported FSCK parameter:   %s\n"
/*119*/
   ,"FSCK  logformat failed (rc=%s).  fsck continuing.\n"
/*120*/
   ,"FSCK  logformat returned rc = %s\n"
/*121 */
   ,"FSCK  Unable to read device characteristics.  Boot sector cannot be refreshed.  \
Continuing.\n"
/*122 */
   ,"FSCK  Primary superblock is corrupt.\n"
/*123 */
   ,"FSCK  Inode Allocation Group %s%s is inconsistent.\n"
/*124 */
   ,"FSCK  cannot repair an allocation error for files and/or directories %s through %s.\n"
/*125*/
   ,"FSCK  Root inode is not a directory.\n"
/*126*/
   ,"FSCK  Root inode is not allocated.\n"
/*127*/
   ,"FSCK  Root inode allocated.\n"
/*128*/
   ,"FSCK  Root inode changed to directory.\n"
/*129*/
   ,"FSCK  IOCtl(...DSK_UNLOCKDRIVE...) returned rc = %s\n"
/*130*/
   ,"FSCK  Primary superblock is valid.\n"
/*131*/
   ,"FSCK  processing terminated:  %s  with return code: %s  exit code: %s.\n"
/*132*/
   ,"FSCK  Close returned rc = %s\n"
/*133*/
   ,"FSCK  Using default parameter: -p\n"
/*134*/
   ,"FSCK  Open(...READ/WRITE EXCLUSIVE...) returned rc = %s\n"
/*135*/
   ,"FSCK  One or more directory entry found for unallocated inode %s%s.\n"
/*136*/
   ,"FSCK  cannot recover files and/or directories %s through %s.  \
FSCK CANNOT CONTINUE.\n"
/*137*/
   ,"FSCK  Unrecoverable error writing %s to %s. FSCK CANNOT CONTINUE.\n"
/*138*/
   ,"FSCK  The root directory has an invalid data format.  Will correct.\n"
/*139*/
   ,"FSCK  The root directory has an invalid format.  Will correct.\n"
/*140*/
   ,"FSCK  cannot recover files and/or directories %s through %s.  Will release.\n"
/*141 */
   ,"FSCK  File claims cross linked block(s).\n"
/*142 */
   ,"FSCK  cannot repair the data format error(s) in this file.\n"
/*143*/
   ,"FSCK  cannot repair the format error(s) in this file.\n"
/*144*/
   ,"FSCK  cannot repair %s%s%s.\n"
/*145*/
   ,"FSCK  The current device is:  %s\n"
/*146*/
   ,"FSCK  The type of file system for the device is JFS.\n"
/*147*/
   ,"FSCK  cannot repair %s%s%s.  Will release.\n"
/*148*/
   ,"FSCK  Secondary superblock is valid.\n"
/*149*/
   ,"FSCK  Unable to open for write access.  Proceeding in read-only mode.\n"
/*150 */
   ,"FSCK  Multiple parent directories for directory %s%s.  Will correct.\n"
/*151 */
   ,"FSCK  Directory %s%s entry \"..\" refers to an incorrect parent directory \
(%s%s). Will correct.\n"
/*152*/
   ,"FSCK  %s unexpected blocks detected.\n"
/*153*/
   ,"FSCK  Directories with illegal hard links have been detected.\n"
/*154*/
   ,"FSCK  Directory entries (entries \"..\") referring to incorrect parent \
directories have been detected.\n"
/*155*/
   ,"FSCK  Directory entries for unallocated files have been detected.\n"
/*156*/
   ,"FSCK  Unable to write secondary superblock.\n"
/*157*/
   ,"FSCK  Incorrect link counts have been detected. Will correct.\n"
/*158*/
   ,"FSCK  File set object %s%s%s has inline data conflict (type %s).\n"
/*159*/
   ,"FSCK  Duplicate block references have been detected in Metadata. FSCK CANNOT CONTINUE.\n"
/*160*/
   ,"FSCK  Multiple metadata references to %s blocks beginning at \
offset %s have been detected.\n"
/*161*/
   ,"FSCK  Directory inode %s%s has a node with empty freelist and nonzero freecount.\n"
/*162*/
   ,"FSCK  Unable to read entire first extent of AIT (%s).\n"
/*163*/
   ,"FSCK  Unable to read first extent of AIT (%s).\n"
/*164*/
   ,"FSCK  Unrecoverable error during UNLOCK processing.\n"
/*165*/
   ,"FSCK  Unrecoverable error during CLOSE processing.\n"
/*166*/
   ,"FSCK  The root directory reference (entry \"..\") has been corrected.\n"
/*167*/
   ,"FSCK  %s appears to be the correct path for directory %s%s.\n"
/*168*/
   ,"FSCK  Directory inode %s%s has illegal hard links.\n"
/*169*/
   ,"FSCK  Directory inode %s%s refers (entry \"..\") to an incorrect inode (%s%s).\n"
/*170*/
   ,"FSCK  One or more directory entry found for unallocated inode %s%s.\n"
/*171*/
   ,"FSCK  ERRORS HAVE BEEN DETECTED.  Run fsck with the -f parameter to repair.\n"
/*172*/
   ,"FSCK  The root directory refers (entry \"..\") to an incorrect inode.\n"
/*173*/
   ,"FSCK  %s directory reconnected to /lost+found/.\n"
/*174*/
   ,"FSCK  MINOR: Unable to reconnect %s directory.  Continuing.\n"
/*175*/
   ,"FSCK  Inode %s%s is not connected to the root directory tree.\n"
/*176*/
   ,"XCHKLOG  Most recent fsck service log extracted into:  %s\n"
/*177*/
   ,"XCHKLOG  Prior fsck service log extracted into:  %s\n"
/*178*/
   ,"XCHKLOG  Can't open output file:  %s\n"
/*179*/
   ,"FSCK  Invalid stamp detected in file system object %s%s%s.\n"
/*180*/
   ,"FSCK  Files and/or directories not connected to the root directory tree \
have been detected.\n"
/*181*/
   ,"FSCK  Directory entries for unallocated files have been detected.  \
Will remove.\n"
/*182*/
   ,"FSCK  Files and/or directories not connected to the root directory tree \
have been detected.  Will reconnect.\n"
/*183*/
   ,"FSCK  Directories with illegal hard links have been detected.  Will correct.\n"
/*184*/
   ,"FSCK  Directories (entries \"..\") referring to incorrect parent directories \
have been detected.  Will correct.\n"
/*185*/
   ,"XCHKDMP  Can't open input file:  %s\n"
/*186*/
   ,"FSCK  Filesystem is clean.\n"
/*187*/
   ,"FSCK  Filesystem is clean but is marked dirty.  Run fsck with the -f \
parameter to fix.\n"
/*188*/
   ,"FSCK  Filesystem is dirty.\n"
/*189*/
   ,"FSCK  Filesystem is dirty but is marked clean.  In its present state,\nthe \
results of accessing %s (except by this utility) are undefined.\n"
/*190*/
   ,"FSCK  Filesystem has been marked clean.\n"
/*191*/
   ,"FSCK  Filesystem has been marked dirty because it contains critical errors.\
Filesystem may be unrecoverable.\n"
/*192*/
   ,"FSCK  File system object %s%s%s has an illegal empty node.\n"
/*193*/
   ,"FSCK File system object %s%s%s -- extent at offset %s has an invalid size (%s).\n"
/*194*/
   ,"FSCK  Dense file (inode %s%s) begins with an unallocated section.\n"
/*195*/
   ,"FSCK  Dense file (inode %s%s) has an unallocated section after offset %s.\n"
/*196*/
   ,"FSCK  The  Free Inode Extent List is inconsistent for Allocation \
Group %s%s.\n"
/*197*/
   ,"FSCK  Discrepancies detected in the Free Inode List for Allocation \
Group %s%s. (%s) \n"
/*198*/
   ,"FSCK  The Free Inode List is inconsistent for Allocation Group %s%s.\n"
/*199*/
   ,"FSCK  Inode Allocation Group %s%s has an invalid Allocation Group (%s).\n"
/*200*/
   ,"FSCK  Directory has an entry for an unallocated file %s%s.\n"
/*201*/
   ,"FSCK  Directory inode %s%s has a node with incorrect size.\n"
/*202*/
   ,"FSCK  Directory inode %s%s has a node with invalid size.\n"
/*203*/
   ,"FSCK  Directory inode %s%s has a node with an invalid freelist.\n"
/*204*/
   ,"FSCK  Directory inode %s%s has a node with an incorrect freecount.\n"
/*205*/
   ,"FSCK  Directory inode %s%s has a node with an incorrect freelist.\n"
/*206*/
   ,"FSCK  Inode Allocation Group %s%s has an invalid AG Start.\n"
/*207*/
   ,"FSCK  Inode Allocation Group %s%s has an invalid Free Extent Summary.\n"
/*208*/
   ,"FSCK  Inode Allocation Group %s%s has an invalid Free Inode Summary.\n"
/*209*/
   ,"FSCK  Discrepancies detected in the Free IAG List. (%s,%s)\n"
/*210*/
   ,"FSCK  The Free Inode Allocation Group List is inconsistent (%s).\n"
/*211*/
   ,"FSCK  Inode Allocation Group %s%s has an incorrect IAG number value.\n"
/*212*/
   ,"FSCK  Inode Allocation Group %s%s has an inconsistent count for \
number of free extents.\n"
/*213*/
   ,"FSCK  Inode Allocation Group %s%s has an inconsistent count for \
number of free inodes.\n"
/*214*/
   ,"FSCK  Discrepancies detected in the pmap for Inode Allocation Group %s%s.\n"
/*215*/
   ,"FSCK  Errors detected in the Fileset File/Directory Allocation Map.\n"
/*216*/
   ,"FSCK  The Inode Allocation Map blocks per inode extent is incorrect (%s).\n"
/*217*/
   ,"FSCK  Errors detected in the Fileset File/Directory Allocation Map control information.\n"
/*218*/
   ,"FSCK  The Inode Allocation Map log2(blocks per inode extent) is incorrect (%s).\n"
/*219*/
   ,"FSCK  The Inode Allocation Map has an incorrect number of backed inodes value (%s).\n"
/*220*/
   ,"FSCK  The Inode Allocation Map has an incorrect number of free inodes value (%s).\n"
/*221*/
   ,"FSCK  The Inode Allocation Map has an incorrect next IAG value (%s).\n"
/*222*/
   ,"Usage: xchkdmp [-f filename] [-V]\n"
/*223*/
   ,"FSCK  Correcting Inode Allocation Group %s%s invalid Allocation Group (%s).\n"
/*224*/
   ,"FSCK  Correcting Inode Allocation Group %s%s invalid AG Start.\n"
/*225*/
   ,"FSCK  Inconsistencies detected in leaf values (%s).\n"
/*226*/
   ,"FSCK  Inconsistencies detected in internal values (%s).\n"
/*227*/
   ,"FSCK  Incorrect data detected in pages (%s).\n"
/*228*/
   ,"FSCK  Descrepancies detected between observed block allocations and pmaps.\n"
/*229*/
   ,"FSCK  Incorrect data detected in disk allocation structures.\n"
/*230*/
   ,"FSCK  Incorrect data detected in disk allocation control structures.\n"
/*231*/
   ,"FSCK  Incorrect height detected in in page %s,%s.\n"
/*232*/
   ,"FSCK  Incorrect l2 number of leafs detected in in page %s,%s.\n"
/*233*/
   ,"FSCK  Incorrect leaf index detected in in page %s,%s.\n"
/*234*/
   ,"FSCK  Incorrect leaf (%s) value detected in %s page %s.\n"
/*235*/
   ,"FSCK  Incorrect internal (%s) value detected in %s page %s.\n"
/*236*/
   ,"FSCK  Incorrect budmin detected in in page %s,%s.\n"
/*237*/
   ,"FSCK  Incorrect number of leafs detected in page %s,%s.\n"
/*238*/
   ,"FSCK  Incorrect number of free blocks in AG %s detected in Block Map Control \
Page.\n"
/*239*/
   ,"FSCK  Incorrect aggregate size detected in Block Map Control Page.\n"
/*240*/
   ,"FSCK  Incorrect blocks per AG detected in Block Map Control Page.\n"
/*241*/
   ,"FSCK  Incorrect dmap control level detected in Block Map Control Page.\n"
/*242*/
   ,"FSCK  Incorrect dmap control height detected in Block Map Control Page.\n"
/*243*/
   ,"FSCK  Incorrect dmap control width detected in Block Map Control Page.\n"
/*244*/
   ,"FSCK  Incorrect l2 blocks per AG detected in Block Map Control Page.\n"
/*245*/
   ,"FSCK  Incorrect l2 blocks per page detected in Block Map Control Page.\n"
/*246*/
   ,"FSCK  Incorrect maximum active AGs detected in Block Map Control Page.\n"
/*247*/
   ,"FSCK  Incorrect maximum level detected in Block Map Control Page.\n"
/*248*/
   ,"FSCK  Incorrect number of AGs detected in Block Map Control Page.\n"
/*249*/
   ,"FSCK  Invalid preferred AG detected in Block Map Control Page.\n"
/*250*/
   ,"XCHKLOG  %s superblock is valid.\n"
/*251*/
   ,"FSCK  Incorrect number of blocks detected in dmap %s.\n"
/*252*/
   ,"FSCK  Incorrect number free detected in dmap %s.\n"
/*253*/
   ,"FSCK  Incorrect start detected in dmap %s.\n"
/*254*/
   ,"FSCK  %s consecutive blocks observed available but pmap (%s, %s, %s) \
indicates they are allocated.\n"
/*255*/
   ,"FSCK  %s consecutive blocks observed allocated but pmap (%s, %s, %s) \
indicates they are available.\n"
/*256*/
   ,"FSCK  Discrepancies detected in the Block Map Control Page AG free count list.\n"
/*257*/
   ,"FSCK  Incorrect data detected in the Block Map Control Page.\n"
/*258*/
   ,"FSCK  Incorrect dmap control start index detected in Block Map Control Page.\n"
/*259*/
   ,"FSCK  Incorrect fwsp length detected in the superblock (%s).\n"
/*260*/
   ,"FSCK  Incorrect jlog address detected in the superblock (%s).\n"
/*261*/
   ,"FSCK  Incorrect jlog length detected in the superblock (%s).\n"
/*262*/
   ,"    |........\r"
/*263*/
   ,"    .|.......\r"
/*264*/
   ,"    ..|......\r"
/*265*/
   ,"    ...|.....\r"
/*266*/
   ,"    ....|....\r"
/*267*/
   ,"    .....|...\r"
/*268*/
   ,"    ......|..\r"
/*269*/
   ,"    .......|.\r"
/*270*/
   ,"    ........|\r"
/*271*/
   ,"FSCK  Directory claims cross linked block(s).\n"
/*272*/
   ,"FSCK  File system object claims cross linked block(s).\n"
/*273*/
   ,"FSCK   File system is formatted for sparse files.\n"
/*274*/
   ,"FSCK  Directory inode %s%s incorrect DASD used value corrected.\n"
/*275*/
   ,"FSCK  %s directories reconnected to /lost+found/.\n"
/*276*/
   ,"FSCK  %s file reconnected to /lost+found/.\n"
/*277*/
   ,"FSCK  %s files reconnected to /lost+found/.\n"
/*278*/
   ,"FSCK cannot repair the data format error(s) in this directory.\n"
/*279*/
   ,"FSCK cannot repair the format error(s) in this directory.\n"
/*280*/
   ,"FSCK cannot repair the data format error(s) in this file system object.\n"
/*281*/
   ,"FSCK cannot repair the format error(s) in this file system object.\n"
/*282*/
   ,"FSCK **Phase 7 - Verify File/Directory Allocation Maps\n"
/*283*/
   ,"FSCK **Phase 8 - Verify Disk Allocation Maps\n"
/*284*/
   ,"FSCK parameter detected:  Omit logredo()\n"
/*285*/
   ,"FSCK The file system type for %s is not listed as jfs \nin the file system description file /etc/fstab.\n\n"
/*286*/
   ,"FSCK   *undefined* \n"
/*287*/
   ,"FSCK   *undefined* \n"
/*288*/
   ,"FSCK   *undefined* \n"
/*289*/
   ,"FSCK   *undefined* \n"
/*290*/
   ,"FSCK  Primary metadata inode %s%s is corrupt.\n"
/*291*/
   ,"FSCK  Secondary metadata inode %s%s is corrupt.\n"
/*292*/
   ,"FSCK  Secondary superblock is corrupt.\n"
/*293*/
   ,"FSCK  Unable to read the Secondary File/Directory Allocation Table.\n"
/*294*/
   ,"FSCK  Errors detected in the File System File/Directory Allocation Map.\n"
/*295*/
   ,"FSCK  Errors detected in the File System File/Directory Allocation Map control information.\n"
/*296*/
   ,"FSCK  Errors detected in the Secondary File/Directory Allocation Table.\n"
/*297*/
   ,"FSCK  Unable to read secondary superblock.\n"
/*298*/
   ,"FSCK   *undefined* \n"
/*299*/
   ,"FSCK   *undefined* \n"
/*300*/
   ,"FSCK   *undefined* \n"
/*301*/
   ,"FSCK  MINOR: Unable to reconnect %s directories.  Continuing.\n"
/*302*/
   ,"FSCK  MINOR: Unable to reconnect %s file.  Continuing.\n"
/*303*/
   ,"FSCK  MINOR: Unable to reconnect %s files.  Continuing.\n"
/*304*/
   ,"FSCK   *undefined* \n"
/*305*/
   ,"FSCK   *undefined* \n"
/*306*/
   ,"FSCK   *undefined* \n"
/*307*/
   ,"FSCK   *undefined* \n"
/*308*/
   ,"FSCK   *undefined* \n"
/*309*/
   ,"FSCK  Directory inode %s%s has been reconnected to /lost+found/.\n"
/*310*/
   ,"FSCK  MINOR: Unable to reconnect directory inode %s%s.  Continuing.\n"
/*311*/
   ,"FSCK   *undefined* \n"
/*312*/
   ,"FSCK  Unable to read either superblock.\n"
/*313*/
   ,"%s kilobytes total disk space.\n"
/*314*/
   ,"%s kilobytes in %s directories.\n"
/*315*/
   ,"%s kilobytes in %s user files.\n"
/*316*/
   ,"%s kilobytes in extended attributes\n"
/*317*/
   ,"%s kilobytes reserved for system use.\n"
/*318*/
   ,"%s kilobytes are available for use.\n"
/*319*/
   ,"XCHKDMP Can't read input file:  %s\n"
/*320*/
   ,"XCHKDMP Input file (%s) not recognized as an extracted JFS fsck service log.\n"
/*321*/
   ,"XCHKLOG  Cannot open device %s\n"
/*322*/
   ,"XCHKLOG  Output file path and name must be less than 128 characters.\n"
/*323*/
   ,"XCHKDMP  Input file path and name must be less than 128 characters.\n"
/*324*/
   ,"FSCK  Unable to read the Primary File/Directory Allocation Table.\n"
/*325*/
  ,"FSCK  Errors detected in the Primary File/Directory Allocation Table.\n"
/*326*/
   ,"FSCK CANNOT CONTINUE.\n"
/*327*/
   ,"********** FSCK CANNOT INITIALIZE THIS SERVICE LOG.  DISREGARD RESIDUAL LOG \
MESSAGES WHICH MAY BE APPENDED. **********\n"
/*328*/
   ,"CHKLOG  Required parameter missing:  device specification\n"
/*329*/
   ,"XCHKLOG  Required parameter missing:  device specification\n"
/*330*/
   ,"FSCK parameter detected:  FixLevel: %s\n"
/*331*/
   ,"FSCK parameter detected:  IfDirty\n"
/*332*/
   ,"FSCK parameter detected:  VerboseMessaging\n"
/*333*/
   ,"FSCK parameter detected:  AutoCheck mode\n"
/*334*/
   ,"FSCK parameter detected:  PMchkdsk mode\n"
/*335*/
   ,"FSCK parameter detected:  Debug mode\n"
/*336*/
   ,"FSCK  CHKDSK.SYS returned %s bytes of high memory at %s\n"
/*337*/
   ,"FSCK  Open(CHKDSK.SYS,...) returned rc = %s\n"
/*338*/
   ,"FSCK  IOCtl( ... ) to call CHKDSK.SYS returned rc = %s, data.rc = %s\n"
/*339*/
   ,"FSCK  ujfs_beginformat() returned rc = %s\n"
/*340*/
   ,"FSCK parameter detected:  Clear LVM Bad Block List\n"
/*341*/
   ,"FSCK (JFSCTL_CHKDSK, ... ) returned rc = %s\n"
/*342*/
   ,"FSCK   FSCK warning: The LVM has detected bad blocks in the partition.  \
Run FSCK /B to transfer entries from the LVM bad block table to the JFS bad \
block table.\n"
/*343*/
   ,"FSCK   LVM GetBadBlockInformation returned rc = %s\n"
/*344*/
   ,"FSCK   LVM GetTableSize rc = %s\n"
/*345*/
   ,"FSCK  THE FILE SYSTEM IS NOW AVAILABLE.\n"
/*346*/
   ,"FSCK  Transferring entries from the LVM Bad Block Table for this file \
system to the JFS Bad Block Table for this file system.\n"
/*347*/
   ,"FSCK   INTERNAL ERROR (%s,%s,%s,%s). FSCK CANNOT CONTINUE.\n"
/*348*/
   ,"FSCK   CLRBBLKS:  relocated %s extents, for total %s relocated blocks.\n"
/*349*/
   ,"FSCK   CLRBBLKS: LVM List #%s  num entries = %s  num active entries = %s\n"
/*350*/
   ,"FSCK   CLRBBLKS: number of LVM Lists = %s\n"
/*351*/
   ,"FSCK   CLRBBLKS: Attempted to relocate bad blocks in range %s to %s.\n"
/*352*/
   ,"FSCK   LVM reports %s bad blocks.  Of these, %s have been transferred to \
the JFS Bad Block List.\n"
/*353*/
   ,"FSCK   CLRBBLKS rc = %s\n"
/*354*/
   ,"FSCK   DosExecPgm(...clrbblks...) rc = %s\n"
/*355*/
   ,"FSCK  Open(...OPEN_SHARE_DENYNONE|OPEN_ACCESS_READWRITE...) returned rc = %s\n"
/*356*/
   ,"FSCK  Device unavailable or locked by another process.  FSCK CANNOT CONTINUE.\n"
/*357*/
   ,"FSCK  File system object %s%s%s has a node with an invalid self field.\n"
/*358*/
   ,"FSCK  File system object %s%s%s is illegally linked as: %s\n"
/*359*/
   ,"FSCK  Insufficient storage (%s) available to continue reconnecting \
lost files and/or directories. Continuing.\n"
/*360*/
   ,"FSCK  Format error in Access Control List space or descriptor.\n"
/*361*/
   ,"FSCK  Format error in Access Control List space or descriptor. Will clear.\n"
/*362*/
   ,"FSCK  Storage allocated to Access Control List for inode \
%s%s has been cleared.\n"
/*363*/
   ,"%s kilobytes in access control lists\n"
/*364*/
   ,"FSCK  File system is full or too fragmented to allocated requested %s blocks.\n"
/*365*/
   ,"FSCK  Minor format error detected.\n"
/*366*/
   ,"FSCK   Minor format error in inode %s%s has been corrected. \n"
/*367*/
   ,"FSCK  Minor format error detected. Will fix.\n"
/*368*/
   ,"FSCK  File system object %s%s%s has invalid length in descriptor (%s).\n"
/*369*/
   ,"FSCK  File system object %s%s%s has invalid offset in descriptor (%s).\n"
/*370*/
   ,"FSCK  File system checked READ ONLY.\n"
/*371*/
   ,"FSCK  Device does not exist. \n"
/*372*/
   ,"FSCK  No device given. \n"
/*373*/
   ,"FSCK   *undefined* \n"
/*374*/
   ,"FSCK   *undefined* \n"
/*375*/
   ,"FSCK   *undefined* \n"
/*376*/
   ,"FSCK   *undefined* \n"
/*377*/
   ,"FSCK   *undefined* \n"
/*378*/
   ,"FSCK   *undefined* \n"
/*379*/
   ,"FSCK   *undefined* \n"
/*380*/
   ,"FSCK   *undefined* \n"
/*381*/
   ,"FSCK   *undefined* \n"
/*382*/
   ,"FSCK   *undefined* \n"
/*383*/
   ,"FSCK   *undefined* \n"
/*384*/
   ,"B"
/*385*/
   ,"A"
/*386*/
   ,"D"
/*387*/
   ,"DM"
/*388*/
   ,"E"
/*389*/
   ,"F"
/*390*/
   ,"I"
/*391*/
   ,"L0"
/*392*/
   ,"L1"
/*393*/
   ,"L2"
/*394*/
   ,"M"
/*395*/
   ,"C"
/*396*/
   ,"P"
/*397*/
   ,"S"
/*398*/
   ,"L"
/*399*/
   ,".RCN\0"
/*400*/
   ,"FSCK:LOGREDO:  Log already redone! \n"
/*401*/
   ,"FSCK:LOGREDO:  End of log found at logend = %s\n"
/*402*/
   ,"FSCK:LOGREDO:  Beginning to recover File System Extend processing.\n"
/*403*/
   ,"FSCK:LOGREDO:  Done recovering File System Extend processing.\n"
/*404*/
   ,"FSCK:LOGREDO:  File System Extend recovered to prior size.\n"
/*405*/
   ,"FSCK:LOGREDO:  File System Extend recovered and completed.\n"
/*406*/
   ,"FSCK:LOGREDO:  Recovery of File System Extend failed.  Error = %s\n"
/*407*/
   ,"FSCK:LOGREDO:  Log superblock contains invalid magic number. \n"
/*408*/
   ,"FSCK:LOGREDO:  Log superblock contains invalid version number. \n"
/*409*/
   ,"FSCK:LOGREDO:  Unable to find valid end of log.\n"
/*410*/
   ,"FSCK:LOGREDO:  Initialization failed.  rc = %s   error num = %s\n"
/*411*/
   ,"FSCK:LOGREDO:  Log superblock contains invalid block size.\n"
/*412*/
   ,"FSCK:LOGREDO:  Log superblock contains invalid log2(block size).\n"
/*413*/
   ,"FSCK:LOGREDO:  Log superblock contains invalid log size.\n"
/*414*/
   ,"FSCK:LOGREDO:  Log end is not in valid range.\n"
/*415*/
   ,"FSCK:LOGREDO:  Synch point record number:  %s \n"
/*416*/
   ,"FSCK:LOGREDO:  Synch point record address:  %s \n"
/*417*/
   ,"FSCK:LOGREDO:  Number of log records:    %s \n"
/*418*/
   ,"FSCK:LOGREDO:  Number of Do blocks:    %s \n"
/*419*/
   ,"FSCK:LOGREDO:  Number of NoDo blocks:    %s \n"
/*420*/
   ,"FSCK:LOGREDO:  Log record for Sync Point at:    %s \n"
/*421*/
   ,"FSCK:LOGREDO:  Log record for Volume Mount at:    %s \n"
/*422*/
   ,"FSCK:  Calling CHKDSK.SYS to allocate high memory.... \n"
/*423*/
   ,"FSCK   CHKDSK.SYS returned  addr= %s  length= %s \n"
/*424*/
   ,"FSCK:LOGREDO:  Allocating for BMap:  %s bytes \n"
/*425*/
   ,"FSCK:LOGREDO:  Allocating for IMap:  %s bytes \n"
/*426*/
   ,"FSCK:LOGREDO:  Allocating for DoBLk:  %s bytes  \n"
/*427*/
   ,"FSCK:LOGREDO:  Allocating for NoReDoFile:  %s bytes  \n"
/*428*/
   ,"FSCK:LOGREDO:  Allocating for ReDoPage:  %s bytes  \n"
/*429*/
   ,"FSCK:LOGREDO:  Allocating for NoDoFile:  %s bytes  \n"
/*430*/
   ,"FSCK:LOGREDO:  Allocating for ExtendDtPg:  %s bytes  \n"
/*431*/
   ,"FSCK:LOGREDO:   Failed trying to allocate for BMap:  %s bytes \n"
/*432*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for IMap:  %s bytes  \n"
/*433*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for DoBLk:  %s bytes   \n"
/*434*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for NoReDoFile:  %s bytes \n"
/*435*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for ReDoPage:  %s bytes \n"
/*436*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for NoDoFile:  %s bytes \n"
/*437*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for ExtendDtPg:  %s bytes \n"
/*438*/
   ,"FSCK:LOGREDO:  Working IMap will occupy storage originally allocated for BMap.\n"
/*439*/
   ,"FSCK:LOGREDO:  Some storage allocated for BMap now used for NoRedoFile records.\n"
/*440*/
   ,"FSCK:LOGREDO:  Some storage allocated for BMap now used for DoBLock records.\n"
/*441*/
   ,"FSCK:LOGREDO:  Some storage allocated for BMap now used for RedoPage records.\n"
/*442*/
   ,"FSCK:LOGREDO:  Some storage allocated for BMap now used for NoDoFile records.\n"
/*443*/
   ,"FSCK:LOGREDO:  Some storage allocated for BMap now used for ExtendDtPage records.\n"
/*444*/
   ,"FSCK:LOGREDO:  Unable to read Journal Log superblock.\n"
/*445*/
   ,"FSCK:LOGREDO:  Unable to update Journal Log superblock.\n"
/*446*/
   ,"FSCK:LOGREDO:  Address of next log record is invalid.\n"
/*447*/
   ,"FSCK:LOGREDO:  Address (%s) of next log record is out of range.\n"
/*448*/
   ,"FSCK:LOGREDO:  Address (%s) of next log record is the same as address of current log record.\n"
/*449*/
   ,"FSCK:LOGREDO:  The Journal Log has wrapped around and written over itself.\n"
/*450*/
   ,"FSCK:LOGREDO:  Invalid Commit record at %s.\n"
/*451*/
   ,"FSCK:LOGREDO:  Invalid Mount record at %s.\n"
/*452*/
   ,"FSCK:LOGREDO:  Device open/read error\n"
/*453*/
   ,"FSCK:LOGREDO:  Invalid RedoPage record at %s. \n"
/*454*/
   ,"FSCK:LOGREDO:  Invalid NoRedoPage record at %s.\n"
/*455*/
   ,"FSCK:LOGREDO:  Invalid NoRedoInoExt record at %s.\n"
/*456*/
   ,"FSCK:LOGREDO:  Invalid UpdateMap record at %s.\n"
/*457*/
   ,"FSCK:LOGREDO:  Unrecognized log record type at %s.\n"
/*458*/
   ,"FSCK:LOGREDO:  Errors encountered imply the log is corrupt.  Reformat needed.\n"
/*459*/
   ,"FSCK:LOGREDO:  Errors encountered prevent logredo() from continuing. \n"
/*460*/
   ,"FSCK:LOGREDO:  Unable to update map(s).\n"
/*461*/
   ,"FSCK:LOGREDO:  Unable to update file system superblock.\n"
/*462*/
   ,"FSCK:LOGREDO:  Unable to write to log superblock.\n"
/*463*/
   ,"FSCK:LOGREDO:  Unable to read file system superblock. \n"
/*464*/
   ,"FSCK:LOGREDO:  File system superblock has invalid magic number.\n"
/*465*/
   ,"FSCK:LOGREDO:  File system superblock has invalid version number.\n"
/*466*/
   ,"FSCK:LOGREDO:  File system superblock has invalid log location.\n"
/*467*/
   ,"FSCK:LOGREDO:  File system superblock has invalid log serial number.\n"
/*468*/
   ,"FSCK:LOGREDO:  Unable to initialize map(s).\n"
/*469*/
   ,"FSCK:LOGREDO:  Attempt to read file system superblock failed.\n"
/*470*/
   ,"FSCK:LOGREDO:  Attempt to write file system superblock failed.\n"
/*471*/
   ,"FSCK:LOGREDO:  Attempt to read file system primary superblock failed.\n"
/*472*/
   ,"FSCK:LOGREDO:  Attempt to read file system secondary superblock failed.\n"
/*473*/
   ,"FSCK:LOGREDO:  Attempt to write file system primary superblock failed.\n"
/*474*/
   ,"FSCK:LOGREDO:  Attempt to write file system secondary superblock failed.\n"
/*475*/
   ,"FSCK:LOGREDO:  Attempt to flush buffers failed.\n"
/*476*/
   ,"FSCK:LOGREDO:  Not a valid file system device number.\n"
/*477*/
   ,"FSCK:LOGREDO:  Journal log must be inline. \n"
/*478*/
   ,"FSCK:LOGREDO:  Device is not a file system device.\n"
/*479*/
   ,"FSCK:LOGREDO:  Journal log is not inline.\n"
/*480*/
   ,"FSCK:LOGREDO:  Journal log is now open.  (major = %s, minor = %s) \n"
/*481*/
   ,"FSCK:LOGREDO:  Error in volume %s.\n"
/*482*/
   ,"FSCK:LOGREDO:  Device open failed.\n"
/*483*/
   ,"FSCK:LOGREDO:  Failed attempting to initialize map(s).\n"
/*484*/
   ,"FSCK:LOGREDO:  Invalid volume block number (%s).\n"
/*485*/
   ,"FSCK:LOGREDO:  Invalid inode number (%s).\n"
/*486*/
   ,"FSCK:LOGREDO:  Failed attempt to read block %s.\n"
/*487*/
   ,"FSCK:LOGREDO:  I/O error attempting to read block %s.\n"
/*488*/
   ,"FSCK:LOGREDO:  Invalid UpdateMap record (nxd = %s). \n"
/*489*/
   ,"FSCK:LOGREDO:  Invalid log serial number.\n"
/*490*/
   ,"FSCK:LOGREDO:  Failed attempt to find the current end of the Journal Log.\n"
/*491*/
   ,"FSCK:LOGREDO:  Failed attempting to read the Journal Log (logaddr = %s).\n"
/*492*/
   ,"FSCK:LOGREDO:  Unrecognized log record type (logaddr = %s).\n"
/*493*/
   ,"FSCK:LOGREDO:  I/O error on Journal Log (logaddr = %s).\n"
/*494*/
   ,"FSCK:LOGREDO:  The Journal Log has wrapped. \n"
/*495*/
   ,"FSCK:LOGREDO:  RecovExtFS: Attempt to read file system superblock failed.\n"
/*496*/
   ,"FSCK:LOGREDO:  RecovExtFS: Attempt to read block map inode failed.\n"
/*497*/
   ,"FSCK:LOGREDO:  RecovExtFS: Read aggregate block %s failed (1).\n"
/*498*/
   ,"FSCK:LOGREDO:  RecovExtFS: Read aggregate block %s failed (2).\n"
/*499*/
   ,"FSCK:LOGREDO:  RecovExtFS: Write aggregate block %s failed (1).\n"
/*500*/
   ,"FSCK:LOGREDO:  RecovExtFS: Write aggregate block %s failed (2).\n"
/*501*/
   ,"FSCK:LOGREDO:  RecovExtFS: Write aggregate block %s failed (3).\n"
/*502*/
   ,"FSCK:LOGREDO:  RecovExtFS: Read aggregate block %s failed (3).\n"
/*503*/
   ,"FSCK:LOGREDO:  RecovExtFS: Read aggregate block %s failed (4).\n"
/*504*/
   ,"FSCK:LOGREDO:  RecovExtFS: Error in initLogredo().\n"
/*505*/
   ,"FSCK:LOGREDO:  RecovExtFS: Read aggregate block %s failed (5).\n"
/*506*/
   ,"FSCK:LOGREDO:  RecovExtFS: Write aggregate block %s failed (4).\n"
/*507*/
   ,"FSCK:LOGREDO:  RecovExtFS: Attempt to write file system superblock failed.\n"
/*508*/
   ,"FSCK:LOGREDO:  RecovExtFS: Attempt to read Journal Log superblock failed.\n"
/*509*/
   ,"FSCK:LOGREDO:  RecovExtFS: Attempt to write Journal Log superblock failed. \n"
/*510*/
   ,"FSCK:LOGREDO:   Read Block Map inode failed.\n"
/*511*/
   ,"FSCK:LOGREDO:   Read Block Map failed.\n"
/*512*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map inode failed.\n"
/*513*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map failed.\n"
/*514*/
   ,"FSCK:LOGREDO:   Read Block Map leftmost leaf failed.\n"
/*515*/
   ,"FSCK:LOGREDO:   Read Block Map data extents failed.\n"
/*516*/
   ,"FSCK:LOGREDO:   Read Block Map next leaf failed.\n"
/*517*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map leftmost leaf failed.\n"
/*518*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map control page failed.\n"
/*519*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map next leaf failed.\n"
/*520*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map data extents failed.\n"
/*521*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map inode failed in UpdateMaps().\n"
/*522*/
   ,"FSCK:LOGREDO:  Write Inode Alloc Map control page failed in UpdateMaps().\n"
/*523*/
   ,"FSCK:LOGREDO:  Read Block Map inode failed in UpdateMaps().\n"
/*524*/
   ,"FSCK:LOGREDO:  Write Block Map control page failed in UpdateMaps().\n"
/*525*/
   ,"FSCK:LOGREDO:  Not rebuilding the Inode Alloc Map because fsck will be doing it.\n"
/*526*/
   ,"FSCK:LOGREDO:  Write Inode Alloc Map, rXtree() failed.\n"
/*527*/
   ,"FSCK:LOGREDO:  Write block (blk=%s) failed when updating the Inode Alloc Mapl.\n"
/*528*/
   ,"FSCK:LOGREDO:  Read next leaf (addr=%s) failed when updating the Inode Alloc Map.\n"
/*529*/
   ,"FSCK:LOGREDO:  Incorrect npages detected when updating the Inode Alloc Map.\n"
/*530*/
   ,"FSCK:LOGREDO:  Done updating the Inode Allocation Map.\n"
/*531*/
   ,"FSCK:LOGREDO:  Beginning to update the Inode Allocation Map.\n"
/*532*/
   ,"FSCK:LOGREDO:  Done updating the Block Map.\n"
/*533*/
   ,"FSCK:LOGREDO:  Beginning to update the Block Map.\n"
/*534*/
   ,"FSCK:LOGREDO:  Not rebuilding the Block Map because fsck will be doing it.\n"
/*535*/
   ,"FSCK:LOGREDO:  Error for pmap and inoext when rebuilding the Inode Allocation Map (1).\n"
/*536*/
   ,"FSCK:LOGREDO:  Inconsistent map size in Block Map.\n"
/*537*/
   ,"FSCK:LOGREDO:  Incorrect leaf index detected (k=%s, j=%s, idx=%s) while writing Block Map.\n"
/*538*/
   ,"FSCK:LOGREDO:  Error rebuilding DMap page (k=%s, j=%s, i=%s).\n"
/*539*/
   ,"FSCK:LOGREDO:  rXtree() failed when called while writing Block Map.\n"
/*540*/
   ,"FSCK:LOGREDO:  Write block (at %s) failed while writing Block Map.\n"
/*541*/
   ,"FSCK:LOGREDO:  Read next leaf (at %s) failed while writing Block Map.\n"
/*542*/
   ,"FSCK:LOGREDO:  Incorrect total pages while writing Block Map.\n"
/*543*/
   ,"FSCK:LOGREDO:  Invalid leaf index detected while updating dmap page.\n"
/*544*/
   ,"FSCK:LOGREDO:  rXtree() Read first leaf failed.\n"
/*545*/
   ,"FSCK:LOGREDO:  bread() Invalid block number specified (%s).\n"
/*546*/
   ,"FSCK:LOGREDO:  bread() Read block (%s) failed.\n"
/*547*/
   ,"FSCK:LOGREDO:  Error for pmap and inoext when rebuilding the Inode Allocation Map (2).\n"
/*548*/
   ,"FSCK:LOGREDO:   doAfter: updatePage failed.  (logaddr = %s, rc = %s)\n"
/*549*/
   ,"FSCK:LOGREDO:   doAfter: markBmap failed.  (logaddr = %s, rc = %s)\n"
/*550*/
   ,"FSCK:LOGREDO:   doExtDtPg: bread failed.  (offset = %s, rc = %s)\n"
/*551*/
   ,"FSCK:LOGREDO:   doNoRedoPage: type dtpage: findPageRedo failed.  (rc = %s)\n"
/*552*/
   ,"FSCK:LOGREDO:   doNoRedoPage: type dtroot: findPageRedo failed.  (rc = %s)\n"
/*553*/
   ,"FSCK:LOGREDO:   doNoRedoPage: type xtroot: findPageRedo failed.  (rc = %s)\n"
/*554*/
   ,"FSCK:LOGREDO:   doNoRedoPage: type xtpage: findPageRedo failed.  (rc = %s)\n"
/*555*/
   ,"FSCK:LOGREDO:   doNoRedoPage: Unknown NoRedoPage record type.\n"
/*556*/
   ,"FSCK:LOGREDO:   doNoRedoInoExt: findPageRedo failed.  (rc = %s)\n"
/*557*/
   ,"FSCK:LOGREDO:   doUpdateMap: Unknown updateMap record type.\n"
/*558*/
   ,"FSCK:LOGREDO:   dtpg_resetFreeList: Invalid stbl entry.\n"
/*559*/
   ,"FSCK:LOGREDO:   dtpg_resetFreeList: Invalid slot next index.\n"
/*560*/
   ,"FSCK:LOGREDO:   dtrt_resetFreeList: Invalid stbl entry.\n"
/*561*/
   ,"FSCK:LOGREDO:   dtrt_resetFreeList: Invalid slot next index.\n"
/*562*/
   ,"FSCK:LOGREDO:   markBmap: Block number(s) out of range (start=%s, length=%s). \n"
/*563*/
   ,"FSCK:LOGREDO:   updatePage: findPageRedo failed.  (rc = %s)\n"
/*564*/
   ,"FSCK:LOGREDO:   updatePage: type=INODE.  Invalid segment offset. (offset = %s)\n"
/*565*/
   ,"FSCK:LOGREDO:   updatePage: bread failed (1).  (rc = %s)\n"
/*566*/
   ,"FSCK:LOGREDO:   updatePage: bread failed (2).  (rc = %s)\n"
/*567*/
   ,"FSCK:LOGREDO:   updatePage: bread failed (3).  (rc = %s)\n"
/*568*/
   ,"FSCK:LOGREDO:   updatePage: bread failed (4).  (rc = %s)\n"
/*569*/
   ,"FSCK:LOGREDO:   updatePage: markImap failed.  (rc = %s)\n"
/*570*/
   ,"FSCK:LOGREDO:   updatePage: markBmap failed.  (rc = %s)\n"
/*571*/
   ,"FSCK:LOGREDO:   updatePage: dtrt_resetFreeList failed.  (rc = %s)\n"
/*572*/
   ,"FSCK:LOGREDO:   updatePage: dtpg_resetFreeList failed.  (rc = %s)\n"
/*573*/
   ,"FSCK:LOGREDO:   updatePage: saveExtDtPg failed.  (rc = %s)\n"
/*574*/
   ,"FSCK:LOGREDO:   fineEndOfLog: pageVal[1] failed (rc = %s).\n"
/*575*/
   ,"FSCK:LOGREDO:   fineEndOfLog: pageVal[2] failed (rc = %s).\n"
/*576*/
   ,"FSCK:LOGREDO:   fineEndOfLog: pageVal[3] failed (rc = %s).\n"
/*577*/
   ,"FSCK:LOGREDO:   fineEndOfLog: pageVal[4] failed (rc = %s).\n"
/*578*/
   ,"FSCK:LOGREDO:   fineEndOfLog: pageVal[4(a)] failed (rc = %s).\n"
/*579*/
   ,"FSCK:LOGREDO:   pageVal: getLogpage failed (pno = %s, rc = %s).\n"
/*580*/
   ,"FSCK:LOGREDO:   setLogpage: Write log page failed (pno = %s, rc = %s).\n"
/*581*/
   ,"FSCK:LOGREDO:   logRead: Log wrapped over itself (lognumread = %s).\n"
/*582*/
   ,"FSCK:LOGREDO:   logRead: Read log page failed (pno = %s, rc = %s).\n"
/*583*/
   ,"FSCK:LOGREDO:   logRead: MoveWords[1] failed (rc = %s).\n"
/*584*/
   ,"FSCK:LOGREDO:   logRead: MoveWords[2] failed (rc = %s).\n"
/*585*/
   ,"FSCK:LOGREDO:   moveWords: getLogpage failed (pno = %s, rc = %s).\n"
/*586*/
   ,"FSCK  DASD Limit has been primed for directories on the volume.\n"
/*587*/
   ,"FSCK  DASD Used has been primed for directories on the volume.\n"
/*588*/
   ,"FSCK:LOGREDO:   logRead: Log data must not exceed LOGPSIZE (pno = %s).\n"
/*589*/
   ,"FSCK   *undefined* \n"
/*590*/
   ,"FSCK   *undefined* \n"
/*591*/
   ,"FSCK   *undefined* \n"
/*592*/
   ,"FSCK   *undefined* \n"
/*593*/
   ,"FSCK   *undefined* \n"
/*594*/
   ,"FSCK   *undefined* \n"
/*595*/
   ,"FSCK   *undefined* \n"
/*596*/
   ,"FSCK   *undefined* \n"
/*597*/
   ,"FSCK   *undefined* \n"
/*598*/
   ,"FSCK   *undefined* \n"
/*599*/
   ,"FSCK   *undefined* \n"
/*600*/
   ,"FSCK   No device given \n"
   };

#endif
