/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : mi may 23 20:36:15 CEST 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "keduca.h"
#include "kcontroldoc.h"

static const char *description =
I18N_NOOP("Form-based tests and exams");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE

static const char *version =
I18N_NOOP("1.1");


static KCmdLineOptions options[] =
{
    { "+file",          I18N_NOOP("File to load"), 0 },
    { "e", 0, 0 },
    { "editor", I18N_NOOP("'Start in editor mode."), 0 },
    { 0, 0, 0 }
    // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

    KAboutData aboutData( "keduca", I18N_NOOP("KEduca"),
                          version, description, KAboutData::License_GPL,
                          "(c) 2001, Javier Campos", 0, "http://edu.kde.org/keduca", "submit@bugs.kde.org");
    aboutData.addAuthor("Javier Campos","Original Author", "javi_cms@terra.es");
    aboutData.addAuthor("Klas Kalass","Current Maintainer", "klas@kde.org");
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

    KApplication a;
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
//  KImageIO::registerFormats();

    // start the mode as specified on the command line
    if (args->isSet("editor")) {
        // Start as KEduca Editor
        KControlDoc *keducaEditor = new KControlDoc();
        a.setMainWidget(keducaEditor);
        keducaEditor->show();

        if ( args->count() > 0 ){
            keducaEditor->slotFileOpenURL( args->url(0) );
        }else{
            keducaEditor->startChooser();
        }
    }else{
        // start as KEduca TestMaster
        Keduca *keducaTestMaster = new Keduca();
        a.setMainWidget(keducaTestMaster);
        keducaTestMaster->show();

        if ( args->count() > 0 ){
            keducaTestMaster->slotFileOpenURL( args->url(0) );
        }else{
            keducaTestMaster->slotFileOpen();
        }
    }

    args->clear();

    return a.exec();
}
