/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.kde.javascript.JSObject;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.KJASAppletStub;
import org.kde.kjas.server.KJASAudioClip;
import org.kde.kjas.server.Main;

public class KJASAppletContext
implements AppletContext {
    private Hashtable stubs = new Hashtable();
    private Hashtable images = new Hashtable();
    private Vector pendingImages = new Vector();
    private Hashtable streams = new Hashtable();
    private String myID;
    private KJASAppletClassLoader loader;
    private boolean active;
    private int refcounter = 0;
    private Hashtable jsReferencedObjects = new Hashtable();
    private JSObject jsobject = null;
    private static final int JError = -1;
    private static final int JVoid = 0;
    private static final int JBoolean = 1;
    private static final int JFunction = 2;
    private static final int JNumber = 3;
    private static final int JObject = 4;
    private static final int JString = 5;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    public KJASAppletContext(String string) {
        this.myID = string;
        this.active = true;
    }

    public String getID() {
        return this.myID;
    }

    public String getAppletID(Applet applet) {
        Enumeration enumeration = this.stubs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
            if (kJASAppletStub.getApplet() != applet) continue;
            return string;
        }
        return null;
    }

    public Applet getAppletById(String string) {
        return ((KJASAppletStub)this.stubs.get(string)).getApplet();
    }

    public Object getJSReferencedObject(int n) {
        return this.jsReferencedObjects.get(new Integer(n));
    }

    public String getAppletName(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            return null;
        }
        return kJASAppletStub.getAppletName();
    }

    public void createApplet(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Hashtable hashtable) {
        Object object;
        String string10 = new String("archive").toUpperCase();
        if (hashtable.containsKey(string10)) {
            object = (String)hashtable.get(string10);
            if (string6 == null) {
                string6 = object;
            } else if (!((String)object).toLowerCase().endsWith(".cab")) {
                string6 = (String)object + "," + string6;
            }
        } else if (string6 != null) {
            hashtable.put(string10, string6);
        }
        string10 = new String("codebase").toUpperCase();
        if (string5 == null && hashtable.containsKey(string10)) {
            string5 = (String)hashtable.get(string10);
        }
        if (!hashtable.containsKey(string10 = new String("width").toUpperCase())) {
            hashtable.put(string10, string7);
        }
        if (!hashtable.containsKey(string10 = new String("height").toUpperCase())) {
            hashtable.put(string10, string8);
        }
        try {
            Object object2;
            object = KJASAppletClassLoader.getLoader(string4, string5);
            if (string6 != null) {
                object2 = new StringTokenizer(string6, ",", false);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    String string11 = ((StringTokenizer)object2).nextToken().trim();
                    ((KJASAppletClassLoader)object).addArchiveName(string11);
                }
            }
            ((KJASAppletClassLoader)object).paramsDone();
            object2 = new KJASAppletStub(this, string, ((KJASAppletClassLoader)object).getCodeBase(), ((KJASAppletClassLoader)object).getDocBase(), string2, string3, new Dimension(Integer.parseInt(string7), Integer.parseInt(string8)), hashtable, string9, (KJASAppletClassLoader)object);
            this.stubs.put(string, object2);
            ((KJASAppletStub)object2).createApplet();
        }
        catch (Exception exception) {
            Main.kjas_err("Something bad happened in createApplet: " + exception, exception);
        }
    }

    public void initApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not init and show applet: " + string);
        } else {
            kJASAppletStub.initApplet();
        }
    }

    public void destroyApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not destroy applet: " + string);
        } else {
            kJASAppletStub.destroyApplet();
            this.stubs.remove(string);
        }
    }

    public void startApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not start applet: " + string);
        } else {
            kJASAppletStub.startApplet();
        }
    }

    public void stopApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not stop applet: " + string);
        } else {
            kJASAppletStub.stopApplet();
        }
    }

    public void destroy() {
        Enumeration enumeration = this.stubs.elements();
        while (enumeration.hasMoreElements()) {
            KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
            kJASAppletStub.destroyApplet();
        }
        this.stubs.clear();
        this.active = false;
    }

    public Applet getApplet(String string) {
        if (this.active) {
            Enumeration enumeration = this.stubs.elements();
            while (enumeration.hasMoreElements()) {
                KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
                if (!kJASAppletStub.getAppletName().equals(string)) continue;
                return kJASAppletStub.getApplet();
            }
        }
        return null;
    }

    public Enumeration getApplets() {
        if (this.active) {
            Vector<Applet> vector = new Vector<Applet>();
            Enumeration enumeration = this.stubs.elements();
            while (enumeration.hasMoreElements()) {
                KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
                vector.add(kJASAppletStub.getApplet());
            }
            return vector.elements();
        }
        return null;
    }

    public AudioClip getAudioClip(URL uRL) {
        Main.debug("getAudioClip, url = " + uRL);
        KJASAudioClip kJASAudioClip = new KJASAudioClip(uRL);
        Main.debug("got AudioClip " + kJASAudioClip);
        return kJASAudioClip;
    }

    public void addImage(String string, byte[] byArray) {
        Main.debug("addImage for url = " + string);
        this.images.put(string, byArray);
        if (Main.cacheImages) {
            this.pendingImages.remove(string);
        }
    }

    public Image getImage(URL uRL) {
        if (this.active && uRL != null) {
            if (this.loader != null) {
                uRL = this.loader.findResource(uRL.toString());
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.createImage(uRL);
            return image;
        }
        return null;
    }

    public void showDocument(URL uRL) {
        if (this.active && uRL != null) {
            Main.protocol.sendShowDocumentCmd(this.myID, uRL.toString());
        }
    }

    public void showDocument(URL uRL, String string) {
        if (this.active && uRL != null && string != null) {
            Main.protocol.sendShowDocumentCmd(this.myID, uRL.toString(), string);
        }
    }

    public void showStatus(String string) {
        if (this.active && string != null) {
            Main.protocol.sendShowStatusCmd(this.myID, string);
        }
    }

    public void evaluateJavaScript(String string, String string2, JSObject jSObject) {
        if (this.active && string != null) {
            this.jsobject = jSObject;
            int[] nArray = new int[]{5};
            String[] stringArray = new String[]{string};
            Main.protocol.sendJavaScriptEventCmd(this.myID, string2, 0, "eval", nArray, stringArray);
        }
    }

    private int[] getJSTypeValue(Object object, int n, StringBuffer stringBuffer) {
        String string = object.toString();
        int[] nArray = new int[]{-1, n};
        String string2 = object.getClass().getName();
        if (string2.equals("boolean") || string2.equals("java.lang.Boolean")) {
            nArray[0] = 1;
        } else if (string2.equals("int") || string2.equals("long") || string2.equals("float") || string2.equals("double") || string2.equals("byte") || object instanceof Number) {
            nArray[0] = 3;
        } else if (string2.equals("java.lang.String")) {
            nArray[0] = 5;
        } else {
            nArray[0] = 4;
            nArray[1] = ++this.refcounter;
            this.jsReferencedObjects.put(new Integer(this.refcounter), object);
        }
        stringBuffer.insert(0, string);
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    public int[] getMember(String var1_1, int var2_2, String var3_3, StringBuffer var4_4) {
        block8: {
            Main.debug("getMember: " + var3_3);
            var5_5 = null;
            var6_6 = null;
            if (var2_2 != 0) {
                var5_5 = (Applet)this.jsReferencedObjects.get(new Integer(var2_2));
            } else {
                var6_6 = (KJASAppletStub)this.stubs.get(var1_1);
                if (var6_6 != null) {
                    var5_5 = ((KJASAppletStub)this.stubs.get(var1_1)).getApplet();
                }
            }
            var7_7 = new int[]{-1, var2_2};
            if (var5_5 == null || var6_6 != null && !var6_6.isLoaded()) {
                return var7_7;
            }
            var8_8 = var5_5.getClass();
            try {
                var9_9 = var8_8.getField(var3_3);
                var7_7 = this.getJSTypeValue(var9_9.get(var5_5), var2_2, var4_4);
                break block8;
            }
            catch (Exception var9_10) {
                var10_11 = var8_8.getDeclaredMethods();
                var11_12 = 0;
                ** while (var11_12 < var10_11.length)
            }
lbl-1000:
            // 1 sources

            {
                if (var10_11[var11_12].getName().equals(var3_3)) {
                    var7_7[0] = 2;
                    break;
                }
                ++var11_12;
                continue;
            }
        }
        return var7_7;
    }

    public boolean putMember(String string, int n, String string2, String string3) {
        Field field;
        if (this.jsobject != null && string2.equals("__lc_ret")) {
            Main.debug("putValue: applet " + string2 + "=" + string3);
            this.jsobject.returnvalue = string3;
            try {
                this.jsobject.thread.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.jsobject = null;
            return true;
        }
        KJASAppletStub kJASAppletStub = null;
        Applet applet = null;
        if (n != 0) {
            applet = (Applet)this.jsReferencedObjects.get(new Integer(n));
        } else {
            kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
            if (kJASAppletStub != null) {
                applet = ((KJASAppletStub)this.stubs.get(string)).getApplet();
            }
        }
        if (applet == null || kJASAppletStub != null && !kJASAppletStub.isLoaded()) {
            Main.debug("Error in putValue: applet " + string + " not found");
            return false;
        }
        try {
            field = applet.getClass().getField(string2);
        }
        catch (Exception exception) {
            return false;
        }
        if (field == null) {
            Main.debug("Error in putValue: " + string2 + " not found");
            return false;
        }
        try {
            String string4 = field.getType().getName();
            Main.debug("putValue: (" + string4 + ")" + string2 + "=" + string3);
            if (string4.equals("boolean")) {
                field.setBoolean(applet, Boolean.getBoolean(string3));
            } else if (string4.equals("java.lang.Boolean")) {
                field.set(applet, Boolean.valueOf(string3));
            } else if (string4.equals("int")) {
                field.setInt(applet, Integer.parseInt(string3));
            } else if (string4.equals("java.lang.Integer")) {
                field.set(applet, Integer.valueOf(string3));
            } else if (string4.equals("byte")) {
                field.setByte(applet, Byte.parseByte(string3));
            } else if (string4.equals("java.lang.Byte")) {
                field.set(applet, Byte.valueOf(string3));
            } else if (string4.equals("char")) {
                field.setChar(applet, string3.charAt(0));
            } else if (string4.equals("java.lang.Character")) {
                field.set(applet, new Character(string3.charAt(0)));
            } else if (string4.equals("double")) {
                field.setDouble(applet, Double.parseDouble(string3));
            } else if (string4.equals("java.lang.Double")) {
                field.set(applet, Double.valueOf(string3));
            } else if (string4.equals("float")) {
                field.setFloat(applet, Float.parseFloat(string3));
            } else if (string4.equals("java.lang.Float")) {
                field.set(applet, Float.valueOf(string3));
            } else if (string4.equals("long")) {
                field.setLong(applet, Long.parseLong(string3));
            } else if (string4.equals("java.lang.Long")) {
                field.set(applet, Long.valueOf(string3));
            } else if (string4.equals("short")) {
                field.setShort(applet, Short.parseShort(string3));
            } else if (string4.equals("java.lang.Short")) {
                field.set(applet, Short.valueOf(string3));
            } else if (string4.equals("java.lang.String")) {
                field.set(applet, string3);
            } else {
                Main.debug("Error putValue: unsupported type: " + string4);
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            Main.debug("Exception in putValue: " + exception.getMessage());
            return false;
        }
    }

    private Method findMethod(Class clazz, String string, Class[] classArray) {
        try {
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                Method method = methodArray[n];
                if (method.getName().equals(string)) {
                    Main.debug("Candidate: " + method);
                    Class<?>[] classArray2 = method.getParameterTypes();
                    if (classArray == null) {
                        if (classArray2.length == 0) {
                            return method;
                        }
                    } else if (classArray.length == classArray2.length) {
                        int n2 = 0;
                        while (n2 < classArray.length) {
                            classArray[n2] = classArray2[n2];
                            ++n2;
                        }
                        return method;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static final Object cast(Object object, Class clazz) throws NumberFormatException {
        Object object2 = object;
        if (object == null) {
            object2 = null;
        } else {
            if (clazz.isAssignableFrom(object.getClass())) {
                return object;
            }
            if (object instanceof String) {
                String string = (String)object;
                Main.debug("Argument String: \"" + string + "\"");
                if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = KJASAppletContext.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    object2 = new Boolean(string);
                } else if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = KJASAppletContext.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    object2 = new Integer(string);
                } else if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = KJASAppletContext.class$("java.lang.Long")) : class$java$lang$Long)) {
                    object2 = new Long(string);
                } else if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = KJASAppletContext.class$("java.lang.Float")) : class$java$lang$Float)) {
                    object2 = new Float(string);
                } else if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = KJASAppletContext.class$("java.lang.Double")) : class$java$lang$Double)) {
                    object2 = new Double(string);
                } else if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = KJASAppletContext.class$("java.lang.Short")) : class$java$lang$Short)) {
                    object2 = new Short(string);
                } else if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = KJASAppletContext.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    object2 = new Byte(string);
                } else if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = KJASAppletContext.class$("java.lang.Character")) : class$java$lang$Character)) {
                    object2 = new Character(string.charAt(0));
                }
            }
        }
        return object2;
    }

    public int[] callMember(String string, int n, String string2, StringBuffer stringBuffer, List list) {
        int[] nArray;
        block9: {
            Applet applet = null;
            KJASAppletStub kJASAppletStub = null;
            if (n != 0) {
                applet = (Applet)this.jsReferencedObjects.get(new Integer(n));
            } else {
                kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
                if (kJASAppletStub != null) {
                    applet = ((KJASAppletStub)this.stubs.get(string)).getApplet();
                }
            }
            nArray = new int[]{-1, n};
            if (applet == null || kJASAppletStub != null && !kJASAppletStub.isLoaded()) {
                return nArray;
            }
            try {
                Main.debug("callMember: " + string2);
                Class<?> clazz = applet.getClass();
                Class[] classArray = new Class[list.size()];
                int n2 = 0;
                while (n2 < list.size()) {
                    classArray[n2] = string2.getClass();
                    ++n2;
                }
                Method method = this.findMethod(clazz, string2, classArray);
                Main.debug("Found Method: " + method);
                if (method == null) break block9;
                Object[] objectArray = new Object[list.size()];
                int n3 = 0;
                while (n3 < list.size()) {
                    objectArray[n3] = KJASAppletContext.cast(list.get(n3), classArray[n3]);
                    ++n3;
                }
                Object object = method.invoke((Object)applet, objectArray);
                if (object == null) {
                    nArray[0] = 0;
                    break block9;
                }
                nArray = this.getJSTypeValue(object, n, stringBuffer);
            }
            catch (Exception exception) {
                Main.debug("callMember threw exception: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return nArray;
    }

    public void derefObject(int n) {
        if (this.jsReferencedObjects.remove(new Integer(n)) == null) {
            Main.debug("couldn't remove referenced object");
        }
    }

    public void setStream(String string, InputStream inputStream) throws IOException {
        Main.debug("setStream, key = " + string);
        this.streams.put(string, inputStream);
    }

    public InputStream getStream(String string) {
        Main.debug("getStream, key = " + string);
        return (InputStream)this.streams.get(string);
    }

    public Iterator getStreamKeys() {
        Main.debug("getStreamKeys");
        return this.streams.keySet().iterator();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

