/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame2.driver;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.Iteration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.impl.GraphQueryResultImpl;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.RDFHandlerBase;
import virtuoso.sesame2.driver.VirtuosoBooleanQuery;
import virtuoso.sesame2.driver.VirtuosoGraphQuery;
import virtuoso.sesame2.driver.VirtuosoQuery;
import virtuoso.sesame2.driver.VirtuosoRepository;
import virtuoso.sesame2.driver.VirtuosoTupleQuery;
import virtuoso.sql.ExtendedString;
import virtuoso.sql.RdfBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtuosoRepositoryConnection
implements RepositoryConnection {
    private static Resource nilContext;
    private Connection quadStoreConnection;
    protected VirtuosoRepository repository;
    static final String S_INSERT = "sparql define output:format '_JAVA_' insert into graph iri(??) { `iri(??)` `iri(??)` `bif:__rdf_long_from_batch_params(??,??,??)` }";
    static final String S_DELETE = "sparql define output:format '_JAVA_' delete from graph iri(??) {`iri(??)` `iri(??)` `bif:__rdf_long_from_batch_params(??,??,??)`}";
    static final int BATCH_SIZE = 5000;
    private PreparedStatement psInsert;
    private int psInsertCount = 0;
    private boolean useLazyAdd = false;
    private int prefetchSize = 200;

    public VirtuosoRepositoryConnection(VirtuosoRepository virtuosoRepository, Connection connection) throws RepositoryException {
        this.quadStoreConnection = connection;
        this.repository = virtuosoRepository;
        this.useLazyAdd = virtuosoRepository.useLazyAdd;
        this.prefetchSize = virtuosoRepository.prefetchSize;
        nilContext = new ValueFactoryImpl().createURI(virtuosoRepository.defGraph);
        this.repository.initialize();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public ValueFactory getValueFactory() {
        return this.repository.getValueFactory();
    }

    public boolean isOpen() throws RepositoryException {
        try {
            return !this.getQuadStoreConnection().isClosed();
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Problem inspecting connection", (Throwable)sQLException);
        }
    }

    public void close() throws RepositoryException {
        this.dropDelayAdd();
        try {
            if (!this.getQuadStoreConnection().isClosed()) {
                this.getQuadStoreConnection().close();
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException((Throwable)sQLException);
        }
    }

    public Query prepareQuery(QueryLanguage queryLanguage, String string) throws RepositoryException, MalformedQueryException {
        return this.prepareQuery(queryLanguage, string, null);
    }

    public Query prepareQuery(QueryLanguage queryLanguage, String string, String string2) throws RepositoryException, MalformedQueryException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = null;
        while (!(!stringTokenizer.hasMoreTokens() || (string3 = stringTokenizer.nextToken().toLowerCase()).equals("select") || string3.equals("construct") || string3.equals("describe") || string3.equals("ask"))) {
        }
        this.flushDelayAdd();
        if (string3.equals("select")) {
            return this.prepareTupleQuery(queryLanguage, string, string2);
        }
        if (string3.equals("construct") || string3.equals("describe")) {
            return this.prepareGraphQuery(queryLanguage, string, string2);
        }
        if (string3.equals("ask")) {
            return this.prepareBooleanQuery(queryLanguage, string, string2);
        }
        return new VirtuosoQuery();
    }

    public TupleQuery prepareTupleQuery(QueryLanguage queryLanguage, String string) throws RepositoryException, MalformedQueryException {
        return this.prepareTupleQuery(queryLanguage, string, null);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage queryLanguage, final String string, String string2) throws RepositoryException, MalformedQueryException {
        VirtuosoTupleQuery virtuosoTupleQuery = new VirtuosoTupleQuery(){

            public TupleQueryResult evaluate() throws QueryEvaluationException {
                return VirtuosoRepositoryConnection.this.executeSPARQLForTupleResult(string, this.getDataset(), this.getIncludeInferred(), this.getBindings());
            }

            public void evaluate(TupleQueryResultHandler tupleQueryResultHandler) throws QueryEvaluationException, TupleQueryResultHandlerException {
                VirtuosoRepositoryConnection.this.executeSPARQLForHandler(tupleQueryResultHandler, string, this.getDataset(), this.getIncludeInferred(), this.getBindings());
            }
        };
        return virtuosoTupleQuery;
    }

    public GraphQuery prepareGraphQuery(QueryLanguage queryLanguage, String string) throws RepositoryException, MalformedQueryException {
        return this.prepareGraphQuery(queryLanguage, string, null);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage queryLanguage, final String string, String string2) throws RepositoryException, MalformedQueryException {
        VirtuosoGraphQuery virtuosoGraphQuery = new VirtuosoGraphQuery(){

            public GraphQueryResult evaluate() throws QueryEvaluationException {
                return VirtuosoRepositoryConnection.this.executeSPARQLForGraphResult(string, this.getDataset(), this.getIncludeInferred(), this.getBindings());
            }

            public void evaluate(RDFHandler rDFHandler) throws QueryEvaluationException, RDFHandlerException {
                VirtuosoRepositoryConnection.this.executeSPARQLForHandler(rDFHandler, string, this.getDataset(), this.getIncludeInferred(), this.getBindings());
            }
        };
        return virtuosoGraphQuery;
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage queryLanguage, String string) throws RepositoryException, MalformedQueryException {
        return this.prepareBooleanQuery(queryLanguage, string, null);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage queryLanguage, final String string, String string2) throws RepositoryException, MalformedQueryException {
        VirtuosoBooleanQuery virtuosoBooleanQuery = new VirtuosoBooleanQuery(){

            public boolean evaluate() throws QueryEvaluationException {
                return VirtuosoRepositoryConnection.this.executeSPARQLForBooleanResult(string, this.getDataset(), this.getIncludeInferred(), this.getBindings());
            }
        };
        return virtuosoBooleanQuery;
    }

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        Vector<Resource> vector = new Vector<Resource>();
        String string = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
        try {
            Statement statement = this.getQuadStoreConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                Object object = resultSet.getObject(1);
                try {
                    Value value = this.castValue(object);
                    vector.add((Resource)value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RepositoryException("VirtuosoRepositoryConnection.getContextIDs() Non-URI context encountered: " + object);
                }
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new RepositoryException(": SPARQL execute failed.\n" + string.toString(), (Throwable)exception);
        }
        return this.createRepositoryResult(vector);
    }

    public RepositoryResult<org.openrdf.model.Statement> getStatements(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws RepositoryException {
        resourceArray = this.checkContext(resourceArray);
        return new RepositoryResult(this.selectFromQuadStore(resource, uRI, value, bl, false, resourceArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStatement(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws RepositoryException {
        resourceArray = this.checkContext(resourceArray);
        CloseableIteration<org.openrdf.model.Statement, RepositoryException> closeableIteration = this.selectFromQuadStore(resource, uRI, value, bl, true, resourceArray);
        try {
            boolean bl2 = closeableIteration.hasNext();
            return bl2;
        }
        finally {
            closeableIteration.close();
        }
    }

    public boolean hasStatement(org.openrdf.model.Statement statement, boolean bl, Resource ... resourceArray) throws RepositoryException {
        return this.hasStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), bl, resourceArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStatements(Resource resource, URI uRI, Value value, boolean bl, RDFHandler rDFHandler, Resource ... resourceArray) throws RepositoryException, RDFHandlerException {
        resourceArray = this.checkContext(resourceArray);
        rDFHandler.startRDF();
        RepositoryResult<Namespace> repositoryResult = this.getNamespaces();
        try {
            while (repositoryResult.hasNext()) {
                Namespace namespace = (Namespace)repositoryResult.next();
                rDFHandler.handleNamespace(namespace.getPrefix(), namespace.getName());
            }
        }
        finally {
            repositoryResult.close();
        }
        CloseableIteration<org.openrdf.model.Statement, RepositoryException> closeableIteration = this.selectFromQuadStore(resource, uRI, value, bl, false, resourceArray);
        try {
            while (closeableIteration.hasNext()) {
                rDFHandler.handleStatement((org.openrdf.model.Statement)closeableIteration.next());
            }
        }
        finally {
            closeableIteration.close();
        }
        rDFHandler.endRDF();
    }

    private Resource[] checkDMLContext(Resource ... resourceArray) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])resourceArray);
        if (resourceArray != null && resourceArray.length == 1 && resourceArray[0] == null) {
            resourceArray = new Resource[]{nilContext};
        } else if (resourceArray == null || resourceArray.length == 0) {
            resourceArray = new Resource[]{nilContext};
        }
        return resourceArray;
    }

    private Resource[] checkContext(Resource ... resourceArray) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])resourceArray);
        if (resourceArray != null && resourceArray.length == 1 && resourceArray[0] == null) {
            resourceArray = new Resource[]{nilContext};
        } else if (resourceArray == null || resourceArray.length == 0) {
            resourceArray = new Resource[]{};
        }
        return resourceArray;
    }

    public void export(RDFHandler rDFHandler, Resource ... resourceArray) throws RepositoryException, RDFHandlerException {
        this.exportStatements(null, null, null, false, rDFHandler, resourceArray);
    }

    public long size(Resource ... resourceArray) throws RepositoryException {
        int n = 0;
        this.verifyIsOpen();
        this.flushDelayAdd();
        resourceArray = this.checkContext(resourceArray);
        StringBuffer stringBuffer = new StringBuffer("select count(*) from (sparql define input:storage \"\" select * ");
        for (int i = 0; i < resourceArray.length; ++i) {
            stringBuffer.append("from named <");
            stringBuffer.append(resourceArray[i].stringValue());
            stringBuffer.append("> ");
        }
        stringBuffer.append("where { graph ?g {?s ?p ?o }})f");
        try {
            Statement statement = this.getQuadStoreConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new RepositoryException(": SPARQL execute failed:[" + stringBuffer + "] \n Exception:" + exception);
        }
        return n;
    }

    public boolean isEmpty() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        boolean bl = false;
        String string = "sparql define input:storage \"\" select * where {?s ?o ?p} limit 1";
        try {
            Statement statement = this.getQuadStoreConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            bl = !resultSet.next();
            resultSet.close();
            return bl;
        }
        catch (Exception exception) {
            throw new RepositoryException(": SPARQL execute failed:[" + string + "] \n Exception:" + exception);
        }
    }

    public void setAutoCommit(boolean bl) throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        try {
            this.getQuadStoreConnection().setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw new RepositoryException((Throwable)sQLException);
        }
    }

    public boolean isAutoCommit() throws RepositoryException {
        this.verifyIsOpen();
        try {
            return this.getQuadStoreConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw new RepositoryException((Throwable)sQLException);
        }
    }

    public void commit() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        try {
            this.getQuadStoreConnection().commit();
        }
        catch (SQLException sQLException) {
            throw new RepositoryException((Throwable)sQLException);
        }
    }

    public void rollback() throws RepositoryException {
        this.verifyIsOpen();
        this.dropDelayAdd();
        try {
            this.getQuadStoreConnection().rollback();
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Problem with rollback", (Throwable)sQLException);
        }
    }

    public void add(InputStream inputStream, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, RepositoryException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.add(inputStreamReader, string, rDFFormat, resourceArray);
    }

    public void add(Reader reader, String string, RDFFormat rDFFormat, final Resource ... resourceArray) throws IOException, RDFParseException, RepositoryException {
        this.verifyIsOpen();
        this.sendDelayAdd();
        final boolean bl = resourceArray != null && resourceArray.length == 0;
        boolean bl2 = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            RDFParser rDFParser = Rio.createParser((RDFFormat)rDFFormat, (ValueFactory)this.getRepository().getValueFactory());
            rDFParser.setVerifyData(true);
            rDFParser.setStopAtFirstError(true);
            rDFParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            final PreparedStatement preparedStatement = this.quadStoreConnection.prepareStatement(S_INSERT);
            final Resource[] resourceArray2 = this.checkDMLContext(resourceArray);
            rDFParser.setRDFHandler((RDFHandler)new RDFHandlerBase(){
                int count = 0;

                public void startRDF() {
                }

                public void endRDF() throws RDFHandlerException {
                    try {
                        if (this.count > 0) {
                            preparedStatement.executeBatch();
                            preparedStatement.clearBatch();
                            this.count = 0;
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new RDFHandlerException("Problem executing query: ", (Throwable)sQLException);
                    }
                }

                public void handleNamespace(String string, String string2) throws RDFHandlerException {
                    String string3 = "DB.DBA.XML_SET_NS_DECL(?, ?, 1)";
                    try {
                        PreparedStatement preparedStatement2 = VirtuosoRepositoryConnection.this.getQuadStoreConnection().prepareStatement(string3);
                        preparedStatement2.setString(1, string);
                        preparedStatement2.setString(2, string2);
                        preparedStatement2.execute();
                    }
                    catch (SQLException sQLException) {
                        throw new RDFHandlerException("Problem executing query: " + string3, (Throwable)sQLException);
                    }
                }

                public void handleStatement(org.openrdf.model.Statement statement) throws RDFHandlerException {
                    try {
                        Resource[] resourceArray3 = statement.getContext() != null && bl ? new Resource[]{statement.getContext()} : resourceArray2;
                        for (int i = 0; i < resourceArray.length; ++i) {
                            preparedStatement.setString(1, resourceArray3[i].stringValue());
                            VirtuosoRepositoryConnection.this.bindResource(preparedStatement, 2, statement.getSubject());
                            VirtuosoRepositoryConnection.this.bindURI(preparedStatement, 3, statement.getPredicate());
                            VirtuosoRepositoryConnection.this.bindValue(preparedStatement, 4, statement.getObject());
                            preparedStatement.addBatch();
                            ++this.count;
                        }
                        if (this.count > 5000) {
                            preparedStatement.executeBatch();
                            preparedStatement.clearBatch();
                            this.count = 0;
                        }
                    }
                    catch (Exception exception) {
                        throw new RDFHandlerException((Throwable)exception);
                    }
                }
            });
            rDFParser.parse(reader, string);
        }
        catch (Exception exception) {
            if (bl2) {
                this.rollback();
            }
            throw new RepositoryException("Problem parsing triples", (Throwable)exception);
        }
        finally {
            this.commit();
            this.setAutoCommit(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URL uRL, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, RepositoryException {
        if (string == null) {
            string = uRL.toExternalForm();
        }
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        try {
            this.add(inputStreamReader, string, rDFFormat, resourceArray);
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, RepositoryException {
        if (string == null) {
            string = file.toURI().toString();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.add(fileInputStream, string, rDFFormat, resourceArray);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public void add(Resource resource, URI uRI, Value value, Resource ... resourceArray) throws RepositoryException {
        resourceArray = this.checkDMLContext(resourceArray);
        this.addToQuadStore(resource, uRI, value, resourceArray);
    }

    public void add(org.openrdf.model.Statement statement, Resource ... resourceArray) throws RepositoryException {
        if (resourceArray != null && resourceArray.length == 0 && statement.getContext() != null) {
            resourceArray = new Resource[]{statement.getContext()};
        }
        this.add(statement.getSubject(), statement.getPredicate(), statement.getObject(), resourceArray);
    }

    public void add(Iterable<? extends org.openrdf.model.Statement> iterable, Resource ... resourceArray) throws RepositoryException {
        this.verifyIsOpen();
        this.sendDelayAdd();
        Iterator<? extends org.openrdf.model.Statement> iterator = iterable.iterator();
        boolean bl = resourceArray != null && resourceArray.length == 0;
        Resource[] resourceArray2 = this.checkDMLContext(resourceArray);
        boolean bl2 = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            PreparedStatement preparedStatement = this.quadStoreConnection.prepareStatement(S_INSERT);
            int n = 0;
            while (iterator.hasNext()) {
                org.openrdf.model.Statement statement = iterator.next();
                resourceArray = statement.getContext() != null && bl ? new Resource[]{statement.getContext()} : resourceArray2;
                for (int i = 0; i < resourceArray.length; ++i) {
                    preparedStatement.setString(1, resourceArray[i].stringValue());
                    this.bindResource(preparedStatement, 2, statement.getSubject());
                    this.bindURI(preparedStatement, 3, statement.getPredicate());
                    this.bindValue(preparedStatement, 4, statement.getObject());
                    preparedStatement.addBatch();
                    ++n;
                }
                if (n <= 5000) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
                n = 0;
            }
            if (n > 0) {
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
        catch (Exception exception) {
            if (bl2) {
                this.rollback();
            }
            throw new RepositoryException((Throwable)exception);
        }
        finally {
            this.commit();
            this.setAutoCommit(bl2);
        }
    }

    public <E extends Exception> void add(Iteration<? extends org.openrdf.model.Statement, E> iteration, Resource ... resourceArray) throws RepositoryException, E {
        this.verifyIsOpen();
        this.sendDelayAdd();
        boolean bl = resourceArray != null && resourceArray.length == 0;
        Resource[] resourceArray2 = this.checkDMLContext(resourceArray);
        boolean bl2 = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            PreparedStatement preparedStatement = this.quadStoreConnection.prepareStatement(S_INSERT);
            int n = 0;
            while (iteration.hasNext()) {
                org.openrdf.model.Statement statement = (org.openrdf.model.Statement)iteration.next();
                resourceArray = statement.getContext() != null && bl ? new Resource[]{statement.getContext()} : resourceArray2;
                for (int i = 0; i < resourceArray.length; ++i) {
                    preparedStatement.setString(1, resourceArray[i].stringValue());
                    this.bindResource(preparedStatement, 2, statement.getSubject());
                    this.bindURI(preparedStatement, 3, statement.getPredicate());
                    this.bindValue(preparedStatement, 4, statement.getObject());
                    preparedStatement.addBatch();
                    ++n;
                }
                if (n <= 5000) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
                n = 0;
            }
            if (n > 0) {
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
        catch (Exception exception) {
            if (bl2) {
                this.rollback();
            }
            throw new RepositoryException((Throwable)exception);
        }
        finally {
            this.commit();
            this.setAutoCommit(bl2);
        }
    }

    public void remove(Resource resource, URI uRI, Value value, Resource ... resourceArray) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])resourceArray);
        this.verifyIsOpen();
        this.flushDelayAdd();
        resourceArray = this.checkDMLContext(resourceArray);
        boolean bl = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            for (int i = 0; i < resourceArray.length; ++i) {
                this.removeContext(resource, uRI, value, resourceArray[i]);
            }
        }
        catch (RepositoryException repositoryException) {
            if (bl) {
                this.rollback();
            }
            throw repositoryException;
        }
        finally {
            this.commit();
            this.setAutoCommit(bl);
        }
    }

    public void remove(org.openrdf.model.Statement statement, Resource ... resourceArray) throws RepositoryException {
        if (resourceArray != null && resourceArray.length == 0 && statement.getContext() != null) {
            resourceArray = new Resource[]{statement.getContext()};
        }
        this.remove(statement.getSubject(), statement.getPredicate(), statement.getObject(), resourceArray);
    }

    public void remove(Iterable<? extends org.openrdf.model.Statement> iterable, Resource ... resourceArray) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])resourceArray);
        this.verifyIsOpen();
        this.flushDelayAdd();
        Iterator<? extends org.openrdf.model.Statement> iterator = iterable.iterator();
        boolean bl = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            while (iterator.hasNext()) {
                org.openrdf.model.Statement statement = iterator.next();
                Resource[] resourceArray2 = resourceArray != null && resourceArray.length == 0 && statement.getContext() != null ? new Resource[]{statement.getContext()} : resourceArray;
                resourceArray2 = this.checkDMLContext(resourceArray2);
                for (int i = 0; i < resourceArray2.length; ++i) {
                    this.removeContext(statement.getSubject(), statement.getPredicate(), statement.getObject(), resourceArray2[i]);
                }
            }
        }
        catch (RepositoryException repositoryException) {
            if (bl) {
                this.rollback();
            }
            throw repositoryException;
        }
        finally {
            this.commit();
            this.setAutoCommit(bl);
        }
    }

    public <E extends Exception> void remove(Iteration<? extends org.openrdf.model.Statement, E> iteration, Resource ... resourceArray) throws RepositoryException, E {
        OpenRDFUtil.verifyContextNotNull((Resource[])resourceArray);
        this.verifyIsOpen();
        this.flushDelayAdd();
        boolean bl = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            while (iteration.hasNext()) {
                org.openrdf.model.Statement statement = (org.openrdf.model.Statement)iteration.next();
                Resource[] resourceArray2 = resourceArray != null && resourceArray.length == 0 && statement.getContext() != null ? new Resource[]{statement.getContext()} : resourceArray;
                resourceArray2 = this.checkDMLContext(resourceArray2);
                for (int i = 0; i < resourceArray2.length; ++i) {
                    this.removeContext(statement.getSubject(), statement.getPredicate(), statement.getObject(), resourceArray2[i]);
                }
            }
        }
        catch (RepositoryException repositoryException) {
            if (bl) {
                this.rollback();
            }
            throw repositoryException;
        }
        finally {
            this.commit();
            this.setAutoCommit(bl);
        }
    }

    public void clear(Resource ... resourceArray) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])resourceArray);
        this.verifyIsOpen();
        this.flushDelayAdd();
        resourceArray = this.checkDMLContext(resourceArray);
        boolean bl = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            this.clearQuadStore(resourceArray);
        }
        catch (RepositoryException repositoryException) {
            if (bl) {
                this.rollback();
            }
            throw repositoryException;
        }
        finally {
            this.commit();
            this.setAutoCommit(bl);
        }
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        LinkedList<NamespaceImpl> linkedList = new LinkedList<NamespaceImpl>();
        String string = "DB.DBA.XML_SELECT_ALL_NS_DECLS (3)";
        try {
            Statement statement = this.getQuadStoreConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                if (string3 == null || string2 == null) continue;
                NamespaceImpl namespaceImpl = new NamespaceImpl(string2, string3);
                linkedList.add(namespaceImpl);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new RepositoryException((Throwable)exception);
        }
        return this.createRepositoryResult(linkedList);
    }

    public String getNamespace(String string) throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String string2 = null;
        String string3 = "SELECT __xml_get_ns_uri (?, 3)";
        try {
            PreparedStatement preparedStatement = this.getQuadStoreConnection().prepareStatement(string3);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new RepositoryException((Throwable)exception);
        }
        return string2;
    }

    public void setNamespace(String string, String string2) throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String string3 = "DB.DBA.XML_SET_NS_DECL(?, ?, 1)";
        try {
            PreparedStatement preparedStatement = this.getQuadStoreConnection().prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Problem executing query: " + string3, (Throwable)sQLException);
        }
    }

    public void removeNamespace(String string) throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String string2 = "DB.DBA.XML_REMOVE_NS_BY_PREFIX(?, 1)";
        try {
            PreparedStatement preparedStatement = this.getQuadStoreConnection().prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.execute(string2);
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Problem executing query: " + string2, (Throwable)sQLException);
        }
    }

    public void clearNamespaces() throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String string = "DB.DBA.XML_CLEAR_ALL_NS_DECLS()";
        try {
            Statement statement = this.getQuadStoreConnection().createStatement();
            statement.execute(string);
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Problem executing query: " + string, (Throwable)sQLException);
        }
    }

    protected TupleQueryResult executeSPARQLForTupleResult(String string, Dataset dataset, boolean bl, BindingSet bindingSet) throws QueryEvaluationException {
        Vector<String> vector = new Vector<String>();
        try {
            this.verifyIsOpen();
            this.flushDelayAdd();
            Statement statement = this.getQuadStoreConnection().createStatement();
            statement.setFetchSize(this.prefetchSize);
            ResultSet resultSet = statement.executeQuery(this.fixQuery(string, dataset, bl, bindingSet));
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String string2 = resultSetMetaData.getColumnName(i);
                if (vector.indexOf(string2) >= 0) continue;
                vector.add(string2);
            }
            return new TupleQueryResultImpl(vector, (CloseableIteration)new CloseableIterationBindingSet(resultSet));
        }
        catch (Exception exception) {
            throw new QueryEvaluationException(": SPARQL execute failed:[" + string + "] \n Exception:" + exception);
        }
    }

    protected GraphQueryResult executeSPARQLForGraphResult(String string, Dataset dataset, boolean bl, BindingSet bindingSet) throws QueryEvaluationException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            this.verifyIsOpen();
            this.flushDelayAdd();
            Statement statement = this.getQuadStoreConnection().createStatement();
            statement.setFetchSize(this.prefetchSize);
            ResultSet resultSet = statement.executeQuery(this.fixQuery(string, dataset, bl, bindingSet));
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                hashMap.put(resultSetMetaData.getColumnName(i), new Integer(i));
            }
            return new GraphQueryResultImpl(new HashMap(), (CloseableIteration)new CloseableIterationGraphResult(resultSet));
        }
        catch (Exception exception) {
            throw new QueryEvaluationException(": SPARQL execute failed:[" + string + "] \n Exception:" + exception);
        }
    }

    protected boolean executeSPARQLForBooleanResult(String string, Dataset dataset, boolean bl, BindingSet bindingSet) throws QueryEvaluationException {
        boolean bl2 = false;
        try {
            this.verifyIsOpen();
            this.flushDelayAdd();
            Statement statement = this.getQuadStoreConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(this.fixQuery(string, dataset, bl, bindingSet));
            while (resultSet.next()) {
                if (resultSet.getInt(1) != 1) continue;
                bl2 = true;
            }
            statement.close();
            return bl2;
        }
        catch (Exception exception) {
            throw new QueryEvaluationException(": SPARQL execute failed:[" + string + "] \n Exception:" + exception);
        }
    }

    protected void executeSPARQLForHandler(TupleQueryResultHandler tupleQueryResultHandler, String string, Dataset dataset, boolean bl, BindingSet bindingSet) throws QueryEvaluationException, TupleQueryResultHandlerException {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            this.verifyIsOpen();
            this.flushDelayAdd();
            Statement statement = this.getQuadStoreConnection().createStatement();
            statement.setFetchSize(this.prefetchSize);
            ResultSet resultSet = statement.executeQuery(this.fixQuery(string, dataset, bl, bindingSet));
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                linkedList.add(resultSetMetaData.getColumnName(i));
            }
            tupleQueryResultHandler.startQueryResult(linkedList);
            while (resultSet.next()) {
                QueryBindingSet queryBindingSet = new QueryBindingSet();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    String string2 = resultSetMetaData.getColumnName(i);
                    Object object = resultSet.getObject(i);
                    Value value = this.castValue(object);
                    queryBindingSet.addBinding(string2, value);
                }
                tupleQueryResultHandler.handleSolution((BindingSet)queryBindingSet);
            }
            tupleQueryResultHandler.endQueryResult();
            statement.close();
        }
        catch (Exception exception) {
            throw new QueryEvaluationException(": SPARQL execute failed:[" + string + "] \n Exception:" + exception);
        }
    }

    protected void executeSPARQLForHandler(RDFHandler rDFHandler, String string, Dataset dataset, boolean bl, BindingSet bindingSet) throws QueryEvaluationException, RDFHandlerException {
        try {
            String string2;
            this.verifyIsOpen();
            this.flushDelayAdd();
            Statement statement = this.getQuadStoreConnection().createStatement();
            statement.setFetchSize(this.prefetchSize);
            ResultSet resultSet = statement.executeQuery(this.fixQuery(string, dataset, bl, bindingSet));
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                string2 = resultSetMetaData.getColumnName(i);
                if (string2.equalsIgnoreCase("g")) {
                    n = i;
                    continue;
                }
                if (string2.equalsIgnoreCase("s")) {
                    n2 = i;
                    continue;
                }
                if (string2.equalsIgnoreCase("p")) {
                    n3 = i;
                    continue;
                }
                if (!string2.equalsIgnoreCase("o")) continue;
                n4 = i;
            }
            rDFHandler.startRDF();
            while (resultSet.next()) {
                Object var13_15 = null;
                string2 = null;
                URI uRI = null;
                Value value = null;
                Resource resource = null;
                if (n2 != -1) {
                    string2 = (Resource)this.castValue(resultSet.getObject(n2));
                }
                if (n3 != -1) {
                    uRI = (URI)this.castValue(resultSet.getObject(n3));
                }
                if (n4 != -1) {
                    value = this.castValue(resultSet.getObject(n4));
                }
                if (n != -1) {
                    resource = (Resource)this.castValue(resultSet.getObject(n));
                }
                ContextStatementImpl contextStatementImpl = new ContextStatementImpl((Resource)string2, uRI, value, resource);
                rDFHandler.handleStatement((org.openrdf.model.Statement)contextStatementImpl);
            }
            rDFHandler.endRDF();
            statement.close();
        }
        catch (Exception exception) {
            throw new QueryEvaluationException(": SPARQL execute failed:[" + string + "] \n Exception:" + exception);
        }
    }

    public int executeSPARUL(String string) throws RepositoryException {
        try {
            this.verifyIsOpen();
            this.flushDelayAdd();
            Statement statement = this.getQuadStoreConnection().createStatement();
            statement.execute("sparql\n define output:format '_JAVA_'\n " + string);
            return statement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            throw new RepositoryException(": SPARQL execute failed:[" + string + "] \n Exception:" + sQLException);
        }
    }

    public Connection getQuadStoreConnection() {
        return this.quadStoreConnection;
    }

    public void setQuadStoreConnection(Connection connection) {
        this.quadStoreConnection = connection;
    }

    private String substBindings(String string, BindingSet bindingSet) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = " ,)(;.";
        int n = 0;
        int n2 = string.length();
        block0: while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) == '\\') {
                stringBuffer.append(c);
                if (n >= n2) continue;
                stringBuffer.append(string.charAt(n++));
                continue;
            }
            if (c == '\"' || c == '\'') {
                char c2 = c;
                stringBuffer.append(c);
                while (n < n2) {
                    c = string.charAt(n++);
                    stringBuffer.append(c);
                    if (c != c2) continue;
                    continue block0;
                }
                continue;
            }
            if (c == '?') {
                String string3;
                Value value;
                int n3;
                String string4 = null;
                for (n3 = n; n3 < n2 && string2.indexOf(string.charAt(n3)) < 0; ++n3) {
                }
                if (n3 != n && (value = bindingSet.getValue(string3 = string.substring(n, n3))) != null) {
                    string4 = this.stringForValue(value);
                    n = n3;
                }
                if (string4 != null) {
                    stringBuffer.append(string4);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String fixQuery(String string, Dataset dataset, boolean bl, BindingSet bindingSet) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer("sparql\n ");
        while (!(!stringTokenizer.hasMoreTokens() || (string2 = stringTokenizer.nextToken().toLowerCase()).equals("describe") || string2.equals("construct") || string2.equals("ask") || string2.equals("select"))) {
        }
        if (string2.equals("describe") || string2.equals("construct") || string2.equals("ask")) {
            stringBuffer.append("define output:format '_JAVA_'\n ");
        }
        if (bl && this.repository.ruleSet != null && this.repository.ruleSet.length() > 0) {
            stringBuffer.append("define input:inference '" + this.repository.ruleSet + "'\n ");
        }
        stringBuffer.append("define output:format '_JAVA_'\n ");
        if (dataset != null) {
            Set set = dataset.getDefaultGraphs();
            if (set != null) {
                for (URI uRI : set) {
                    stringBuffer.append(" define input:default-graph-uri <" + uRI.stringValue() + "> \n");
                }
            }
            if ((set = dataset.getNamedGraphs()) != null) {
                for (URI uRI : set) {
                    stringBuffer.append(" define input:named-graph-uri <" + uRI.stringValue() + "> \n");
                }
            }
        }
        stringBuffer.append(this.substBindings(string, bindingSet));
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQuadStore(Resource resource, URI uRI, Value value, Resource ... resourceArray) throws RepositoryException {
        block10: {
            this.verifyIsOpen();
            try {
                boolean bl = this.getQuadStoreConnection().getAutoCommit();
                if (!bl && this.useLazyAdd) {
                    VirtuosoRepositoryConnection virtuosoRepositoryConnection = this;
                    synchronized (virtuosoRepositoryConnection) {
                        if (this.psInsert == null) {
                            this.psInsert = this.getQuadStoreConnection().prepareStatement(S_INSERT);
                        }
                        for (int i = 0; i < resourceArray.length; ++i) {
                            this.psInsert.setString(1, resourceArray[i].stringValue());
                            this.bindResource(this.psInsert, 2, resource);
                            this.bindURI(this.psInsert, 3, uRI);
                            this.bindValue(this.psInsert, 4, value);
                            this.psInsert.addBatch();
                            ++this.psInsertCount;
                        }
                        if (this.psInsertCount >= 5000) {
                            this.psInsert.executeBatch();
                            this.psInsert.clearBatch();
                            this.psInsertCount = 0;
                        }
                        break block10;
                    }
                }
                PreparedStatement preparedStatement = this.getQuadStoreConnection().prepareStatement(S_INSERT);
                for (int i = 0; i < resourceArray.length; ++i) {
                    preparedStatement.setString(1, resourceArray[i].stringValue());
                    this.bindResource(preparedStatement, 2, resource);
                    this.bindURI(preparedStatement, 3, uRI);
                    this.bindValue(preparedStatement, 4, value);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
            catch (Exception exception) {
                throw new RepositoryException((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDelayAdd() throws RepositoryException {
        VirtuosoRepositoryConnection virtuosoRepositoryConnection = this;
        synchronized (virtuosoRepositoryConnection) {
            try {
                if (this.psInsertCount >= 5000 && this.psInsert != null) {
                    this.psInsert.executeBatch();
                    this.psInsert.clearBatch();
                    this.psInsertCount = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDelayAdd() throws RepositoryException {
        VirtuosoRepositoryConnection virtuosoRepositoryConnection = this;
        synchronized (virtuosoRepositoryConnection) {
            try {
                if (this.psInsertCount > 0 && this.psInsert != null) {
                    this.psInsert.executeBatch();
                    this.psInsert.clearBatch();
                    this.psInsertCount = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDelayAdd() throws RepositoryException {
        VirtuosoRepositoryConnection virtuosoRepositoryConnection = this;
        synchronized (virtuosoRepositoryConnection) {
            try {
                if (this.psInsertCount >= 5000 && this.psInsert != null) {
                    this.psInsert.clearBatch();
                    this.psInsertCount = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clearQuadStore(Resource[] resourceArray) throws RepositoryException {
        String string = "sparql clear graph iri(??)";
        if (resourceArray != null && resourceArray.length > 0) {
            try {
                PreparedStatement preparedStatement = this.quadStoreConnection.prepareStatement(string);
                for (int i = 0; i < resourceArray.length; ++i) {
                    preparedStatement.setString(1, resourceArray[i].stringValue());
                    preparedStatement.execute();
                }
            }
            catch (Exception exception) {
                throw new RepositoryException((Throwable)exception);
            }
        }
    }

    private CloseableIteration<org.openrdf.model.Statement, RepositoryException> selectFromQuadStore(Resource resource, URI uRI, Value value, boolean bl, boolean bl2, Resource ... resourceArray) throws RepositoryException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        ResultSet resultSet = null;
        String string = "?s";
        String string2 = "?p";
        String string3 = "?o";
        if (resource != null) {
            string = this.stringForResource(resource);
        }
        if (uRI != null) {
            string2 = this.stringForURI(uRI);
        }
        if (value != null) {
            string3 = this.stringForValue(value);
        }
        StringBuffer stringBuffer = new StringBuffer("sparql ");
        if (bl && this.repository.ruleSet != null && this.repository.ruleSet.length() > 0) {
            stringBuffer.append("define input:inference '" + this.repository.ruleSet + "' ");
        }
        stringBuffer.append("select * ");
        for (int i = 0; i < resourceArray.length; ++i) {
            stringBuffer.append("from named <");
            stringBuffer.append(resourceArray[i].stringValue());
            stringBuffer.append("> ");
        }
        stringBuffer.append("where { graph ?g {");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string3);
        stringBuffer.append(" }}");
        if (bl2) {
            stringBuffer.append(" LIMIT 1");
        }
        try {
            Statement statement = this.getQuadStoreConnection().createStatement();
            statement.setFetchSize(this.prefetchSize);
            resultSet = statement.executeQuery(stringBuffer.toString());
        }
        catch (Exception exception) {
            throw new RepositoryException(this.getClass().getCanonicalName() + ": SPARQL execute failed." + "\n" + stringBuffer.toString() + "[" + exception + "]", (Throwable)exception);
        }
        return new CloseableIterationStmt(resultSet, resource, uRI, value);
    }

    private void removeContext(Resource resource, URI uRI, Value value, Resource resource2) throws RepositoryException {
        PreparedStatement preparedStatement = null;
        String string = "?s";
        String string2 = "?p";
        String string3 = "?o";
        try {
            if (resource == null && uRI == null && value == null && resource2 != null) {
                String string4 = "sparql clear graph iri(??)";
                preparedStatement = this.getQuadStoreConnection().prepareStatement(string4);
                preparedStatement.setString(1, resource2.stringValue());
                preparedStatement.execute();
            } else if (resource != null && uRI != null && value != null && resource2 != null) {
                preparedStatement = this.getQuadStoreConnection().prepareStatement(S_DELETE);
                preparedStatement.setString(1, resource2.stringValue());
                this.bindResource(preparedStatement, 2, resource);
                this.bindURI(preparedStatement, 3, uRI);
                this.bindValue(preparedStatement, 4, value);
                preparedStatement.execute();
            } else {
                if (resource != null) {
                    string = this.stringForResource(resource);
                }
                if (uRI != null) {
                    string2 = this.stringForURI(uRI);
                }
                if (value != null) {
                    string3 = this.stringForValue(value);
                }
                String string5 = "sparql delete from graph <" + resource2 + "> { " + string + " " + string2 + " " + string3 + " } from <" + resource2 + "> where { " + string + " " + string2 + " " + string3 + " }";
                Statement statement = this.getQuadStoreConnection().createStatement();
                statement.execute(string5);
            }
        }
        catch (Exception exception) {
            throw new RepositoryException((Throwable)exception);
        }
    }

    private void bindResource(PreparedStatement preparedStatement, int n, Resource resource) throws SQLException {
        if (resource == null) {
            return;
        }
        if (resource instanceof URI) {
            preparedStatement.setString(n, resource.stringValue());
        } else if (resource instanceof BNode) {
            preparedStatement.setString(n, "_:" + ((BNode)resource).getID());
        } else {
            preparedStatement.setString(n, resource.stringValue());
        }
    }

    private void bindURI(PreparedStatement preparedStatement, int n, URI uRI) throws SQLException {
        if (uRI == null) {
            return;
        }
        preparedStatement.setString(n, uRI.stringValue());
    }

    private void bindValue(PreparedStatement preparedStatement, int n, Value value) throws SQLException {
        if (value == null) {
            return;
        }
        if (value instanceof URI) {
            preparedStatement.setInt(n, 1);
            preparedStatement.setString(n + 1, value.stringValue());
            preparedStatement.setNull(n + 2, 12);
        } else if (value instanceof BNode) {
            preparedStatement.setInt(n, 1);
            preparedStatement.setString(n + 1, "_:" + ((BNode)value).getID());
            preparedStatement.setNull(n + 2, 12);
        } else if (value instanceof Literal) {
            Literal literal = (Literal)value;
            if (literal.getLanguage() != null) {
                preparedStatement.setInt(n, 5);
                preparedStatement.setString(n + 1, literal.stringValue());
                preparedStatement.setString(n + 2, literal.getLanguage());
            } else if (literal.getDatatype() != null) {
                preparedStatement.setInt(n, 4);
                preparedStatement.setString(n + 1, literal.stringValue());
                preparedStatement.setString(n + 2, literal.getDatatype().toString());
            } else {
                preparedStatement.setInt(n, 3);
                preparedStatement.setString(n + 1, value.stringValue());
                preparedStatement.setNull(n + 2, 12);
            }
        } else {
            preparedStatement.setInt(n, 3);
            preparedStatement.setString(n + 1, value.stringValue());
            preparedStatement.setNull(n + 2, 12);
        }
    }

    private String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '\'') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String stringForResource(Resource resource) {
        if (resource instanceof URI) {
            return this.stringForURI((URI)resource);
        }
        if (resource instanceof BNode) {
            return this.stringForBNode((BNode)resource);
        }
        return "<" + resource.stringValue() + ">";
    }

    private String stringForURI(URI uRI) {
        return "<" + uRI.stringValue() + ">";
    }

    private String stringForBNode(BNode bNode) {
        return "<_:" + bNode.getID() + ">";
    }

    private String stringForValue(Value value) {
        if (value instanceof Resource) {
            return this.stringForResource((Resource)value);
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            String string = "'" + this.escapeString(literal.stringValue()) + "'";
            if (literal.getLanguage() != null) {
                return string + "@" + literal.getLanguage();
            }
            if (literal.getDatatype() != null) {
                return string + "^^<" + literal.getDatatype() + ">";
            }
            return string;
        }
        return "'" + this.escapeString(value.stringValue()) + "'";
    }

    private Value castValue(Object object) throws RepositoryException {
        if (object == null) {
            return null;
        }
        if (object instanceof ExtendedString) {
            ExtendedString extendedString = (ExtendedString)object;
            String string = extendedString.toString();
            if (extendedString.getIriType() == 1 && (extendedString.getStrType() & 1) == 1) {
                if (string.startsWith("_:")) {
                    string = string.substring(2);
                    return this.getRepository().getValueFactory().createBNode(string);
                }
                try {
                    if (string.indexOf(58) < 0) {
                        return this.getRepository().getValueFactory().createURI(":" + string);
                    }
                    return this.getRepository().getValueFactory().createURI(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RepositoryException("VirtuosoRepositoryConnection().castValue() Invalid value from Virtuoso: \"" + string + "\"", (Throwable)illegalArgumentException);
                }
            }
            if (extendedString.getIriType() == 2) {
                try {
                    string = string.substring(9);
                    return this.getRepository().getValueFactory().createBNode(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RepositoryException("VirtuosoRepositoryConnection().castValue() Invalid value from Virtuoso: \"" + string + "\"", (Throwable)illegalArgumentException);
                }
            }
            try {
                return this.getRepository().getValueFactory().createLiteral(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RepositoryException("VirtuosoRepositoryConnection().castValue() Invalid value from Virtuoso: \"" + string + "\", STRTYPE = " + extendedString.getIriType(), (Throwable)illegalArgumentException);
            }
        }
        if (object instanceof RdfBox) {
            RdfBox rdfBox = (RdfBox)object;
            if (rdfBox.getLang() != null) {
                return this.getRepository().getValueFactory().createLiteral(rdfBox.toString(), rdfBox.getLang());
            }
            if (rdfBox.getType() != null) {
                return this.getRepository().getValueFactory().createLiteral(rdfBox.toString(), this.getRepository().getValueFactory().createURI(rdfBox.getType()));
            }
            return this.getRepository().getValueFactory().createLiteral(rdfBox.toString());
        }
        if (object instanceof Integer) {
            return this.getRepository().getValueFactory().createLiteral(((Integer)object).intValue());
        }
        if (object instanceof Short) {
            return this.getRepository().getValueFactory().createLiteral(((Short)object).intValue());
        }
        if (object instanceof Float) {
            return this.getRepository().getValueFactory().createLiteral(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.getRepository().getValueFactory().createLiteral(((Double)object).doubleValue());
        }
        if (object instanceof BigDecimal) {
            URI uRI = this.getRepository().getValueFactory().createURI("http://www.w3.org/2001/XMLSchema#decimal");
            return this.getRepository().getValueFactory().createLiteral(object.toString(), uRI);
        }
        if (object instanceof Blob) {
            URI uRI = this.getRepository().getValueFactory().createURI("http://www.w3.org/2001/XMLSchema#hexBinary");
            return this.getRepository().getValueFactory().createLiteral(object.toString(), uRI);
        }
        if (object instanceof Date) {
            URI uRI = this.getRepository().getValueFactory().createURI("http://www.w3.org/2001/XMLSchema#date");
            return this.getRepository().getValueFactory().createLiteral(object.toString(), uRI);
        }
        if (object instanceof Timestamp) {
            URI uRI = this.getRepository().getValueFactory().createURI("http://www.w3.org/2001/XMLSchema#dateTime");
            return this.getRepository().getValueFactory().createLiteral(this.Timestamp2String((Timestamp)object), uRI);
        }
        if (object instanceof Time) {
            URI uRI = this.getRepository().getValueFactory().createURI("http://www.w3.org/2001/XMLSchema#time");
            return this.getRepository().getValueFactory().createLiteral(object.toString(), uRI);
        }
        try {
            return this.getRepository().getValueFactory().createLiteral((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RepositoryException("VirtuosoRepositoryConnection().castValue() Could not parse resource: " + object, (Throwable)illegalArgumentException);
        }
    }

    protected <E> RepositoryResult<E> createRepositoryResult(Iterable<? extends E> iterable) {
        return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration(iterable.iterator()));
    }

    private void verifyIsOpen() throws RepositoryException {
        try {
            if (this.getQuadStoreConnection().isClosed()) {
                throw new IllegalStateException("Connection has been closed");
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException((Throwable)sQLException);
        }
    }

    private String Timestamp2String(Timestamp timestamp) {
        String string;
        String string2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(timestamp);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = timestamp.getNanos();
        String string3 = "000000000";
        String string4 = "0000";
        if (n < 1000) {
            string2 = "" + n;
            string2 = string4.substring(0, 4 - string2.length()) + string2;
        } else {
            string2 = "" + n;
        }
        String string5 = n2 < 10 ? "0" + n2 : Integer.toString(n2);
        String string6 = n3 < 10 ? "0" + n3 : Integer.toString(n3);
        String string7 = n4 < 10 ? "0" + n4 : Integer.toString(n4);
        String string8 = n5 < 10 ? "0" + n5 : Integer.toString(n5);
        String string9 = n6 < 10 ? "0" + n6 : Integer.toString(n6);
        if (n7 == 0) {
            string = "0";
        } else {
            string = Integer.toString(n7);
            string = string3.substring(0, 9 - string.length()) + string;
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            int n8 = 8;
            while (cArray[n8] == '0') {
                --n8;
            }
            string = new String(cArray, 0, n8 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("-");
        stringBuffer.append(string5);
        stringBuffer.append("-");
        stringBuffer.append(string6);
        stringBuffer.append("T");
        stringBuffer.append(string7);
        stringBuffer.append(":");
        stringBuffer.append(string8);
        stringBuffer.append(":");
        stringBuffer.append(string9);
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CloseableIterationGraphResult
    extends CloseableIterationBase<org.openrdf.model.Statement, QueryEvaluationException> {
        int col_g;
        int col_s;
        int col_p;
        int col_o;

        public CloseableIterationGraphResult(ResultSet resultSet) throws QueryEvaluationException {
            super(resultSet, null, null, null);
            this.col_g = -1;
            this.col_s = -1;
            this.col_p = -1;
            this.col_o = -1;
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    String string = resultSetMetaData.getColumnName(i);
                    if (string.equalsIgnoreCase("G")) {
                        this.col_g = i;
                        continue;
                    }
                    if (string.equalsIgnoreCase("S")) {
                        this.col_s = i;
                        continue;
                    }
                    if (string.equalsIgnoreCase("P")) {
                        this.col_p = i;
                        continue;
                    }
                    if (!string.equalsIgnoreCase("O")) continue;
                    this.col_o = i;
                }
            }
            catch (Exception exception) {
                throw this.createException(exception);
            }
        }

        private QueryEvaluationException createException(Exception exception) {
            return new QueryEvaluationException((Throwable)exception);
        }

        @Override
        protected void extractRow() throws Exception {
            Resource resource = null;
            URI uRI = null;
            Value value = null;
            Resource resource2 = null;
            if (this.col_s != -1) {
                resource = (Resource)VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_s));
            }
            if (this.col_p != -1) {
                uRI = (URI)VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_p));
            }
            if (this.col_o != -1) {
                value = VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_o));
            }
            if (this.col_g != -1) {
                resource2 = (Resource)VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_g));
            }
            this.v_row = new ContextStatementImpl(resource, uRI, value, resource2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CloseableIterationBindingSet
    extends CloseableIterationBase<BindingSet, QueryEvaluationException> {
        ResultSetMetaData rsmd;

        public CloseableIterationBindingSet(ResultSet resultSet) throws QueryEvaluationException {
            super(resultSet, null, null, null);
            try {
                this.rsmd = resultSet.getMetaData();
            }
            catch (Exception exception) {
                throw this.createException(exception);
            }
        }

        private QueryEvaluationException createException(Exception exception) {
            return new QueryEvaluationException((Throwable)exception);
        }

        @Override
        protected void extractRow() throws Exception {
            this.v_row = new QueryBindingSet();
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                String string = this.rsmd.getColumnName(i);
                Object object = this.v_rs.getObject(i);
                Value value = VirtuosoRepositoryConnection.this.castValue(object);
                ((QueryBindingSet)this.v_row).setBinding(string, value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CloseableIterationStmt
    extends CloseableIterationBase<org.openrdf.model.Statement, RepositoryException> {
        int col_g;
        int col_s;
        int col_p;
        int col_o;

        public CloseableIterationStmt(ResultSet resultSet, Resource resource, URI uRI, Value value) throws RepositoryException {
            super(resultSet, resource, uRI, value);
            this.col_g = -1;
            this.col_s = -1;
            this.col_p = -1;
            this.col_o = -1;
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    String string = resultSetMetaData.getColumnName(i);
                    if (string.equalsIgnoreCase("g")) {
                        this.col_g = i;
                        continue;
                    }
                    if (string.equalsIgnoreCase("s")) {
                        this.col_s = i;
                        continue;
                    }
                    if (string.equalsIgnoreCase("p")) {
                        this.col_p = i;
                        continue;
                    }
                    if (!string.equalsIgnoreCase("o")) continue;
                    this.col_o = i;
                }
            }
            catch (Exception exception) {
                throw this.createException(exception);
            }
        }

        private RepositoryException createException(Exception exception) {
            return new RepositoryException((Throwable)exception);
        }

        @Override
        protected void extractRow() throws Exception {
            Resource resource = null;
            Resource resource2 = this.subject;
            URI uRI = this.predicate;
            Value value = this.object;
            Object object = null;
            try {
                if (this.col_g != -1) {
                    object = this.v_rs.getObject(this.col_g);
                    resource = (Resource)VirtuosoRepositoryConnection.this.castValue(object);
                }
            }
            catch (ClassCastException classCastException) {
                throw new RepositoryException("Unexpected resource type encountered. Was expecting Resource: " + object, (Throwable)classCastException);
            }
            if (resource2 == null && this.col_s != -1) {
                try {
                    object = this.v_rs.getObject(this.col_s);
                    resource2 = (Resource)VirtuosoRepositoryConnection.this.castValue(object);
                }
                catch (ClassCastException classCastException) {
                    throw new RepositoryException("Unexpected resource type encountered. Was expecting Resource: " + object, (Throwable)classCastException);
                }
            }
            if (uRI == null && this.col_p != -1) {
                try {
                    object = this.v_rs.getObject(this.col_p);
                    uRI = (URI)VirtuosoRepositoryConnection.this.castValue(object);
                }
                catch (ClassCastException classCastException) {
                    throw new RepositoryException("Unexpected resource type encountered. Was expecting URI: " + object, (Throwable)classCastException);
                }
            }
            if (value == null && this.col_o != -1) {
                value = VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_o));
            }
            this.v_row = new ContextStatementImpl(resource2, uRI, value, resource);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CloseableIterationBase<E, X extends Exception>
    implements CloseableIteration<E, X> {
        E v_row;
        boolean v_finished = false;
        boolean v_prefetched = false;
        Resource subject;
        URI predicate;
        Value object;
        ResultSet v_rs;

        public CloseableIterationBase(ResultSet resultSet, Resource resource, URI uRI, Value value) {
            this.v_rs = resultSet;
            this.subject = resource;
            this.predicate = uRI;
            this.object = value;
        }

        private X createException(Exception exception) {
            return null;
        }

        public boolean hasNext() throws X {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            return !this.v_finished;
        }

        public E next() throws X {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            this.v_prefetched = false;
            if (this.v_finished) {
                throw new NoSuchElementException();
            }
            return this.v_row;
        }

        public void remove() throws X {
            throw new UnsupportedOperationException();
        }

        public void close() throws X {
            if (!this.v_finished) {
                try {
                    this.v_rs.close();
                }
                catch (SQLException sQLException) {
                    throw this.createException(sQLException);
                }
            }
            this.v_finished = true;
        }

        protected void finalize() throws Throwable {
            if (!this.v_finished) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void moveForward() throws X {
            try {
                if (!this.v_finished && this.v_rs.next()) {
                    this.extractRow();
                    this.v_prefetched = true;
                } else {
                    this.close();
                }
            }
            catch (Exception exception) {
                throw this.createException(exception);
            }
        }

        protected void extractRow() throws Exception {
        }
    }
}

