# frozen_string_literal: true
# :markup: markdown

=begin
--
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/lib/prism/compiler.rb.erb
if you are looking to modify the template
++
=end

module Prism
  # A compiler is a visitor that returns the value of each node as it visits.
  # This is as opposed to a visitor which will only walk the tree. This can be
  # useful when you are trying to compile a tree into a different format.
  #
  # For example, to build a representation of the tree as s-expressions, you
  # could write:
  #
  #     class SExpressions < Prism::Compiler
  #       def visit_arguments_node(node) = [:arguments, super]
  #       def visit_call_node(node) = [:call, super]
  #       def visit_integer_node(node) = [:integer]
  #       def visit_program_node(node) = [:program, super]
  #     end
  #
  #     Prism.parse("1 + 2").value.accept(SExpressions.new)
  #     # => [:program, [[[:call, [[:integer], [:arguments, [[:integer]]]]]]]]
  #
  class Compiler < Visitor
    # Visit an individual node.
    def visit(node)
      node&.accept(self)
    end

    # Visit a list of nodes.
    def visit_all(nodes)
      nodes.map { |node| node&.accept(self) }
    end

    # Visit the child nodes of the given node.
    def visit_child_nodes(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a AliasGlobalVariableNode node
    def visit_alias_global_variable_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a AliasMethodNode node
    def visit_alias_method_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a AlternationPatternNode node
    def visit_alternation_pattern_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a AndNode node
    def visit_and_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ArgumentsNode node
    def visit_arguments_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ArrayNode node
    def visit_array_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ArrayPatternNode node
    def visit_array_pattern_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a AssocNode node
    def visit_assoc_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a AssocSplatNode node
    def visit_assoc_splat_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a BackReferenceReadNode node
    def visit_back_reference_read_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a BeginNode node
    def visit_begin_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a BlockArgumentNode node
    def visit_block_argument_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a BlockLocalVariableNode node
    def visit_block_local_variable_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a BlockNode node
    def visit_block_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a BlockParameterNode node
    def visit_block_parameter_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a BlockParametersNode node
    def visit_block_parameters_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a BreakNode node
    def visit_break_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a CallAndWriteNode node
    def visit_call_and_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a CallNode node
    def visit_call_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a CallOperatorWriteNode node
    def visit_call_operator_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a CallOrWriteNode node
    def visit_call_or_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a CallTargetNode node
    def visit_call_target_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a CapturePatternNode node
    def visit_capture_pattern_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a CaseMatchNode node
    def visit_case_match_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a CaseNode node
    def visit_case_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ClassNode node
    def visit_class_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ClassVariableAndWriteNode node
    def visit_class_variable_and_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ClassVariableOperatorWriteNode node
    def visit_class_variable_operator_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ClassVariableOrWriteNode node
    def visit_class_variable_or_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ClassVariableReadNode node
    def visit_class_variable_read_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ClassVariableTargetNode node
    def visit_class_variable_target_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ClassVariableWriteNode node
    def visit_class_variable_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantAndWriteNode node
    def visit_constant_and_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantOperatorWriteNode node
    def visit_constant_operator_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantOrWriteNode node
    def visit_constant_or_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantPathAndWriteNode node
    def visit_constant_path_and_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantPathNode node
    def visit_constant_path_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantPathOperatorWriteNode node
    def visit_constant_path_operator_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantPathOrWriteNode node
    def visit_constant_path_or_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantPathTargetNode node
    def visit_constant_path_target_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantPathWriteNode node
    def visit_constant_path_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantReadNode node
    def visit_constant_read_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantTargetNode node
    def visit_constant_target_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ConstantWriteNode node
    def visit_constant_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a DefNode node
    def visit_def_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a DefinedNode node
    def visit_defined_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ElseNode node
    def visit_else_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a EmbeddedStatementsNode node
    def visit_embedded_statements_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a EmbeddedVariableNode node
    def visit_embedded_variable_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a EnsureNode node
    def visit_ensure_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a FalseNode node
    def visit_false_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a FindPatternNode node
    def visit_find_pattern_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a FlipFlopNode node
    def visit_flip_flop_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a FloatNode node
    def visit_float_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ForNode node
    def visit_for_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ForwardingArgumentsNode node
    def visit_forwarding_arguments_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ForwardingParameterNode node
    def visit_forwarding_parameter_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ForwardingSuperNode node
    def visit_forwarding_super_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a GlobalVariableAndWriteNode node
    def visit_global_variable_and_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a GlobalVariableOperatorWriteNode node
    def visit_global_variable_operator_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a GlobalVariableOrWriteNode node
    def visit_global_variable_or_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a GlobalVariableReadNode node
    def visit_global_variable_read_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a GlobalVariableTargetNode node
    def visit_global_variable_target_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a GlobalVariableWriteNode node
    def visit_global_variable_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a HashNode node
    def visit_hash_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a HashPatternNode node
    def visit_hash_pattern_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a IfNode node
    def visit_if_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ImaginaryNode node
    def visit_imaginary_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ImplicitNode node
    def visit_implicit_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ImplicitRestNode node
    def visit_implicit_rest_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InNode node
    def visit_in_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a IndexAndWriteNode node
    def visit_index_and_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a IndexOperatorWriteNode node
    def visit_index_operator_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a IndexOrWriteNode node
    def visit_index_or_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a IndexTargetNode node
    def visit_index_target_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InstanceVariableAndWriteNode node
    def visit_instance_variable_and_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InstanceVariableOperatorWriteNode node
    def visit_instance_variable_operator_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InstanceVariableOrWriteNode node
    def visit_instance_variable_or_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InstanceVariableReadNode node
    def visit_instance_variable_read_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InstanceVariableTargetNode node
    def visit_instance_variable_target_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InstanceVariableWriteNode node
    def visit_instance_variable_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a IntegerNode node
    def visit_integer_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InterpolatedMatchLastLineNode node
    def visit_interpolated_match_last_line_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InterpolatedRegularExpressionNode node
    def visit_interpolated_regular_expression_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InterpolatedStringNode node
    def visit_interpolated_string_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InterpolatedSymbolNode node
    def visit_interpolated_symbol_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a InterpolatedXStringNode node
    def visit_interpolated_x_string_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ItLocalVariableReadNode node
    def visit_it_local_variable_read_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ItParametersNode node
    def visit_it_parameters_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a KeywordHashNode node
    def visit_keyword_hash_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a KeywordRestParameterNode node
    def visit_keyword_rest_parameter_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a LambdaNode node
    def visit_lambda_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a LocalVariableAndWriteNode node
    def visit_local_variable_and_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a LocalVariableOperatorWriteNode node
    def visit_local_variable_operator_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a LocalVariableOrWriteNode node
    def visit_local_variable_or_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a LocalVariableReadNode node
    def visit_local_variable_read_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a LocalVariableTargetNode node
    def visit_local_variable_target_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a LocalVariableWriteNode node
    def visit_local_variable_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a MatchLastLineNode node
    def visit_match_last_line_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a MatchPredicateNode node
    def visit_match_predicate_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a MatchRequiredNode node
    def visit_match_required_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a MatchWriteNode node
    def visit_match_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a MissingNode node
    def visit_missing_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ModuleNode node
    def visit_module_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a MultiTargetNode node
    def visit_multi_target_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a MultiWriteNode node
    def visit_multi_write_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a NextNode node
    def visit_next_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a NilNode node
    def visit_nil_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a NoKeywordsParameterNode node
    def visit_no_keywords_parameter_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a NumberedParametersNode node
    def visit_numbered_parameters_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a NumberedReferenceReadNode node
    def visit_numbered_reference_read_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a OptionalKeywordParameterNode node
    def visit_optional_keyword_parameter_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a OptionalParameterNode node
    def visit_optional_parameter_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a OrNode node
    def visit_or_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ParametersNode node
    def visit_parameters_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ParenthesesNode node
    def visit_parentheses_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a PinnedExpressionNode node
    def visit_pinned_expression_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a PinnedVariableNode node
    def visit_pinned_variable_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a PostExecutionNode node
    def visit_post_execution_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a PreExecutionNode node
    def visit_pre_execution_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ProgramNode node
    def visit_program_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a RangeNode node
    def visit_range_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a RationalNode node
    def visit_rational_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a RedoNode node
    def visit_redo_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a RegularExpressionNode node
    def visit_regular_expression_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a RequiredKeywordParameterNode node
    def visit_required_keyword_parameter_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a RequiredParameterNode node
    def visit_required_parameter_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a RescueModifierNode node
    def visit_rescue_modifier_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a RescueNode node
    def visit_rescue_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a RestParameterNode node
    def visit_rest_parameter_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a RetryNode node
    def visit_retry_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ReturnNode node
    def visit_return_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a SelfNode node
    def visit_self_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a ShareableConstantNode node
    def visit_shareable_constant_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a SingletonClassNode node
    def visit_singleton_class_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a SourceEncodingNode node
    def visit_source_encoding_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a SourceFileNode node
    def visit_source_file_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a SourceLineNode node
    def visit_source_line_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a SplatNode node
    def visit_splat_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a StatementsNode node
    def visit_statements_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a StringNode node
    def visit_string_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a SuperNode node
    def visit_super_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a SymbolNode node
    def visit_symbol_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a TrueNode node
    def visit_true_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a UndefNode node
    def visit_undef_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a UnlessNode node
    def visit_unless_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a UntilNode node
    def visit_until_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a WhenNode node
    def visit_when_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a WhileNode node
    def visit_while_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a XStringNode node
    def visit_x_string_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end

    # Compile a YieldNode node
    def visit_yield_node(node)
      node.each_child_node.map { |node| node.accept(self) }
    end
  end
end
