/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.ArgListExpr;
import android.databinding.tool.expr.BitShiftExpr;
import android.databinding.tool.expr.BracketExpr;
import android.databinding.tool.expr.CastExpr;
import android.databinding.tool.expr.ComparisonExpr;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.FieldAccessExpr;
import android.databinding.tool.expr.GroupExpr;
import android.databinding.tool.expr.IdentifierExpr;
import android.databinding.tool.expr.InstanceOfExpr;
import android.databinding.tool.expr.MathExpr;
import android.databinding.tool.expr.MethodCallExpr;
import android.databinding.tool.expr.ResourceExpr;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.expr.SymbolExpr;
import android.databinding.tool.expr.TernaryExpr;
import android.databinding.tool.expr.UnaryExpr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.util.L;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExprModel {
    Map<String, Expr> mExprMap = new HashMap<String, Expr>();
    List<Expr> mBindingExpressions = new ArrayList<Expr>();
    private int mInvalidateableFieldLimit = 0;
    private int mRequirementIdCount = 0;
    private int mArgListIdCounter = 0;
    private static final String TRUE_KEY_SUFFIX = "== true";
    private static final String FALSE_KEY_SUFFIX = "== false";
    private BitSet mInvalidateAnyFlags;
    private List<Expr> mPendingExpressions;
    private String[] mFlagMapping;
    private BitSet mInvalidateableFlags;
    private BitSet mConditionalFlags;
    private int mFlagBucketCount;
    private List<Expr> mObservables;
    private boolean mSealed = false;
    private Map<String, String> mImports = new HashMap<String, String>();
    private static final Predicate<Expr> sShouldReadPred = new Predicate<Expr>(){

        @Override
        public boolean apply(Expr expr) {
            return !expr.getShouldReadFlags().isEmpty() && !Iterables.any(expr.getDependencies(), new Predicate<Dependency>(){

                @Override
                public boolean apply(Dependency dependency) {
                    boolean result = dependency.isConditional() || dependency.getOther().hasNestedCannotRead();
                    return result;
                }
            });
        }
    };

    public <T extends Expr> T register(T expr) {
        Preconditions.checkState(!this.mSealed, "Cannot add expressions to a model after it is sealed");
        Expr existing = this.mExprMap.get(expr.getUniqueKey());
        if (existing != null) {
            Preconditions.checkState(expr.getParents().isEmpty(), "If an expression already exists, it should've never been added to a parent,if thats the case, somewhere we are creating an expression w/ocalling expression model");
            expr.onSwappedWith(existing);
            return (T)existing;
        }
        this.mExprMap.put(expr.getUniqueKey(), expr);
        expr.setModel(this);
        return expr;
    }

    public void unregister(Expr expr) {
        this.mExprMap.remove(expr.getUniqueKey());
    }

    public Map<String, Expr> getExprMap() {
        return this.mExprMap;
    }

    public int size() {
        return this.mExprMap.size();
    }

    public ComparisonExpr comparison(String op, Expr left, Expr right) {
        return this.register(new ComparisonExpr(op, left, right));
    }

    public InstanceOfExpr instanceOfOp(Expr expr, String type) {
        return this.register(new InstanceOfExpr(expr, type));
    }

    public FieldAccessExpr field(Expr parent, String name) {
        return this.register(new FieldAccessExpr(parent, name));
    }

    public FieldAccessExpr observableField(Expr parent, String name) {
        return this.register(new FieldAccessExpr(parent, name, true));
    }

    public SymbolExpr symbol(String text, Class type) {
        return this.register(new SymbolExpr(text, type));
    }

    public TernaryExpr ternary(Expr pred, Expr ifTrue, Expr ifFalse) {
        return this.register(new TernaryExpr(pred, ifTrue, ifFalse));
    }

    public IdentifierExpr identifier(String name) {
        return this.register(new IdentifierExpr(name));
    }

    public StaticIdentifierExpr staticIdentifier(String name) {
        return this.register(new StaticIdentifierExpr(name));
    }

    public MethodCallExpr methodCall(Expr target, String name, List<Expr> args) {
        return this.register(new MethodCallExpr(target, name, args));
    }

    public MathExpr math(Expr left, String op, Expr right) {
        return this.register(new MathExpr(left, op, right));
    }

    public TernaryExpr logical(Expr left, String op, Expr right) {
        if ("&&".equals(op)) {
            return this.register(new TernaryExpr(left, right, (Expr)this.symbol("false", Boolean.TYPE)));
        }
        return this.register(new TernaryExpr(left, (Expr)this.symbol("true", Boolean.TYPE), right));
    }

    public BitShiftExpr bitshift(Expr left, String op, Expr right) {
        return this.register(new BitShiftExpr(left, op, right));
    }

    public UnaryExpr unary(String op, Expr expr) {
        return this.register(new UnaryExpr(op, expr));
    }

    public Expr group(Expr grouped) {
        return this.register(new GroupExpr(grouped));
    }

    public Expr resourceExpr(String packageName, String resourceType, String resourceName, List<Expr> args) {
        return this.register(new ResourceExpr(packageName, resourceType, resourceName, args));
    }

    public Expr bracketExpr(Expr variableExpr, Expr argExpr) {
        return this.register(new BracketExpr(variableExpr, argExpr));
    }

    public Expr castExpr(String type, Expr expr) {
        return this.register(new CastExpr(type, expr));
    }

    public List<Expr> getBindingExpressions() {
        return this.mBindingExpressions;
    }

    public void addImport(String alias, String type) {
        Preconditions.checkState(!this.mImports.containsKey(alias), "%s has already been defined as %s", alias, type);
        StaticIdentifierExpr id = this.staticIdentifier(alias);
        L.d("adding import %s as %s klass: %s", type, alias, id.getClass().getSimpleName());
        id.setUserDefinedType(type);
        this.mImports.put(alias, type);
    }

    public Map<String, String> getImports() {
        return this.mImports;
    }

    public Expr bindingExpr(Expr bindingExpr) {
        Preconditions.checkArgument(this.mExprMap.containsKey(bindingExpr.getUniqueKey()), "Main expression should already be registered");
        if (!this.mBindingExpressions.contains(bindingExpr)) {
            this.mBindingExpressions.add(bindingExpr);
        }
        return bindingExpr;
    }

    public Iterable<Expr> findRootNodes() {
        return Iterables.filter(this.mExprMap.values(), new Predicate<Expr>(){

            @Override
            public boolean apply(Expr input) {
                return input.getParents().isEmpty();
            }
        });
    }

    public Iterable<Expr> findLeafNodes() {
        return Iterables.filter(this.mExprMap.values(), new Predicate<Expr>(){

            @Override
            public boolean apply(Expr input) {
                return input.getChildren().isEmpty();
            }
        });
    }

    public List<Expr> getObservables() {
        return this.mObservables;
    }

    public void seal() {
        L.d("sealing model", new Object[0]);
        ArrayList<Expr> notifiableExpressions = new ArrayList<Expr>();
        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
        ArrayList<Expr> exprs = new ArrayList<Expr>(this.mBindingExpressions);
        for (Expr expr : exprs) {
            expr.updateExpr(modelAnalyzer);
        }
        int counter = 0;
        Iterable<Expr> observables = this.filterObservables(modelAnalyzer);
        ArrayList<String> flagMapping2 = Lists.newArrayList();
        this.mObservables = Lists.newArrayList();
        for (Expr expr : observables) {
            flagMapping2.add(expr.getUniqueKey());
            expr.setId(counter++);
            this.mObservables.add(expr);
            notifiableExpressions.add(expr);
            L.d("observable %s", expr.getUniqueKey());
        }
        Iterable<Expr> nonObservableIds = this.filterNonObservableIds(modelAnalyzer);
        for (Expr expr : nonObservableIds) {
            flagMapping2.add(expr.getUniqueKey());
            expr.setId(counter++);
            notifiableExpressions.add(expr);
            L.d("non-observable %s", expr.getUniqueKey());
        }
        for (Expr expr : observables) {
            for (Expr parent : expr.getParents()) {
                if (parent.hasId() || !(parent instanceof FieldAccessExpr)) continue;
                FieldAccessExpr fae = (FieldAccessExpr)parent;
                L.d("checking field access expr %s. getter: %s", fae, fae.getGetter());
                if (!fae.isDynamic() || !fae.getGetter().canBeInvalidated()) continue;
                flagMapping2.add(parent.getUniqueKey());
                parent.setId(counter++);
                notifiableExpressions.add(parent);
                L.d("notifiable field %s : %s for %s : %s", parent.getUniqueKey(), Integer.toHexString(System.identityHashCode(parent)), expr.getUniqueKey(), Integer.toHexString(System.identityHashCode(expr)));
            }
        }
        L.d("list of binding expressions", new Object[0]);
        for (int i = 0; i < this.mBindingExpressions.size(); ++i) {
            L.d("[%d] %s", i, this.mBindingExpressions.get(i));
        }
        for (Expr expr : notifiableExpressions) {
            expr.enableDirectInvalidation();
        }
        for (Expr expr : this.mExprMap.values()) {
            expr.getDependencies();
        }
        int invalidateAnyFlagIndex = counter++;
        flagMapping2.add("INVALIDATE ANY");
        this.mInvalidateableFieldLimit = counter;
        this.mInvalidateableFlags = new BitSet();
        for (int i = 0; i < this.mInvalidateableFieldLimit; ++i) {
            this.mInvalidateableFlags.set(i, true);
        }
        for (Expr expr : this.mExprMap.values()) {
            if (!expr.isConditional()) continue;
            L.d("requirement id for %s is %d", expr, counter);
            expr.setRequirementId(counter);
            flagMapping2.add(expr.getUniqueKey() + FALSE_KEY_SUFFIX);
            flagMapping2.add(expr.getUniqueKey() + TRUE_KEY_SUFFIX);
            counter += 2;
        }
        this.mConditionalFlags = new BitSet();
        for (int i = this.mInvalidateableFieldLimit; i < counter; ++i) {
            this.mConditionalFlags.set(i, true);
        }
        this.mRequirementIdCount = (counter - this.mInvalidateableFieldLimit) / 2;
        for (Map.Entry<String, Expr> entry : this.mExprMap.entrySet()) {
            Expr value = entry.getValue();
            if (value.hasId()) continue;
            value.setId(counter++);
        }
        this.mFlagMapping = new String[flagMapping2.size()];
        flagMapping2.toArray(this.mFlagMapping);
        this.mFlagBucketCount = 1 + this.getTotalFlagCount() / 64;
        this.mInvalidateAnyFlags = new BitSet();
        this.mInvalidateAnyFlags.set(invalidateAnyFlagIndex, true);
        for (Expr expr : this.mExprMap.values()) {
            expr.getShouldReadFlagsWithConditionals();
        }
        for (Expr expr : this.mExprMap.values()) {
            expr.getResolvedType();
        }
        this.mSealed = true;
    }

    public int getFlagBucketCount() {
        return this.mFlagBucketCount;
    }

    public int getTotalFlagCount() {
        return this.mRequirementIdCount * 2 + this.mInvalidateableFieldLimit;
    }

    public int getInvalidateableFieldLimit() {
        return this.mInvalidateableFieldLimit;
    }

    public String[] getFlagMapping() {
        return this.mFlagMapping;
    }

    public String getFlag(int id) {
        return this.mFlagMapping[id];
    }

    private Iterable<Expr> filterNonObservableIds(ModelAnalyzer modelAnalyzer) {
        return Iterables.filter(this.mExprMap.values(), new Predicate<Expr>(){

            @Override
            public boolean apply(Expr input) {
                return input instanceof IdentifierExpr && !input.hasId() && !input.isObservable() && input.isDynamic();
            }
        });
    }

    private Iterable<Expr> filterObservables(ModelAnalyzer modelAnalyzer) {
        return Iterables.filter(this.mExprMap.values(), new Predicate<Expr>(){

            @Override
            public boolean apply(Expr input) {
                return input.isObservable();
            }
        });
    }

    public List<Expr> getPendingExpressions() {
        if (this.mPendingExpressions == null) {
            this.mPendingExpressions = Lists.newArrayList();
            for (Expr expr : this.mExprMap.values()) {
                if (expr.isRead() || !expr.isDynamic()) continue;
                this.mPendingExpressions.add(expr);
            }
        }
        return this.mPendingExpressions;
    }

    public boolean markBitsRead() {
        ArrayList<Expr> markedSomeFlagsRead = Lists.newArrayList();
        for (Expr expr : ExprModel.filterShouldRead(this.getPendingExpressions())) {
            expr.markFlagsAsRead(expr.getShouldReadFlags());
            markedSomeFlagsRead.add(expr);
        }
        return this.pruneDone(markedSomeFlagsRead);
    }

    private boolean pruneDone(List<Expr> markedSomeFlagsAsRead) {
        boolean marked = true;
        ArrayList<Expr> markedAsReadList = Lists.newArrayList();
        while (marked) {
            marked = false;
            for (Expr expr : this.mExprMap.values()) {
                if (expr.isRead() || !expr.markAsReadIfDone()) continue;
                L.d("marked %s as read ", expr.getUniqueKey());
                marked = true;
                markedAsReadList.add(expr);
                markedSomeFlagsAsRead.remove(expr);
            }
        }
        boolean elevated = false;
        for (Expr markedAsRead : markedAsReadList) {
            for (Dependency dependency : markedAsRead.getDependants()) {
                if (!dependency.getDependant().considerElevatingConditionals(markedAsRead)) continue;
                elevated = true;
            }
        }
        for (Expr partialRead : markedSomeFlagsAsRead) {
            boolean allPathsAreSatisfied = partialRead.getAllCalculationPaths().areAllPathsSatisfied(partialRead.mReadSoFar);
            if (!allPathsAreSatisfied) continue;
            for (Dependency dependency : partialRead.getDependants()) {
                if (!dependency.getDependant().considerElevatingConditionals(partialRead)) continue;
                elevated = true;
            }
        }
        if (elevated) {
            for (Expr expr : this.getPendingExpressions()) {
                if (expr.isRead()) continue;
                expr.invalidateReadFlags();
            }
            this.mPendingExpressions = null;
        }
        return elevated;
    }

    public static Iterable<Expr> filterShouldRead(Iterable<Expr> exprs) {
        return ExprModel.toCollection(Iterables.filter(exprs, sShouldReadPred));
    }

    public static List<Expr> toCollection(Iterable<Expr> iterable) {
        return Arrays.asList(Iterables.toArray(iterable, Expr.class));
    }

    public Expr findFlagExpression(int flag) {
        if (this.mInvalidateAnyFlags.get(flag)) {
            return null;
        }
        String key = this.mFlagMapping[flag];
        if (this.mExprMap.containsKey(key)) {
            return this.mExprMap.get(key);
        }
        int falseIndex = key.indexOf(FALSE_KEY_SUFFIX);
        if (falseIndex > -1) {
            String trimmed = key.substring(0, falseIndex);
            return this.mExprMap.get(trimmed);
        }
        int trueIndex = key.indexOf(TRUE_KEY_SUFFIX);
        if (trueIndex > -1) {
            String trimmed = key.substring(0, trueIndex);
            return this.mExprMap.get(trimmed);
        }
        StringBuilder error = new StringBuilder();
        error.append("cannot find flag:").append(flag).append("\n");
        error.append("invalidate any flag:").append(this.mInvalidateAnyFlags).append("\n");
        error.append("key:").append(key).append("\n");
        error.append("flag mapping:").append(Arrays.toString(this.mFlagMapping));
        Preconditions.checkArgument(false, error.toString());
        return null;
    }

    public BitSet getInvalidateAnyBitSet() {
        return this.mInvalidateAnyFlags;
    }

    public Expr argListExpr(Iterable<Expr> expressions) {
        return this.register(new ArgListExpr(this.mArgListIdCounter++, expressions));
    }
}

