/*
 *   Licensed to the Apache Software Foundation (ASF) under one
 *   or more contributor license agreements.  See the NOTICE file
 *   distributed with this work for additional information
 *   regarding copyright ownership.  The ASF licenses this file
 *   to you under the Apache License, Version 2.0 (the
 *   "License"); you may not use this file except in compliance
 *   with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing,
 *   software distributed under the License is distributed on an
 *   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *   KIND, either express or implied.  See the License for the
 *   specific language governing permissions and limitations
 *   under the License.
 *
 */

package org.apache.directory.api.ldap.model.csn;


import com.mycila.junit.concurrent.Concurrency;
import com.mycila.junit.concurrent.ConcurrentJunitRunner;

import org.apache.directory.api.ldap.model.csn.Csn;
import org.apache.directory.api.ldap.model.csn.CsnFactory;
import org.junit.Test;
import org.junit.runner.RunWith;

import static org.junit.Assert.assertFalse;


/**
 * Test case for the DefaultCSNFactory class.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
@RunWith(ConcurrentJunitRunner.class)
@Concurrency()
public class CsnFactoryTest
{
    private static final int NUM_GENERATES = 10;


    /**
     * Ensure all CSN's generated by a CSNFactory are unique.
     *
     */
    @Test
    public void testUnique()
    {
        int replicaId = 001;
        CsnFactory defaultCSNFactory = new CsnFactory( replicaId );

        Csn[] csns = new Csn[NUM_GENERATES];

        for ( int i = 0; i < NUM_GENERATES; i++ )
        {
            csns[i] = defaultCSNFactory.newInstance();
        }

        for ( int i = 0; i < NUM_GENERATES; i++ )
        {
            for ( int j = i + 1; j < NUM_GENERATES; j++ )
            {
                assertFalse( csns[i].equals( csns[j] ) );
            }
        }
    }
}
