# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .offer_term_info import OfferTermInfo


class RecurringCharge(OfferTermInfo):
    """Indicates a recurring charge is present for this offer.

    :param effective_date: Indicates the date from which the offer term is
     effective.
    :type effective_date: datetime
    :param name: Polymorphic Discriminator
    :type name: str
    :param recurring_charge: The amount of recurring charge as per the offer
     term.
    :type recurring_charge: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'effective_date': {'key': 'EffectiveDate', 'type': 'iso-8601'},
        'name': {'key': 'Name', 'type': 'str'},
        'recurring_charge': {'key': 'RecurringCharge', 'type': 'int'},
    }

    def __init__(self, effective_date=None, recurring_charge=None):
        super(RecurringCharge, self).__init__(effective_date=effective_date)
        self.recurring_charge = recurring_charge
        self.name = 'Recurring Charge'
