# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .entity_health import EntityHealth


class ReplicaHealth(EntityHealth):
    """Represents a base class for stateful service replica or stateless service
    instance health.
    Contains the replica aggregated health state, the health events and the
    unhealthy evaluations.
    .

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy.
     . Possible values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str
    :param health_events: The list of health events reported on the entity.
    :type health_events: list of :class:`HealthEvent
     <azure.servicefabric.models.HealthEvent>`
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations: list of :class:`HealthEvaluationWrapper
     <azure.servicefabric.models.HealthEvaluationWrapper>`
    :param partition_id: Id of the partition to which this replica belongs.
    :type partition_id: str
    :param ServiceKind: Polymorphic Discriminator
    :type ServiceKind: str
    """ 

    _validation = {
        'ServiceKind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'ServiceKind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'ServiceKind': {'Stateful': 'StatefulServiceReplicaHealth', 'Stateless': 'StatelessServiceInstanceHealth'}
    }

    def __init__(self, aggregated_health_state=None, health_events=None, unhealthy_evaluations=None, partition_id=None):
        super(ReplicaHealth, self).__init__(aggregated_health_state=aggregated_health_state, health_events=health_events, unhealthy_evaluations=unhealthy_evaluations)
        self.partition_id = partition_id
        self.ServiceKind = None
        self.ServiceKind = 'ReplicaHealth'
