# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackendUpdateParameters(Model):
    """Backend update parameters.

    :param title: Backend Title.
    :type title: str
    :param description: Backend Description.
    :type description: str
    :param resource_id: Management Uri of the Resource in External System.
     This url can be the Arm Resource Id of Logic Apps, Function Apps or Api
     Apps.
    :type resource_id: str
    :param properties: Backend Properties contract
    :type properties: ~azure.mgmt.apimanagement.models.BackendProperties
    :param credentials: Backend Credentials Contract Properties
    :type credentials:
     ~azure.mgmt.apimanagement.models.BackendCredentialsContract
    :param proxy: Backend Proxy Contract Properties
    :type proxy: ~azure.mgmt.apimanagement.models.BackendProxyContract
    :param tls: Backend TLS Properties
    :type tls: ~azure.mgmt.apimanagement.models.BackendTlsProperties
    :param url: Runtime Url of the Backend.
    :type url: str
    :param protocol: Backend communication protocol. Possible values include:
     'http', 'soap'
    :type protocol: str or ~azure.mgmt.apimanagement.models.BackendProtocol
    """

    _validation = {
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
        'url': {'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'properties.credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'properties.proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'properties.tls', 'type': 'BackendTlsProperties'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BackendUpdateParameters, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.properties = kwargs.get('properties', None)
        self.credentials = kwargs.get('credentials', None)
        self.proxy = kwargs.get('proxy', None)
        self.tls = kwargs.get('tls', None)
        self.url = kwargs.get('url', None)
        self.protocol = kwargs.get('protocol', None)
