# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class PolicyContract(Resource):
    """Policy Contract details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param value: Required. Contents of the Policy as defined by the format.
    :type value: str
    :param format: Format of the policyContent. Possible values include:
     'xml', 'xml-link', 'rawxml', 'rawxml-link'. Default value: "xml" .
    :type format: str or ~azure.mgmt.apimanagement.models.PolicyContentFormat
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PolicyContract, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.format = kwargs.get('format', "xml")
