# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._data_factory_management_client_enums import *


class AccessPolicyResponse(msrest.serialization.Model):
    """Get Data Plane read only token response definition.

    :param policy: The user access policy.
    :type policy: ~azure.mgmt.datafactory.models.UserAccessPolicy
    :param access_token: Data Plane read only access token.
    :type access_token: str
    :param data_plane_url: Data Plane service base URL.
    :type data_plane_url: str
    """

    _attribute_map = {
        'policy': {'key': 'policy', 'type': 'UserAccessPolicy'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'data_plane_url': {'key': 'dataPlaneUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        policy: Optional["UserAccessPolicy"] = None,
        access_token: Optional[str] = None,
        data_plane_url: Optional[str] = None,
        **kwargs
    ):
        super(AccessPolicyResponse, self).__init__(**kwargs)
        self.policy = policy
        self.access_token = access_token
        self.data_plane_url = data_plane_url


class Activity(msrest.serialization.Model):
    """A pipeline activity.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ControlActivity, ExecuteWranglingDataflowActivity, ExecutionActivity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
    }

    _subtype_map = {
        'type': {'Container': 'ControlActivity', 'ExecuteWranglingDataflow': 'ExecuteWranglingDataflowActivity', 'Execution': 'ExecutionActivity'}
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        **kwargs
    ):
        super(Activity, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.type = 'Activity'  # type: str
        self.description = description
        self.depends_on = depends_on
        self.user_properties = user_properties


class ActivityDependency(msrest.serialization.Model):
    """Activity dependency information.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param activity: Required. Activity name.
    :type activity: str
    :param dependency_conditions: Required. Match-Condition for the dependency.
    :type dependency_conditions: list[str or ~azure.mgmt.datafactory.models.DependencyCondition]
    """

    _validation = {
        'activity': {'required': True},
        'dependency_conditions': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'activity': {'key': 'activity', 'type': 'str'},
        'dependency_conditions': {'key': 'dependencyConditions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        activity: str,
        dependency_conditions: List[Union[str, "DependencyCondition"]],
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(ActivityDependency, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.activity = activity
        self.dependency_conditions = dependency_conditions


class ActivityPolicy(msrest.serialization.Model):
    """Execution policy for an activity.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param timeout: Specifies the timeout for the activity to run. The default timeout is 7 days.
     Type: string (or Expression with resultType string), pattern:
     ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type timeout: any
    :param retry: Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with
     resultType integer), minimum: 0.
    :type retry: any
    :param retry_interval_in_seconds: Interval between each retry attempt (in seconds). The default
     is 30 sec.
    :type retry_interval_in_seconds: int
    :param secure_input: When set to true, Input from activity is considered as secure and will not
     be logged to monitoring.
    :type secure_input: bool
    :param secure_output: When set to true, Output from activity is considered as secure and will
     not be logged to monitoring.
    :type secure_output: bool
    """

    _validation = {
        'retry_interval_in_seconds': {'maximum': 86400, 'minimum': 30},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'timeout': {'key': 'timeout', 'type': 'object'},
        'retry': {'key': 'retry', 'type': 'object'},
        'retry_interval_in_seconds': {'key': 'retryIntervalInSeconds', 'type': 'int'},
        'secure_input': {'key': 'secureInput', 'type': 'bool'},
        'secure_output': {'key': 'secureOutput', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        timeout: Optional[Any] = None,
        retry: Optional[Any] = None,
        retry_interval_in_seconds: Optional[int] = None,
        secure_input: Optional[bool] = None,
        secure_output: Optional[bool] = None,
        **kwargs
    ):
        super(ActivityPolicy, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.timeout = timeout
        self.retry = retry
        self.retry_interval_in_seconds = retry_interval_in_seconds
        self.secure_input = secure_input
        self.secure_output = secure_output


class ActivityRun(msrest.serialization.Model):
    """Information about an activity run in a pipeline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :ivar pipeline_name: The name of the pipeline.
    :vartype pipeline_name: str
    :ivar pipeline_run_id: The id of the pipeline run.
    :vartype pipeline_run_id: str
    :ivar activity_name: The name of the activity.
    :vartype activity_name: str
    :ivar activity_type: The type of the activity.
    :vartype activity_type: str
    :ivar activity_run_id: The id of the activity run.
    :vartype activity_run_id: str
    :ivar linked_service_name: The name of the compute linked service.
    :vartype linked_service_name: str
    :ivar status: The status of the activity run.
    :vartype status: str
    :ivar activity_run_start: The start time of the activity run in 'ISO 8601' format.
    :vartype activity_run_start: ~datetime.datetime
    :ivar activity_run_end: The end time of the activity run in 'ISO 8601' format.
    :vartype activity_run_end: ~datetime.datetime
    :ivar duration_in_ms: The duration of the activity run.
    :vartype duration_in_ms: int
    :ivar input: The input for the activity.
    :vartype input: any
    :ivar output: The output for the activity.
    :vartype output: any
    :ivar error: The error if any from the activity run.
    :vartype error: any
    """

    _validation = {
        'pipeline_name': {'readonly': True},
        'pipeline_run_id': {'readonly': True},
        'activity_name': {'readonly': True},
        'activity_type': {'readonly': True},
        'activity_run_id': {'readonly': True},
        'linked_service_name': {'readonly': True},
        'status': {'readonly': True},
        'activity_run_start': {'readonly': True},
        'activity_run_end': {'readonly': True},
        'duration_in_ms': {'readonly': True},
        'input': {'readonly': True},
        'output': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'pipeline_name': {'key': 'pipelineName', 'type': 'str'},
        'pipeline_run_id': {'key': 'pipelineRunId', 'type': 'str'},
        'activity_name': {'key': 'activityName', 'type': 'str'},
        'activity_type': {'key': 'activityType', 'type': 'str'},
        'activity_run_id': {'key': 'activityRunId', 'type': 'str'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'activity_run_start': {'key': 'activityRunStart', 'type': 'iso-8601'},
        'activity_run_end': {'key': 'activityRunEnd', 'type': 'iso-8601'},
        'duration_in_ms': {'key': 'durationInMs', 'type': 'int'},
        'input': {'key': 'input', 'type': 'object'},
        'output': {'key': 'output', 'type': 'object'},
        'error': {'key': 'error', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(ActivityRun, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.pipeline_name = None
        self.pipeline_run_id = None
        self.activity_name = None
        self.activity_type = None
        self.activity_run_id = None
        self.linked_service_name = None
        self.status = None
        self.activity_run_start = None
        self.activity_run_end = None
        self.duration_in_ms = None
        self.input = None
        self.output = None
        self.error = None


class ActivityRunsQueryResponse(msrest.serialization.Model):
    """A list activity runs.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of activity runs.
    :type value: list[~azure.mgmt.datafactory.models.ActivityRun]
    :param continuation_token: The continuation token for getting the next page of results, if any
     remaining results exist, null otherwise.
    :type continuation_token: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ActivityRun]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ActivityRun"],
        continuation_token: Optional[str] = None,
        **kwargs
    ):
        super(ActivityRunsQueryResponse, self).__init__(**kwargs)
        self.value = value
        self.continuation_token = continuation_token


class AddDataFlowToDebugSessionResponse(msrest.serialization.Model):
    """Response body structure for starting data flow debug session.

    :param job_version: The ID of data flow debug job version.
    :type job_version: str
    """

    _attribute_map = {
        'job_version': {'key': 'jobVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_version: Optional[str] = None,
        **kwargs
    ):
        super(AddDataFlowToDebugSessionResponse, self).__init__(**kwargs)
        self.job_version = job_version


class AdditionalColumns(msrest.serialization.Model):
    """Specify the column name and value of additional columns.

    :param name: Additional column name. Type: string (or Expression with resultType string).
    :type name: any
    :param value: Additional column value. Type: string (or Expression with resultType string).
    :type value: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'object'},
        'value': {'key': 'value', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[Any] = None,
        value: Optional[Any] = None,
        **kwargs
    ):
        super(AdditionalColumns, self).__init__(**kwargs)
        self.name = name
        self.value = value


class LinkedService(msrest.serialization.Model):
    """The Azure Data Factory nested object which contains the information and credential which can be used to connect with related store or compute resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSLinkedService, AmazonRdsForOracleLinkedService, AmazonRdsForSqlServerLinkedService, AmazonRedshiftLinkedService, AmazonS3LinkedService, AmazonS3CompatibleLinkedService, AzureBatchLinkedService, AzureBlobFSLinkedService, AzureBlobStorageLinkedService, AzureDataExplorerLinkedService, AzureDataLakeAnalyticsLinkedService, AzureDataLakeStoreLinkedService, AzureDatabricksLinkedService, AzureDatabricksDeltaLakeLinkedService, AzureFileStorageLinkedService, AzureFunctionLinkedService, AzureKeyVaultLinkedService, AzureMLLinkedService, AzureMLServiceLinkedService, AzureMariaDBLinkedService, AzureMySqlLinkedService, AzurePostgreSqlLinkedService, AzureSearchLinkedService, AzureSqlDWLinkedService, AzureSqlDatabaseLinkedService, AzureSqlMILinkedService, AzureStorageLinkedService, AzureTableStorageLinkedService, CassandraLinkedService, CommonDataServiceForAppsLinkedService, ConcurLinkedService, CosmosDbLinkedService, CosmosDbMongoDbApiLinkedService, CouchbaseLinkedService, CustomDataSourceLinkedService, Db2LinkedService, DrillLinkedService, DynamicsLinkedService, DynamicsAXLinkedService, DynamicsCrmLinkedService, EloquaLinkedService, FileServerLinkedService, FtpServerLinkedService, GoogleAdWordsLinkedService, GoogleBigQueryLinkedService, GoogleCloudStorageLinkedService, GreenplumLinkedService, HBaseLinkedService, HDInsightLinkedService, HDInsightOnDemandLinkedService, HdfsLinkedService, HiveLinkedService, HttpLinkedService, HubspotLinkedService, ImpalaLinkedService, InformixLinkedService, JiraLinkedService, MagentoLinkedService, MariaDBLinkedService, MarketoLinkedService, MicrosoftAccessLinkedService, MongoDbLinkedService, MongoDbAtlasLinkedService, MongoDbV2LinkedService, MySqlLinkedService, NetezzaLinkedService, ODataLinkedService, OdbcLinkedService, Office365LinkedService, OracleLinkedService, OracleCloudStorageLinkedService, OracleServiceCloudLinkedService, PaypalLinkedService, PhoenixLinkedService, PostgreSqlLinkedService, PrestoLinkedService, QuickBooksLinkedService, ResponsysLinkedService, RestServiceLinkedService, SalesforceLinkedService, SalesforceMarketingCloudLinkedService, SalesforceServiceCloudLinkedService, SapBWLinkedService, SapCloudForCustomerLinkedService, SapEccLinkedService, SapHanaLinkedService, SapOpenHubLinkedService, SapTableLinkedService, ServiceNowLinkedService, SftpServerLinkedService, SharePointOnlineListLinkedService, ShopifyLinkedService, SnowflakeLinkedService, SparkLinkedService, SqlServerLinkedService, SquareLinkedService, SybaseLinkedService, TeradataLinkedService, VerticaLinkedService, WebLinkedService, XeroLinkedService, ZohoLinkedService.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
    }

    _subtype_map = {
        'type': {'AmazonMWS': 'AmazonMWSLinkedService', 'AmazonRdsForOracle': 'AmazonRdsForOracleLinkedService', 'AmazonRdsForSqlServer': 'AmazonRdsForSqlServerLinkedService', 'AmazonRedshift': 'AmazonRedshiftLinkedService', 'AmazonS3': 'AmazonS3LinkedService', 'AmazonS3Compatible': 'AmazonS3CompatibleLinkedService', 'AzureBatch': 'AzureBatchLinkedService', 'AzureBlobFS': 'AzureBlobFSLinkedService', 'AzureBlobStorage': 'AzureBlobStorageLinkedService', 'AzureDataExplorer': 'AzureDataExplorerLinkedService', 'AzureDataLakeAnalytics': 'AzureDataLakeAnalyticsLinkedService', 'AzureDataLakeStore': 'AzureDataLakeStoreLinkedService', 'AzureDatabricks': 'AzureDatabricksLinkedService', 'AzureDatabricksDeltaLake': 'AzureDatabricksDeltaLakeLinkedService', 'AzureFileStorage': 'AzureFileStorageLinkedService', 'AzureFunction': 'AzureFunctionLinkedService', 'AzureKeyVault': 'AzureKeyVaultLinkedService', 'AzureML': 'AzureMLLinkedService', 'AzureMLService': 'AzureMLServiceLinkedService', 'AzureMariaDB': 'AzureMariaDBLinkedService', 'AzureMySql': 'AzureMySqlLinkedService', 'AzurePostgreSql': 'AzurePostgreSqlLinkedService', 'AzureSearch': 'AzureSearchLinkedService', 'AzureSqlDW': 'AzureSqlDWLinkedService', 'AzureSqlDatabase': 'AzureSqlDatabaseLinkedService', 'AzureSqlMI': 'AzureSqlMILinkedService', 'AzureStorage': 'AzureStorageLinkedService', 'AzureTableStorage': 'AzureTableStorageLinkedService', 'Cassandra': 'CassandraLinkedService', 'CommonDataServiceForApps': 'CommonDataServiceForAppsLinkedService', 'Concur': 'ConcurLinkedService', 'CosmosDb': 'CosmosDbLinkedService', 'CosmosDbMongoDbApi': 'CosmosDbMongoDbApiLinkedService', 'Couchbase': 'CouchbaseLinkedService', 'CustomDataSource': 'CustomDataSourceLinkedService', 'Db2': 'Db2LinkedService', 'Drill': 'DrillLinkedService', 'Dynamics': 'DynamicsLinkedService', 'DynamicsAX': 'DynamicsAXLinkedService', 'DynamicsCrm': 'DynamicsCrmLinkedService', 'Eloqua': 'EloquaLinkedService', 'FileServer': 'FileServerLinkedService', 'FtpServer': 'FtpServerLinkedService', 'GoogleAdWords': 'GoogleAdWordsLinkedService', 'GoogleBigQuery': 'GoogleBigQueryLinkedService', 'GoogleCloudStorage': 'GoogleCloudStorageLinkedService', 'Greenplum': 'GreenplumLinkedService', 'HBase': 'HBaseLinkedService', 'HDInsight': 'HDInsightLinkedService', 'HDInsightOnDemand': 'HDInsightOnDemandLinkedService', 'Hdfs': 'HdfsLinkedService', 'Hive': 'HiveLinkedService', 'HttpServer': 'HttpLinkedService', 'Hubspot': 'HubspotLinkedService', 'Impala': 'ImpalaLinkedService', 'Informix': 'InformixLinkedService', 'Jira': 'JiraLinkedService', 'Magento': 'MagentoLinkedService', 'MariaDB': 'MariaDBLinkedService', 'Marketo': 'MarketoLinkedService', 'MicrosoftAccess': 'MicrosoftAccessLinkedService', 'MongoDb': 'MongoDbLinkedService', 'MongoDbAtlas': 'MongoDbAtlasLinkedService', 'MongoDbV2': 'MongoDbV2LinkedService', 'MySql': 'MySqlLinkedService', 'Netezza': 'NetezzaLinkedService', 'OData': 'ODataLinkedService', 'Odbc': 'OdbcLinkedService', 'Office365': 'Office365LinkedService', 'Oracle': 'OracleLinkedService', 'OracleCloudStorage': 'OracleCloudStorageLinkedService', 'OracleServiceCloud': 'OracleServiceCloudLinkedService', 'Paypal': 'PaypalLinkedService', 'Phoenix': 'PhoenixLinkedService', 'PostgreSql': 'PostgreSqlLinkedService', 'Presto': 'PrestoLinkedService', 'QuickBooks': 'QuickBooksLinkedService', 'Responsys': 'ResponsysLinkedService', 'RestService': 'RestServiceLinkedService', 'Salesforce': 'SalesforceLinkedService', 'SalesforceMarketingCloud': 'SalesforceMarketingCloudLinkedService', 'SalesforceServiceCloud': 'SalesforceServiceCloudLinkedService', 'SapBW': 'SapBWLinkedService', 'SapCloudForCustomer': 'SapCloudForCustomerLinkedService', 'SapEcc': 'SapEccLinkedService', 'SapHana': 'SapHanaLinkedService', 'SapOpenHub': 'SapOpenHubLinkedService', 'SapTable': 'SapTableLinkedService', 'ServiceNow': 'ServiceNowLinkedService', 'Sftp': 'SftpServerLinkedService', 'SharePointOnlineList': 'SharePointOnlineListLinkedService', 'Shopify': 'ShopifyLinkedService', 'Snowflake': 'SnowflakeLinkedService', 'Spark': 'SparkLinkedService', 'SqlServer': 'SqlServerLinkedService', 'Square': 'SquareLinkedService', 'Sybase': 'SybaseLinkedService', 'Teradata': 'TeradataLinkedService', 'Vertica': 'VerticaLinkedService', 'Web': 'WebLinkedService', 'Xero': 'XeroLinkedService', 'Zoho': 'ZohoLinkedService'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        **kwargs
    ):
        super(LinkedService, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'LinkedService'  # type: str
        self.connect_via = connect_via
        self.description = description
        self.parameters = parameters
        self.annotations = annotations


class AmazonMWSLinkedService(LinkedService):
    """Amazon Marketplace Web Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param endpoint: Required. The endpoint of the Amazon MWS server, (i.e.
     mws.amazonservices.com).
    :type endpoint: any
    :param marketplace_id: Required. The Amazon Marketplace ID you want to retrieve data from. To
     retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e.
     A2EUQ1WTGCTBG2).
    :type marketplace_id: any
    :param seller_id: Required. The Amazon seller ID.
    :type seller_id: any
    :param mws_auth_token: The Amazon MWS authentication token.
    :type mws_auth_token: ~azure.mgmt.datafactory.models.SecretBase
    :param access_key_id: Required. The access key id used to access data.
    :type access_key_id: any
    :param secret_key: The secret key used to access data.
    :type secret_key: ~azure.mgmt.datafactory.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: any
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: any
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'marketplace_id': {'required': True},
        'seller_id': {'required': True},
        'access_key_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'marketplace_id': {'key': 'typeProperties.marketplaceID', 'type': 'object'},
        'seller_id': {'key': 'typeProperties.sellerID', 'type': 'object'},
        'mws_auth_token': {'key': 'typeProperties.mwsAuthToken', 'type': 'SecretBase'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_key': {'key': 'typeProperties.secretKey', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: Any,
        marketplace_id: Any,
        seller_id: Any,
        access_key_id: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        mws_auth_token: Optional["SecretBase"] = None,
        secret_key: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[Any] = None,
        use_host_verification: Optional[Any] = None,
        use_peer_verification: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonMWSLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AmazonMWS'  # type: str
        self.endpoint = endpoint
        self.marketplace_id = marketplace_id
        self.seller_id = seller_id
        self.mws_auth_token = mws_auth_token
        self.access_key_id = access_key_id
        self.secret_key = secret_key
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class Dataset(msrest.serialization.Model):
    """The Azure Data Factory nested object which identifies data within different data stores, such as tables, files, folders, and documents.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSObjectDataset, AmazonRdsForOracleTableDataset, AmazonRdsForSqlServerTableDataset, AmazonRedshiftTableDataset, AmazonS3Dataset, AvroDataset, AzureBlobDataset, AzureBlobFSDataset, AzureDataExplorerTableDataset, AzureDataLakeStoreDataset, AzureDatabricksDeltaLakeDataset, AzureMariaDBTableDataset, AzureMySqlTableDataset, AzurePostgreSqlTableDataset, AzureSearchIndexDataset, AzureSqlDWTableDataset, AzureSqlMITableDataset, AzureSqlTableDataset, AzureTableDataset, BinaryDataset, CassandraTableDataset, CommonDataServiceForAppsEntityDataset, ConcurObjectDataset, CosmosDbMongoDbApiCollectionDataset, CosmosDbSqlApiCollectionDataset, CouchbaseTableDataset, CustomDataset, Db2TableDataset, DelimitedTextDataset, DocumentDbCollectionDataset, DrillTableDataset, DynamicsAXResourceDataset, DynamicsCrmEntityDataset, DynamicsEntityDataset, EloquaObjectDataset, ExcelDataset, FileShareDataset, GoogleAdWordsObjectDataset, GoogleBigQueryObjectDataset, GreenplumTableDataset, HBaseObjectDataset, HiveObjectDataset, HttpDataset, HubspotObjectDataset, ImpalaObjectDataset, InformixTableDataset, JiraObjectDataset, JsonDataset, MagentoObjectDataset, MariaDBTableDataset, MarketoObjectDataset, MicrosoftAccessTableDataset, MongoDbAtlasCollectionDataset, MongoDbCollectionDataset, MongoDbV2CollectionDataset, MySqlTableDataset, NetezzaTableDataset, ODataResourceDataset, OdbcTableDataset, Office365Dataset, OracleServiceCloudObjectDataset, OracleTableDataset, OrcDataset, ParquetDataset, PaypalObjectDataset, PhoenixObjectDataset, PostgreSqlTableDataset, PrestoObjectDataset, QuickBooksObjectDataset, RelationalTableDataset, ResponsysObjectDataset, RestResourceDataset, SalesforceMarketingCloudObjectDataset, SalesforceObjectDataset, SalesforceServiceCloudObjectDataset, SapBwCubeDataset, SapCloudForCustomerResourceDataset, SapEccResourceDataset, SapHanaTableDataset, SapOpenHubTableDataset, SapTableResourceDataset, ServiceNowObjectDataset, SharePointOnlineListResourceDataset, ShopifyObjectDataset, SnowflakeDataset, SparkObjectDataset, SqlServerTableDataset, SquareObjectDataset, SybaseTableDataset, TeradataTableDataset, VerticaTableDataset, WebTableDataset, XeroObjectDataset, XmlDataset, ZohoObjectDataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
    }

    _subtype_map = {
        'type': {'AmazonMWSObject': 'AmazonMWSObjectDataset', 'AmazonRdsForOracleTable': 'AmazonRdsForOracleTableDataset', 'AmazonRdsForSqlServerTable': 'AmazonRdsForSqlServerTableDataset', 'AmazonRedshiftTable': 'AmazonRedshiftTableDataset', 'AmazonS3Object': 'AmazonS3Dataset', 'Avro': 'AvroDataset', 'AzureBlob': 'AzureBlobDataset', 'AzureBlobFSFile': 'AzureBlobFSDataset', 'AzureDataExplorerTable': 'AzureDataExplorerTableDataset', 'AzureDataLakeStoreFile': 'AzureDataLakeStoreDataset', 'AzureDatabricksDeltaLakeDataset': 'AzureDatabricksDeltaLakeDataset', 'AzureMariaDBTable': 'AzureMariaDBTableDataset', 'AzureMySqlTable': 'AzureMySqlTableDataset', 'AzurePostgreSqlTable': 'AzurePostgreSqlTableDataset', 'AzureSearchIndex': 'AzureSearchIndexDataset', 'AzureSqlDWTable': 'AzureSqlDWTableDataset', 'AzureSqlMITable': 'AzureSqlMITableDataset', 'AzureSqlTable': 'AzureSqlTableDataset', 'AzureTable': 'AzureTableDataset', 'Binary': 'BinaryDataset', 'CassandraTable': 'CassandraTableDataset', 'CommonDataServiceForAppsEntity': 'CommonDataServiceForAppsEntityDataset', 'ConcurObject': 'ConcurObjectDataset', 'CosmosDbMongoDbApiCollection': 'CosmosDbMongoDbApiCollectionDataset', 'CosmosDbSqlApiCollection': 'CosmosDbSqlApiCollectionDataset', 'CouchbaseTable': 'CouchbaseTableDataset', 'CustomDataset': 'CustomDataset', 'Db2Table': 'Db2TableDataset', 'DelimitedText': 'DelimitedTextDataset', 'DocumentDbCollection': 'DocumentDbCollectionDataset', 'DrillTable': 'DrillTableDataset', 'DynamicsAXResource': 'DynamicsAXResourceDataset', 'DynamicsCrmEntity': 'DynamicsCrmEntityDataset', 'DynamicsEntity': 'DynamicsEntityDataset', 'EloquaObject': 'EloquaObjectDataset', 'Excel': 'ExcelDataset', 'FileShare': 'FileShareDataset', 'GoogleAdWordsObject': 'GoogleAdWordsObjectDataset', 'GoogleBigQueryObject': 'GoogleBigQueryObjectDataset', 'GreenplumTable': 'GreenplumTableDataset', 'HBaseObject': 'HBaseObjectDataset', 'HiveObject': 'HiveObjectDataset', 'HttpFile': 'HttpDataset', 'HubspotObject': 'HubspotObjectDataset', 'ImpalaObject': 'ImpalaObjectDataset', 'InformixTable': 'InformixTableDataset', 'JiraObject': 'JiraObjectDataset', 'Json': 'JsonDataset', 'MagentoObject': 'MagentoObjectDataset', 'MariaDBTable': 'MariaDBTableDataset', 'MarketoObject': 'MarketoObjectDataset', 'MicrosoftAccessTable': 'MicrosoftAccessTableDataset', 'MongoDbAtlasCollection': 'MongoDbAtlasCollectionDataset', 'MongoDbCollection': 'MongoDbCollectionDataset', 'MongoDbV2Collection': 'MongoDbV2CollectionDataset', 'MySqlTable': 'MySqlTableDataset', 'NetezzaTable': 'NetezzaTableDataset', 'ODataResource': 'ODataResourceDataset', 'OdbcTable': 'OdbcTableDataset', 'Office365Table': 'Office365Dataset', 'OracleServiceCloudObject': 'OracleServiceCloudObjectDataset', 'OracleTable': 'OracleTableDataset', 'Orc': 'OrcDataset', 'Parquet': 'ParquetDataset', 'PaypalObject': 'PaypalObjectDataset', 'PhoenixObject': 'PhoenixObjectDataset', 'PostgreSqlTable': 'PostgreSqlTableDataset', 'PrestoObject': 'PrestoObjectDataset', 'QuickBooksObject': 'QuickBooksObjectDataset', 'RelationalTable': 'RelationalTableDataset', 'ResponsysObject': 'ResponsysObjectDataset', 'RestResource': 'RestResourceDataset', 'SalesforceMarketingCloudObject': 'SalesforceMarketingCloudObjectDataset', 'SalesforceObject': 'SalesforceObjectDataset', 'SalesforceServiceCloudObject': 'SalesforceServiceCloudObjectDataset', 'SapBwCube': 'SapBwCubeDataset', 'SapCloudForCustomerResource': 'SapCloudForCustomerResourceDataset', 'SapEccResource': 'SapEccResourceDataset', 'SapHanaTable': 'SapHanaTableDataset', 'SapOpenHubTable': 'SapOpenHubTableDataset', 'SapTableResource': 'SapTableResourceDataset', 'ServiceNowObject': 'ServiceNowObjectDataset', 'SharePointOnlineListResource': 'SharePointOnlineListResourceDataset', 'ShopifyObject': 'ShopifyObjectDataset', 'SnowflakeTable': 'SnowflakeDataset', 'SparkObject': 'SparkObjectDataset', 'SqlServerTable': 'SqlServerTableDataset', 'SquareObject': 'SquareObjectDataset', 'SybaseTable': 'SybaseTableDataset', 'TeradataTable': 'TeradataTableDataset', 'VerticaTable': 'VerticaTableDataset', 'WebTable': 'WebTableDataset', 'XeroObject': 'XeroObjectDataset', 'Xml': 'XmlDataset', 'ZohoObject': 'ZohoObjectDataset'}
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(Dataset, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'Dataset'  # type: str
        self.description = description
        self.structure = structure
        self.schema = schema
        self.linked_service_name = linked_service_name
        self.parameters = parameters
        self.annotations = annotations
        self.folder = folder


class AmazonMWSObjectDataset(Dataset):
    """Amazon Marketplace Web Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonMWSObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AmazonMWSObject'  # type: str
        self.table_name = table_name


class CopySource(msrest.serialization.Model):
    """A copy activity source.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonRdsForOracleSource, AvroSource, AzureBlobFSSource, AzureDataExplorerSource, AzureDataLakeStoreSource, AzureDatabricksDeltaLakeSource, BinarySource, BlobSource, CommonDataServiceForAppsSource, CosmosDbMongoDbApiSource, CosmosDbSqlApiSource, DelimitedTextSource, DocumentDbCollectionSource, DynamicsCrmSource, DynamicsSource, ExcelSource, FileSystemSource, HdfsSource, HttpSource, JsonSource, MicrosoftAccessSource, MongoDbAtlasSource, MongoDbSource, MongoDbV2Source, ODataSource, Office365Source, OracleSource, OrcSource, ParquetSource, RelationalSource, RestSource, SalesforceServiceCloudSource, SharePointOnlineListSource, SnowflakeSource, TabularSource, WebSource, XmlSource.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AmazonRdsForOracleSource': 'AmazonRdsForOracleSource', 'AvroSource': 'AvroSource', 'AzureBlobFSSource': 'AzureBlobFSSource', 'AzureDataExplorerSource': 'AzureDataExplorerSource', 'AzureDataLakeStoreSource': 'AzureDataLakeStoreSource', 'AzureDatabricksDeltaLakeSource': 'AzureDatabricksDeltaLakeSource', 'BinarySource': 'BinarySource', 'BlobSource': 'BlobSource', 'CommonDataServiceForAppsSource': 'CommonDataServiceForAppsSource', 'CosmosDbMongoDbApiSource': 'CosmosDbMongoDbApiSource', 'CosmosDbSqlApiSource': 'CosmosDbSqlApiSource', 'DelimitedTextSource': 'DelimitedTextSource', 'DocumentDbCollectionSource': 'DocumentDbCollectionSource', 'DynamicsCrmSource': 'DynamicsCrmSource', 'DynamicsSource': 'DynamicsSource', 'ExcelSource': 'ExcelSource', 'FileSystemSource': 'FileSystemSource', 'HdfsSource': 'HdfsSource', 'HttpSource': 'HttpSource', 'JsonSource': 'JsonSource', 'MicrosoftAccessSource': 'MicrosoftAccessSource', 'MongoDbAtlasSource': 'MongoDbAtlasSource', 'MongoDbSource': 'MongoDbSource', 'MongoDbV2Source': 'MongoDbV2Source', 'ODataSource': 'ODataSource', 'Office365Source': 'Office365Source', 'OracleSource': 'OracleSource', 'OrcSource': 'OrcSource', 'ParquetSource': 'ParquetSource', 'RelationalSource': 'RelationalSource', 'RestSource': 'RestSource', 'SalesforceServiceCloudSource': 'SalesforceServiceCloudSource', 'SharePointOnlineListSource': 'SharePointOnlineListSource', 'SnowflakeSource': 'SnowflakeSource', 'TabularSource': 'TabularSource', 'WebSource': 'WebSource', 'XmlSource': 'XmlSource'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        **kwargs
    ):
        super(CopySource, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'CopySource'  # type: str
        self.source_retry_count = source_retry_count
        self.source_retry_wait = source_retry_wait
        self.max_concurrent_connections = max_concurrent_connections
        self.disable_metrics_collection = disable_metrics_collection


class TabularSource(CopySource):
    """Copy activity sources of tabular type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSSource, AmazonRdsForSqlServerSource, AmazonRedshiftSource, AzureMariaDBSource, AzureMySqlSource, AzurePostgreSqlSource, AzureSqlSource, AzureTableSource, CassandraSource, ConcurSource, CouchbaseSource, Db2Source, DrillSource, DynamicsAXSource, EloquaSource, GoogleAdWordsSource, GoogleBigQuerySource, GreenplumSource, HBaseSource, HiveSource, HubspotSource, ImpalaSource, InformixSource, JiraSource, MagentoSource, MariaDBSource, MarketoSource, MySqlSource, NetezzaSource, OdbcSource, OracleServiceCloudSource, PaypalSource, PhoenixSource, PostgreSqlSource, PrestoSource, QuickBooksSource, ResponsysSource, SalesforceMarketingCloudSource, SalesforceSource, SapBwSource, SapCloudForCustomerSource, SapEccSource, SapHanaSource, SapOpenHubSource, SapTableSource, ServiceNowSource, ShopifySource, SparkSource, SqlDWSource, SqlMISource, SqlServerSource, SqlSource, SquareSource, SybaseSource, TeradataSource, VerticaSource, XeroSource, ZohoSource.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AmazonMWSSource': 'AmazonMWSSource', 'AmazonRdsForSqlServerSource': 'AmazonRdsForSqlServerSource', 'AmazonRedshiftSource': 'AmazonRedshiftSource', 'AzureMariaDBSource': 'AzureMariaDBSource', 'AzureMySqlSource': 'AzureMySqlSource', 'AzurePostgreSqlSource': 'AzurePostgreSqlSource', 'AzureSqlSource': 'AzureSqlSource', 'AzureTableSource': 'AzureTableSource', 'CassandraSource': 'CassandraSource', 'ConcurSource': 'ConcurSource', 'CouchbaseSource': 'CouchbaseSource', 'Db2Source': 'Db2Source', 'DrillSource': 'DrillSource', 'DynamicsAXSource': 'DynamicsAXSource', 'EloquaSource': 'EloquaSource', 'GoogleAdWordsSource': 'GoogleAdWordsSource', 'GoogleBigQuerySource': 'GoogleBigQuerySource', 'GreenplumSource': 'GreenplumSource', 'HBaseSource': 'HBaseSource', 'HiveSource': 'HiveSource', 'HubspotSource': 'HubspotSource', 'ImpalaSource': 'ImpalaSource', 'InformixSource': 'InformixSource', 'JiraSource': 'JiraSource', 'MagentoSource': 'MagentoSource', 'MariaDBSource': 'MariaDBSource', 'MarketoSource': 'MarketoSource', 'MySqlSource': 'MySqlSource', 'NetezzaSource': 'NetezzaSource', 'OdbcSource': 'OdbcSource', 'OracleServiceCloudSource': 'OracleServiceCloudSource', 'PaypalSource': 'PaypalSource', 'PhoenixSource': 'PhoenixSource', 'PostgreSqlSource': 'PostgreSqlSource', 'PrestoSource': 'PrestoSource', 'QuickBooksSource': 'QuickBooksSource', 'ResponsysSource': 'ResponsysSource', 'SalesforceMarketingCloudSource': 'SalesforceMarketingCloudSource', 'SalesforceSource': 'SalesforceSource', 'SapBwSource': 'SapBwSource', 'SapCloudForCustomerSource': 'SapCloudForCustomerSource', 'SapEccSource': 'SapEccSource', 'SapHanaSource': 'SapHanaSource', 'SapOpenHubSource': 'SapOpenHubSource', 'SapTableSource': 'SapTableSource', 'ServiceNowSource': 'ServiceNowSource', 'ShopifySource': 'ShopifySource', 'SparkSource': 'SparkSource', 'SqlDWSource': 'SqlDWSource', 'SqlMISource': 'SqlMISource', 'SqlServerSource': 'SqlServerSource', 'SqlSource': 'SqlSource', 'SquareSource': 'SquareSource', 'SybaseSource': 'SybaseSource', 'TeradataSource': 'TeradataSource', 'VerticaSource': 'VerticaSource', 'XeroSource': 'XeroSource', 'ZohoSource': 'ZohoSource'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(TabularSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'TabularSource'  # type: str
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class AmazonMWSSource(TabularSource):
    """A copy activity Amazon Marketplace Web Service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonMWSSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AmazonMWSSource'  # type: str
        self.query = query


class AmazonRdsForOracleLinkedService(LinkedService):
    """AmazonRdsForOracle database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonRdsForOracleLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AmazonRdsForOracle'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class AmazonRdsForOraclePartitionSettings(msrest.serialization.Model):
    """The settings that will be leveraged for AmazonRdsForOracle source partitioning.

    :param partition_names: Names of the physical partitions of AmazonRdsForOracle table.
    :type partition_names: any
    :param partition_column_name: The name of the column in integer type that will be used for
     proceeding range partitioning. Type: string (or Expression with resultType string).
    :type partition_column_name: any
    :param partition_upper_bound: The maximum value of column specified in partitionColumnName that
     will be used for proceeding range partitioning. Type: string (or Expression with resultType
     string).
    :type partition_upper_bound: any
    :param partition_lower_bound: The minimum value of column specified in partitionColumnName that
     will be used for proceeding range partitioning. Type: string (or Expression with resultType
     string).
    :type partition_lower_bound: any
    """

    _attribute_map = {
        'partition_names': {'key': 'partitionNames', 'type': 'object'},
        'partition_column_name': {'key': 'partitionColumnName', 'type': 'object'},
        'partition_upper_bound': {'key': 'partitionUpperBound', 'type': 'object'},
        'partition_lower_bound': {'key': 'partitionLowerBound', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        partition_names: Optional[Any] = None,
        partition_column_name: Optional[Any] = None,
        partition_upper_bound: Optional[Any] = None,
        partition_lower_bound: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonRdsForOraclePartitionSettings, self).__init__(**kwargs)
        self.partition_names = partition_names
        self.partition_column_name = partition_column_name
        self.partition_upper_bound = partition_upper_bound
        self.partition_lower_bound = partition_lower_bound


class AmazonRdsForOracleSource(CopySource):
    """A copy activity AmazonRdsForOracle source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param oracle_reader_query: AmazonRdsForOracle reader query. Type: string (or Expression with
     resultType string).
    :type oracle_reader_query: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param partition_option: The partition mechanism that will be used for AmazonRdsForOracle read
     in parallel. Type: string (or Expression with resultType string).
    :type partition_option: any
    :param partition_settings: The settings that will be leveraged for AmazonRdsForOracle source
     partitioning.
    :type partition_settings: ~azure.mgmt.datafactory.models.AmazonRdsForOraclePartitionSettings
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'oracle_reader_query': {'key': 'oracleReaderQuery', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'partition_option': {'key': 'partitionOption', 'type': 'object'},
        'partition_settings': {'key': 'partitionSettings', 'type': 'AmazonRdsForOraclePartitionSettings'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        oracle_reader_query: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        partition_option: Optional[Any] = None,
        partition_settings: Optional["AmazonRdsForOraclePartitionSettings"] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonRdsForOracleSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AmazonRdsForOracleSource'  # type: str
        self.oracle_reader_query = oracle_reader_query
        self.query_timeout = query_timeout
        self.partition_option = partition_option
        self.partition_settings = partition_settings
        self.additional_columns = additional_columns


class AmazonRdsForOracleTableDataset(Dataset):
    """The AmazonRdsForOracle database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param schema_type_properties_schema: The schema name of the AmazonRdsForOracle database. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: any
    :param table: The table name of the AmazonRdsForOracle database. Type: string (or Expression
     with resultType string).
    :type table: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        schema_type_properties_schema: Optional[Any] = None,
        table: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonRdsForOracleTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AmazonRdsForOracleTable'  # type: str
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AmazonRdsForSqlServerLinkedService(LinkedService):
    """Amazon RDS for SQL Server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param user_name: The on-premises Windows authentication user name. Type: string (or Expression
     with resultType string).
    :type user_name: any
    :param password: The on-premises Windows authentication password.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param always_encrypted_settings: Sql always encrypted properties.
    :type always_encrypted_settings: ~azure.mgmt.datafactory.models.SqlAlwaysEncryptedProperties
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'always_encrypted_settings': {'key': 'typeProperties.alwaysEncryptedSettings', 'type': 'SqlAlwaysEncryptedProperties'},
    }

    def __init__(
        self,
        *,
        connection_string: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        user_name: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        always_encrypted_settings: Optional["SqlAlwaysEncryptedProperties"] = None,
        **kwargs
    ):
        super(AmazonRdsForSqlServerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AmazonRdsForSqlServer'  # type: str
        self.connection_string = connection_string
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential
        self.always_encrypted_settings = always_encrypted_settings


class AmazonRdsForSqlServerSource(TabularSource):
    """A copy activity Amazon RDS for SQL Server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param sql_reader_query: SQL reader query. Type: string (or Expression with resultType string).
    :type sql_reader_query: any
    :param sql_reader_stored_procedure_name: Name of the stored procedure for a SQL Database
     source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression
     with resultType string).
    :type sql_reader_stored_procedure_name: any
    :param stored_procedure_parameters: Value and type setting for stored procedure parameters.
     Example: "{Parameter1: {value: "1", type: "int"}}".
    :type stored_procedure_parameters: dict[str,
     ~azure.mgmt.datafactory.models.StoredProcedureParameter]
    :param produce_additional_types: Which additional types to produce.
    :type produce_additional_types: any
    :param partition_option: The partition mechanism that will be used for Sql read in parallel.
     Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
    :type partition_option: any
    :param partition_settings: The settings that will be leveraged for Sql source partitioning.
    :type partition_settings: ~azure.mgmt.datafactory.models.SqlPartitionSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'sql_reader_query': {'key': 'sqlReaderQuery', 'type': 'object'},
        'sql_reader_stored_procedure_name': {'key': 'sqlReaderStoredProcedureName', 'type': 'object'},
        'stored_procedure_parameters': {'key': 'storedProcedureParameters', 'type': '{StoredProcedureParameter}'},
        'produce_additional_types': {'key': 'produceAdditionalTypes', 'type': 'object'},
        'partition_option': {'key': 'partitionOption', 'type': 'object'},
        'partition_settings': {'key': 'partitionSettings', 'type': 'SqlPartitionSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        sql_reader_query: Optional[Any] = None,
        sql_reader_stored_procedure_name: Optional[Any] = None,
        stored_procedure_parameters: Optional[Dict[str, "StoredProcedureParameter"]] = None,
        produce_additional_types: Optional[Any] = None,
        partition_option: Optional[Any] = None,
        partition_settings: Optional["SqlPartitionSettings"] = None,
        **kwargs
    ):
        super(AmazonRdsForSqlServerSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AmazonRdsForSqlServerSource'  # type: str
        self.sql_reader_query = sql_reader_query
        self.sql_reader_stored_procedure_name = sql_reader_stored_procedure_name
        self.stored_procedure_parameters = stored_procedure_parameters
        self.produce_additional_types = produce_additional_types
        self.partition_option = partition_option
        self.partition_settings = partition_settings


class AmazonRdsForSqlServerTableDataset(Dataset):
    """The Amazon RDS for SQL Server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param schema_type_properties_schema: The schema name of the SQL Server dataset. Type: string
     (or Expression with resultType string).
    :type schema_type_properties_schema: any
    :param table: The table name of the SQL Server dataset. Type: string (or Expression with
     resultType string).
    :type table: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        schema_type_properties_schema: Optional[Any] = None,
        table: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonRdsForSqlServerTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AmazonRdsForSqlServerTable'  # type: str
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AmazonRedshiftLinkedService(LinkedService):
    """Linked service for Amazon Redshift.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param server: Required. The name of the Amazon Redshift server. Type: string (or Expression
     with resultType string).
    :type server: any
    :param username: The username of the Amazon Redshift source. Type: string (or Expression with
     resultType string).
    :type username: any
    :param password: The password of the Amazon Redshift source.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param database: Required. The database name of the Amazon Redshift source. Type: string (or
     Expression with resultType string).
    :type database: any
    :param port: The TCP port number that the Amazon Redshift server uses to listen for client
     connections. The default value is 5439. Type: integer (or Expression with resultType integer).
    :type port: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        server: Any,
        database: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        username: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        port: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonRedshiftLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AmazonRedshift'  # type: str
        self.server = server
        self.username = username
        self.password = password
        self.database = database
        self.port = port
        self.encrypted_credential = encrypted_credential


class AmazonRedshiftSource(TabularSource):
    """A copy activity source for Amazon Redshift Source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: any
    :param redshift_unload_settings: The Amazon S3 settings needed for the interim Amazon S3 when
     copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be
     unloaded into S3 first and then copied into the targeted sink from the interim S3.
    :type redshift_unload_settings: ~azure.mgmt.datafactory.models.RedshiftUnloadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'redshift_unload_settings': {'key': 'redshiftUnloadSettings', 'type': 'RedshiftUnloadSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        redshift_unload_settings: Optional["RedshiftUnloadSettings"] = None,
        **kwargs
    ):
        super(AmazonRedshiftSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AmazonRedshiftSource'  # type: str
        self.query = query
        self.redshift_unload_settings = redshift_unload_settings


class AmazonRedshiftTableDataset(Dataset):
    """The Amazon Redshift table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: any
    :param table: The Amazon Redshift table name. Type: string (or Expression with resultType
     string).
    :type table: any
    :param schema_type_properties_schema: The Amazon Redshift schema name. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        table: Optional[Any] = None,
        schema_type_properties_schema: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonRedshiftTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AmazonRedshiftTable'  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class AmazonS3CompatibleLinkedService(LinkedService):
    """Linked service for Amazon S3 Compatible.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param access_key_id: The access key identifier of the Amazon S3 Compatible Identity and Access
     Management (IAM) user. Type: string (or Expression with resultType string).
    :type access_key_id: any
    :param secret_access_key: The secret access key of the Amazon S3 Compatible Identity and Access
     Management (IAM) user.
    :type secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the Amazon S3 Compatible
     Connector. This is an optional property; change it only if you want to try a different service
     endpoint or want to switch between https and http. Type: string (or Expression with resultType
     string).
    :type service_url: any
    :param force_path_style: If true, use S3 path-style access instead of virtual hosted-style
     access. Default value is false. Type: boolean (or Expression with resultType boolean).
    :type force_path_style: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'force_path_style': {'key': 'typeProperties.forcePathStyle', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        access_key_id: Optional[Any] = None,
        secret_access_key: Optional["SecretBase"] = None,
        service_url: Optional[Any] = None,
        force_path_style: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonS3CompatibleLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AmazonS3Compatible'  # type: str
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.service_url = service_url
        self.force_path_style = force_path_style
        self.encrypted_credential = encrypted_credential


class DatasetLocation(msrest.serialization.Model):
    """Dataset location.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonS3CompatibleLocation, AmazonS3Location, AzureBlobFSLocation, AzureBlobStorageLocation, AzureDataLakeStoreLocation, AzureFileStorageLocation, FileServerLocation, FtpServerLocation, GoogleCloudStorageLocation, HdfsLocation, HttpServerLocation, OracleCloudStorageLocation, SftpLocation.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AmazonS3CompatibleLocation': 'AmazonS3CompatibleLocation', 'AmazonS3Location': 'AmazonS3Location', 'AzureBlobFSLocation': 'AzureBlobFSLocation', 'AzureBlobStorageLocation': 'AzureBlobStorageLocation', 'AzureDataLakeStoreLocation': 'AzureDataLakeStoreLocation', 'AzureFileStorageLocation': 'AzureFileStorageLocation', 'FileServerLocation': 'FileServerLocation', 'FtpServerLocation': 'FtpServerLocation', 'GoogleCloudStorageLocation': 'GoogleCloudStorageLocation', 'HdfsLocation': 'HdfsLocation', 'HttpServerLocation': 'HttpServerLocation', 'OracleCloudStorageLocation': 'OracleCloudStorageLocation', 'SftpLocation': 'SftpLocation'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        **kwargs
    ):
        super(DatasetLocation, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'DatasetLocation'  # type: str
        self.folder_path = folder_path
        self.file_name = file_name


class AmazonS3CompatibleLocation(DatasetLocation):
    """The location of Amazon S3 Compatible dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    :param bucket_name: Specify the bucketName of Amazon S3 Compatible. Type: string (or Expression
     with resultType string).
    :type bucket_name: any
    :param version: Specify the version of Amazon S3 Compatible. Type: string (or Expression with
     resultType string).
    :type version: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'bucket_name': {'key': 'bucketName', 'type': 'object'},
        'version': {'key': 'version', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        bucket_name: Optional[Any] = None,
        version: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonS3CompatibleLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AmazonS3CompatibleLocation'  # type: str
        self.bucket_name = bucket_name
        self.version = version


class StoreReadSettings(msrest.serialization.Model):
    """Connector read setting.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonS3CompatibleReadSettings, AmazonS3ReadSettings, AzureBlobFSReadSettings, AzureBlobStorageReadSettings, AzureDataLakeStoreReadSettings, AzureFileStorageReadSettings, FileServerReadSettings, FtpReadSettings, GoogleCloudStorageReadSettings, HdfsReadSettings, HttpReadSettings, OracleCloudStorageReadSettings, SftpReadSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AmazonS3CompatibleReadSettings': 'AmazonS3CompatibleReadSettings', 'AmazonS3ReadSettings': 'AmazonS3ReadSettings', 'AzureBlobFSReadSettings': 'AzureBlobFSReadSettings', 'AzureBlobStorageReadSettings': 'AzureBlobStorageReadSettings', 'AzureDataLakeStoreReadSettings': 'AzureDataLakeStoreReadSettings', 'AzureFileStorageReadSettings': 'AzureFileStorageReadSettings', 'FileServerReadSettings': 'FileServerReadSettings', 'FtpReadSettings': 'FtpReadSettings', 'GoogleCloudStorageReadSettings': 'GoogleCloudStorageReadSettings', 'HdfsReadSettings': 'HdfsReadSettings', 'HttpReadSettings': 'HttpReadSettings', 'OracleCloudStorageReadSettings': 'OracleCloudStorageReadSettings', 'SftpReadSettings': 'SftpReadSettings'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        **kwargs
    ):
        super(StoreReadSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'StoreReadSettings'  # type: str
        self.max_concurrent_connections = max_concurrent_connections
        self.disable_metrics_collection = disable_metrics_collection


class AmazonS3CompatibleReadSettings(StoreReadSettings):
    """Amazon S3 Compatible read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param wildcard_folder_path: Amazon S3 Compatible wildcardFolderPath. Type: string (or
     Expression with resultType string).
    :type wildcard_folder_path: any
    :param wildcard_file_name: Amazon S3 Compatible wildcardFileName. Type: string (or Expression
     with resultType string).
    :type wildcard_file_name: any
    :param prefix: The prefix filter for the S3 Compatible object name. Type: string (or Expression
     with resultType string).
    :type prefix: any
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: any
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: any
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: any
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        wildcard_folder_path: Optional[Any] = None,
        wildcard_file_name: Optional[Any] = None,
        prefix: Optional[Any] = None,
        file_list_path: Optional[Any] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[Any] = None,
        delete_files_after_completion: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonS3CompatibleReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AmazonS3CompatibleReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AmazonS3Dataset(Dataset):
    """A single Amazon Simple Storage Service (S3) object or a set of S3 objects.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param bucket_name: Required. The name of the Amazon S3 bucket. Type: string (or Expression
     with resultType string).
    :type bucket_name: any
    :param key: The key of the Amazon S3 object. Type: string (or Expression with resultType
     string).
    :type key: any
    :param prefix: The prefix filter for the S3 object name. Type: string (or Expression with
     resultType string).
    :type prefix: any
    :param version: The version for the S3 object. Type: string (or Expression with resultType
     string).
    :type version: any
    :param modified_datetime_start: The start of S3 object's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of S3 object's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_end: any
    :param format: The format of files.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param compression: The data compression method used for the Amazon S3 object.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'bucket_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'bucket_name': {'key': 'typeProperties.bucketName', 'type': 'object'},
        'key': {'key': 'typeProperties.key', 'type': 'object'},
        'prefix': {'key': 'typeProperties.prefix', 'type': 'object'},
        'version': {'key': 'typeProperties.version', 'type': 'object'},
        'modified_datetime_start': {'key': 'typeProperties.modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'typeProperties.modifiedDatetimeEnd', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        bucket_name: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        key: Optional[Any] = None,
        prefix: Optional[Any] = None,
        version: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        format: Optional["DatasetStorageFormat"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(AmazonS3Dataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AmazonS3Object'  # type: str
        self.bucket_name = bucket_name
        self.key = key
        self.prefix = prefix
        self.version = version
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.format = format
        self.compression = compression


class AmazonS3LinkedService(LinkedService):
    """Linked service for Amazon S3.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param authentication_type: The authentication type of S3. Allowed value: AccessKey (default)
     or TemporarySecurityCredentials. Type: string (or Expression with resultType string).
    :type authentication_type: any
    :param access_key_id: The access key identifier of the Amazon S3 Identity and Access Management
     (IAM) user. Type: string (or Expression with resultType string).
    :type access_key_id: any
    :param secret_access_key: The secret access key of the Amazon S3 Identity and Access Management
     (IAM) user.
    :type secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the S3 Connector. This is
     an optional property; change it only if you want to try a different service endpoint or want to
     switch between https and http. Type: string (or Expression with resultType string).
    :type service_url: any
    :param session_token: The session token for the S3 temporary security credential.
    :type session_token: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'session_token': {'key': 'typeProperties.sessionToken', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        authentication_type: Optional[Any] = None,
        access_key_id: Optional[Any] = None,
        secret_access_key: Optional["SecretBase"] = None,
        service_url: Optional[Any] = None,
        session_token: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonS3LinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AmazonS3'  # type: str
        self.authentication_type = authentication_type
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.service_url = service_url
        self.session_token = session_token
        self.encrypted_credential = encrypted_credential


class AmazonS3Location(DatasetLocation):
    """The location of amazon S3 dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    :param bucket_name: Specify the bucketName of amazon S3. Type: string (or Expression with
     resultType string).
    :type bucket_name: any
    :param version: Specify the version of amazon S3. Type: string (or Expression with resultType
     string).
    :type version: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'bucket_name': {'key': 'bucketName', 'type': 'object'},
        'version': {'key': 'version', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        bucket_name: Optional[Any] = None,
        version: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonS3Location, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AmazonS3Location'  # type: str
        self.bucket_name = bucket_name
        self.version = version


class AmazonS3ReadSettings(StoreReadSettings):
    """Amazon S3 read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param wildcard_folder_path: AmazonS3 wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: any
    :param wildcard_file_name: AmazonS3 wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: any
    :param prefix: The prefix filter for the S3 object name. Type: string (or Expression with
     resultType string).
    :type prefix: any
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: any
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: any
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: any
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        wildcard_folder_path: Optional[Any] = None,
        wildcard_file_name: Optional[Any] = None,
        prefix: Optional[Any] = None,
        file_list_path: Optional[Any] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[Any] = None,
        delete_files_after_completion: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        **kwargs
    ):
        super(AmazonS3ReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AmazonS3ReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class ControlActivity(Activity):
    """Base class for all control activities like IfCondition, ForEach , Until.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AppendVariableActivity, ExecutePipelineActivity, FilterActivity, ForEachActivity, IfConditionActivity, SetVariableActivity, SwitchActivity, UntilActivity, ValidationActivity, WaitActivity, WebHookActivity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
    }

    _subtype_map = {
        'type': {'AppendVariable': 'AppendVariableActivity', 'ExecutePipeline': 'ExecutePipelineActivity', 'Filter': 'FilterActivity', 'ForEach': 'ForEachActivity', 'IfCondition': 'IfConditionActivity', 'SetVariable': 'SetVariableActivity', 'Switch': 'SwitchActivity', 'Until': 'UntilActivity', 'Validation': 'ValidationActivity', 'Wait': 'WaitActivity', 'WebHook': 'WebHookActivity'}
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        **kwargs
    ):
        super(ControlActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'Container'  # type: str


class AppendVariableActivity(ControlActivity):
    """Append value for a Variable of type Array.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param variable_name: Name of the variable whose value needs to be appended to.
    :type variable_name: str
    :param value: Value to be appended. Could be a static value or Expression.
    :type value: any
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'variable_name': {'key': 'typeProperties.variableName', 'type': 'str'},
        'value': {'key': 'typeProperties.value', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        variable_name: Optional[str] = None,
        value: Optional[Any] = None,
        **kwargs
    ):
        super(AppendVariableActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'AppendVariable'  # type: str
        self.variable_name = variable_name
        self.value = value


class ArmIdWrapper(msrest.serialization.Model):
    """A wrapper for an ARM resource id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmIdWrapper, self).__init__(**kwargs)
        self.id = None


class AvroDataset(Dataset):
    """Avro dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param location: The location of the avro storage.
    :type location: ~azure.mgmt.datafactory.models.DatasetLocation
    :param avro_compression_codec: The data avroCompressionCodec. Type: string (or Expression with
     resultType string).
    :type avro_compression_codec: any
    :param avro_compression_level:
    :type avro_compression_level: int
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'avro_compression_level': {'maximum': 9, 'minimum': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'avro_compression_codec': {'key': 'typeProperties.avroCompressionCodec', 'type': 'object'},
        'avro_compression_level': {'key': 'typeProperties.avroCompressionLevel', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        avro_compression_codec: Optional[Any] = None,
        avro_compression_level: Optional[int] = None,
        **kwargs
    ):
        super(AvroDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'Avro'  # type: str
        self.location = location
        self.avro_compression_codec = avro_compression_codec
        self.avro_compression_level = avro_compression_level


class DatasetStorageFormat(msrest.serialization.Model):
    """The format definition of a storage.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroFormat, JsonFormat, OrcFormat, ParquetFormat, TextFormat.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage format.Constant filled by server.
    :type type: str
    :param serializer: Serializer. Type: string (or Expression with resultType string).
    :type serializer: any
    :param deserializer: Deserializer. Type: string (or Expression with resultType string).
    :type deserializer: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AvroFormat': 'AvroFormat', 'JsonFormat': 'JsonFormat', 'OrcFormat': 'OrcFormat', 'ParquetFormat': 'ParquetFormat', 'TextFormat': 'TextFormat'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        serializer: Optional[Any] = None,
        deserializer: Optional[Any] = None,
        **kwargs
    ):
        super(DatasetStorageFormat, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'DatasetStorageFormat'  # type: str
        self.serializer = serializer
        self.deserializer = deserializer


class AvroFormat(DatasetStorageFormat):
    """The data stored in Avro format.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage format.Constant filled by server.
    :type type: str
    :param serializer: Serializer. Type: string (or Expression with resultType string).
    :type serializer: any
    :param deserializer: Deserializer. Type: string (or Expression with resultType string).
    :type deserializer: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        serializer: Optional[Any] = None,
        deserializer: Optional[Any] = None,
        **kwargs
    ):
        super(AvroFormat, self).__init__(additional_properties=additional_properties, serializer=serializer, deserializer=deserializer, **kwargs)
        self.type = 'AvroFormat'  # type: str


class CopySink(msrest.serialization.Model):
    """A copy activity sink.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroSink, AzureBlobFSSink, AzureDataExplorerSink, AzureDataLakeStoreSink, AzureDatabricksDeltaLakeSink, AzureMySqlSink, AzurePostgreSqlSink, AzureQueueSink, AzureSearchIndexSink, AzureSqlSink, AzureTableSink, BinarySink, BlobSink, CommonDataServiceForAppsSink, CosmosDbMongoDbApiSink, CosmosDbSqlApiSink, DelimitedTextSink, DocumentDbCollectionSink, DynamicsCrmSink, DynamicsSink, FileSystemSink, InformixSink, JsonSink, MicrosoftAccessSink, MongoDbAtlasSink, MongoDbV2Sink, OdbcSink, OracleSink, OrcSink, ParquetSink, RestSink, SalesforceServiceCloudSink, SalesforceSink, SapCloudForCustomerSink, SnowflakeSink, SqlDWSink, SqlMISink, SqlServerSink, SqlSink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AvroSink': 'AvroSink', 'AzureBlobFSSink': 'AzureBlobFSSink', 'AzureDataExplorerSink': 'AzureDataExplorerSink', 'AzureDataLakeStoreSink': 'AzureDataLakeStoreSink', 'AzureDatabricksDeltaLakeSink': 'AzureDatabricksDeltaLakeSink', 'AzureMySqlSink': 'AzureMySqlSink', 'AzurePostgreSqlSink': 'AzurePostgreSqlSink', 'AzureQueueSink': 'AzureQueueSink', 'AzureSearchIndexSink': 'AzureSearchIndexSink', 'AzureSqlSink': 'AzureSqlSink', 'AzureTableSink': 'AzureTableSink', 'BinarySink': 'BinarySink', 'BlobSink': 'BlobSink', 'CommonDataServiceForAppsSink': 'CommonDataServiceForAppsSink', 'CosmosDbMongoDbApiSink': 'CosmosDbMongoDbApiSink', 'CosmosDbSqlApiSink': 'CosmosDbSqlApiSink', 'DelimitedTextSink': 'DelimitedTextSink', 'DocumentDbCollectionSink': 'DocumentDbCollectionSink', 'DynamicsCrmSink': 'DynamicsCrmSink', 'DynamicsSink': 'DynamicsSink', 'FileSystemSink': 'FileSystemSink', 'InformixSink': 'InformixSink', 'JsonSink': 'JsonSink', 'MicrosoftAccessSink': 'MicrosoftAccessSink', 'MongoDbAtlasSink': 'MongoDbAtlasSink', 'MongoDbV2Sink': 'MongoDbV2Sink', 'OdbcSink': 'OdbcSink', 'OracleSink': 'OracleSink', 'OrcSink': 'OrcSink', 'ParquetSink': 'ParquetSink', 'RestSink': 'RestSink', 'SalesforceServiceCloudSink': 'SalesforceServiceCloudSink', 'SalesforceSink': 'SalesforceSink', 'SapCloudForCustomerSink': 'SapCloudForCustomerSink', 'SnowflakeSink': 'SnowflakeSink', 'SqlDWSink': 'SqlDWSink', 'SqlMISink': 'SqlMISink', 'SqlServerSink': 'SqlServerSink', 'SqlSink': 'SqlSink'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        **kwargs
    ):
        super(CopySink, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'CopySink'  # type: str
        self.write_batch_size = write_batch_size
        self.write_batch_timeout = write_batch_timeout
        self.sink_retry_count = sink_retry_count
        self.sink_retry_wait = sink_retry_wait
        self.max_concurrent_connections = max_concurrent_connections
        self.disable_metrics_collection = disable_metrics_collection


class AvroSink(CopySink):
    """A copy activity Avro sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param store_settings: Avro store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreWriteSettings
    :param format_settings: Avro format settings.
    :type format_settings: ~azure.mgmt.datafactory.models.AvroWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'AvroWriteSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        store_settings: Optional["StoreWriteSettings"] = None,
        format_settings: Optional["AvroWriteSettings"] = None,
        **kwargs
    ):
        super(AvroSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AvroSink'  # type: str
        self.store_settings = store_settings
        self.format_settings = format_settings


class AvroSource(CopySource):
    """A copy activity Avro source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param store_settings: Avro store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(AvroSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AvroSource'  # type: str
        self.store_settings = store_settings
        self.additional_columns = additional_columns


class FormatWriteSettings(msrest.serialization.Model):
    """Format write settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroWriteSettings, DelimitedTextWriteSettings, JsonWriteSettings, OrcWriteSettings, ParquetWriteSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AvroWriteSettings': 'AvroWriteSettings', 'DelimitedTextWriteSettings': 'DelimitedTextWriteSettings', 'JsonWriteSettings': 'JsonWriteSettings', 'OrcWriteSettings': 'OrcWriteSettings', 'ParquetWriteSettings': 'ParquetWriteSettings'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(FormatWriteSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'FormatWriteSettings'  # type: str


class AvroWriteSettings(FormatWriteSettings):
    """Avro write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param record_name: Top level record name in write result, which is required in AVRO spec.
    :type record_name: str
    :param record_namespace: Record namespace in the write result.
    :type record_namespace: str
    :param max_rows_per_file: Limit the written file's row count to be smaller than or equal to the
     specified count. Type: integer (or Expression with resultType integer).
    :type max_rows_per_file: any
    :param file_name_prefix: Specifies the file name pattern
     :code:`<fileNamePrefix>`_:code:`<fileIndex>`.:code:`<fileExtension>` when copy from non-file
     based store without partitionOptions. Type: string (or Expression with resultType string).
    :type file_name_prefix: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'record_name': {'key': 'recordName', 'type': 'str'},
        'record_namespace': {'key': 'recordNamespace', 'type': 'str'},
        'max_rows_per_file': {'key': 'maxRowsPerFile', 'type': 'object'},
        'file_name_prefix': {'key': 'fileNamePrefix', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        record_name: Optional[str] = None,
        record_namespace: Optional[str] = None,
        max_rows_per_file: Optional[Any] = None,
        file_name_prefix: Optional[Any] = None,
        **kwargs
    ):
        super(AvroWriteSettings, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'AvroWriteSettings'  # type: str
        self.record_name = record_name
        self.record_namespace = record_namespace
        self.max_rows_per_file = max_rows_per_file
        self.file_name_prefix = file_name_prefix


class CustomSetupBase(msrest.serialization.Model):
    """The base definition of the custom setup.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzPowerShellSetup, CmdkeySetup, ComponentSetup, EnvironmentVariableSetup.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzPowerShellSetup': 'AzPowerShellSetup', 'CmdkeySetup': 'CmdkeySetup', 'ComponentSetup': 'ComponentSetup', 'EnvironmentVariableSetup': 'EnvironmentVariableSetup'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomSetupBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzPowerShellSetup(CustomSetupBase):
    """The express custom setup of installing Azure PowerShell.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param version: Required. The required version of Azure PowerShell to install.
    :type version: str
    """

    _validation = {
        'type': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'typeProperties.version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        version: str,
        **kwargs
    ):
        super(AzPowerShellSetup, self).__init__(**kwargs)
        self.type = 'AzPowerShellSetup'  # type: str
        self.version = version


class AzureBatchLinkedService(LinkedService):
    """Azure Batch linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param account_name: Required. The Azure Batch account name. Type: string (or Expression with
     resultType string).
    :type account_name: any
    :param access_key: The Azure Batch account access key.
    :type access_key: ~azure.mgmt.datafactory.models.SecretBase
    :param batch_uri: Required. The Azure Batch URI. Type: string (or Expression with resultType
     string).
    :type batch_uri: any
    :param pool_name: Required. The Azure Batch pool name. Type: string (or Expression with
     resultType string).
    :type pool_name: any
    :param linked_service_name: Required. The Azure Storage linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'batch_uri': {'required': True},
        'pool_name': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'access_key': {'key': 'typeProperties.accessKey', 'type': 'SecretBase'},
        'batch_uri': {'key': 'typeProperties.batchUri', 'type': 'object'},
        'pool_name': {'key': 'typeProperties.poolName', 'type': 'object'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
    }

    def __init__(
        self,
        *,
        account_name: Any,
        batch_uri: Any,
        pool_name: Any,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        access_key: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        credential: Optional["CredentialReference"] = None,
        **kwargs
    ):
        super(AzureBatchLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureBatch'  # type: str
        self.account_name = account_name
        self.access_key = access_key
        self.batch_uri = batch_uri
        self.pool_name = pool_name
        self.linked_service_name = linked_service_name
        self.encrypted_credential = encrypted_credential
        self.credential = credential


class AzureBlobDataset(Dataset):
    """The Azure Blob storage.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param folder_path: The path of the Azure Blob storage. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param table_root_location: The root of blob path. Type: string (or Expression with resultType
     string).
    :type table_root_location: any
    :param file_name: The name of the Azure Blob. Type: string (or Expression with resultType
     string).
    :type file_name: any
    :param modified_datetime_start: The start of Azure Blob's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of Azure Blob's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_end: any
    :param format: The format of the Azure Blob storage.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param compression: The data compression method used for the blob storage.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'table_root_location': {'key': 'typeProperties.tableRootLocation', 'type': 'object'},
        'file_name': {'key': 'typeProperties.fileName', 'type': 'object'},
        'modified_datetime_start': {'key': 'typeProperties.modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'typeProperties.modifiedDatetimeEnd', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        folder_path: Optional[Any] = None,
        table_root_location: Optional[Any] = None,
        file_name: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        format: Optional["DatasetStorageFormat"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(AzureBlobDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureBlob'  # type: str
        self.folder_path = folder_path
        self.table_root_location = table_root_location
        self.file_name = file_name
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.format = format
        self.compression = compression


class AzureBlobFSDataset(Dataset):
    """The Azure Data Lake Storage Gen2 storage.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param folder_path: The path of the Azure Data Lake Storage Gen2 storage. Type: string (or
     Expression with resultType string).
    :type folder_path: any
    :param file_name: The name of the Azure Data Lake Storage Gen2. Type: string (or Expression
     with resultType string).
    :type file_name: any
    :param format: The format of the Azure Data Lake Storage Gen2 storage.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param compression: The data compression method used for the blob storage.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'file_name': {'key': 'typeProperties.fileName', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        format: Optional["DatasetStorageFormat"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(AzureBlobFSDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureBlobFSFile'  # type: str
        self.folder_path = folder_path
        self.file_name = file_name
        self.format = format
        self.compression = compression


class AzureBlobFSLinkedService(LinkedService):
    """Azure Data Lake Storage Gen2 linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param url: Required. Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or
     Expression with resultType string).
    :type url: any
    :param account_key: Account key for the Azure Data Lake Storage Gen2 service. Type: string (or
     Expression with resultType string).
    :type account_key: any
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Storage Gen2 account. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Storage Gen2 account.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: any
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
    }

    def __init__(
        self,
        *,
        url: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        account_key: Optional[Any] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[Any] = None,
        azure_cloud_type: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        credential: Optional["CredentialReference"] = None,
        **kwargs
    ):
        super(AzureBlobFSLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureBlobFS'  # type: str
        self.url = url
        self.account_key = account_key
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential
        self.credential = credential


class AzureBlobFSLocation(DatasetLocation):
    """The location of azure blobFS dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    :param file_system: Specify the fileSystem of azure blobFS. Type: string (or Expression with
     resultType string).
    :type file_system: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'file_system': {'key': 'fileSystem', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        file_system: Optional[Any] = None,
        **kwargs
    ):
        super(AzureBlobFSLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AzureBlobFSLocation'  # type: str
        self.file_system = file_system


class AzureBlobFSReadSettings(StoreReadSettings):
    """Azure blobFS read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param wildcard_folder_path: Azure blobFS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: any
    :param wildcard_file_name: Azure blobFS wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: any
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: any
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: any
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: any
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        wildcard_folder_path: Optional[Any] = None,
        wildcard_file_name: Optional[Any] = None,
        file_list_path: Optional[Any] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[Any] = None,
        delete_files_after_completion: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        **kwargs
    ):
        super(AzureBlobFSReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureBlobFSReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureBlobFSSink(CopySink):
    """A copy activity Azure Data Lake Storage Gen2 sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: any
    :param metadata: Specify the custom metadata to be added to sink data. Type: array of objects
     (or Expression with resultType array of objects).
    :type metadata: list[~azure.mgmt.datafactory.models.MetadataItem]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        copy_behavior: Optional[Any] = None,
        metadata: Optional[List["MetadataItem"]] = None,
        **kwargs
    ):
        super(AzureBlobFSSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureBlobFSSink'  # type: str
        self.copy_behavior = copy_behavior
        self.metadata = metadata


class AzureBlobFSSource(CopySource):
    """A copy activity Azure BlobFS source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType
     boolean).
    :type treat_empty_as_null: any
    :param skip_header_line_count: Number of header lines to skip from each blob. Type: integer (or
     Expression with resultType integer).
    :type skip_header_line_count: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'treat_empty_as_null': {'key': 'treatEmptyAsNull', 'type': 'object'},
        'skip_header_line_count': {'key': 'skipHeaderLineCount', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        treat_empty_as_null: Optional[Any] = None,
        skip_header_line_count: Optional[Any] = None,
        recursive: Optional[Any] = None,
        **kwargs
    ):
        super(AzureBlobFSSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureBlobFSSource'  # type: str
        self.treat_empty_as_null = treat_empty_as_null
        self.skip_header_line_count = skip_header_line_count
        self.recursive = recursive


class StoreWriteSettings(msrest.serialization.Model):
    """Connector write settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBlobFSWriteSettings, AzureBlobStorageWriteSettings, AzureDataLakeStoreWriteSettings, AzureFileStorageWriteSettings, FileServerWriteSettings, SftpWriteSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AzureBlobFSWriteSettings': 'AzureBlobFSWriteSettings', 'AzureBlobStorageWriteSettings': 'AzureBlobStorageWriteSettings', 'AzureDataLakeStoreWriteSettings': 'AzureDataLakeStoreWriteSettings', 'AzureFileStorageWriteSettings': 'AzureFileStorageWriteSettings', 'FileServerWriteSettings': 'FileServerWriteSettings', 'SftpWriteSettings': 'SftpWriteSettings'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        copy_behavior: Optional[Any] = None,
        **kwargs
    ):
        super(StoreWriteSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'StoreWriteSettings'  # type: str
        self.max_concurrent_connections = max_concurrent_connections
        self.disable_metrics_collection = disable_metrics_collection
        self.copy_behavior = copy_behavior


class AzureBlobFSWriteSettings(StoreWriteSettings):
    """Azure blobFS write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: any
    :param block_size_in_mb: Indicates the block size(MB) when writing data to blob. Type: integer
     (or Expression with resultType integer).
    :type block_size_in_mb: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'block_size_in_mb': {'key': 'blockSizeInMB', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        copy_behavior: Optional[Any] = None,
        block_size_in_mb: Optional[Any] = None,
        **kwargs
    ):
        super(AzureBlobFSWriteSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, copy_behavior=copy_behavior, **kwargs)
        self.type = 'AzureBlobFSWriteSettings'  # type: str
        self.block_size_in_mb = block_size_in_mb


class AzureBlobStorageLinkedService(LinkedService):
    """The azure blob storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: The connection string. It is mutually exclusive with sasUri,
     serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: any
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Blob Storage resource. It is mutually exclusive with
     connectionString, serviceEndpoint property. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type sas_uri: any
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param service_endpoint: Blob service endpoint of the Azure Blob Storage resource. It is
     mutually exclusive with connectionString, sasUri property.
    :type service_endpoint: str
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Data Warehouse. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Data Warehouse.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: any
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: any
    :param account_kind: Specify the kind of your storage account. Allowed values are: Storage
     (general purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type:
     string (or Expression with resultType string).
    :type account_kind: str
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'service_endpoint': {'key': 'typeProperties.serviceEndpoint', 'type': 'str'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'account_kind': {'key': 'typeProperties.accountKind', 'type': 'str'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_string: Optional[Any] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[Any] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        service_endpoint: Optional[str] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[Any] = None,
        azure_cloud_type: Optional[Any] = None,
        account_kind: Optional[str] = None,
        encrypted_credential: Optional[str] = None,
        credential: Optional["CredentialReference"] = None,
        **kwargs
    ):
        super(AzureBlobStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureBlobStorage'  # type: str
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.service_endpoint = service_endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.account_kind = account_kind
        self.encrypted_credential = encrypted_credential
        self.credential = credential


class AzureBlobStorageLocation(DatasetLocation):
    """The location of azure blob dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    :param container: Specify the container of azure blob. Type: string (or Expression with
     resultType string).
    :type container: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'container': {'key': 'container', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        container: Optional[Any] = None,
        **kwargs
    ):
        super(AzureBlobStorageLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AzureBlobStorageLocation'  # type: str
        self.container = container


class AzureBlobStorageReadSettings(StoreReadSettings):
    """Azure blob read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param wildcard_folder_path: Azure blob wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: any
    :param wildcard_file_name: Azure blob wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: any
    :param prefix: The prefix filter for the Azure Blob name. Type: string (or Expression with
     resultType string).
    :type prefix: any
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: any
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: any
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: any
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        wildcard_folder_path: Optional[Any] = None,
        wildcard_file_name: Optional[Any] = None,
        prefix: Optional[Any] = None,
        file_list_path: Optional[Any] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[Any] = None,
        delete_files_after_completion: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        **kwargs
    ):
        super(AzureBlobStorageReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureBlobStorageReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureBlobStorageWriteSettings(StoreWriteSettings):
    """Azure blob write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: any
    :param block_size_in_mb: Indicates the block size(MB) when writing data to blob. Type: integer
     (or Expression with resultType integer).
    :type block_size_in_mb: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'block_size_in_mb': {'key': 'blockSizeInMB', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        copy_behavior: Optional[Any] = None,
        block_size_in_mb: Optional[Any] = None,
        **kwargs
    ):
        super(AzureBlobStorageWriteSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, copy_behavior=copy_behavior, **kwargs)
        self.type = 'AzureBlobStorageWriteSettings'  # type: str
        self.block_size_in_mb = block_size_in_mb


class AzureDatabricksDeltaLakeDataset(Dataset):
    """Azure Databricks Delta Lake dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table: The name of delta table. Type: string (or Expression with resultType string).
    :type table: any
    :param database: The database name of delta table. Type: string (or Expression with resultType
     string).
    :type database: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table: Optional[Any] = None,
        database: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureDatabricksDeltaLakeDataset'  # type: str
        self.table = table
        self.database = database


class ExportSettings(msrest.serialization.Model):
    """Export command settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureDatabricksDeltaLakeExportCommand, SnowflakeExportCopyCommand.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The export setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzureDatabricksDeltaLakeExportCommand': 'AzureDatabricksDeltaLakeExportCommand', 'SnowflakeExportCopyCommand': 'SnowflakeExportCopyCommand'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(ExportSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'ExportSettings'  # type: str


class AzureDatabricksDeltaLakeExportCommand(ExportSettings):
    """Azure Databricks Delta Lake export command settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The export setting type.Constant filled by server.
    :type type: str
    :param date_format: Specify the date format for the csv in Azure Databricks Delta Lake Copy.
     Type: string (or Expression with resultType string).
    :type date_format: any
    :param timestamp_format: Specify the timestamp format for the csv in Azure Databricks Delta
     Lake Copy. Type: string (or Expression with resultType string).
    :type timestamp_format: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'object'},
        'timestamp_format': {'key': 'timestampFormat', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        date_format: Optional[Any] = None,
        timestamp_format: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeExportCommand, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'AzureDatabricksDeltaLakeExportCommand'  # type: str
        self.date_format = date_format
        self.timestamp_format = timestamp_format


class ImportSettings(msrest.serialization.Model):
    """Import command settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureDatabricksDeltaLakeImportCommand, SnowflakeImportCopyCommand.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The import setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzureDatabricksDeltaLakeImportCommand': 'AzureDatabricksDeltaLakeImportCommand', 'SnowflakeImportCopyCommand': 'SnowflakeImportCopyCommand'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(ImportSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'ImportSettings'  # type: str


class AzureDatabricksDeltaLakeImportCommand(ImportSettings):
    """Azure Databricks Delta Lake import command settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The import setting type.Constant filled by server.
    :type type: str
    :param date_format: Specify the date format for csv in Azure Databricks Delta Lake Copy. Type:
     string (or Expression with resultType string).
    :type date_format: any
    :param timestamp_format: Specify the timestamp format for csv in Azure Databricks Delta Lake
     Copy. Type: string (or Expression with resultType string).
    :type timestamp_format: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'object'},
        'timestamp_format': {'key': 'timestampFormat', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        date_format: Optional[Any] = None,
        timestamp_format: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeImportCommand, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'AzureDatabricksDeltaLakeImportCommand'  # type: str
        self.date_format = date_format
        self.timestamp_format = timestamp_format


class AzureDatabricksDeltaLakeLinkedService(LinkedService):
    """Azure Databricks Delta Lake linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param domain: Required. :code:`<REGION>`.azuredatabricks.net, domain name of your Databricks
     deployment. Type: string (or Expression with resultType string).
    :type domain: any
    :param access_token: Access token for databricks REST API. Refer to
     https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type access_token: ~azure.mgmt.datafactory.models.SecretBase
    :param cluster_id: The id of an existing interactive cluster that will be used for all runs of
     this job. Type: string (or Expression with resultType string).
    :type cluster_id: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'domain': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'domain': {'key': 'typeProperties.domain', 'type': 'object'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'cluster_id': {'key': 'typeProperties.clusterId', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        domain: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        access_token: Optional["SecretBase"] = None,
        cluster_id: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureDatabricksDeltaLake'  # type: str
        self.domain = domain
        self.access_token = access_token
        self.cluster_id = cluster_id
        self.encrypted_credential = encrypted_credential


class AzureDatabricksDeltaLakeSink(CopySink):
    """A copy activity Azure Databricks Delta Lake sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType
     string).
    :type pre_copy_script: any
    :param import_settings: Azure Databricks Delta Lake import settings.
    :type import_settings: ~azure.mgmt.datafactory.models.AzureDatabricksDeltaLakeImportCommand
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
        'import_settings': {'key': 'importSettings', 'type': 'AzureDatabricksDeltaLakeImportCommand'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        pre_copy_script: Optional[Any] = None,
        import_settings: Optional["AzureDatabricksDeltaLakeImportCommand"] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureDatabricksDeltaLakeSink'  # type: str
        self.pre_copy_script = pre_copy_script
        self.import_settings = import_settings


class AzureDatabricksDeltaLakeSource(CopySource):
    """A copy activity Azure Databricks Delta Lake source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query: Azure Databricks Delta Lake Sql query. Type: string (or Expression with
     resultType string).
    :type query: any
    :param export_settings: Azure Databricks Delta Lake export settings.
    :type export_settings: ~azure.mgmt.datafactory.models.AzureDatabricksDeltaLakeExportCommand
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'export_settings': {'key': 'exportSettings', 'type': 'AzureDatabricksDeltaLakeExportCommand'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query: Optional[Any] = None,
        export_settings: Optional["AzureDatabricksDeltaLakeExportCommand"] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureDatabricksDeltaLakeSource'  # type: str
        self.query = query
        self.export_settings = export_settings


class AzureDatabricksLinkedService(LinkedService):
    """Azure Databricks linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param domain: Required. :code:`<REGION>`.azuredatabricks.net, domain name of your Databricks
     deployment. Type: string (or Expression with resultType string).
    :type domain: any
    :param access_token: Access token for databricks REST API. Refer to
     https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression
     with resultType string).
    :type access_token: ~azure.mgmt.datafactory.models.SecretBase
    :param authentication: Required to specify MSI, if using Workspace resource id for databricks
     REST API. Type: string (or Expression with resultType string).
    :type authentication: any
    :param workspace_resource_id: Workspace resource id for databricks REST API. Type: string (or
     Expression with resultType string).
    :type workspace_resource_id: any
    :param existing_cluster_id: The id of an existing interactive cluster that will be used for all
     runs of this activity. Type: string (or Expression with resultType string).
    :type existing_cluster_id: any
    :param instance_pool_id: The id of an existing instance pool that will be used for all runs of
     this activity. Type: string (or Expression with resultType string).
    :type instance_pool_id: any
    :param new_cluster_version: If not using an existing interactive cluster, this specifies the
     Spark version of a new job cluster or instance pool nodes created for each run of this
     activity. Required if instancePoolId is specified. Type: string (or Expression with resultType
     string).
    :type new_cluster_version: any
    :param new_cluster_num_of_worker: If not using an existing interactive cluster, this specifies
     the number of worker nodes to use for the new job cluster or instance pool. For new job
     clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means
     auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and
     can only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is
     specified. Type: string (or Expression with resultType string).
    :type new_cluster_num_of_worker: any
    :param new_cluster_node_type: The node type of the new job cluster. This property is required
     if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is
     specified, this property is ignored. Type: string (or Expression with resultType string).
    :type new_cluster_node_type: any
    :param new_cluster_spark_conf: A set of optional, user-specified Spark configuration key-value
     pairs.
    :type new_cluster_spark_conf: dict[str, any]
    :param new_cluster_spark_env_vars: A set of optional, user-specified Spark environment
     variables key-value pairs.
    :type new_cluster_spark_env_vars: dict[str, any]
    :param new_cluster_custom_tags: Additional tags for cluster resources. This property is ignored
     in instance pool configurations.
    :type new_cluster_custom_tags: dict[str, any]
    :param new_cluster_log_destination: Specify a location to deliver Spark driver, worker, and
     event logs. Type: string (or Expression with resultType string).
    :type new_cluster_log_destination: any
    :param new_cluster_driver_node_type: The driver node type for the new job cluster. This
     property is ignored in instance pool configurations. Type: string (or Expression with
     resultType string).
    :type new_cluster_driver_node_type: any
    :param new_cluster_init_scripts: User-defined initialization scripts for the new cluster. Type:
     array of strings (or Expression with resultType array of strings).
    :type new_cluster_init_scripts: any
    :param new_cluster_enable_elastic_disk: Enable the elastic disk on the new cluster. This
     property is now ignored, and takes the default elastic disk behavior in Databricks (elastic
     disks are always enabled). Type: boolean (or Expression with resultType boolean).
    :type new_cluster_enable_elastic_disk: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param policy_id: The policy id for limiting the ability to configure clusters based on a user
     defined set of rules. Type: string (or Expression with resultType string).
    :type policy_id: any
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        'type': {'required': True},
        'domain': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'domain': {'key': 'typeProperties.domain', 'type': 'object'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'authentication': {'key': 'typeProperties.authentication', 'type': 'object'},
        'workspace_resource_id': {'key': 'typeProperties.workspaceResourceId', 'type': 'object'},
        'existing_cluster_id': {'key': 'typeProperties.existingClusterId', 'type': 'object'},
        'instance_pool_id': {'key': 'typeProperties.instancePoolId', 'type': 'object'},
        'new_cluster_version': {'key': 'typeProperties.newClusterVersion', 'type': 'object'},
        'new_cluster_num_of_worker': {'key': 'typeProperties.newClusterNumOfWorker', 'type': 'object'},
        'new_cluster_node_type': {'key': 'typeProperties.newClusterNodeType', 'type': 'object'},
        'new_cluster_spark_conf': {'key': 'typeProperties.newClusterSparkConf', 'type': '{object}'},
        'new_cluster_spark_env_vars': {'key': 'typeProperties.newClusterSparkEnvVars', 'type': '{object}'},
        'new_cluster_custom_tags': {'key': 'typeProperties.newClusterCustomTags', 'type': '{object}'},
        'new_cluster_log_destination': {'key': 'typeProperties.newClusterLogDestination', 'type': 'object'},
        'new_cluster_driver_node_type': {'key': 'typeProperties.newClusterDriverNodeType', 'type': 'object'},
        'new_cluster_init_scripts': {'key': 'typeProperties.newClusterInitScripts', 'type': 'object'},
        'new_cluster_enable_elastic_disk': {'key': 'typeProperties.newClusterEnableElasticDisk', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'policy_id': {'key': 'typeProperties.policyId', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
    }

    def __init__(
        self,
        *,
        domain: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        access_token: Optional["SecretBase"] = None,
        authentication: Optional[Any] = None,
        workspace_resource_id: Optional[Any] = None,
        existing_cluster_id: Optional[Any] = None,
        instance_pool_id: Optional[Any] = None,
        new_cluster_version: Optional[Any] = None,
        new_cluster_num_of_worker: Optional[Any] = None,
        new_cluster_node_type: Optional[Any] = None,
        new_cluster_spark_conf: Optional[Dict[str, Any]] = None,
        new_cluster_spark_env_vars: Optional[Dict[str, Any]] = None,
        new_cluster_custom_tags: Optional[Dict[str, Any]] = None,
        new_cluster_log_destination: Optional[Any] = None,
        new_cluster_driver_node_type: Optional[Any] = None,
        new_cluster_init_scripts: Optional[Any] = None,
        new_cluster_enable_elastic_disk: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        policy_id: Optional[Any] = None,
        credential: Optional["CredentialReference"] = None,
        **kwargs
    ):
        super(AzureDatabricksLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureDatabricks'  # type: str
        self.domain = domain
        self.access_token = access_token
        self.authentication = authentication
        self.workspace_resource_id = workspace_resource_id
        self.existing_cluster_id = existing_cluster_id
        self.instance_pool_id = instance_pool_id
        self.new_cluster_version = new_cluster_version
        self.new_cluster_num_of_worker = new_cluster_num_of_worker
        self.new_cluster_node_type = new_cluster_node_type
        self.new_cluster_spark_conf = new_cluster_spark_conf
        self.new_cluster_spark_env_vars = new_cluster_spark_env_vars
        self.new_cluster_custom_tags = new_cluster_custom_tags
        self.new_cluster_log_destination = new_cluster_log_destination
        self.new_cluster_driver_node_type = new_cluster_driver_node_type
        self.new_cluster_init_scripts = new_cluster_init_scripts
        self.new_cluster_enable_elastic_disk = new_cluster_enable_elastic_disk
        self.encrypted_credential = encrypted_credential
        self.policy_id = policy_id
        self.credential = credential


class ExecutionActivity(Activity):
    """Base class for all execution activities.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureDataExplorerCommandActivity, AzureFunctionActivity, AzureMLBatchExecutionActivity, AzureMLExecutePipelineActivity, AzureMLUpdateResourceActivity, CopyActivity, CustomActivity, DataLakeAnalyticsUSQLActivity, DatabricksNotebookActivity, DatabricksSparkJarActivity, DatabricksSparkPythonActivity, DeleteActivity, ExecuteDataFlowActivity, ExecuteSSISPackageActivity, GetMetadataActivity, HDInsightHiveActivity, HDInsightMapReduceActivity, HDInsightPigActivity, HDInsightSparkActivity, HDInsightStreamingActivity, LookupActivity, SqlServerStoredProcedureActivity, WebActivity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
    }

    _subtype_map = {
        'type': {'AzureDataExplorerCommand': 'AzureDataExplorerCommandActivity', 'AzureFunctionActivity': 'AzureFunctionActivity', 'AzureMLBatchExecution': 'AzureMLBatchExecutionActivity', 'AzureMLExecutePipeline': 'AzureMLExecutePipelineActivity', 'AzureMLUpdateResource': 'AzureMLUpdateResourceActivity', 'Copy': 'CopyActivity', 'Custom': 'CustomActivity', 'DataLakeAnalyticsU-SQL': 'DataLakeAnalyticsUSQLActivity', 'DatabricksNotebook': 'DatabricksNotebookActivity', 'DatabricksSparkJar': 'DatabricksSparkJarActivity', 'DatabricksSparkPython': 'DatabricksSparkPythonActivity', 'Delete': 'DeleteActivity', 'ExecuteDataFlow': 'ExecuteDataFlowActivity', 'ExecuteSSISPackage': 'ExecuteSSISPackageActivity', 'GetMetadata': 'GetMetadataActivity', 'HDInsightHive': 'HDInsightHiveActivity', 'HDInsightMapReduce': 'HDInsightMapReduceActivity', 'HDInsightPig': 'HDInsightPigActivity', 'HDInsightSpark': 'HDInsightSparkActivity', 'HDInsightStreaming': 'HDInsightStreamingActivity', 'Lookup': 'LookupActivity', 'SqlServerStoredProcedure': 'SqlServerStoredProcedureActivity', 'WebActivity': 'WebActivity'}
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        **kwargs
    ):
        super(ExecutionActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'Execution'  # type: str
        self.linked_service_name = linked_service_name
        self.policy = policy


class AzureDataExplorerCommandActivity(ExecutionActivity):
    """Azure Data Explorer command activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param command: Required. A control command, according to the Azure Data Explorer command
     syntax. Type: string (or Expression with resultType string).
    :type command: any
    :param command_timeout: Control command timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..).
    :type command_timeout: any
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'command': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'command': {'key': 'typeProperties.command', 'type': 'object'},
        'command_timeout': {'key': 'typeProperties.commandTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        command: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        command_timeout: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDataExplorerCommandActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'AzureDataExplorerCommand'  # type: str
        self.command = command
        self.command_timeout = command_timeout


class AzureDataExplorerLinkedService(LinkedService):
    """Azure Data Explorer (Kusto) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param endpoint: Required. The endpoint of Azure Data Explorer (the engine's endpoint). URL
     will be in the format https://:code:`<clusterName>`.:code:`<regionName>`.kusto.windows.net.
     Type: string (or Expression with resultType string).
    :type endpoint: any
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     Data Explorer. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_key: The key of the service principal used to authenticate against
     Kusto.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param database: Required. Database name for connection. Type: string (or Expression with
     resultType string).
    :type database: any
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: any
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
    }

    def __init__(
        self,
        *,
        endpoint: Any,
        database: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[Any] = None,
        credential: Optional["CredentialReference"] = None,
        **kwargs
    ):
        super(AzureDataExplorerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureDataExplorer'  # type: str
        self.endpoint = endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.database = database
        self.tenant = tenant
        self.credential = credential


class AzureDataExplorerSink(CopySink):
    """A copy activity Azure Data Explorer sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param ingestion_mapping_name: A name of a pre-created csv mapping that was defined on the
     target Kusto table. Type: string.
    :type ingestion_mapping_name: any
    :param ingestion_mapping_as_json: An explicit column mapping description provided in a json
     format. Type: string.
    :type ingestion_mapping_as_json: any
    :param flush_immediately: If set to true, any aggregation will be skipped. Default is false.
     Type: boolean.
    :type flush_immediately: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'ingestion_mapping_name': {'key': 'ingestionMappingName', 'type': 'object'},
        'ingestion_mapping_as_json': {'key': 'ingestionMappingAsJson', 'type': 'object'},
        'flush_immediately': {'key': 'flushImmediately', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        ingestion_mapping_name: Optional[Any] = None,
        ingestion_mapping_as_json: Optional[Any] = None,
        flush_immediately: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDataExplorerSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureDataExplorerSink'  # type: str
        self.ingestion_mapping_name = ingestion_mapping_name
        self.ingestion_mapping_as_json = ingestion_mapping_as_json
        self.flush_immediately = flush_immediately


class AzureDataExplorerSource(CopySource):
    """A copy activity Azure Data Explorer (Kusto) source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query: Required. Database query. Should be a Kusto Query Language (KQL) query. Type:
     string (or Expression with resultType string).
    :type query: any
    :param no_truncation: The name of the Boolean option that controls whether truncation is
     applied to result-sets that go beyond a certain row-count limit.
    :type no_truncation: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'no_truncation': {'key': 'noTruncation', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        query: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        no_truncation: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDataExplorerSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureDataExplorerSource'  # type: str
        self.query = query
        self.no_truncation = no_truncation
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class AzureDataExplorerTableDataset(Dataset):
    """The Azure Data Explorer (Kusto) dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table: The table name of the Azure Data Explorer database. Type: string (or Expression
     with resultType string).
    :type table: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDataExplorerTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureDataExplorerTable'  # type: str
        self.table = table


class AzureDataLakeAnalyticsLinkedService(LinkedService):
    """Azure Data Lake Analytics linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param account_name: Required. The Azure Data Lake Analytics account name. Type: string (or
     Expression with resultType string).
    :type account_name: any
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Analytics account. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Analytics account.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: Required. The name or ID of the tenant to which the service principal belongs.
     Type: string (or Expression with resultType string).
    :type tenant: any
    :param subscription_id: Data Lake Analytics account subscription ID (if different from Data
     Factory account). Type: string (or Expression with resultType string).
    :type subscription_id: any
    :param resource_group_name: Data Lake Analytics account resource group name (if different from
     Data Factory account). Type: string (or Expression with resultType string).
    :type resource_group_name: any
    :param data_lake_analytics_uri: Azure Data Lake Analytics URI Type: string (or Expression with
     resultType string).
    :type data_lake_analytics_uri: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'tenant': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'data_lake_analytics_uri': {'key': 'typeProperties.dataLakeAnalyticsUri', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        account_name: Any,
        tenant: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_key: Optional["SecretBase"] = None,
        subscription_id: Optional[Any] = None,
        resource_group_name: Optional[Any] = None,
        data_lake_analytics_uri: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDataLakeAnalyticsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureDataLakeAnalytics'  # type: str
        self.account_name = account_name
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.data_lake_analytics_uri = data_lake_analytics_uri
        self.encrypted_credential = encrypted_credential


class AzureDataLakeStoreDataset(Dataset):
    """Azure Data Lake Store dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param folder_path: Path to the folder in the Azure Data Lake Store. Type: string (or
     Expression with resultType string).
    :type folder_path: any
    :param file_name: The name of the file in the Azure Data Lake Store. Type: string (or
     Expression with resultType string).
    :type file_name: any
    :param format: The format of the Data Lake Store.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param compression: The data compression method used for the item(s) in the Azure Data Lake
     Store.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'file_name': {'key': 'typeProperties.fileName', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        format: Optional["DatasetStorageFormat"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureDataLakeStoreFile'  # type: str
        self.folder_path = folder_path
        self.file_name = file_name
        self.format = format
        self.compression = compression


class AzureDataLakeStoreLinkedService(LinkedService):
    """Azure Data Lake Store linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param data_lake_store_uri: Required. Data Lake Store service URI. Type: string (or Expression
     with resultType string).
    :type data_lake_store_uri: any
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Store account. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Store account.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: any
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: any
    :param account_name: Data Lake Store account name. Type: string (or Expression with resultType
     string).
    :type account_name: any
    :param subscription_id: Data Lake Store account subscription ID (if different from Data Factory
     account). Type: string (or Expression with resultType string).
    :type subscription_id: any
    :param resource_group_name: Data Lake Store account resource group name (if different from Data
     Factory account). Type: string (or Expression with resultType string).
    :type resource_group_name: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        'type': {'required': True},
        'data_lake_store_uri': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'data_lake_store_uri': {'key': 'typeProperties.dataLakeStoreUri', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
    }

    def __init__(
        self,
        *,
        data_lake_store_uri: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[Any] = None,
        azure_cloud_type: Optional[Any] = None,
        account_name: Optional[Any] = None,
        subscription_id: Optional[Any] = None,
        resource_group_name: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        credential: Optional["CredentialReference"] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureDataLakeStore'  # type: str
        self.data_lake_store_uri = data_lake_store_uri
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.account_name = account_name
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.encrypted_credential = encrypted_credential
        self.credential = credential


class AzureDataLakeStoreLocation(DatasetLocation):
    """The location of azure data lake store dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AzureDataLakeStoreLocation'  # type: str


class AzureDataLakeStoreReadSettings(StoreReadSettings):
    """Azure data lake store read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param wildcard_folder_path: ADLS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: any
    :param wildcard_file_name: ADLS wildcardFileName. Type: string (or Expression with resultType
     string).
    :type wildcard_file_name: any
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: any
    :param list_after: Lists files after the value (exclusive) based on file/folder names’
     lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders
     under the folderPath. Type: string (or Expression with resultType string).
    :type list_after: any
    :param list_before: Lists files before the value (inclusive) based on file/folder names’
     lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders
     under the folderPath. Type: string (or Expression with resultType string).
    :type list_before: any
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: any
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: any
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'list_after': {'key': 'listAfter', 'type': 'object'},
        'list_before': {'key': 'listBefore', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        wildcard_folder_path: Optional[Any] = None,
        wildcard_file_name: Optional[Any] = None,
        file_list_path: Optional[Any] = None,
        list_after: Optional[Any] = None,
        list_before: Optional[Any] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[Any] = None,
        delete_files_after_completion: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureDataLakeStoreReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.file_list_path = file_list_path
        self.list_after = list_after
        self.list_before = list_before
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureDataLakeStoreSink(CopySink):
    """A copy activity Azure Data Lake Store sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: any
    :param enable_adls_single_file_parallel: Single File Parallel.
    :type enable_adls_single_file_parallel: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'enable_adls_single_file_parallel': {'key': 'enableAdlsSingleFileParallel', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        copy_behavior: Optional[Any] = None,
        enable_adls_single_file_parallel: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureDataLakeStoreSink'  # type: str
        self.copy_behavior = copy_behavior
        self.enable_adls_single_file_parallel = enable_adls_single_file_parallel


class AzureDataLakeStoreSource(CopySource):
    """A copy activity Azure Data Lake source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureDataLakeStoreSource'  # type: str
        self.recursive = recursive


class AzureDataLakeStoreWriteSettings(StoreWriteSettings):
    """Azure data lake store write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: any
    :param expiry_date_time: Specifies the expiry time of the written files. The time is applied to
     the UTC time zone in the format of "2018-12-01T05:00:00Z". Default value is NULL. Type: integer
     (or Expression with resultType integer).
    :type expiry_date_time: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'expiry_date_time': {'key': 'expiryDateTime', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        copy_behavior: Optional[Any] = None,
        expiry_date_time: Optional[Any] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreWriteSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, copy_behavior=copy_behavior, **kwargs)
        self.type = 'AzureDataLakeStoreWriteSettings'  # type: str
        self.expiry_date_time = expiry_date_time


class AzureFileStorageLinkedService(LinkedService):
    """Azure File Storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param host: Host name of the server. Type: string (or Expression with resultType string).
    :type host: any
    :param user_id: User ID to logon the server. Type: string (or Expression with resultType
     string).
    :type user_id: any
    :param password: Password to logon the server.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: any
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure File resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type sas_uri: any
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param file_share: The azure file share name. It is required when auth with
     accountKey/sasToken. Type: string (or Expression with resultType string).
    :type file_share: any
    :param snapshot: The azure file share snapshot version. Type: string (or Expression with
     resultType string).
    :type snapshot: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'user_id': {'key': 'typeProperties.userId', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'file_share': {'key': 'typeProperties.fileShare', 'type': 'object'},
        'snapshot': {'key': 'typeProperties.snapshot', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        host: Optional[Any] = None,
        user_id: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        connection_string: Optional[Any] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[Any] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        file_share: Optional[Any] = None,
        snapshot: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AzureFileStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureFileStorage'  # type: str
        self.host = host
        self.user_id = user_id
        self.password = password
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.file_share = file_share
        self.snapshot = snapshot
        self.encrypted_credential = encrypted_credential


class AzureFileStorageLocation(DatasetLocation):
    """The location of file server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        **kwargs
    ):
        super(AzureFileStorageLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AzureFileStorageLocation'  # type: str


class AzureFileStorageReadSettings(StoreReadSettings):
    """Azure File Storage read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param wildcard_folder_path: Azure File Storage wildcardFolderPath. Type: string (or Expression
     with resultType string).
    :type wildcard_folder_path: any
    :param wildcard_file_name: Azure File Storage wildcardFileName. Type: string (or Expression
     with resultType string).
    :type wildcard_file_name: any
    :param prefix: The prefix filter for the Azure File name starting from root path. Type: string
     (or Expression with resultType string).
    :type prefix: any
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: any
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: any
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: any
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        wildcard_folder_path: Optional[Any] = None,
        wildcard_file_name: Optional[Any] = None,
        prefix: Optional[Any] = None,
        file_list_path: Optional[Any] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[Any] = None,
        delete_files_after_completion: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        **kwargs
    ):
        super(AzureFileStorageReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureFileStorageReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureFileStorageWriteSettings(StoreWriteSettings):
    """Azure File Storage write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        copy_behavior: Optional[Any] = None,
        **kwargs
    ):
        super(AzureFileStorageWriteSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, copy_behavior=copy_behavior, **kwargs)
        self.type = 'AzureFileStorageWriteSettings'  # type: str


class AzureFunctionActivity(ExecutionActivity):
    """Azure Function activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param method: Required. Rest API method for target endpoint. Possible values include: "GET",
     "POST", "PUT", "DELETE", "OPTIONS", "HEAD", "TRACE".
    :type method: str or ~azure.mgmt.datafactory.models.AzureFunctionActivityMethod
    :param function_name: Required. Name of the Function that the Azure Function Activity will
     call. Type: string (or Expression with resultType string).
    :type function_name: any
    :param headers: Represents the headers that will be sent to the request. For example, to set
     the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type":
     "application/json" }. Type: string (or Expression with resultType string).
    :type headers: any
    :param body: Represents the payload that will be sent to the endpoint. Required for POST/PUT
     method, not allowed for GET method Type: string (or Expression with resultType string).
    :type body: any
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'method': {'required': True},
        'function_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'method': {'key': 'typeProperties.method', 'type': 'str'},
        'function_name': {'key': 'typeProperties.functionName', 'type': 'object'},
        'headers': {'key': 'typeProperties.headers', 'type': 'object'},
        'body': {'key': 'typeProperties.body', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        method: Union[str, "AzureFunctionActivityMethod"],
        function_name: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        headers: Optional[Any] = None,
        body: Optional[Any] = None,
        **kwargs
    ):
        super(AzureFunctionActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'AzureFunctionActivity'  # type: str
        self.method = method
        self.function_name = function_name
        self.headers = headers
        self.body = body


class AzureFunctionLinkedService(LinkedService):
    """Azure Function linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param function_app_url: Required. The endpoint of the Azure Function App. URL will be in the
     format https://:code:`<accountName>`.azurewebsites.net.
    :type function_app_url: any
    :param function_key: Function or Host key for Azure Function App.
    :type function_key: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    :param resource_id: Allowed token audiences for azure function.
    :type resource_id: any
    :param authentication: Type of authentication (Required to specify MSI) used to connect to
     AzureFunction. Type: string (or Expression with resultType string).
    :type authentication: any
    """

    _validation = {
        'type': {'required': True},
        'function_app_url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'function_app_url': {'key': 'typeProperties.functionAppUrl', 'type': 'object'},
        'function_key': {'key': 'typeProperties.functionKey', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
        'resource_id': {'key': 'typeProperties.resourceId', 'type': 'object'},
        'authentication': {'key': 'typeProperties.authentication', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        function_app_url: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        function_key: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        credential: Optional["CredentialReference"] = None,
        resource_id: Optional[Any] = None,
        authentication: Optional[Any] = None,
        **kwargs
    ):
        super(AzureFunctionLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureFunction'  # type: str
        self.function_app_url = function_app_url
        self.function_key = function_key
        self.encrypted_credential = encrypted_credential
        self.credential = credential
        self.resource_id = resource_id
        self.authentication = authentication


class AzureKeyVaultLinkedService(LinkedService):
    """Azure Key Vault linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param base_url: Required. The base URL of the Azure Key Vault. e.g.
     https://myakv.vault.azure.net Type: string (or Expression with resultType string).
    :type base_url: any
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        'type': {'required': True},
        'base_url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'base_url': {'key': 'typeProperties.baseUrl', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
    }

    def __init__(
        self,
        *,
        base_url: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        credential: Optional["CredentialReference"] = None,
        **kwargs
    ):
        super(AzureKeyVaultLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureKeyVault'  # type: str
        self.base_url = base_url
        self.credential = credential


class SecretBase(msrest.serialization.Model):
    """The base definition of a secret type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureKeyVaultSecretReference, SecureString.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzureKeyVaultSecret': 'AzureKeyVaultSecretReference', 'SecureString': 'SecureString'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecretBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureKeyVaultSecretReference(SecretBase):
    """Azure Key Vault secret reference.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    :param store: Required. The Azure Key Vault linked service reference.
    :type store: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param secret_name: Required. The name of the secret in Azure Key Vault. Type: string (or
     Expression with resultType string).
    :type secret_name: any
    :param secret_version: The version of the secret in Azure Key Vault. The default value is the
     latest version of the secret. Type: string (or Expression with resultType string).
    :type secret_version: any
    """

    _validation = {
        'type': {'required': True},
        'store': {'required': True},
        'secret_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'store': {'key': 'store', 'type': 'LinkedServiceReference'},
        'secret_name': {'key': 'secretName', 'type': 'object'},
        'secret_version': {'key': 'secretVersion', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        store: "LinkedServiceReference",
        secret_name: Any,
        secret_version: Optional[Any] = None,
        **kwargs
    ):
        super(AzureKeyVaultSecretReference, self).__init__(**kwargs)
        self.type = 'AzureKeyVaultSecret'  # type: str
        self.store = store
        self.secret_name = secret_name
        self.secret_version = secret_version


class AzureMariaDBLinkedService(LinkedService):
    """Azure Database for MariaDB linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_string: Optional[Any] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AzureMariaDBLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureMariaDB'  # type: str
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class AzureMariaDBSource(TabularSource):
    """A copy activity Azure MariaDB source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(AzureMariaDBSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AzureMariaDBSource'  # type: str
        self.query = query


class AzureMariaDBTableDataset(Dataset):
    """Azure Database for MariaDB dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        **kwargs
    ):
        super(AzureMariaDBTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureMariaDBTable'  # type: str
        self.table_name = table_name


class AzureMLBatchExecutionActivity(ExecutionActivity):
    """Azure ML Batch Execution activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param global_parameters: Key,Value pairs to be passed to the Azure ML Batch Execution Service
     endpoint. Keys must match the names of web service parameters defined in the published Azure ML
     web service. Values will be passed in the GlobalParameters property of the Azure ML batch
     execution request.
    :type global_parameters: dict[str, any]
    :param web_service_outputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
     Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This
     information will be passed in the WebServiceOutputs property of the Azure ML batch execution
     request.
    :type web_service_outputs: dict[str, ~azure.mgmt.datafactory.models.AzureMLWebServiceFile]
    :param web_service_inputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
     Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This
     information will be passed in the WebServiceInputs property of the Azure ML batch execution
     request.
    :type web_service_inputs: dict[str, ~azure.mgmt.datafactory.models.AzureMLWebServiceFile]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'global_parameters': {'key': 'typeProperties.globalParameters', 'type': '{object}'},
        'web_service_outputs': {'key': 'typeProperties.webServiceOutputs', 'type': '{AzureMLWebServiceFile}'},
        'web_service_inputs': {'key': 'typeProperties.webServiceInputs', 'type': '{AzureMLWebServiceFile}'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        global_parameters: Optional[Dict[str, Any]] = None,
        web_service_outputs: Optional[Dict[str, "AzureMLWebServiceFile"]] = None,
        web_service_inputs: Optional[Dict[str, "AzureMLWebServiceFile"]] = None,
        **kwargs
    ):
        super(AzureMLBatchExecutionActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'AzureMLBatchExecution'  # type: str
        self.global_parameters = global_parameters
        self.web_service_outputs = web_service_outputs
        self.web_service_inputs = web_service_inputs


class AzureMLExecutePipelineActivity(ExecutionActivity):
    """Azure ML Execute Pipeline activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param ml_pipeline_id: ID of the published Azure ML pipeline. Type: string (or Expression with
     resultType string).
    :type ml_pipeline_id: any
    :param ml_pipeline_endpoint_id: ID of the published Azure ML pipeline endpoint. Type: string
     (or Expression with resultType string).
    :type ml_pipeline_endpoint_id: any
    :param version: Version of the published Azure ML pipeline endpoint. Type: string (or
     Expression with resultType string).
    :type version: any
    :param experiment_name: Run history experiment name of the pipeline run. This information will
     be passed in the ExperimentName property of the published pipeline execution request. Type:
     string (or Expression with resultType string).
    :type experiment_name: any
    :param ml_pipeline_parameters: Key,Value pairs to be passed to the published Azure ML pipeline
     endpoint. Keys must match the names of pipeline parameters defined in the published pipeline.
     Values will be passed in the ParameterAssignments property of the published pipeline execution
     request. Type: object with key value pairs (or Expression with resultType object).
    :type ml_pipeline_parameters: any
    :param data_path_assignments: Dictionary used for changing data path assignments without
     retraining. Values will be passed in the dataPathAssignments property of the published pipeline
     execution request. Type: object with key value pairs (or Expression with resultType object).
    :type data_path_assignments: any
    :param ml_parent_run_id: The parent Azure ML Service pipeline run id. This information will be
     passed in the ParentRunId property of the published pipeline execution request. Type: string
     (or Expression with resultType string).
    :type ml_parent_run_id: any
    :param continue_on_step_failure: Whether to continue execution of other steps in the
     PipelineRun if a step fails. This information will be passed in the continueOnStepFailure
     property of the published pipeline execution request. Type: boolean (or Expression with
     resultType boolean).
    :type continue_on_step_failure: any
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'ml_pipeline_id': {'key': 'typeProperties.mlPipelineId', 'type': 'object'},
        'ml_pipeline_endpoint_id': {'key': 'typeProperties.mlPipelineEndpointId', 'type': 'object'},
        'version': {'key': 'typeProperties.version', 'type': 'object'},
        'experiment_name': {'key': 'typeProperties.experimentName', 'type': 'object'},
        'ml_pipeline_parameters': {'key': 'typeProperties.mlPipelineParameters', 'type': 'object'},
        'data_path_assignments': {'key': 'typeProperties.dataPathAssignments', 'type': 'object'},
        'ml_parent_run_id': {'key': 'typeProperties.mlParentRunId', 'type': 'object'},
        'continue_on_step_failure': {'key': 'typeProperties.continueOnStepFailure', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        ml_pipeline_id: Optional[Any] = None,
        ml_pipeline_endpoint_id: Optional[Any] = None,
        version: Optional[Any] = None,
        experiment_name: Optional[Any] = None,
        ml_pipeline_parameters: Optional[Any] = None,
        data_path_assignments: Optional[Any] = None,
        ml_parent_run_id: Optional[Any] = None,
        continue_on_step_failure: Optional[Any] = None,
        **kwargs
    ):
        super(AzureMLExecutePipelineActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'AzureMLExecutePipeline'  # type: str
        self.ml_pipeline_id = ml_pipeline_id
        self.ml_pipeline_endpoint_id = ml_pipeline_endpoint_id
        self.version = version
        self.experiment_name = experiment_name
        self.ml_pipeline_parameters = ml_pipeline_parameters
        self.data_path_assignments = data_path_assignments
        self.ml_parent_run_id = ml_parent_run_id
        self.continue_on_step_failure = continue_on_step_failure


class AzureMLLinkedService(LinkedService):
    """Azure ML Studio Web Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param ml_endpoint: Required. The Batch Execution REST URL for an Azure ML Studio Web Service
     endpoint. Type: string (or Expression with resultType string).
    :type ml_endpoint: any
    :param api_key: Required. The API key for accessing the Azure ML model endpoint.
    :type api_key: ~azure.mgmt.datafactory.models.SecretBase
    :param update_resource_endpoint: The Update Resource REST URL for an Azure ML Studio Web
     Service endpoint. Type: string (or Expression with resultType string).
    :type update_resource_endpoint: any
    :param service_principal_id: The ID of the service principal used to authenticate against the
     ARM-based updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression
     with resultType string).
    :type service_principal_id: any
    :param service_principal_key: The key of the service principal used to authenticate against the
     ARM-based updateResourceEndpoint of an Azure ML Studio web service.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param authentication: Type of authentication (Required to specify MSI) used to connect to
     AzureML. Type: string (or Expression with resultType string).
    :type authentication: any
    """

    _validation = {
        'type': {'required': True},
        'ml_endpoint': {'required': True},
        'api_key': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'ml_endpoint': {'key': 'typeProperties.mlEndpoint', 'type': 'object'},
        'api_key': {'key': 'typeProperties.apiKey', 'type': 'SecretBase'},
        'update_resource_endpoint': {'key': 'typeProperties.updateResourceEndpoint', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'authentication': {'key': 'typeProperties.authentication', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        ml_endpoint: Any,
        api_key: "SecretBase",
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        update_resource_endpoint: Optional[Any] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        authentication: Optional[Any] = None,
        **kwargs
    ):
        super(AzureMLLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureML'  # type: str
        self.ml_endpoint = ml_endpoint
        self.api_key = api_key
        self.update_resource_endpoint = update_resource_endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential
        self.authentication = authentication


class AzureMLServiceLinkedService(LinkedService):
    """Azure ML Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param subscription_id: Required. Azure ML Service workspace subscription ID. Type: string (or
     Expression with resultType string).
    :type subscription_id: any
    :param resource_group_name: Required. Azure ML Service workspace resource group name. Type:
     string (or Expression with resultType string).
    :type resource_group_name: any
    :param ml_workspace_name: Required. Azure ML Service workspace name. Type: string (or
     Expression with resultType string).
    :type ml_workspace_name: any
    :param service_principal_id: The ID of the service principal used to authenticate against the
     endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType
     string).
    :type service_principal_id: any
    :param service_principal_key: The key of the service principal used to authenticate against the
     endpoint of a published Azure ML Service pipeline.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'ml_workspace_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'ml_workspace_name': {'key': 'typeProperties.mlWorkspaceName', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        subscription_id: Any,
        resource_group_name: Any,
        ml_workspace_name: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AzureMLServiceLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureMLService'  # type: str
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.ml_workspace_name = ml_workspace_name
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureMLUpdateResourceActivity(ExecutionActivity):
    """Azure ML Update Resource management activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param trained_model_name: Required. Name of the Trained Model module in the Web Service
     experiment to be updated. Type: string (or Expression with resultType string).
    :type trained_model_name: any
    :param trained_model_linked_service_name: Required. Name of Azure Storage linked service
     holding the .ilearner file that will be uploaded by the update operation.
    :type trained_model_linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param trained_model_file_path: Required. The relative file path in trainedModelLinkedService
     to represent the .ilearner file that will be uploaded by the update operation.  Type: string
     (or Expression with resultType string).
    :type trained_model_file_path: any
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'trained_model_name': {'required': True},
        'trained_model_linked_service_name': {'required': True},
        'trained_model_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'trained_model_name': {'key': 'typeProperties.trainedModelName', 'type': 'object'},
        'trained_model_linked_service_name': {'key': 'typeProperties.trainedModelLinkedServiceName', 'type': 'LinkedServiceReference'},
        'trained_model_file_path': {'key': 'typeProperties.trainedModelFilePath', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        trained_model_name: Any,
        trained_model_linked_service_name: "LinkedServiceReference",
        trained_model_file_path: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        **kwargs
    ):
        super(AzureMLUpdateResourceActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'AzureMLUpdateResource'  # type: str
        self.trained_model_name = trained_model_name
        self.trained_model_linked_service_name = trained_model_linked_service_name
        self.trained_model_file_path = trained_model_file_path


class AzureMLWebServiceFile(msrest.serialization.Model):
    """Azure ML WebService Input/Output file.

    All required parameters must be populated in order to send to Azure.

    :param file_path: Required. The relative file path, including container name, in the Azure Blob
     Storage specified by the LinkedService. Type: string (or Expression with resultType string).
    :type file_path: any
    :param linked_service_name: Required. Reference to an Azure Storage LinkedService, where Azure
     ML WebService Input/Output file located.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        'file_path': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'file_path': {'key': 'filePath', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        *,
        file_path: Any,
        linked_service_name: "LinkedServiceReference",
        **kwargs
    ):
        super(AzureMLWebServiceFile, self).__init__(**kwargs)
        self.file_path = file_path
        self.linked_service_name = linked_service_name


class AzureMySqlLinkedService(LinkedService):
    """Azure MySQL database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AzureMySqlLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureMySql'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class AzureMySqlSink(CopySink):
    """A copy activity Azure MySql sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param pre_copy_script: A query to execute before starting the copy. Type: string (or
     Expression with resultType string).
    :type pre_copy_script: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        pre_copy_script: Optional[Any] = None,
        **kwargs
    ):
        super(AzureMySqlSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureMySqlSink'  # type: str
        self.pre_copy_script = pre_copy_script


class AzureMySqlSource(TabularSource):
    """A copy activity Azure MySQL source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(AzureMySqlSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AzureMySqlSource'  # type: str
        self.query = query


class AzureMySqlTableDataset(Dataset):
    """The Azure MySQL database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The Azure MySQL database table name. Type: string (or Expression with
     resultType string).
    :type table_name: any
    :param table: The name of Azure MySQL database table. Type: string (or Expression with
     resultType string).
    :type table: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        table: Optional[Any] = None,
        **kwargs
    ):
        super(AzureMySqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureMySqlTable'  # type: str
        self.table_name = table_name
        self.table = table


class AzurePostgreSqlLinkedService(LinkedService):
    """Azure PostgreSQL linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_string: Optional[Any] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AzurePostgreSqlLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzurePostgreSql'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class AzurePostgreSqlSink(CopySink):
    """A copy activity Azure PostgreSQL sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param pre_copy_script: A query to execute before starting the copy. Type: string (or
     Expression with resultType string).
    :type pre_copy_script: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        pre_copy_script: Optional[Any] = None,
        **kwargs
    ):
        super(AzurePostgreSqlSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzurePostgreSqlSink'  # type: str
        self.pre_copy_script = pre_copy_script


class AzurePostgreSqlSource(TabularSource):
    """A copy activity Azure PostgreSQL source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(AzurePostgreSqlSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AzurePostgreSqlSource'  # type: str
        self.query = query


class AzurePostgreSqlTableDataset(Dataset):
    """Azure PostgreSQL dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name of the Azure PostgreSQL database which includes both schema
     and table. Type: string (or Expression with resultType string).
    :type table_name: any
    :param table: The table name of the Azure PostgreSQL database. Type: string (or Expression with
     resultType string).
    :type table: any
    :param schema_type_properties_schema: The schema name of the Azure PostgreSQL database. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        table: Optional[Any] = None,
        schema_type_properties_schema: Optional[Any] = None,
        **kwargs
    ):
        super(AzurePostgreSqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzurePostgreSqlTable'  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class AzureQueueSink(CopySink):
    """A copy activity Azure Queue sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        **kwargs
    ):
        super(AzureQueueSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureQueueSink'  # type: str


class AzureSearchIndexDataset(Dataset):
    """The Azure Search Index.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param index_name: Required. The name of the Azure Search Index. Type: string (or Expression
     with resultType string).
    :type index_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'index_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'index_name': {'key': 'typeProperties.indexName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        index_name: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(AzureSearchIndexDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureSearchIndex'  # type: str
        self.index_name = index_name


class AzureSearchIndexSink(CopySink):
    """A copy activity Azure Search Index sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param write_behavior: Specify the write behavior when upserting documents into Azure Search
     Index. Possible values include: "Merge", "Upload".
    :type write_behavior: str or ~azure.mgmt.datafactory.models.AzureSearchIndexWriteBehaviorType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        write_behavior: Optional[Union[str, "AzureSearchIndexWriteBehaviorType"]] = None,
        **kwargs
    ):
        super(AzureSearchIndexSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureSearchIndexSink'  # type: str
        self.write_behavior = write_behavior


class AzureSearchLinkedService(LinkedService):
    """Linked service for Windows Azure Search Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param url: Required. URL for Azure Search service. Type: string (or Expression with resultType
     string).
    :type url: any
    :param key: Admin Key for Azure Search service.
    :type key: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'key': {'key': 'typeProperties.key', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        key: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(AzureSearchLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureSearch'  # type: str
        self.url = url
        self.key = key
        self.encrypted_credential = encrypted_credential


class AzureSqlDatabaseLinkedService(LinkedService):
    """Microsoft Azure SQL Database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Database. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Database.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: any
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param always_encrypted_settings: Sql always encrypted properties.
    :type always_encrypted_settings: ~azure.mgmt.datafactory.models.SqlAlwaysEncryptedProperties
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'always_encrypted_settings': {'key': 'typeProperties.alwaysEncryptedSettings', 'type': 'SqlAlwaysEncryptedProperties'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
    }

    def __init__(
        self,
        *,
        connection_string: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[Any] = None,
        azure_cloud_type: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        always_encrypted_settings: Optional["SqlAlwaysEncryptedProperties"] = None,
        credential: Optional["CredentialReference"] = None,
        **kwargs
    ):
        super(AzureSqlDatabaseLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureSqlDatabase'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential
        self.always_encrypted_settings = always_encrypted_settings
        self.credential = credential


class AzureSqlDWLinkedService(LinkedService):
    """Azure SQL Data Warehouse linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: any
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Data Warehouse. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Data Warehouse.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: any
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
    }

    def __init__(
        self,
        *,
        connection_string: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[Any] = None,
        azure_cloud_type: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        credential: Optional["CredentialReference"] = None,
        **kwargs
    ):
        super(AzureSqlDWLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureSqlDW'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential
        self.credential = credential


class AzureSqlDWTableDataset(Dataset):
    """The Azure SQL Data Warehouse dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: any
    :param schema_type_properties_schema: The schema name of the Azure SQL Data Warehouse. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: any
    :param table: The table name of the Azure SQL Data Warehouse. Type: string (or Expression with
     resultType string).
    :type table: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        schema_type_properties_schema: Optional[Any] = None,
        table: Optional[Any] = None,
        **kwargs
    ):
        super(AzureSqlDWTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureSqlDWTable'  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureSqlMILinkedService(LinkedService):
    """Azure SQL Managed Instance linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Managed Instance. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Managed Instance.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: any
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param always_encrypted_settings: Sql always encrypted properties.
    :type always_encrypted_settings: ~azure.mgmt.datafactory.models.SqlAlwaysEncryptedProperties
    :param credential: The credential reference containing authentication information.
    :type credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'always_encrypted_settings': {'key': 'typeProperties.alwaysEncryptedSettings', 'type': 'SqlAlwaysEncryptedProperties'},
        'credential': {'key': 'typeProperties.credential', 'type': 'CredentialReference'},
    }

    def __init__(
        self,
        *,
        connection_string: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[Any] = None,
        azure_cloud_type: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        always_encrypted_settings: Optional["SqlAlwaysEncryptedProperties"] = None,
        credential: Optional["CredentialReference"] = None,
        **kwargs
    ):
        super(AzureSqlMILinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureSqlMI'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential
        self.always_encrypted_settings = always_encrypted_settings
        self.credential = credential


class AzureSqlMITableDataset(Dataset):
    """The Azure SQL Managed Instance dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: any
    :param schema_type_properties_schema: The schema name of the Azure SQL Managed Instance. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: any
    :param table: The table name of the Azure SQL Managed Instance dataset. Type: string (or
     Expression with resultType string).
    :type table: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        schema_type_properties_schema: Optional[Any] = None,
        table: Optional[Any] = None,
        **kwargs
    ):
        super(AzureSqlMITableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureSqlMITable'  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureSqlSink(CopySink):
    """A copy activity Azure SQL sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param sql_writer_stored_procedure_name: SQL writer stored procedure name. Type: string (or
     Expression with resultType string).
    :type sql_writer_stored_procedure_name: any
    :param sql_writer_table_type: SQL writer table type. Type: string (or Expression with
     resultType string).
    :type sql_writer_table_type: any
    :param pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType
     string).
    :type pre_copy_script: any
    :param stored_procedure_parameters: SQL stored procedure parameters.
    :type stored_procedure_parameters: dict[str,
     ~azure.mgmt.datafactory.models.StoredProcedureParameter]
    :param stored_procedure_table_type_parameter_name: The stored procedure parameter name of the
     table type. Type: string (or Expression with resultType string).
    :type stored_procedure_table_type_parameter_name: any
    :param table_option: The option to handle sink table, such as autoCreate. For now only
     'autoCreate' value is supported. Type: string (or Expression with resultType string).
    :type table_option: any
    :param sql_writer_use_table_lock: Whether to use table lock during bulk copy. Type: boolean (or
     Expression with resultType boolean).
    :type sql_writer_use_table_lock: any
    :param write_behavior: Write behavior when copying data into Azure SQL. Type:
     SqlWriteBehaviorEnum (or Expression with resultType SqlWriteBehaviorEnum).
    :type write_behavior: any
    :param upsert_settings: SQL upsert settings.
    :type upsert_settings: ~azure.mgmt.datafactory.models.SqlUpsertSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'sql_writer_stored_procedure_name': {'key': 'sqlWriterStoredProcedureName', 'type': 'object'},
        'sql_writer_table_type': {'key': 'sqlWriterTableType', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
        'stored_procedure_parameters': {'key': 'storedProcedureParameters', 'type': '{StoredProcedureParameter}'},
        'stored_procedure_table_type_parameter_name': {'key': 'storedProcedureTableTypeParameterName', 'type': 'object'},
        'table_option': {'key': 'tableOption', 'type': 'object'},
        'sql_writer_use_table_lock': {'key': 'sqlWriterUseTableLock', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'object'},
        'upsert_settings': {'key': 'upsertSettings', 'type': 'SqlUpsertSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        sql_writer_stored_procedure_name: Optional[Any] = None,
        sql_writer_table_type: Optional[Any] = None,
        pre_copy_script: Optional[Any] = None,
        stored_procedure_parameters: Optional[Dict[str, "StoredProcedureParameter"]] = None,
        stored_procedure_table_type_parameter_name: Optional[Any] = None,
        table_option: Optional[Any] = None,
        sql_writer_use_table_lock: Optional[Any] = None,
        write_behavior: Optional[Any] = None,
        upsert_settings: Optional["SqlUpsertSettings"] = None,
        **kwargs
    ):
        super(AzureSqlSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureSqlSink'  # type: str
        self.sql_writer_stored_procedure_name = sql_writer_stored_procedure_name
        self.sql_writer_table_type = sql_writer_table_type
        self.pre_copy_script = pre_copy_script
        self.stored_procedure_parameters = stored_procedure_parameters
        self.stored_procedure_table_type_parameter_name = stored_procedure_table_type_parameter_name
        self.table_option = table_option
        self.sql_writer_use_table_lock = sql_writer_use_table_lock
        self.write_behavior = write_behavior
        self.upsert_settings = upsert_settings


class AzureSqlSource(TabularSource):
    """A copy activity Azure SQL source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param sql_reader_query: SQL reader query. Type: string (or Expression with resultType string).
    :type sql_reader_query: any
    :param sql_reader_stored_procedure_name: Name of the stored procedure for a SQL Database
     source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression
     with resultType string).
    :type sql_reader_stored_procedure_name: any
    :param stored_procedure_parameters: Value and type setting for stored procedure parameters.
     Example: "{Parameter1: {value: "1", type: "int"}}".
    :type stored_procedure_parameters: dict[str,
     ~azure.mgmt.datafactory.models.StoredProcedureParameter]
    :param produce_additional_types: Which additional types to produce.
    :type produce_additional_types: any
    :param partition_option: The partition mechanism that will be used for Sql read in parallel.
     Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
    :type partition_option: any
    :param partition_settings: The settings that will be leveraged for Sql source partitioning.
    :type partition_settings: ~azure.mgmt.datafactory.models.SqlPartitionSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'sql_reader_query': {'key': 'sqlReaderQuery', 'type': 'object'},
        'sql_reader_stored_procedure_name': {'key': 'sqlReaderStoredProcedureName', 'type': 'object'},
        'stored_procedure_parameters': {'key': 'storedProcedureParameters', 'type': '{StoredProcedureParameter}'},
        'produce_additional_types': {'key': 'produceAdditionalTypes', 'type': 'object'},
        'partition_option': {'key': 'partitionOption', 'type': 'object'},
        'partition_settings': {'key': 'partitionSettings', 'type': 'SqlPartitionSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        sql_reader_query: Optional[Any] = None,
        sql_reader_stored_procedure_name: Optional[Any] = None,
        stored_procedure_parameters: Optional[Dict[str, "StoredProcedureParameter"]] = None,
        produce_additional_types: Optional[Any] = None,
        partition_option: Optional[Any] = None,
        partition_settings: Optional["SqlPartitionSettings"] = None,
        **kwargs
    ):
        super(AzureSqlSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AzureSqlSource'  # type: str
        self.sql_reader_query = sql_reader_query
        self.sql_reader_stored_procedure_name = sql_reader_stored_procedure_name
        self.stored_procedure_parameters = stored_procedure_parameters
        self.produce_additional_types = produce_additional_types
        self.partition_option = partition_option
        self.partition_settings = partition_settings


class AzureSqlTableDataset(Dataset):
    """The Azure SQL Server database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: any
    :param schema_type_properties_schema: The schema name of the Azure SQL database. Type: string
     (or Expression with resultType string).
    :type schema_type_properties_schema: any
    :param table: The table name of the Azure SQL database. Type: string (or Expression with
     resultType string).
    :type table: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        schema_type_properties_schema: Optional[Any] = None,
        table: Optional[Any] = None,
        **kwargs
    ):
        super(AzureSqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureSqlTable'  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureStorageLinkedService(LinkedService):
    """The storage account linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: any
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type sas_uri: any
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_string: Optional[Any] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[Any] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        super(AzureStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureStorage'  # type: str
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.encrypted_credential = encrypted_credential


class AzureTableDataset(Dataset):
    """The Azure Table storage dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: Required. The table name of the Azure Table storage. Type: string (or
     Expression with resultType string).
    :type table_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'table_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        table_name: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(AzureTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureTable'  # type: str
        self.table_name = table_name


class AzureTableSink(CopySink):
    """A copy activity Azure Table sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param azure_table_default_partition_key_value: Azure Table default partition key value. Type:
     string (or Expression with resultType string).
    :type azure_table_default_partition_key_value: any
    :param azure_table_partition_key_name: Azure Table partition key name. Type: string (or
     Expression with resultType string).
    :type azure_table_partition_key_name: any
    :param azure_table_row_key_name: Azure Table row key name. Type: string (or Expression with
     resultType string).
    :type azure_table_row_key_name: any
    :param azure_table_insert_type: Azure Table insert type. Type: string (or Expression with
     resultType string).
    :type azure_table_insert_type: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'azure_table_default_partition_key_value': {'key': 'azureTableDefaultPartitionKeyValue', 'type': 'object'},
        'azure_table_partition_key_name': {'key': 'azureTablePartitionKeyName', 'type': 'object'},
        'azure_table_row_key_name': {'key': 'azureTableRowKeyName', 'type': 'object'},
        'azure_table_insert_type': {'key': 'azureTableInsertType', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        azure_table_default_partition_key_value: Optional[Any] = None,
        azure_table_partition_key_name: Optional[Any] = None,
        azure_table_row_key_name: Optional[Any] = None,
        azure_table_insert_type: Optional[Any] = None,
        **kwargs
    ):
        super(AzureTableSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'AzureTableSink'  # type: str
        self.azure_table_default_partition_key_value = azure_table_default_partition_key_value
        self.azure_table_partition_key_name = azure_table_partition_key_name
        self.azure_table_row_key_name = azure_table_row_key_name
        self.azure_table_insert_type = azure_table_insert_type


class AzureTableSource(TabularSource):
    """A copy activity Azure Table source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param azure_table_source_query: Azure Table source query. Type: string (or Expression with
     resultType string).
    :type azure_table_source_query: any
    :param azure_table_source_ignore_table_not_found: Azure Table source ignore table not found.
     Type: boolean (or Expression with resultType boolean).
    :type azure_table_source_ignore_table_not_found: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'azure_table_source_query': {'key': 'azureTableSourceQuery', 'type': 'object'},
        'azure_table_source_ignore_table_not_found': {'key': 'azureTableSourceIgnoreTableNotFound', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        azure_table_source_query: Optional[Any] = None,
        azure_table_source_ignore_table_not_found: Optional[Any] = None,
        **kwargs
    ):
        super(AzureTableSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AzureTableSource'  # type: str
        self.azure_table_source_query = azure_table_source_query
        self.azure_table_source_ignore_table_not_found = azure_table_source_ignore_table_not_found


class AzureTableStorageLinkedService(LinkedService):
    """The azure table storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: any
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type sas_uri: any
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_string: Optional[Any] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[Any] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        super(AzureTableStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureTableStorage'  # type: str
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.encrypted_credential = encrypted_credential


class BinaryDataset(Dataset):
    """Binary dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param location: The location of the Binary storage.
    :type location: ~azure.mgmt.datafactory.models.DatasetLocation
    :param compression: The data compression method used for the binary dataset.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(BinaryDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'Binary'  # type: str
        self.location = location
        self.compression = compression


class FormatReadSettings(msrest.serialization.Model):
    """Format read settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BinaryReadSettings, DelimitedTextReadSettings, JsonReadSettings, XmlReadSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'BinaryReadSettings': 'BinaryReadSettings', 'DelimitedTextReadSettings': 'DelimitedTextReadSettings', 'JsonReadSettings': 'JsonReadSettings', 'XmlReadSettings': 'XmlReadSettings'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(FormatReadSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'FormatReadSettings'  # type: str


class BinaryReadSettings(FormatReadSettings):
    """Binary read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param compression_properties: Compression settings.
    :type compression_properties: ~azure.mgmt.datafactory.models.CompressionReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'compression_properties': {'key': 'compressionProperties', 'type': 'CompressionReadSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        compression_properties: Optional["CompressionReadSettings"] = None,
        **kwargs
    ):
        super(BinaryReadSettings, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'BinaryReadSettings'  # type: str
        self.compression_properties = compression_properties


class BinarySink(CopySink):
    """A copy activity Binary sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param store_settings: Binary store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        store_settings: Optional["StoreWriteSettings"] = None,
        **kwargs
    ):
        super(BinarySink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'BinarySink'  # type: str
        self.store_settings = store_settings


class BinarySource(CopySource):
    """A copy activity Binary source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param store_settings: Binary store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :param format_settings: Binary format settings.
    :type format_settings: ~azure.mgmt.datafactory.models.BinaryReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'BinaryReadSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        format_settings: Optional["BinaryReadSettings"] = None,
        **kwargs
    ):
        super(BinarySource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'BinarySource'  # type: str
        self.store_settings = store_settings
        self.format_settings = format_settings


class Trigger(msrest.serialization.Model):
    """Azure data factory nested object which contains information about creating pipeline run.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ChainingTrigger, MultiplePipelineTrigger, RerunTumblingWindowTrigger, TumblingWindowTrigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[any]
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
    }

    _subtype_map = {
        'type': {'ChainingTrigger': 'ChainingTrigger', 'MultiplePipelineTrigger': 'MultiplePipelineTrigger', 'RerunTumblingWindowTrigger': 'RerunTumblingWindowTrigger', 'TumblingWindowTrigger': 'TumblingWindowTrigger'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[Any]] = None,
        **kwargs
    ):
        super(Trigger, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'Trigger'  # type: str
        self.description = description
        self.runtime_state = None
        self.annotations = annotations


class MultiplePipelineTrigger(Trigger):
    """Base class for all triggers that support one to many model for trigger to pipeline.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BlobEventsTrigger, BlobTrigger, CustomEventsTrigger, ScheduleTrigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[any]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
    }

    _subtype_map = {
        'type': {'BlobEventsTrigger': 'BlobEventsTrigger', 'BlobTrigger': 'BlobTrigger', 'CustomEventsTrigger': 'CustomEventsTrigger', 'ScheduleTrigger': 'ScheduleTrigger'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[Any]] = None,
        pipelines: Optional[List["TriggerPipelineReference"]] = None,
        **kwargs
    ):
        super(MultiplePipelineTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, **kwargs)
        self.type = 'MultiplePipelineTrigger'  # type: str
        self.pipelines = pipelines


class BlobEventsTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time a Blob event occurs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[any]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    :param blob_path_begins_with: The blob path must begin with the pattern provided for trigger to
     fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the
     december folder under the records container. At least one of these must be provided:
     blobPathBeginsWith, blobPathEndsWith.
    :type blob_path_begins_with: str
    :param blob_path_ends_with: The blob path must end with the pattern provided for trigger to
     fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a
     december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
    :type blob_path_ends_with: str
    :param ignore_empty_blobs: If set to true, blobs with zero bytes will be ignored.
    :type ignore_empty_blobs: bool
    :param events: Required. The type of events that cause this trigger to fire.
    :type events: list[str or ~azure.mgmt.datafactory.models.BlobEventTypes]
    :param scope: Required. The ARM resource ID of the Storage Account.
    :type scope: str
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'events': {'required': True},
        'scope': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
        'blob_path_begins_with': {'key': 'typeProperties.blobPathBeginsWith', 'type': 'str'},
        'blob_path_ends_with': {'key': 'typeProperties.blobPathEndsWith', 'type': 'str'},
        'ignore_empty_blobs': {'key': 'typeProperties.ignoreEmptyBlobs', 'type': 'bool'},
        'events': {'key': 'typeProperties.events', 'type': '[str]'},
        'scope': {'key': 'typeProperties.scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        events: List[Union[str, "BlobEventTypes"]],
        scope: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[Any]] = None,
        pipelines: Optional[List["TriggerPipelineReference"]] = None,
        blob_path_begins_with: Optional[str] = None,
        blob_path_ends_with: Optional[str] = None,
        ignore_empty_blobs: Optional[bool] = None,
        **kwargs
    ):
        super(BlobEventsTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, pipelines=pipelines, **kwargs)
        self.type = 'BlobEventsTrigger'  # type: str
        self.blob_path_begins_with = blob_path_begins_with
        self.blob_path_ends_with = blob_path_ends_with
        self.ignore_empty_blobs = ignore_empty_blobs
        self.events = events
        self.scope = scope


class BlobSink(CopySink):
    """A copy activity Azure Blob sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param blob_writer_overwrite_files: Blob writer overwrite files. Type: boolean (or Expression
     with resultType boolean).
    :type blob_writer_overwrite_files: any
    :param blob_writer_date_time_format: Blob writer date time format. Type: string (or Expression
     with resultType string).
    :type blob_writer_date_time_format: any
    :param blob_writer_add_header: Blob writer add header. Type: boolean (or Expression with
     resultType boolean).
    :type blob_writer_add_header: any
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: any
    :param metadata: Specify the custom metadata to be added to sink data. Type: array of objects
     (or Expression with resultType array of objects).
    :type metadata: list[~azure.mgmt.datafactory.models.MetadataItem]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'blob_writer_overwrite_files': {'key': 'blobWriterOverwriteFiles', 'type': 'object'},
        'blob_writer_date_time_format': {'key': 'blobWriterDateTimeFormat', 'type': 'object'},
        'blob_writer_add_header': {'key': 'blobWriterAddHeader', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        blob_writer_overwrite_files: Optional[Any] = None,
        blob_writer_date_time_format: Optional[Any] = None,
        blob_writer_add_header: Optional[Any] = None,
        copy_behavior: Optional[Any] = None,
        metadata: Optional[List["MetadataItem"]] = None,
        **kwargs
    ):
        super(BlobSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'BlobSink'  # type: str
        self.blob_writer_overwrite_files = blob_writer_overwrite_files
        self.blob_writer_date_time_format = blob_writer_date_time_format
        self.blob_writer_add_header = blob_writer_add_header
        self.copy_behavior = copy_behavior
        self.metadata = metadata


class BlobSource(CopySource):
    """A copy activity Azure Blob source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType
     boolean).
    :type treat_empty_as_null: any
    :param skip_header_line_count: Number of header lines to skip from each blob. Type: integer (or
     Expression with resultType integer).
    :type skip_header_line_count: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'treat_empty_as_null': {'key': 'treatEmptyAsNull', 'type': 'object'},
        'skip_header_line_count': {'key': 'skipHeaderLineCount', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        treat_empty_as_null: Optional[Any] = None,
        skip_header_line_count: Optional[Any] = None,
        recursive: Optional[Any] = None,
        **kwargs
    ):
        super(BlobSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'BlobSource'  # type: str
        self.treat_empty_as_null = treat_empty_as_null
        self.skip_header_line_count = skip_header_line_count
        self.recursive = recursive


class BlobTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time the selected Blob container changes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[any]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    :param folder_path: Required. The path of the container/folder that will trigger the pipeline.
    :type folder_path: str
    :param max_concurrency: Required. The max number of parallel files to handle when it is
     triggered.
    :type max_concurrency: int
    :param linked_service: Required. The Azure Storage linked service reference.
    :type linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'folder_path': {'required': True},
        'max_concurrency': {'required': True},
        'linked_service': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'str'},
        'max_concurrency': {'key': 'typeProperties.maxConcurrency', 'type': 'int'},
        'linked_service': {'key': 'typeProperties.linkedService', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        *,
        folder_path: str,
        max_concurrency: int,
        linked_service: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[Any]] = None,
        pipelines: Optional[List["TriggerPipelineReference"]] = None,
        **kwargs
    ):
        super(BlobTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, pipelines=pipelines, **kwargs)
        self.type = 'BlobTrigger'  # type: str
        self.folder_path = folder_path
        self.max_concurrency = max_concurrency
        self.linked_service = linked_service


class CassandraLinkedService(LinkedService):
    """Linked service for Cassandra data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param host: Required. Host name for connection. Type: string (or Expression with resultType
     string).
    :type host: any
    :param authentication_type: AuthenticationType to be used for connection. Type: string (or
     Expression with resultType string).
    :type authentication_type: any
    :param port: The port for the connection. Type: integer (or Expression with resultType
     integer).
    :type port: any
    :param username: Username for authentication. Type: string (or Expression with resultType
     string).
    :type username: any
    :param password: Password for authentication.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        authentication_type: Optional[Any] = None,
        port: Optional[Any] = None,
        username: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(CassandraLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Cassandra'  # type: str
        self.host = host
        self.authentication_type = authentication_type
        self.port = port
        self.username = username
        self.password = password
        self.encrypted_credential = encrypted_credential


class CassandraSource(TabularSource):
    """A copy activity source for a Cassandra database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: Database query. Should be a SQL-92 query expression or Cassandra Query Language
     (CQL) command. Type: string (or Expression with resultType string).
    :type query: any
    :param consistency_level: The consistency level specifies how many Cassandra servers must
     respond to a read request before returning data to the client application. Cassandra checks the
     specified number of Cassandra servers for data to satisfy the read request. Must be one of
     cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive.
     Possible values include: "ALL", "EACH_QUORUM", "QUORUM", "LOCAL_QUORUM", "ONE", "TWO", "THREE",
     "LOCAL_ONE", "SERIAL", "LOCAL_SERIAL".
    :type consistency_level: str or
     ~azure.mgmt.datafactory.models.CassandraSourceReadConsistencyLevels
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'consistency_level': {'key': 'consistencyLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        consistency_level: Optional[Union[str, "CassandraSourceReadConsistencyLevels"]] = None,
        **kwargs
    ):
        super(CassandraSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'CassandraSource'  # type: str
        self.query = query
        self.consistency_level = consistency_level


class CassandraTableDataset(Dataset):
    """The Cassandra database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name of the Cassandra database. Type: string (or Expression with
     resultType string).
    :type table_name: any
    :param keyspace: The keyspace of the Cassandra database. Type: string (or Expression with
     resultType string).
    :type keyspace: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'keyspace': {'key': 'typeProperties.keyspace', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        keyspace: Optional[Any] = None,
        **kwargs
    ):
        super(CassandraTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CassandraTable'  # type: str
        self.table_name = table_name
        self.keyspace = keyspace


class ChainingTrigger(Trigger):
    """Trigger that allows the referenced pipeline to depend on other pipeline runs based on runDimension Name/Value pairs. Upstream pipelines should declare the same runDimension Name and their runs should have the values for those runDimensions. The referenced pipeline run would be triggered if the values for the runDimension match for all upstream pipeline runs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[any]
    :param pipeline: Required. Pipeline for which runs are created when all upstream pipelines
     complete successfully.
    :type pipeline: ~azure.mgmt.datafactory.models.TriggerPipelineReference
    :param depends_on: Required. Upstream Pipelines.
    :type depends_on: list[~azure.mgmt.datafactory.models.PipelineReference]
    :param run_dimension: Required. Run Dimension property that needs to be emitted by upstream
     pipelines.
    :type run_dimension: str
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'pipeline': {'required': True},
        'depends_on': {'required': True},
        'run_dimension': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipeline': {'key': 'pipeline', 'type': 'TriggerPipelineReference'},
        'depends_on': {'key': 'typeProperties.dependsOn', 'type': '[PipelineReference]'},
        'run_dimension': {'key': 'typeProperties.runDimension', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        pipeline: "TriggerPipelineReference",
        depends_on: List["PipelineReference"],
        run_dimension: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[Any]] = None,
        **kwargs
    ):
        super(ChainingTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, **kwargs)
        self.type = 'ChainingTrigger'  # type: str
        self.pipeline = pipeline
        self.depends_on = depends_on
        self.run_dimension = run_dimension


class CloudError(msrest.serialization.Model):
    """The object that defines the structure of an Azure Data Factory error response.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. Error message.
    :type message: str
    :param target: Property name/path in request associated with error.
    :type target: str
    :param details: Array with additional error details.
    :type details: list[~azure.mgmt.datafactory.models.CloudError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
        'target': {'key': 'error.target', 'type': 'str'},
        'details': {'key': 'error.details', 'type': '[CloudError]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["CloudError"]] = None,
        **kwargs
    ):
        super(CloudError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CmdkeySetup(CustomSetupBase):
    """The custom setup of running cmdkey commands.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param target_name: Required. The server name of data source access.
    :type target_name: any
    :param user_name: Required. The user name of data source access.
    :type user_name: any
    :param password: Required. The password of data source access.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'target_name': {'required': True},
        'user_name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'target_name': {'key': 'typeProperties.targetName', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
    }

    def __init__(
        self,
        *,
        target_name: Any,
        user_name: Any,
        password: "SecretBase",
        **kwargs
    ):
        super(CmdkeySetup, self).__init__(**kwargs)
        self.type = 'CmdkeySetup'  # type: str
        self.target_name = target_name
        self.user_name = user_name
        self.password = password


class CMKIdentityDefinition(msrest.serialization.Model):
    """Managed Identity used for CMK.

    :param user_assigned_identity: The resource id of the user assigned identity to authenticate to
     customer's key vault.
    :type user_assigned_identity: str
    """

    _attribute_map = {
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_assigned_identity: Optional[str] = None,
        **kwargs
    ):
        super(CMKIdentityDefinition, self).__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity


class CommonDataServiceForAppsEntityDataset(Dataset):
    """The Common Data Service for Apps entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        entity_name: Optional[Any] = None,
        **kwargs
    ):
        super(CommonDataServiceForAppsEntityDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CommonDataServiceForAppsEntity'  # type: str
        self.entity_name = entity_name


class CommonDataServiceForAppsLinkedService(LinkedService):
    """Common Data Service for Apps linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param deployment_type: Required. The deployment type of the Common Data Service for Apps
     instance. 'Online' for Common Data Service for Apps Online and 'OnPremisesWithIfd' for Common
     Data Service for Apps on-premises with Ifd. Type: string (or Expression with resultType
     string).
    :type deployment_type: any
    :param host_name: The host name of the on-premises Common Data Service for Apps server. The
     property is required for on-prem and not allowed for online. Type: string (or Expression with
     resultType string).
    :type host_name: any
    :param port: The port of on-premises Common Data Service for Apps server. The property is
     required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression
     with resultType integer), minimum: 0.
    :type port: any
    :param service_uri: The URL to the Microsoft Common Data Service for Apps server. The property
     is required for on-line and not allowed for on-prem. Type: string (or Expression with
     resultType string).
    :type service_uri: any
    :param organization_name: The organization name of the Common Data Service for Apps instance.
     The property is required for on-prem and required for online when there are more than one
     Common Data Service for Apps instances associated with the user. Type: string (or Expression
     with resultType string).
    :type organization_name: any
    :param authentication_type: Required. The authentication type to connect to Common Data Service
     for Apps server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario.
     'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or
     Expression with resultType string).
    :type authentication_type: any
    :param username: User name to access the Common Data Service for Apps instance. Type: string
     (or Expression with resultType string).
    :type username: any
    :param password: Password to access the Common Data Service for Apps instance.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string).
    :type service_principal_credential_type: any
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'object'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'object'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'object'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        deployment_type: Any,
        authentication_type: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        host_name: Optional[Any] = None,
        port: Optional[Any] = None,
        service_uri: Optional[Any] = None,
        organization_name: Optional[Any] = None,
        username: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_credential_type: Optional[Any] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(CommonDataServiceForAppsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'CommonDataServiceForApps'  # type: str
        self.deployment_type = deployment_type
        self.host_name = host_name
        self.port = port
        self.service_uri = service_uri
        self.organization_name = organization_name
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.encrypted_credential = encrypted_credential


class CommonDataServiceForAppsSink(CopySink):
    """A copy activity Common Data Service for Apps sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param write_behavior: Required. The write behavior for the operation. Possible values include:
     "Upsert".
    :type write_behavior: str or ~azure.mgmt.datafactory.models.DynamicsSinkWriteBehavior
    :param ignore_null_values: The flag indicating whether to ignore null values from input dataset
     (except key fields) during write operation. Default is false. Type: boolean (or Expression with
     resultType boolean).
    :type ignore_null_values: any
    :param alternate_key_name: The logical name of the alternate key which will be used when
     upserting records. Type: string (or Expression with resultType string).
    :type alternate_key_name: any
    """

    _validation = {
        'type': {'required': True},
        'write_behavior': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
        'ignore_null_values': {'key': 'ignoreNullValues', 'type': 'object'},
        'alternate_key_name': {'key': 'alternateKeyName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        write_behavior: Union[str, "DynamicsSinkWriteBehavior"],
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        ignore_null_values: Optional[Any] = None,
        alternate_key_name: Optional[Any] = None,
        **kwargs
    ):
        super(CommonDataServiceForAppsSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'CommonDataServiceForAppsSink'  # type: str
        self.write_behavior = write_behavior
        self.ignore_null_values = ignore_null_values
        self.alternate_key_name = alternate_key_name


class CommonDataServiceForAppsSource(CopySource):
    """A copy activity Common Data Service for Apps source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query: FetchXML is a proprietary query language that is used in Microsoft Common Data
     Service for Apps (online & on-premises). Type: string (or Expression with resultType string).
    :type query: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(CommonDataServiceForAppsSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'CommonDataServiceForAppsSource'  # type: str
        self.query = query
        self.additional_columns = additional_columns


class ComponentSetup(CustomSetupBase):
    """The custom setup of installing 3rd party components.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param component_name: Required. The name of the 3rd party component.
    :type component_name: str
    :param license_key: The license key to activate the component.
    :type license_key: ~azure.mgmt.datafactory.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'component_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'component_name': {'key': 'typeProperties.componentName', 'type': 'str'},
        'license_key': {'key': 'typeProperties.licenseKey', 'type': 'SecretBase'},
    }

    def __init__(
        self,
        *,
        component_name: str,
        license_key: Optional["SecretBase"] = None,
        **kwargs
    ):
        super(ComponentSetup, self).__init__(**kwargs)
        self.type = 'ComponentSetup'  # type: str
        self.component_name = component_name
        self.license_key = license_key


class CompressionReadSettings(msrest.serialization.Model):
    """Compression read settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: TarGZipReadSettings, TarReadSettings, ZipDeflateReadSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The Compression setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'TarGZipReadSettings': 'TarGZipReadSettings', 'TarReadSettings': 'TarReadSettings', 'ZipDeflateReadSettings': 'ZipDeflateReadSettings'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(CompressionReadSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'CompressionReadSettings'  # type: str


class ConcurLinkedService(LinkedService):
    """Concur Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_properties: Properties used to connect to Concur. It is mutually exclusive
     with any other properties in the linked service. Type: object.
    :type connection_properties: any
    :param client_id: Required. Application client_id supplied by Concur App Management.
    :type client_id: any
    :param username: Required. The user name that you use to access Concur Service.
    :type username: any
    :param password: The password corresponding to the user name that you provided in the username
     field.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: any
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: any
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'client_id': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_properties': {'key': 'typeProperties.connectionProperties', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        client_id: Any,
        username: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_properties: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[Any] = None,
        use_host_verification: Optional[Any] = None,
        use_peer_verification: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(ConcurLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Concur'  # type: str
        self.connection_properties = connection_properties
        self.client_id = client_id
        self.username = username
        self.password = password
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class ConcurObjectDataset(Dataset):
    """Concur Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        **kwargs
    ):
        super(ConcurObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'ConcurObject'  # type: str
        self.table_name = table_name


class ConcurSource(TabularSource):
    """A copy activity Concur Service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(ConcurSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'ConcurSource'  # type: str
        self.query = query


class ConnectionStateProperties(msrest.serialization.Model):
    """The connection state of a managed private endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar actions_required: The actions required on the managed private endpoint.
    :vartype actions_required: str
    :ivar description: The managed private endpoint description.
    :vartype description: str
    :ivar status: The approval status.
    :vartype status: str
    """

    _validation = {
        'actions_required': {'readonly': True},
        'description': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionStateProperties, self).__init__(**kwargs)
        self.actions_required = None
        self.description = None
        self.status = None


class CopyActivity(ExecutionActivity):
    """Copy activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param inputs: List of inputs for the activity.
    :type inputs: list[~azure.mgmt.datafactory.models.DatasetReference]
    :param outputs: List of outputs for the activity.
    :type outputs: list[~azure.mgmt.datafactory.models.DatasetReference]
    :param source: Required. Copy activity source.
    :type source: ~azure.mgmt.datafactory.models.CopySource
    :param sink: Required. Copy activity sink.
    :type sink: ~azure.mgmt.datafactory.models.CopySink
    :param translator: Copy activity translator. If not specified, tabular translator is used.
    :type translator: any
    :param enable_staging: Specifies whether to copy data via an interim staging. Default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type enable_staging: any
    :param staging_settings: Specifies interim staging settings when EnableStaging is true.
    :type staging_settings: ~azure.mgmt.datafactory.models.StagingSettings
    :param parallel_copies: Maximum number of concurrent sessions opened on the source or sink to
     avoid overloading the data store. Type: integer (or Expression with resultType integer),
     minimum: 0.
    :type parallel_copies: any
    :param data_integration_units: Maximum number of data integration units that can be used to
     perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
    :type data_integration_units: any
    :param enable_skip_incompatible_row: Whether to skip incompatible row. Default value is false.
     Type: boolean (or Expression with resultType boolean).
    :type enable_skip_incompatible_row: any
    :param redirect_incompatible_row_settings: Redirect incompatible row settings when
     EnableSkipIncompatibleRow is true.
    :type redirect_incompatible_row_settings:
     ~azure.mgmt.datafactory.models.RedirectIncompatibleRowSettings
    :param log_storage_settings: (Deprecated. Please use LogSettings) Log storage settings customer
     need to provide when enabling session log.
    :type log_storage_settings: ~azure.mgmt.datafactory.models.LogStorageSettings
    :param log_settings: Log settings customer needs provide when enabling log.
    :type log_settings: ~azure.mgmt.datafactory.models.LogSettings
    :param preserve_rules: Preserve Rules.
    :type preserve_rules: list[any]
    :param preserve: Preserve rules.
    :type preserve: list[any]
    :param validate_data_consistency: Whether to enable Data Consistency validation. Type: boolean
     (or Expression with resultType boolean).
    :type validate_data_consistency: any
    :param skip_error_file: Specify the fault tolerance for data consistency.
    :type skip_error_file: ~azure.mgmt.datafactory.models.SkipErrorFile
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'source': {'required': True},
        'sink': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'inputs': {'key': 'inputs', 'type': '[DatasetReference]'},
        'outputs': {'key': 'outputs', 'type': '[DatasetReference]'},
        'source': {'key': 'typeProperties.source', 'type': 'CopySource'},
        'sink': {'key': 'typeProperties.sink', 'type': 'CopySink'},
        'translator': {'key': 'typeProperties.translator', 'type': 'object'},
        'enable_staging': {'key': 'typeProperties.enableStaging', 'type': 'object'},
        'staging_settings': {'key': 'typeProperties.stagingSettings', 'type': 'StagingSettings'},
        'parallel_copies': {'key': 'typeProperties.parallelCopies', 'type': 'object'},
        'data_integration_units': {'key': 'typeProperties.dataIntegrationUnits', 'type': 'object'},
        'enable_skip_incompatible_row': {'key': 'typeProperties.enableSkipIncompatibleRow', 'type': 'object'},
        'redirect_incompatible_row_settings': {'key': 'typeProperties.redirectIncompatibleRowSettings', 'type': 'RedirectIncompatibleRowSettings'},
        'log_storage_settings': {'key': 'typeProperties.logStorageSettings', 'type': 'LogStorageSettings'},
        'log_settings': {'key': 'typeProperties.logSettings', 'type': 'LogSettings'},
        'preserve_rules': {'key': 'typeProperties.preserveRules', 'type': '[object]'},
        'preserve': {'key': 'typeProperties.preserve', 'type': '[object]'},
        'validate_data_consistency': {'key': 'typeProperties.validateDataConsistency', 'type': 'object'},
        'skip_error_file': {'key': 'typeProperties.skipErrorFile', 'type': 'SkipErrorFile'},
    }

    def __init__(
        self,
        *,
        name: str,
        source: "CopySource",
        sink: "CopySink",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        inputs: Optional[List["DatasetReference"]] = None,
        outputs: Optional[List["DatasetReference"]] = None,
        translator: Optional[Any] = None,
        enable_staging: Optional[Any] = None,
        staging_settings: Optional["StagingSettings"] = None,
        parallel_copies: Optional[Any] = None,
        data_integration_units: Optional[Any] = None,
        enable_skip_incompatible_row: Optional[Any] = None,
        redirect_incompatible_row_settings: Optional["RedirectIncompatibleRowSettings"] = None,
        log_storage_settings: Optional["LogStorageSettings"] = None,
        log_settings: Optional["LogSettings"] = None,
        preserve_rules: Optional[List[Any]] = None,
        preserve: Optional[List[Any]] = None,
        validate_data_consistency: Optional[Any] = None,
        skip_error_file: Optional["SkipErrorFile"] = None,
        **kwargs
    ):
        super(CopyActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'Copy'  # type: str
        self.inputs = inputs
        self.outputs = outputs
        self.source = source
        self.sink = sink
        self.translator = translator
        self.enable_staging = enable_staging
        self.staging_settings = staging_settings
        self.parallel_copies = parallel_copies
        self.data_integration_units = data_integration_units
        self.enable_skip_incompatible_row = enable_skip_incompatible_row
        self.redirect_incompatible_row_settings = redirect_incompatible_row_settings
        self.log_storage_settings = log_storage_settings
        self.log_settings = log_settings
        self.preserve_rules = preserve_rules
        self.preserve = preserve
        self.validate_data_consistency = validate_data_consistency
        self.skip_error_file = skip_error_file


class CopyActivityLogSettings(msrest.serialization.Model):
    """Settings for copy activity log.

    :param log_level: Gets or sets the log level, support: Info, Warning. Type: string (or
     Expression with resultType string).
    :type log_level: any
    :param enable_reliable_logging: Specifies whether to enable reliable logging. Type: boolean (or
     Expression with resultType boolean).
    :type enable_reliable_logging: any
    """

    _attribute_map = {
        'log_level': {'key': 'logLevel', 'type': 'object'},
        'enable_reliable_logging': {'key': 'enableReliableLogging', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        log_level: Optional[Any] = None,
        enable_reliable_logging: Optional[Any] = None,
        **kwargs
    ):
        super(CopyActivityLogSettings, self).__init__(**kwargs)
        self.log_level = log_level
        self.enable_reliable_logging = enable_reliable_logging


class CopyTranslator(msrest.serialization.Model):
    """A copy activity translator.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: TabularTranslator.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy translator type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'TabularTranslator': 'TabularTranslator'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(CopyTranslator, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'CopyTranslator'  # type: str


class CosmosDbLinkedService(LinkedService):
    """Microsoft Azure Cosmos Database (CosmosDB) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param account_endpoint: The endpoint of the Azure CosmosDB account. Type: string (or
     Expression with resultType string).
    :type account_endpoint: any
    :param database: The name of the database. Type: string (or Expression with resultType string).
    :type database: any
    :param account_key: The account key of the Azure CosmosDB account. Type: SecureString or
     AzureKeyVaultSecretReference.
    :type account_key: ~azure.mgmt.datafactory.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.mgmt.datafactory.models.CosmosDbServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: any
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: any
    :param connection_mode: The connection mode used to access CosmosDB account. Type: string (or
     Expression with resultType string). Possible values include: "Gateway", "Direct".
    :type connection_mode: str or ~azure.mgmt.datafactory.models.CosmosDbConnectionMode
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_endpoint': {'key': 'typeProperties.accountEndpoint', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'connection_mode': {'key': 'typeProperties.connectionMode', 'type': 'str'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_string: Optional[Any] = None,
        account_endpoint: Optional[Any] = None,
        database: Optional[Any] = None,
        account_key: Optional["SecretBase"] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_credential_type: Optional[Union[str, "CosmosDbServicePrincipalCredentialType"]] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        tenant: Optional[Any] = None,
        azure_cloud_type: Optional[Any] = None,
        connection_mode: Optional[Union[str, "CosmosDbConnectionMode"]] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(CosmosDbLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'CosmosDb'  # type: str
        self.connection_string = connection_string
        self.account_endpoint = account_endpoint
        self.database = database
        self.account_key = account_key
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.connection_mode = connection_mode
        self.encrypted_credential = encrypted_credential


class CosmosDbMongoDbApiCollectionDataset(Dataset):
    """The CosmosDB (MongoDB API) database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param collection: Required. The collection name of the CosmosDB (MongoDB API) database. Type:
     string (or Expression with resultType string).
    :type collection: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection': {'key': 'typeProperties.collection', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(CosmosDbMongoDbApiCollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CosmosDbMongoDbApiCollection'  # type: str
        self.collection = collection


class CosmosDbMongoDbApiLinkedService(LinkedService):
    """Linked service for CosmosDB (MongoDB API) data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param is_server_version_above32: Whether the CosmosDB (MongoDB API) server version is higher
     than 3.2. The default value is false. Type: boolean (or Expression with resultType boolean).
    :type is_server_version_above32: any
    :param connection_string: Required. The CosmosDB (MongoDB API) connection string. Type: string,
     SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param database: Required. The name of the CosmosDB (MongoDB API) database that you want to
     access. Type: string (or Expression with resultType string).
    :type database: any
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'is_server_version_above32': {'key': 'typeProperties.isServerVersionAbove32', 'type': 'object'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: Any,
        database: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        is_server_version_above32: Optional[Any] = None,
        **kwargs
    ):
        super(CosmosDbMongoDbApiLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'CosmosDbMongoDbApi'  # type: str
        self.is_server_version_above32 = is_server_version_above32
        self.connection_string = connection_string
        self.database = database


class CosmosDbMongoDbApiSink(CopySink):
    """A copy activity sink for a CosmosDB (MongoDB API) database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param write_behavior: Specifies whether the document with same key to be overwritten (upsert)
     rather than throw exception (insert). The default value is "insert". Type: string (or
     Expression with resultType string). Type: string (or Expression with resultType string).
    :type write_behavior: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        write_behavior: Optional[Any] = None,
        **kwargs
    ):
        super(CosmosDbMongoDbApiSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'CosmosDbMongoDbApiSink'  # type: str
        self.write_behavior = write_behavior


class CosmosDbMongoDbApiSource(CopySource):
    """A copy activity source for a CosmosDB (MongoDB API) database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param filter: Specifies selection filter using query operators. To return all documents in a
     collection, omit this parameter or pass an empty document ({}). Type: string (or Expression
     with resultType string).
    :type filter: any
    :param cursor_methods: Cursor methods for Mongodb query.
    :type cursor_methods: ~azure.mgmt.datafactory.models.MongoDbCursorMethodsProperties
    :param batch_size: Specifies the number of documents to return in each batch of the response
     from MongoDB instance. In most cases, modifying the batch size will not affect the user or the
     application. This property's main purpose is to avoid hit the limitation of response size.
     Type: integer (or Expression with resultType integer).
    :type batch_size: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'filter': {'key': 'filter', 'type': 'object'},
        'cursor_methods': {'key': 'cursorMethods', 'type': 'MongoDbCursorMethodsProperties'},
        'batch_size': {'key': 'batchSize', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        filter: Optional[Any] = None,
        cursor_methods: Optional["MongoDbCursorMethodsProperties"] = None,
        batch_size: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(CosmosDbMongoDbApiSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'CosmosDbMongoDbApiSource'  # type: str
        self.filter = filter
        self.cursor_methods = cursor_methods
        self.batch_size = batch_size
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class CosmosDbSqlApiCollectionDataset(Dataset):
    """Microsoft Azure CosmosDB (SQL API) Collection dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param collection_name: Required. CosmosDB (SQL API) collection name. Type: string (or
     Expression with resultType string).
    :type collection_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection_name': {'key': 'typeProperties.collectionName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection_name: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(CosmosDbSqlApiCollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CosmosDbSqlApiCollection'  # type: str
        self.collection_name = collection_name


class CosmosDbSqlApiSink(CopySink):
    """A copy activity Azure CosmosDB (SQL API) Collection sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param write_behavior: Describes how to write data to Azure Cosmos DB. Type: string (or
     Expression with resultType string). Allowed values: insert and upsert.
    :type write_behavior: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        write_behavior: Optional[Any] = None,
        **kwargs
    ):
        super(CosmosDbSqlApiSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'CosmosDbSqlApiSink'  # type: str
        self.write_behavior = write_behavior


class CosmosDbSqlApiSource(CopySource):
    """A copy activity Azure CosmosDB (SQL API) Collection source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query: SQL API query. Type: string (or Expression with resultType string).
    :type query: any
    :param page_size: Page size of the result. Type: integer (or Expression with resultType
     integer).
    :type page_size: any
    :param preferred_regions: Preferred regions. Type: array of strings (or Expression with
     resultType array of strings).
    :type preferred_regions: any
    :param detect_datetime: Whether detect primitive values as datetime values. Type: boolean (or
     Expression with resultType boolean).
    :type detect_datetime: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'page_size': {'key': 'pageSize', 'type': 'object'},
        'preferred_regions': {'key': 'preferredRegions', 'type': 'object'},
        'detect_datetime': {'key': 'detectDatetime', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query: Optional[Any] = None,
        page_size: Optional[Any] = None,
        preferred_regions: Optional[Any] = None,
        detect_datetime: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(CosmosDbSqlApiSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'CosmosDbSqlApiSource'  # type: str
        self.query = query
        self.page_size = page_size
        self.preferred_regions = preferred_regions
        self.detect_datetime = detect_datetime
        self.additional_columns = additional_columns


class CouchbaseLinkedService(LinkedService):
    """Couchbase server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param cred_string: The Azure key vault secret reference of credString in connection string.
    :type cred_string: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'cred_string': {'key': 'typeProperties.credString', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_string: Optional[Any] = None,
        cred_string: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(CouchbaseLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Couchbase'  # type: str
        self.connection_string = connection_string
        self.cred_string = cred_string
        self.encrypted_credential = encrypted_credential


class CouchbaseSource(TabularSource):
    """A copy activity Couchbase server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(CouchbaseSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'CouchbaseSource'  # type: str
        self.query = query


class CouchbaseTableDataset(Dataset):
    """Couchbase server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        **kwargs
    ):
        super(CouchbaseTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CouchbaseTable'  # type: str
        self.table_name = table_name


class CreateDataFlowDebugSessionRequest(msrest.serialization.Model):
    """Request body structure for creating data flow debug session.

    :param compute_type: Compute type of the cluster. The value will be overwritten by the same
     setting in integration runtime if provided.
    :type compute_type: str
    :param core_count: Core count of the cluster. The value will be overwritten by the same setting
     in integration runtime if provided.
    :type core_count: int
    :param time_to_live: Time to live setting of the cluster in minutes.
    :type time_to_live: int
    :param integration_runtime: Set to use integration runtime setting for data flow debug session.
    :type integration_runtime: ~azure.mgmt.datafactory.models.IntegrationRuntimeDebugResource
    """

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
        'time_to_live': {'key': 'timeToLive', 'type': 'int'},
        'integration_runtime': {'key': 'integrationRuntime', 'type': 'IntegrationRuntimeDebugResource'},
    }

    def __init__(
        self,
        *,
        compute_type: Optional[str] = None,
        core_count: Optional[int] = None,
        time_to_live: Optional[int] = None,
        integration_runtime: Optional["IntegrationRuntimeDebugResource"] = None,
        **kwargs
    ):
        super(CreateDataFlowDebugSessionRequest, self).__init__(**kwargs)
        self.compute_type = compute_type
        self.core_count = core_count
        self.time_to_live = time_to_live
        self.integration_runtime = integration_runtime


class CreateDataFlowDebugSessionResponse(msrest.serialization.Model):
    """Response body structure for creating data flow debug session.

    :param status: The state of the debug session.
    :type status: str
    :param session_id: The ID of data flow debug session.
    :type session_id: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        session_id: Optional[str] = None,
        **kwargs
    ):
        super(CreateDataFlowDebugSessionResponse, self).__init__(**kwargs)
        self.status = status
        self.session_id = session_id


class CreateLinkedIntegrationRuntimeRequest(msrest.serialization.Model):
    """The linked integration runtime information.

    :param name: The name of the linked integration runtime.
    :type name: str
    :param subscription_id: The ID of the subscription that the linked integration runtime belongs
     to.
    :type subscription_id: str
    :param data_factory_name: The name of the data factory that the linked integration runtime
     belongs to.
    :type data_factory_name: str
    :param data_factory_location: The location of the data factory that the linked integration
     runtime belongs to.
    :type data_factory_location: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'data_factory_location': {'key': 'dataFactoryLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        subscription_id: Optional[str] = None,
        data_factory_name: Optional[str] = None,
        data_factory_location: Optional[str] = None,
        **kwargs
    ):
        super(CreateLinkedIntegrationRuntimeRequest, self).__init__(**kwargs)
        self.name = name
        self.subscription_id = subscription_id
        self.data_factory_name = data_factory_name
        self.data_factory_location = data_factory_location


class CreateRunResponse(msrest.serialization.Model):
    """Response body with a run identifier.

    All required parameters must be populated in order to send to Azure.

    :param run_id: Required. Identifier of a run.
    :type run_id: str
    """

    _validation = {
        'run_id': {'required': True},
    }

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_id: str,
        **kwargs
    ):
        super(CreateRunResponse, self).__init__(**kwargs)
        self.run_id = run_id


class Credential(msrest.serialization.Model):
    """The Azure Data Factory nested object which contains the information and credential which can be used to connect with related store or compute resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ManagedIdentityCredential, ServicePrincipalCredential.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of credential.Constant filled by server.
    :type type: str
    :param description: Credential description.
    :type description: str
    :param annotations: List of tags that can be used for describing the Credential.
    :type annotations: list[any]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
    }

    _subtype_map = {
        'type': {'ManagedIdentity': 'ManagedIdentityCredential', 'ServicePrincipal': 'ServicePrincipalCredential'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[Any]] = None,
        **kwargs
    ):
        super(Credential, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'Credential'  # type: str
        self.description = description
        self.annotations = annotations


class CredentialReference(msrest.serialization.Model):
    """Credential reference type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :ivar type: Credential reference type. Has constant value: "CredentialReference".
    :vartype type: str
    :param reference_name: Required. Reference credential name.
    :type reference_name: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
    }

    type = "CredentialReference"

    def __init__(
        self,
        *,
        reference_name: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(CredentialReference, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.reference_name = reference_name


class SubResource(msrest.serialization.Model):
    """Azure Data Factory nested resource, which belongs to a factory.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class CredentialResource(SubResource):
    """Credential resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Properties of credentials.
    :type properties: ~azure.mgmt.datafactory.models.Credential
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Credential'},
    }

    def __init__(
        self,
        *,
        properties: "Credential",
        **kwargs
    ):
        super(CredentialResource, self).__init__(**kwargs)
        self.properties = properties


class CustomActivity(ExecutionActivity):
    """Custom activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param command: Required. Command for custom activity Type: string (or Expression with
     resultType string).
    :type command: any
    :param resource_linked_service: Resource linked service reference.
    :type resource_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param folder_path: Folder path for resource files Type: string (or Expression with resultType
     string).
    :type folder_path: any
    :param reference_objects: Reference objects.
    :type reference_objects: ~azure.mgmt.datafactory.models.CustomActivityReferenceObject
    :param extended_properties: User defined property bag. There is no restriction on the keys or
     values that can be used. The user specified custom activity has the full responsibility to
     consume and interpret the content defined.
    :type extended_properties: dict[str, any]
    :param retention_time_in_days: The retention time for the files submitted for custom activity.
     Type: double (or Expression with resultType double).
    :type retention_time_in_days: any
    :param auto_user_specification: Elevation level and scope for the user, default is nonadmin
     task. Type: string (or Expression with resultType double).
    :type auto_user_specification: any
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'command': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'command': {'key': 'typeProperties.command', 'type': 'object'},
        'resource_linked_service': {'key': 'typeProperties.resourceLinkedService', 'type': 'LinkedServiceReference'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'reference_objects': {'key': 'typeProperties.referenceObjects', 'type': 'CustomActivityReferenceObject'},
        'extended_properties': {'key': 'typeProperties.extendedProperties', 'type': '{object}'},
        'retention_time_in_days': {'key': 'typeProperties.retentionTimeInDays', 'type': 'object'},
        'auto_user_specification': {'key': 'typeProperties.autoUserSpecification', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        command: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        resource_linked_service: Optional["LinkedServiceReference"] = None,
        folder_path: Optional[Any] = None,
        reference_objects: Optional["CustomActivityReferenceObject"] = None,
        extended_properties: Optional[Dict[str, Any]] = None,
        retention_time_in_days: Optional[Any] = None,
        auto_user_specification: Optional[Any] = None,
        **kwargs
    ):
        super(CustomActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'Custom'  # type: str
        self.command = command
        self.resource_linked_service = resource_linked_service
        self.folder_path = folder_path
        self.reference_objects = reference_objects
        self.extended_properties = extended_properties
        self.retention_time_in_days = retention_time_in_days
        self.auto_user_specification = auto_user_specification


class CustomActivityReferenceObject(msrest.serialization.Model):
    """Reference objects for custom activity.

    :param linked_services: Linked service references.
    :type linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceReference]
    :param datasets: Dataset references.
    :type datasets: list[~azure.mgmt.datafactory.models.DatasetReference]
    """

    _attribute_map = {
        'linked_services': {'key': 'linkedServices', 'type': '[LinkedServiceReference]'},
        'datasets': {'key': 'datasets', 'type': '[DatasetReference]'},
    }

    def __init__(
        self,
        *,
        linked_services: Optional[List["LinkedServiceReference"]] = None,
        datasets: Optional[List["DatasetReference"]] = None,
        **kwargs
    ):
        super(CustomActivityReferenceObject, self).__init__(**kwargs)
        self.linked_services = linked_services
        self.datasets = datasets


class CustomDataset(Dataset):
    """The custom dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param type_properties: Custom dataset properties.
    :type type_properties: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'type_properties': {'key': 'typeProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        type_properties: Optional[Any] = None,
        **kwargs
    ):
        super(CustomDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CustomDataset'  # type: str
        self.type_properties = type_properties


class CustomDataSourceLinkedService(LinkedService):
    """Custom linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param type_properties: Required. Custom linked service properties.
    :type type_properties: any
    """

    _validation = {
        'type': {'required': True},
        'type_properties': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'type_properties': {'key': 'typeProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        type_properties: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        **kwargs
    ):
        super(CustomDataSourceLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'CustomDataSource'  # type: str
        self.type_properties = type_properties


class CustomEventsTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time a custom event is received.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[any]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    :param subject_begins_with: The event subject must begin with the pattern provided for trigger
     to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
    :type subject_begins_with: str
    :param subject_ends_with: The event subject must end with the pattern provided for trigger to
     fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
    :type subject_ends_with: str
    :param events: Required. The list of event types that cause this trigger to fire.
    :type events: list[any]
    :param scope: Required. The ARM resource ID of the Azure Event Grid Topic.
    :type scope: str
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'events': {'required': True},
        'scope': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
        'subject_begins_with': {'key': 'typeProperties.subjectBeginsWith', 'type': 'str'},
        'subject_ends_with': {'key': 'typeProperties.subjectEndsWith', 'type': 'str'},
        'events': {'key': 'typeProperties.events', 'type': '[object]'},
        'scope': {'key': 'typeProperties.scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        events: List[Any],
        scope: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[Any]] = None,
        pipelines: Optional[List["TriggerPipelineReference"]] = None,
        subject_begins_with: Optional[str] = None,
        subject_ends_with: Optional[str] = None,
        **kwargs
    ):
        super(CustomEventsTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, pipelines=pipelines, **kwargs)
        self.type = 'CustomEventsTrigger'  # type: str
        self.subject_begins_with = subject_begins_with
        self.subject_ends_with = subject_ends_with
        self.events = events
        self.scope = scope


class DatabricksNotebookActivity(ExecutionActivity):
    """DatabricksNotebook activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param notebook_path: Required. The absolute path of the notebook to be run in the Databricks
     Workspace. This path must begin with a slash. Type: string (or Expression with resultType
     string).
    :type notebook_path: any
    :param base_parameters: Base parameters to be used for each run of this job.If the notebook
     takes a parameter that is not specified, the default value from the notebook will be used.
    :type base_parameters: dict[str, any]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, any]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'notebook_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'notebook_path': {'key': 'typeProperties.notebookPath', 'type': 'object'},
        'base_parameters': {'key': 'typeProperties.baseParameters', 'type': '{object}'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        *,
        name: str,
        notebook_path: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        base_parameters: Optional[Dict[str, Any]] = None,
        libraries: Optional[List[Dict[str, Any]]] = None,
        **kwargs
    ):
        super(DatabricksNotebookActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'DatabricksNotebook'  # type: str
        self.notebook_path = notebook_path
        self.base_parameters = base_parameters
        self.libraries = libraries


class DatabricksSparkJarActivity(ExecutionActivity):
    """DatabricksSparkJar activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param main_class_name: Required. The full name of the class containing the main method to be
     executed. This class must be contained in a JAR provided as a library. Type: string (or
     Expression with resultType string).
    :type main_class_name: any
    :param parameters: Parameters that will be passed to the main method.
    :type parameters: list[any]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, any]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'main_class_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'main_class_name': {'key': 'typeProperties.mainClassName', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '[object]'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        *,
        name: str,
        main_class_name: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        parameters: Optional[List[Any]] = None,
        libraries: Optional[List[Dict[str, Any]]] = None,
        **kwargs
    ):
        super(DatabricksSparkJarActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'DatabricksSparkJar'  # type: str
        self.main_class_name = main_class_name
        self.parameters = parameters
        self.libraries = libraries


class DatabricksSparkPythonActivity(ExecutionActivity):
    """DatabricksSparkPython activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param python_file: Required. The URI of the Python file to be executed. DBFS paths are
     supported. Type: string (or Expression with resultType string).
    :type python_file: any
    :param parameters: Command line parameters that will be passed to the Python file.
    :type parameters: list[any]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, any]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'python_file': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'python_file': {'key': 'typeProperties.pythonFile', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '[object]'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        *,
        name: str,
        python_file: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        parameters: Optional[List[Any]] = None,
        libraries: Optional[List[Dict[str, Any]]] = None,
        **kwargs
    ):
        super(DatabricksSparkPythonActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'DatabricksSparkPython'  # type: str
        self.python_file = python_file
        self.parameters = parameters
        self.libraries = libraries


class DataFlow(msrest.serialization.Model):
    """Azure Data Factory nested object which contains a flow with data movements and transformations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MappingDataFlow, WranglingDataFlow.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of data flow.Constant filled by server.
    :type type: str
    :param description: The description of the data flow.
    :type description: str
    :param annotations: List of tags that can be used for describing the data flow.
    :type annotations: list[any]
    :param folder: The folder that this data flow is in. If not specified, Data flow will appear at
     the root level.
    :type folder: ~azure.mgmt.datafactory.models.DataFlowFolder
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DataFlowFolder'},
    }

    _subtype_map = {
        'type': {'MappingDataFlow': 'MappingDataFlow', 'WranglingDataFlow': 'WranglingDataFlow'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DataFlowFolder"] = None,
        **kwargs
    ):
        super(DataFlow, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.description = description
        self.annotations = annotations
        self.folder = folder


class DataFlowDebugCommandPayload(msrest.serialization.Model):
    """Structure of command payload.

    All required parameters must be populated in order to send to Azure.

    :param stream_name: Required. The stream name which is used for preview.
    :type stream_name: str
    :param row_limits: Row limits for preview response.
    :type row_limits: int
    :param columns: Array of column names.
    :type columns: list[str]
    :param expression: The expression which is used for preview.
    :type expression: str
    """

    _validation = {
        'stream_name': {'required': True},
    }

    _attribute_map = {
        'stream_name': {'key': 'streamName', 'type': 'str'},
        'row_limits': {'key': 'rowLimits', 'type': 'int'},
        'columns': {'key': 'columns', 'type': '[str]'},
        'expression': {'key': 'expression', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        stream_name: str,
        row_limits: Optional[int] = None,
        columns: Optional[List[str]] = None,
        expression: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugCommandPayload, self).__init__(**kwargs)
        self.stream_name = stream_name
        self.row_limits = row_limits
        self.columns = columns
        self.expression = expression


class DataFlowDebugCommandRequest(msrest.serialization.Model):
    """Request body structure for data flow debug command.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param command: The command type. Possible values include: "executePreviewQuery",
     "executeStatisticsQuery", "executeExpressionQuery".
    :type command: str or ~azure.mgmt.datafactory.models.DataFlowDebugCommandType
    :param command_payload: The command payload object.
    :type command_payload: ~azure.mgmt.datafactory.models.DataFlowDebugCommandPayload
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'command': {'key': 'command', 'type': 'str'},
        'command_payload': {'key': 'commandPayload', 'type': 'DataFlowDebugCommandPayload'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        command: Optional[Union[str, "DataFlowDebugCommandType"]] = None,
        command_payload: Optional["DataFlowDebugCommandPayload"] = None,
        **kwargs
    ):
        super(DataFlowDebugCommandRequest, self).__init__(**kwargs)
        self.session_id = session_id
        self.command = command
        self.command_payload = command_payload


class DataFlowDebugCommandResponse(msrest.serialization.Model):
    """Response body structure of data flow result for data preview, statistics or expression preview.

    :param status: The run status of data preview, statistics or expression preview.
    :type status: str
    :param data: The result data of data preview, statistics or expression preview.
    :type data: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'data': {'key': 'data', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        data: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugCommandResponse, self).__init__(**kwargs)
        self.status = status
        self.data = data


class DataFlowDebugPackage(msrest.serialization.Model):
    """Request body structure for starting data flow debug session.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow: Data flow instance.
    :type data_flow: ~azure.mgmt.datafactory.models.DataFlowDebugResource
    :param datasets: List of datasets.
    :type datasets: list[~azure.mgmt.datafactory.models.DatasetDebugResource]
    :param linked_services: List of linked services.
    :type linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceDebugResource]
    :param staging: Staging info for debug session.
    :type staging: ~azure.mgmt.datafactory.models.DataFlowStagingInfo
    :param debug_settings: Data flow debug settings.
    :type debug_settings: ~azure.mgmt.datafactory.models.DataFlowDebugPackageDebugSettings
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow': {'key': 'dataFlow', 'type': 'DataFlowDebugResource'},
        'datasets': {'key': 'datasets', 'type': '[DatasetDebugResource]'},
        'linked_services': {'key': 'linkedServices', 'type': '[LinkedServiceDebugResource]'},
        'staging': {'key': 'staging', 'type': 'DataFlowStagingInfo'},
        'debug_settings': {'key': 'debugSettings', 'type': 'DataFlowDebugPackageDebugSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        session_id: Optional[str] = None,
        data_flow: Optional["DataFlowDebugResource"] = None,
        datasets: Optional[List["DatasetDebugResource"]] = None,
        linked_services: Optional[List["LinkedServiceDebugResource"]] = None,
        staging: Optional["DataFlowStagingInfo"] = None,
        debug_settings: Optional["DataFlowDebugPackageDebugSettings"] = None,
        **kwargs
    ):
        super(DataFlowDebugPackage, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.session_id = session_id
        self.data_flow = data_flow
        self.datasets = datasets
        self.linked_services = linked_services
        self.staging = staging
        self.debug_settings = debug_settings


class DataFlowDebugPackageDebugSettings(msrest.serialization.Model):
    """Data flow debug settings.

    :param source_settings: Source setting for data flow debug.
    :type source_settings: list[~azure.mgmt.datafactory.models.DataFlowSourceSetting]
    :param parameters: Data flow parameters.
    :type parameters: dict[str, any]
    :param dataset_parameters: Parameters for dataset.
    :type dataset_parameters: any
    """

    _attribute_map = {
        'source_settings': {'key': 'sourceSettings', 'type': '[DataFlowSourceSetting]'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
        'dataset_parameters': {'key': 'datasetParameters', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        source_settings: Optional[List["DataFlowSourceSetting"]] = None,
        parameters: Optional[Dict[str, Any]] = None,
        dataset_parameters: Optional[Any] = None,
        **kwargs
    ):
        super(DataFlowDebugPackageDebugSettings, self).__init__(**kwargs)
        self.source_settings = source_settings
        self.parameters = parameters
        self.dataset_parameters = dataset_parameters


class SubResourceDebugResource(msrest.serialization.Model):
    """Azure Data Factory nested debug resource.

    :param name: The resource name.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(SubResourceDebugResource, self).__init__(**kwargs)
        self.name = name


class DataFlowDebugResource(SubResourceDebugResource):
    """Data flow debug resource.

    All required parameters must be populated in order to send to Azure.

    :param name: The resource name.
    :type name: str
    :param properties: Required. Data flow properties.
    :type properties: ~azure.mgmt.datafactory.models.DataFlow
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataFlow'},
    }

    def __init__(
        self,
        *,
        properties: "DataFlow",
        name: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugResource, self).__init__(name=name, **kwargs)
        self.properties = properties


class DataFlowDebugSessionInfo(msrest.serialization.Model):
    """Data flow debug session info.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param data_flow_name: The name of the data flow.
    :type data_flow_name: str
    :param compute_type: Compute type of the cluster.
    :type compute_type: str
    :param core_count: Core count of the cluster.
    :type core_count: int
    :param node_count: Node count of the cluster. (deprecated property).
    :type node_count: int
    :param integration_runtime_name: Attached integration runtime name of data flow debug session.
    :type integration_runtime_name: str
    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param start_time: Start time of data flow debug session.
    :type start_time: str
    :param time_to_live_in_minutes: Compute type of the cluster.
    :type time_to_live_in_minutes: int
    :param last_activity_time: Last activity time of data flow debug session.
    :type last_activity_time: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
        'node_count': {'key': 'nodeCount', 'type': 'int'},
        'integration_runtime_name': {'key': 'integrationRuntimeName', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_to_live_in_minutes': {'key': 'timeToLiveInMinutes', 'type': 'int'},
        'last_activity_time': {'key': 'lastActivityTime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        data_flow_name: Optional[str] = None,
        compute_type: Optional[str] = None,
        core_count: Optional[int] = None,
        node_count: Optional[int] = None,
        integration_runtime_name: Optional[str] = None,
        session_id: Optional[str] = None,
        start_time: Optional[str] = None,
        time_to_live_in_minutes: Optional[int] = None,
        last_activity_time: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugSessionInfo, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.data_flow_name = data_flow_name
        self.compute_type = compute_type
        self.core_count = core_count
        self.node_count = node_count
        self.integration_runtime_name = integration_runtime_name
        self.session_id = session_id
        self.start_time = start_time
        self.time_to_live_in_minutes = time_to_live_in_minutes
        self.last_activity_time = last_activity_time


class DataFlowFolder(msrest.serialization.Model):
    """The folder that this data flow is in. If not specified, Data flow will appear at the root level.

    :param name: The name of the folder that this data flow is in.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowFolder, self).__init__(**kwargs)
        self.name = name


class DataFlowListResponse(msrest.serialization.Model):
    """A list of data flow resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of data flows.
    :type value: list[~azure.mgmt.datafactory.models.DataFlowResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataFlowResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DataFlowResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataFlowReference(msrest.serialization.Model):
    """Data flow reference type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :ivar type: Data flow reference type. Has constant value: "DataFlowReference".
    :vartype type: str
    :param reference_name: Required. Reference data flow name.
    :type reference_name: str
    :param dataset_parameters: Reference data flow parameters from dataset.
    :type dataset_parameters: any
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'dataset_parameters': {'key': 'datasetParameters', 'type': 'object'},
    }

    type = "DataFlowReference"

    def __init__(
        self,
        *,
        reference_name: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        dataset_parameters: Optional[Any] = None,
        **kwargs
    ):
        super(DataFlowReference, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.reference_name = reference_name
        self.dataset_parameters = dataset_parameters


class DataFlowResource(SubResource):
    """Data flow resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Data flow properties.
    :type properties: ~azure.mgmt.datafactory.models.DataFlow
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataFlow'},
    }

    def __init__(
        self,
        *,
        properties: "DataFlow",
        **kwargs
    ):
        super(DataFlowResource, self).__init__(**kwargs)
        self.properties = properties


class Transformation(msrest.serialization.Model):
    """A data flow transformation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Transformation, self).__init__(**kwargs)
        self.name = name
        self.description = description


class DataFlowSink(Transformation):
    """Transformation for data flow sink.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    :param dataset: Dataset reference.
    :type dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :param linked_service: Linked service reference.
    :type linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param schema_linked_service: Schema linked service reference.
    :type schema_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'dataset': {'key': 'dataset', 'type': 'DatasetReference'},
        'linked_service': {'key': 'linkedService', 'type': 'LinkedServiceReference'},
        'schema_linked_service': {'key': 'schemaLinkedService', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        dataset: Optional["DatasetReference"] = None,
        linked_service: Optional["LinkedServiceReference"] = None,
        schema_linked_service: Optional["LinkedServiceReference"] = None,
        **kwargs
    ):
        super(DataFlowSink, self).__init__(name=name, description=description, **kwargs)
        self.dataset = dataset
        self.linked_service = linked_service
        self.schema_linked_service = schema_linked_service


class DataFlowSource(Transformation):
    """Transformation for data flow source.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    :param dataset: Dataset reference.
    :type dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :param linked_service: Linked service reference.
    :type linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param schema_linked_service: Schema linked service reference.
    :type schema_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'dataset': {'key': 'dataset', 'type': 'DatasetReference'},
        'linked_service': {'key': 'linkedService', 'type': 'LinkedServiceReference'},
        'schema_linked_service': {'key': 'schemaLinkedService', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        dataset: Optional["DatasetReference"] = None,
        linked_service: Optional["LinkedServiceReference"] = None,
        schema_linked_service: Optional["LinkedServiceReference"] = None,
        **kwargs
    ):
        super(DataFlowSource, self).__init__(name=name, description=description, **kwargs)
        self.dataset = dataset
        self.linked_service = linked_service
        self.schema_linked_service = schema_linked_service


class DataFlowSourceSetting(msrest.serialization.Model):
    """Definition of data flow source setting for debug.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param source_name: The data flow source name.
    :type source_name: str
    :param row_limit: Defines the row limit of data flow source in debug.
    :type row_limit: int
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'source_name': {'key': 'sourceName', 'type': 'str'},
        'row_limit': {'key': 'rowLimit', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_name: Optional[str] = None,
        row_limit: Optional[int] = None,
        **kwargs
    ):
        super(DataFlowSourceSetting, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.source_name = source_name
        self.row_limit = row_limit


class DataFlowStagingInfo(msrest.serialization.Model):
    """Staging info for execute data flow activity.

    :param linked_service: Staging linked service reference.
    :type linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param folder_path: Folder path for staging blob. Type: string (or Expression with resultType
     string).
    :type folder_path: any
    """

    _attribute_map = {
        'linked_service': {'key': 'linkedService', 'type': 'LinkedServiceReference'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service: Optional["LinkedServiceReference"] = None,
        folder_path: Optional[Any] = None,
        **kwargs
    ):
        super(DataFlowStagingInfo, self).__init__(**kwargs)
        self.linked_service = linked_service
        self.folder_path = folder_path


class DataLakeAnalyticsUSQLActivity(ExecutionActivity):
    """Data Lake Analytics U-SQL activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param script_path: Required. Case-sensitive path to folder that contains the U-SQL script.
     Type: string (or Expression with resultType string).
    :type script_path: any
    :param script_linked_service: Required. Script linked service reference.
    :type script_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param degree_of_parallelism: The maximum number of nodes simultaneously used to run the job.
     Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
    :type degree_of_parallelism: any
    :param priority: Determines which jobs out of all that are queued should be selected to run
     first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or
     Expression with resultType integer), minimum: 1.
    :type priority: any
    :param parameters: Parameters for U-SQL job request.
    :type parameters: dict[str, any]
    :param runtime_version: Runtime version of the U-SQL engine to use. Type: string (or Expression
     with resultType string).
    :type runtime_version: any
    :param compilation_mode: Compilation mode of U-SQL. Must be one of these values : Semantic,
     Full and SingleBox. Type: string (or Expression with resultType string).
    :type compilation_mode: any
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'script_path': {'required': True},
        'script_linked_service': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'degree_of_parallelism': {'key': 'typeProperties.degreeOfParallelism', 'type': 'object'},
        'priority': {'key': 'typeProperties.priority', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '{object}'},
        'runtime_version': {'key': 'typeProperties.runtimeVersion', 'type': 'object'},
        'compilation_mode': {'key': 'typeProperties.compilationMode', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        script_path: Any,
        script_linked_service: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        degree_of_parallelism: Optional[Any] = None,
        priority: Optional[Any] = None,
        parameters: Optional[Dict[str, Any]] = None,
        runtime_version: Optional[Any] = None,
        compilation_mode: Optional[Any] = None,
        **kwargs
    ):
        super(DataLakeAnalyticsUSQLActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'DataLakeAnalyticsU-SQL'  # type: str
        self.script_path = script_path
        self.script_linked_service = script_linked_service
        self.degree_of_parallelism = degree_of_parallelism
        self.priority = priority
        self.parameters = parameters
        self.runtime_version = runtime_version
        self.compilation_mode = compilation_mode


class DatasetCompression(msrest.serialization.Model):
    """The compression method used on a dataset.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DatasetBZip2Compression, DatasetDeflateCompression, DatasetGZipCompression, DatasetTarCompression, DatasetTarGZipCompression, DatasetZipDeflateCompression.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset compression. Type: string (or Expression with resultType
     string).Constant filled by server.
    :type type: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'BZip2': 'DatasetBZip2Compression', 'Deflate': 'DatasetDeflateCompression', 'GZip': 'DatasetGZipCompression', 'Tar': 'DatasetTarCompression', 'TarGZip': 'DatasetTarGZipCompression', 'ZipDeflate': 'DatasetZipDeflateCompression'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(DatasetCompression, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'DatasetCompression'  # type: str


class DatasetBZip2Compression(DatasetCompression):
    """The BZip2 compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset compression. Type: string (or Expression with resultType
     string).Constant filled by server.
    :type type: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(DatasetBZip2Compression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'BZip2'  # type: str


class DatasetDataElement(msrest.serialization.Model):
    """Columns that define the structure of the dataset.

    :param name: Name of the column. Type: string (or Expression with resultType string).
    :type name: any
    :param type: Type of the column. Type: string (or Expression with resultType string).
    :type type: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'object'},
        'type': {'key': 'type', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[Any] = None,
        type: Optional[Any] = None,
        **kwargs
    ):
        super(DatasetDataElement, self).__init__(**kwargs)
        self.name = name
        self.type = type


class DatasetDebugResource(SubResourceDebugResource):
    """Dataset debug resource.

    All required parameters must be populated in order to send to Azure.

    :param name: The resource name.
    :type name: str
    :param properties: Required. Dataset properties.
    :type properties: ~azure.mgmt.datafactory.models.Dataset
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Dataset'},
    }

    def __init__(
        self,
        *,
        properties: "Dataset",
        name: Optional[str] = None,
        **kwargs
    ):
        super(DatasetDebugResource, self).__init__(name=name, **kwargs)
        self.properties = properties


class DatasetDeflateCompression(DatasetCompression):
    """The Deflate compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset compression. Type: string (or Expression with resultType
     string).Constant filled by server.
    :type type: any
    :param level: The Deflate compression level.
    :type level: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'object'},
        'level': {'key': 'level', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        level: Optional[Any] = None,
        **kwargs
    ):
        super(DatasetDeflateCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'Deflate'  # type: str
        self.level = level


class DatasetFolder(msrest.serialization.Model):
    """The folder that this Dataset is in. If not specified, Dataset will appear at the root level.

    :param name: The name of the folder that this Dataset is in.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DatasetFolder, self).__init__(**kwargs)
        self.name = name


class DatasetGZipCompression(DatasetCompression):
    """The GZip compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset compression. Type: string (or Expression with resultType
     string).Constant filled by server.
    :type type: any
    :param level: The GZip compression level.
    :type level: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'object'},
        'level': {'key': 'level', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        level: Optional[Any] = None,
        **kwargs
    ):
        super(DatasetGZipCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'GZip'  # type: str
        self.level = level


class DatasetListResponse(msrest.serialization.Model):
    """A list of dataset resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of datasets.
    :type value: list[~azure.mgmt.datafactory.models.DatasetResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatasetResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DatasetResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DatasetListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DatasetReference(msrest.serialization.Model):
    """Dataset reference type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Dataset reference type. Has constant value: "DatasetReference".
    :vartype type: str
    :param reference_name: Required. Reference dataset name.
    :type reference_name: str
    :param parameters: Arguments for dataset.
    :type parameters: dict[str, any]
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    type = "DatasetReference"

    def __init__(
        self,
        *,
        reference_name: str,
        parameters: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(DatasetReference, self).__init__(**kwargs)
        self.reference_name = reference_name
        self.parameters = parameters


class DatasetResource(SubResource):
    """Dataset resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Dataset properties.
    :type properties: ~azure.mgmt.datafactory.models.Dataset
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Dataset'},
    }

    def __init__(
        self,
        *,
        properties: "Dataset",
        **kwargs
    ):
        super(DatasetResource, self).__init__(**kwargs)
        self.properties = properties


class DatasetSchemaDataElement(msrest.serialization.Model):
    """Columns that define the physical type schema of the dataset.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Name of the schema column. Type: string (or Expression with resultType string).
    :type name: any
    :param type: Type of the schema column. Type: string (or Expression with resultType string).
    :type type: any
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'object'},
        'type': {'key': 'type', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        name: Optional[Any] = None,
        type: Optional[Any] = None,
        **kwargs
    ):
        super(DatasetSchemaDataElement, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.type = type


class DatasetTarCompression(DatasetCompression):
    """The Tar archive method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset compression. Type: string (or Expression with resultType
     string).Constant filled by server.
    :type type: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(DatasetTarCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'Tar'  # type: str


class DatasetTarGZipCompression(DatasetCompression):
    """The TarGZip compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset compression. Type: string (or Expression with resultType
     string).Constant filled by server.
    :type type: any
    :param level: The TarGZip compression level.
    :type level: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'object'},
        'level': {'key': 'level', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        level: Optional[Any] = None,
        **kwargs
    ):
        super(DatasetTarGZipCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'TarGZip'  # type: str
        self.level = level


class DatasetZipDeflateCompression(DatasetCompression):
    """The ZipDeflate compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset compression. Type: string (or Expression with resultType
     string).Constant filled by server.
    :type type: any
    :param level: The ZipDeflate compression level.
    :type level: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'object'},
        'level': {'key': 'level', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        level: Optional[Any] = None,
        **kwargs
    ):
        super(DatasetZipDeflateCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'ZipDeflate'  # type: str
        self.level = level


class Db2LinkedService(LinkedService):
    """Linked service for DB2 data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: The connection string. It is mutually exclusive with server,
     database, authenticationType, userName, packageCollection and certificateCommonName property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: any
    :param server: Server name for connection. It is mutually exclusive with connectionString
     property. Type: string (or Expression with resultType string).
    :type server: any
    :param database: Database name for connection. It is mutually exclusive with connectionString
     property. Type: string (or Expression with resultType string).
    :type database: any
    :param authentication_type: AuthenticationType to be used for connection. It is mutually
     exclusive with connectionString property. Possible values include: "Basic".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.Db2AuthenticationType
    :param username: Username for authentication. It is mutually exclusive with connectionString
     property. Type: string (or Expression with resultType string).
    :type username: any
    :param password: Password for authentication.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param package_collection: Under where packages are created when querying database. It is
     mutually exclusive with connectionString property. Type: string (or Expression with resultType
     string).
    :type package_collection: any
    :param certificate_common_name: Certificate Common Name when TLS is enabled. It is mutually
     exclusive with connectionString property. Type: string (or Expression with resultType string).
    :type certificate_common_name: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. It is mutually exclusive with
     connectionString property. Type: string (or Expression with resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'package_collection': {'key': 'typeProperties.packageCollection', 'type': 'object'},
        'certificate_common_name': {'key': 'typeProperties.certificateCommonName', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_string: Optional[Any] = None,
        server: Optional[Any] = None,
        database: Optional[Any] = None,
        authentication_type: Optional[Union[str, "Db2AuthenticationType"]] = None,
        username: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        package_collection: Optional[Any] = None,
        certificate_common_name: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(Db2LinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Db2'  # type: str
        self.connection_string = connection_string
        self.server = server
        self.database = database
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.package_collection = package_collection
        self.certificate_common_name = certificate_common_name
        self.encrypted_credential = encrypted_credential


class Db2Source(TabularSource):
    """A copy activity source for Db2 databases.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(Db2Source, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'Db2Source'  # type: str
        self.query = query


class Db2TableDataset(Dataset):
    """The Db2 table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: any
    :param schema_type_properties_schema: The Db2 schema name. Type: string (or Expression with
     resultType string).
    :type schema_type_properties_schema: any
    :param table: The Db2 table name. Type: string (or Expression with resultType string).
    :type table: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        schema_type_properties_schema: Optional[Any] = None,
        table: Optional[Any] = None,
        **kwargs
    ):
        super(Db2TableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'Db2Table'  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class DeleteActivity(ExecutionActivity):
    """Delete activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param recursive: If true, files or sub-folders under current folder path will be deleted
     recursively. Default is false. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param max_concurrent_connections: The max concurrent connections to connect data source at the
     same time.
    :type max_concurrent_connections: int
    :param enable_logging: Whether to record detailed logs of delete-activity execution. Default
     value is false. Type: boolean (or Expression with resultType boolean).
    :type enable_logging: any
    :param log_storage_settings: Log storage settings customer need to provide when enableLogging
     is true.
    :type log_storage_settings: ~azure.mgmt.datafactory.models.LogStorageSettings
    :param dataset: Required. Delete activity dataset reference.
    :type dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :param store_settings: Delete activity store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'max_concurrent_connections': {'minimum': 1},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'recursive': {'key': 'typeProperties.recursive', 'type': 'object'},
        'max_concurrent_connections': {'key': 'typeProperties.maxConcurrentConnections', 'type': 'int'},
        'enable_logging': {'key': 'typeProperties.enableLogging', 'type': 'object'},
        'log_storage_settings': {'key': 'typeProperties.logStorageSettings', 'type': 'LogStorageSettings'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
        'store_settings': {'key': 'typeProperties.storeSettings', 'type': 'StoreReadSettings'},
    }

    def __init__(
        self,
        *,
        name: str,
        dataset: "DatasetReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        recursive: Optional[Any] = None,
        max_concurrent_connections: Optional[int] = None,
        enable_logging: Optional[Any] = None,
        log_storage_settings: Optional["LogStorageSettings"] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        **kwargs
    ):
        super(DeleteActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'Delete'  # type: str
        self.recursive = recursive
        self.max_concurrent_connections = max_concurrent_connections
        self.enable_logging = enable_logging
        self.log_storage_settings = log_storage_settings
        self.dataset = dataset
        self.store_settings = store_settings


class DeleteDataFlowDebugSessionRequest(msrest.serialization.Model):
    """Request body structure for deleting data flow debug session.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        **kwargs
    ):
        super(DeleteDataFlowDebugSessionRequest, self).__init__(**kwargs)
        self.session_id = session_id


class DelimitedTextDataset(Dataset):
    """Delimited text dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param location: The location of the delimited text storage.
    :type location: ~azure.mgmt.datafactory.models.DatasetLocation
    :param column_delimiter: The column delimiter. Type: string (or Expression with resultType
     string).
    :type column_delimiter: any
    :param row_delimiter: The row delimiter. Type: string (or Expression with resultType string).
    :type row_delimiter: any
    :param encoding_name: The code page name of the preferred encoding. If miss, the default value
     is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in
     the following link to set supported values:
     https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with
     resultType string).
    :type encoding_name: any
    :param compression_codec: The data compressionCodec. Type: string (or Expression with
     resultType string).
    :type compression_codec: any
    :param compression_level: The data compression method used for DelimitedText.
    :type compression_level: any
    :param quote_char: The quote character. Type: string (or Expression with resultType string).
    :type quote_char: any
    :param escape_char: The escape character. Type: string (or Expression with resultType string).
    :type escape_char: any
    :param first_row_as_header: When used as input, treat the first row of data as headers. When
     used as output,write the headers into the output as the first row of data. The default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type first_row_as_header: any
    :param null_value: The null value string. Type: string (or Expression with resultType string).
    :type null_value: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'column_delimiter': {'key': 'typeProperties.columnDelimiter', 'type': 'object'},
        'row_delimiter': {'key': 'typeProperties.rowDelimiter', 'type': 'object'},
        'encoding_name': {'key': 'typeProperties.encodingName', 'type': 'object'},
        'compression_codec': {'key': 'typeProperties.compressionCodec', 'type': 'object'},
        'compression_level': {'key': 'typeProperties.compressionLevel', 'type': 'object'},
        'quote_char': {'key': 'typeProperties.quoteChar', 'type': 'object'},
        'escape_char': {'key': 'typeProperties.escapeChar', 'type': 'object'},
        'first_row_as_header': {'key': 'typeProperties.firstRowAsHeader', 'type': 'object'},
        'null_value': {'key': 'typeProperties.nullValue', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        column_delimiter: Optional[Any] = None,
        row_delimiter: Optional[Any] = None,
        encoding_name: Optional[Any] = None,
        compression_codec: Optional[Any] = None,
        compression_level: Optional[Any] = None,
        quote_char: Optional[Any] = None,
        escape_char: Optional[Any] = None,
        first_row_as_header: Optional[Any] = None,
        null_value: Optional[Any] = None,
        **kwargs
    ):
        super(DelimitedTextDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DelimitedText'  # type: str
        self.location = location
        self.column_delimiter = column_delimiter
        self.row_delimiter = row_delimiter
        self.encoding_name = encoding_name
        self.compression_codec = compression_codec
        self.compression_level = compression_level
        self.quote_char = quote_char
        self.escape_char = escape_char
        self.first_row_as_header = first_row_as_header
        self.null_value = null_value


class DelimitedTextReadSettings(FormatReadSettings):
    """Delimited text read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param skip_line_count: Indicates the number of non-empty rows to skip when reading data from
     input files. Type: integer (or Expression with resultType integer).
    :type skip_line_count: any
    :param compression_properties: Compression settings.
    :type compression_properties: ~azure.mgmt.datafactory.models.CompressionReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'skip_line_count': {'key': 'skipLineCount', 'type': 'object'},
        'compression_properties': {'key': 'compressionProperties', 'type': 'CompressionReadSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        skip_line_count: Optional[Any] = None,
        compression_properties: Optional["CompressionReadSettings"] = None,
        **kwargs
    ):
        super(DelimitedTextReadSettings, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'DelimitedTextReadSettings'  # type: str
        self.skip_line_count = skip_line_count
        self.compression_properties = compression_properties


class DelimitedTextSink(CopySink):
    """A copy activity DelimitedText sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param store_settings: DelimitedText store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreWriteSettings
    :param format_settings: DelimitedText format settings.
    :type format_settings: ~azure.mgmt.datafactory.models.DelimitedTextWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'DelimitedTextWriteSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        store_settings: Optional["StoreWriteSettings"] = None,
        format_settings: Optional["DelimitedTextWriteSettings"] = None,
        **kwargs
    ):
        super(DelimitedTextSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'DelimitedTextSink'  # type: str
        self.store_settings = store_settings
        self.format_settings = format_settings


class DelimitedTextSource(CopySource):
    """A copy activity DelimitedText source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param store_settings: DelimitedText store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :param format_settings: DelimitedText format settings.
    :type format_settings: ~azure.mgmt.datafactory.models.DelimitedTextReadSettings
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'DelimitedTextReadSettings'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        format_settings: Optional["DelimitedTextReadSettings"] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(DelimitedTextSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'DelimitedTextSource'  # type: str
        self.store_settings = store_settings
        self.format_settings = format_settings
        self.additional_columns = additional_columns


class DelimitedTextWriteSettings(FormatWriteSettings):
    """Delimited text write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param quote_all_text: Indicates whether string values should always be enclosed with quotes.
     Type: boolean (or Expression with resultType boolean).
    :type quote_all_text: any
    :param file_extension: Required. The file extension used to create the files. Type: string (or
     Expression with resultType string).
    :type file_extension: any
    :param max_rows_per_file: Limit the written file's row count to be smaller than or equal to the
     specified count. Type: integer (or Expression with resultType integer).
    :type max_rows_per_file: any
    :param file_name_prefix: Specifies the file name pattern
     :code:`<fileNamePrefix>`_:code:`<fileIndex>`.:code:`<fileExtension>` when copy from non-file
     based store without partitionOptions. Type: string (or Expression with resultType string).
    :type file_name_prefix: any
    """

    _validation = {
        'type': {'required': True},
        'file_extension': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'quote_all_text': {'key': 'quoteAllText', 'type': 'object'},
        'file_extension': {'key': 'fileExtension', 'type': 'object'},
        'max_rows_per_file': {'key': 'maxRowsPerFile', 'type': 'object'},
        'file_name_prefix': {'key': 'fileNamePrefix', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        file_extension: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        quote_all_text: Optional[Any] = None,
        max_rows_per_file: Optional[Any] = None,
        file_name_prefix: Optional[Any] = None,
        **kwargs
    ):
        super(DelimitedTextWriteSettings, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'DelimitedTextWriteSettings'  # type: str
        self.quote_all_text = quote_all_text
        self.file_extension = file_extension
        self.max_rows_per_file = max_rows_per_file
        self.file_name_prefix = file_name_prefix


class DependencyReference(msrest.serialization.Model):
    """Referenced dependency.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SelfDependencyTumblingWindowTriggerReference, TriggerDependencyReference.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of dependency reference.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'SelfDependencyTumblingWindowTriggerReference': 'SelfDependencyTumblingWindowTriggerReference', 'TriggerDependencyReference': 'TriggerDependencyReference'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DependencyReference, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class DistcpSettings(msrest.serialization.Model):
    """Distcp settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_manager_endpoint: Required. Specifies the Yarn ResourceManager endpoint. Type:
     string (or Expression with resultType string).
    :type resource_manager_endpoint: any
    :param temp_script_path: Required. Specifies an existing folder path which will be used to
     store temp Distcp command script. The script file is generated by ADF and will be removed after
     Copy job finished. Type: string (or Expression with resultType string).
    :type temp_script_path: any
    :param distcp_options: Specifies the Distcp options. Type: string (or Expression with
     resultType string).
    :type distcp_options: any
    """

    _validation = {
        'resource_manager_endpoint': {'required': True},
        'temp_script_path': {'required': True},
    }

    _attribute_map = {
        'resource_manager_endpoint': {'key': 'resourceManagerEndpoint', 'type': 'object'},
        'temp_script_path': {'key': 'tempScriptPath', 'type': 'object'},
        'distcp_options': {'key': 'distcpOptions', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        resource_manager_endpoint: Any,
        temp_script_path: Any,
        distcp_options: Optional[Any] = None,
        **kwargs
    ):
        super(DistcpSettings, self).__init__(**kwargs)
        self.resource_manager_endpoint = resource_manager_endpoint
        self.temp_script_path = temp_script_path
        self.distcp_options = distcp_options


class DocumentDbCollectionDataset(Dataset):
    """Microsoft Azure Document Database Collection dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param collection_name: Required. Document Database collection name. Type: string (or
     Expression with resultType string).
    :type collection_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection_name': {'key': 'typeProperties.collectionName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection_name: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(DocumentDbCollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DocumentDbCollection'  # type: str
        self.collection_name = collection_name


class DocumentDbCollectionSink(CopySink):
    """A copy activity Document Database Collection sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param nesting_separator: Nested properties separator. Default is . (dot). Type: string (or
     Expression with resultType string).
    :type nesting_separator: any
    :param write_behavior: Describes how to write data to Azure Cosmos DB. Type: string (or
     Expression with resultType string). Allowed values: insert and upsert.
    :type write_behavior: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'nesting_separator': {'key': 'nestingSeparator', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        nesting_separator: Optional[Any] = None,
        write_behavior: Optional[Any] = None,
        **kwargs
    ):
        super(DocumentDbCollectionSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'DocumentDbCollectionSink'  # type: str
        self.nesting_separator = nesting_separator
        self.write_behavior = write_behavior


class DocumentDbCollectionSource(CopySource):
    """A copy activity Document Database Collection source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query: Documents query. Type: string (or Expression with resultType string).
    :type query: any
    :param nesting_separator: Nested properties separator. Type: string (or Expression with
     resultType string).
    :type nesting_separator: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'nesting_separator': {'key': 'nestingSeparator', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query: Optional[Any] = None,
        nesting_separator: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(DocumentDbCollectionSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'DocumentDbCollectionSource'  # type: str
        self.query = query
        self.nesting_separator = nesting_separator
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class DrillLinkedService(LinkedService):
    """Drill server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_string: Optional[Any] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(DrillLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Drill'  # type: str
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class DrillSource(TabularSource):
    """A copy activity Drill server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(DrillSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'DrillSource'  # type: str
        self.query = query


class DrillTableDataset(Dataset):
    """Drill server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: any
    :param table: The table name of the Drill. Type: string (or Expression with resultType string).
    :type table: any
    :param schema_type_properties_schema: The schema name of the Drill. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        table: Optional[Any] = None,
        schema_type_properties_schema: Optional[Any] = None,
        **kwargs
    ):
        super(DrillTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DrillTable'  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class DWCopyCommandDefaultValue(msrest.serialization.Model):
    """Default value.

    :param column_name: Column name. Type: object (or Expression with resultType string).
    :type column_name: any
    :param default_value: The default value of the column. Type: object (or Expression with
     resultType string).
    :type default_value: any
    """

    _attribute_map = {
        'column_name': {'key': 'columnName', 'type': 'object'},
        'default_value': {'key': 'defaultValue', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        column_name: Optional[Any] = None,
        default_value: Optional[Any] = None,
        **kwargs
    ):
        super(DWCopyCommandDefaultValue, self).__init__(**kwargs)
        self.column_name = column_name
        self.default_value = default_value


class DWCopyCommandSettings(msrest.serialization.Model):
    """DW Copy Command settings.

    :param default_values: Specifies the default values for each target column in SQL DW. The
     default values in the property overwrite the DEFAULT constraint set in the DB, and identity
     column cannot have a default value. Type: array of objects (or Expression with resultType array
     of objects).
    :type default_values: list[~azure.mgmt.datafactory.models.DWCopyCommandDefaultValue]
    :param additional_options: Additional options directly passed to SQL DW in Copy Command. Type:
     key value pairs (value should be string type) (or Expression with resultType object). Example:
     "additionalOptions": { "MAXERRORS": "1000", "DATEFORMAT": "'ymd'" }.
    :type additional_options: dict[str, str]
    """

    _attribute_map = {
        'default_values': {'key': 'defaultValues', 'type': '[DWCopyCommandDefaultValue]'},
        'additional_options': {'key': 'additionalOptions', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        default_values: Optional[List["DWCopyCommandDefaultValue"]] = None,
        additional_options: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(DWCopyCommandSettings, self).__init__(**kwargs)
        self.default_values = default_values
        self.additional_options = additional_options


class DynamicsAXLinkedService(LinkedService):
    """Dynamics AX linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param url: Required. The Dynamics AX (or Dynamics 365 Finance and Operations) instance OData
     endpoint.
    :type url: any
    :param service_principal_id: Required. Specify the application's client ID. Type: string (or
     Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_key: Required. Specify the application's key. Mark this field as a
     SecureString to store it securely in Data Factory, or reference a secret stored in Azure Key
     Vault. Type: string (or Expression with resultType string).
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: Required. Specify the tenant information (domain name or tenant ID) under which
     your application resides. Retrieve it by hovering the mouse in the top-right corner of the
     Azure portal. Type: string (or Expression with resultType string).
    :type tenant: any
    :param aad_resource_id: Required. Specify the resource you are requesting authorization. Type:
     string (or Expression with resultType string).
    :type aad_resource_id: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
        'service_principal_id': {'required': True},
        'service_principal_key': {'required': True},
        'tenant': {'required': True},
        'aad_resource_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'aad_resource_id': {'key': 'typeProperties.aadResourceId', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: Any,
        service_principal_id: Any,
        service_principal_key: "SecretBase",
        tenant: Any,
        aad_resource_id: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(DynamicsAXLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'DynamicsAX'  # type: str
        self.url = url
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.aad_resource_id = aad_resource_id
        self.encrypted_credential = encrypted_credential


class DynamicsAXResourceDataset(Dataset):
    """The path of the Dynamics AX OData entity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param path: Required. The path of the Dynamics AX OData entity. Type: string (or Expression
     with resultType string).
    :type path: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'path': {'key': 'typeProperties.path', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        path: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(DynamicsAXResourceDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DynamicsAXResource'  # type: str
        self.path = path


class DynamicsAXSource(TabularSource):
    """A copy activity Dynamics AX source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    :param http_request_timeout: The timeout (TimeSpan) to get an HTTP response. It is the timeout
     to get a response, not the timeout to read response data. Default value: 00:05:00. Type: string
     (or Expression with resultType string), pattern:
     ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type http_request_timeout: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'http_request_timeout': {'key': 'httpRequestTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        http_request_timeout: Optional[Any] = None,
        **kwargs
    ):
        super(DynamicsAXSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'DynamicsAXSource'  # type: str
        self.query = query
        self.http_request_timeout = http_request_timeout


class DynamicsCrmEntityDataset(Dataset):
    """The Dynamics CRM entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        entity_name: Optional[Any] = None,
        **kwargs
    ):
        super(DynamicsCrmEntityDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DynamicsCrmEntity'  # type: str
        self.entity_name = entity_name


class DynamicsCrmLinkedService(LinkedService):
    """Dynamics CRM linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param deployment_type: Required. The deployment type of the Dynamics CRM instance. 'Online'
     for Dynamics CRM Online and 'OnPremisesWithIfd' for Dynamics CRM on-premises with Ifd. Type:
     string (or Expression with resultType string).
    :type deployment_type: any
    :param host_name: The host name of the on-premises Dynamics CRM server. The property is
     required for on-prem and not allowed for online. Type: string (or Expression with resultType
     string).
    :type host_name: any
    :param port: The port of on-premises Dynamics CRM server. The property is required for on-prem
     and not allowed for online. Default is 443. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type port: any
    :param service_uri: The URL to the Microsoft Dynamics CRM server. The property is required for
     on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
    :type service_uri: any
    :param organization_name: The organization name of the Dynamics CRM instance. The property is
     required for on-prem and required for online when there are more than one Dynamics CRM
     instances associated with the user. Type: string (or Expression with resultType string).
    :type organization_name: any
    :param authentication_type: Required. The authentication type to connect to Dynamics CRM
     server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario,
     'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or
     Expression with resultType string).
    :type authentication_type: any
    :param username: User name to access the Dynamics CRM instance. Type: string (or Expression
     with resultType string).
    :type username: any
    :param password: Password to access the Dynamics CRM instance.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string).
    :type service_principal_credential_type: any
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'object'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'object'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'object'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        deployment_type: Any,
        authentication_type: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        host_name: Optional[Any] = None,
        port: Optional[Any] = None,
        service_uri: Optional[Any] = None,
        organization_name: Optional[Any] = None,
        username: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_credential_type: Optional[Any] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(DynamicsCrmLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'DynamicsCrm'  # type: str
        self.deployment_type = deployment_type
        self.host_name = host_name
        self.port = port
        self.service_uri = service_uri
        self.organization_name = organization_name
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.encrypted_credential = encrypted_credential


class DynamicsCrmSink(CopySink):
    """A copy activity Dynamics CRM sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param write_behavior: Required. The write behavior for the operation. Possible values include:
     "Upsert".
    :type write_behavior: str or ~azure.mgmt.datafactory.models.DynamicsSinkWriteBehavior
    :param ignore_null_values: The flag indicating whether to ignore null values from input dataset
     (except key fields) during write operation. Default is false. Type: boolean (or Expression with
     resultType boolean).
    :type ignore_null_values: any
    :param alternate_key_name: The logical name of the alternate key which will be used when
     upserting records. Type: string (or Expression with resultType string).
    :type alternate_key_name: any
    """

    _validation = {
        'type': {'required': True},
        'write_behavior': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
        'ignore_null_values': {'key': 'ignoreNullValues', 'type': 'object'},
        'alternate_key_name': {'key': 'alternateKeyName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        write_behavior: Union[str, "DynamicsSinkWriteBehavior"],
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        ignore_null_values: Optional[Any] = None,
        alternate_key_name: Optional[Any] = None,
        **kwargs
    ):
        super(DynamicsCrmSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'DynamicsCrmSink'  # type: str
        self.write_behavior = write_behavior
        self.ignore_null_values = ignore_null_values
        self.alternate_key_name = alternate_key_name


class DynamicsCrmSource(CopySource):
    """A copy activity Dynamics CRM source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query: FetchXML is a proprietary query language that is used in Microsoft Dynamics CRM
     (online & on-premises). Type: string (or Expression with resultType string).
    :type query: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(DynamicsCrmSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'DynamicsCrmSource'  # type: str
        self.query = query
        self.additional_columns = additional_columns


class DynamicsEntityDataset(Dataset):
    """The Dynamics entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        entity_name: Optional[Any] = None,
        **kwargs
    ):
        super(DynamicsEntityDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DynamicsEntity'  # type: str
        self.entity_name = entity_name


class DynamicsLinkedService(LinkedService):
    """Dynamics linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param deployment_type: Required. The deployment type of the Dynamics instance. 'Online' for
     Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or
     Expression with resultType string).
    :type deployment_type: any
    :param host_name: The host name of the on-premises Dynamics server. The property is required
     for on-prem and not allowed for online. Type: string (or Expression with resultType string).
    :type host_name: any
    :param port: The port of on-premises Dynamics server. The property is required for on-prem and
     not allowed for online. Default is 443. Type: integer (or Expression with resultType integer),
     minimum: 0.
    :type port: any
    :param service_uri: The URL to the Microsoft Dynamics server. The property is required for
     on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
    :type service_uri: any
    :param organization_name: The organization name of the Dynamics instance. The property is
     required for on-prem and required for online when there are more than one Dynamics instances
     associated with the user. Type: string (or Expression with resultType string).
    :type organization_name: any
    :param authentication_type: Required. The authentication type to connect to Dynamics server.
     'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal'
     for Server-To-Server authentication in online scenario. Type: string (or Expression with
     resultType string).
    :type authentication_type: any
    :param username: User name to access the Dynamics instance. Type: string (or Expression with
     resultType string).
    :type username: any
    :param password: Password to access the Dynamics instance.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: any
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string).
    :type service_principal_credential_type: str
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'object'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'object'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        deployment_type: Any,
        authentication_type: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        host_name: Optional[Any] = None,
        port: Optional[Any] = None,
        service_uri: Optional[Any] = None,
        organization_name: Optional[Any] = None,
        username: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        service_principal_id: Optional[Any] = None,
        service_principal_credential_type: Optional[str] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(DynamicsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Dynamics'  # type: str
        self.deployment_type = deployment_type
        self.host_name = host_name
        self.port = port
        self.service_uri = service_uri
        self.organization_name = organization_name
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.encrypted_credential = encrypted_credential


class DynamicsSink(CopySink):
    """A copy activity Dynamics sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param write_behavior: Required. The write behavior for the operation. Possible values include:
     "Upsert".
    :type write_behavior: str or ~azure.mgmt.datafactory.models.DynamicsSinkWriteBehavior
    :param ignore_null_values: The flag indicating whether ignore null values from input dataset
     (except key fields) during write operation. Default is false. Type: boolean (or Expression with
     resultType boolean).
    :type ignore_null_values: any
    :param alternate_key_name: The logical name of the alternate key which will be used when
     upserting records. Type: string (or Expression with resultType string).
    :type alternate_key_name: any
    """

    _validation = {
        'type': {'required': True},
        'write_behavior': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
        'ignore_null_values': {'key': 'ignoreNullValues', 'type': 'object'},
        'alternate_key_name': {'key': 'alternateKeyName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        write_behavior: Union[str, "DynamicsSinkWriteBehavior"],
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        ignore_null_values: Optional[Any] = None,
        alternate_key_name: Optional[Any] = None,
        **kwargs
    ):
        super(DynamicsSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'DynamicsSink'  # type: str
        self.write_behavior = write_behavior
        self.ignore_null_values = ignore_null_values
        self.alternate_key_name = alternate_key_name


class DynamicsSource(CopySource):
    """A copy activity Dynamics source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query: FetchXML is a proprietary query language that is used in Microsoft Dynamics
     (online & on-premises). Type: string (or Expression with resultType string).
    :type query: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(DynamicsSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'DynamicsSource'  # type: str
        self.query = query
        self.additional_columns = additional_columns


class EloquaLinkedService(LinkedService):
    """Eloqua server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param endpoint: Required. The endpoint of the Eloqua server. (i.e. eloqua.example.com).
    :type endpoint: any
    :param username: Required. The site name and user name of your Eloqua account in the form:
     sitename/username. (i.e. Eloqua/Alice).
    :type username: any
    :param password: The password corresponding to the user name.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: any
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: any
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: Any,
        username: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        password: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[Any] = None,
        use_host_verification: Optional[Any] = None,
        use_peer_verification: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(EloquaLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Eloqua'  # type: str
        self.endpoint = endpoint
        self.username = username
        self.password = password
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class EloquaObjectDataset(Dataset):
    """Eloqua server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        **kwargs
    ):
        super(EloquaObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'EloquaObject'  # type: str
        self.table_name = table_name


class EloquaSource(TabularSource):
    """A copy activity Eloqua server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(EloquaSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'EloquaSource'  # type: str
        self.query = query


class EncryptionConfiguration(msrest.serialization.Model):
    """Definition of CMK for the factory.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The name of the key in Azure Key Vault to use as Customer Managed
     Key.
    :type key_name: str
    :param vault_base_url: Required. The url of the Azure Key Vault used for CMK.
    :type vault_base_url: str
    :param key_version: The version of the key used for CMK. If not provided, latest version will
     be used.
    :type key_version: str
    :param identity: User assigned identity to use to authenticate to customer's key vault. If not
     provided Managed Service Identity will be used.
    :type identity: ~azure.mgmt.datafactory.models.CMKIdentityDefinition
    """

    _validation = {
        'key_name': {'required': True},
        'vault_base_url': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'vault_base_url': {'key': 'vaultBaseUrl', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'CMKIdentityDefinition'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        vault_base_url: str,
        key_version: Optional[str] = None,
        identity: Optional["CMKIdentityDefinition"] = None,
        **kwargs
    ):
        super(EncryptionConfiguration, self).__init__(**kwargs)
        self.key_name = key_name
        self.vault_base_url = vault_base_url
        self.key_version = key_version
        self.identity = identity


class EntityReference(msrest.serialization.Model):
    """The entity reference.

    :param type: The type of this referenced entity. Possible values include:
     "IntegrationRuntimeReference", "LinkedServiceReference".
    :type type: str or ~azure.mgmt.datafactory.models.IntegrationRuntimeEntityReferenceType
    :param reference_name: The name of this referenced entity.
    :type reference_name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "IntegrationRuntimeEntityReferenceType"]] = None,
        reference_name: Optional[str] = None,
        **kwargs
    ):
        super(EntityReference, self).__init__(**kwargs)
        self.type = type
        self.reference_name = reference_name


class EnvironmentVariableSetup(CustomSetupBase):
    """The custom setup of setting environment variable.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param variable_name: Required. The name of the environment variable.
    :type variable_name: str
    :param variable_value: Required. The value of the environment variable.
    :type variable_value: str
    """

    _validation = {
        'type': {'required': True},
        'variable_name': {'required': True},
        'variable_value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'variable_name': {'key': 'typeProperties.variableName', 'type': 'str'},
        'variable_value': {'key': 'typeProperties.variableValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        variable_name: str,
        variable_value: str,
        **kwargs
    ):
        super(EnvironmentVariableSetup, self).__init__(**kwargs)
        self.type = 'EnvironmentVariableSetup'  # type: str
        self.variable_name = variable_name
        self.variable_value = variable_value


class ExcelDataset(Dataset):
    """Excel dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param location: The location of the excel storage.
    :type location: ~azure.mgmt.datafactory.models.DatasetLocation
    :param sheet_name: The sheet name of excel file. Type: string (or Expression with resultType
     string).
    :type sheet_name: any
    :param sheet_index: The sheet index of excel file and default value is 0. Type: integer (or
     Expression with resultType integer).
    :type sheet_index: any
    :param range: The partial data of one sheet. Type: string (or Expression with resultType
     string).
    :type range: any
    :param first_row_as_header: When used as input, treat the first row of data as headers. When
     used as output,write the headers into the output as the first row of data. The default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type first_row_as_header: any
    :param compression: The data compression method used for the json dataset.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    :param null_value: The null value string. Type: string (or Expression with resultType string).
    :type null_value: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'sheet_name': {'key': 'typeProperties.sheetName', 'type': 'object'},
        'sheet_index': {'key': 'typeProperties.sheetIndex', 'type': 'object'},
        'range': {'key': 'typeProperties.range', 'type': 'object'},
        'first_row_as_header': {'key': 'typeProperties.firstRowAsHeader', 'type': 'object'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
        'null_value': {'key': 'typeProperties.nullValue', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        sheet_name: Optional[Any] = None,
        sheet_index: Optional[Any] = None,
        range: Optional[Any] = None,
        first_row_as_header: Optional[Any] = None,
        compression: Optional["DatasetCompression"] = None,
        null_value: Optional[Any] = None,
        **kwargs
    ):
        super(ExcelDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'Excel'  # type: str
        self.location = location
        self.sheet_name = sheet_name
        self.sheet_index = sheet_index
        self.range = range
        self.first_row_as_header = first_row_as_header
        self.compression = compression
        self.null_value = null_value


class ExcelSource(CopySource):
    """A copy activity excel source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param store_settings: Excel store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(ExcelSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'ExcelSource'  # type: str
        self.store_settings = store_settings
        self.additional_columns = additional_columns


class ExecuteDataFlowActivity(ExecutionActivity):
    """Execute data flow activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param data_flow: Required. Data flow reference.
    :type data_flow: ~azure.mgmt.datafactory.models.DataFlowReference
    :param staging: Staging info for execute data flow activity.
    :type staging: ~azure.mgmt.datafactory.models.DataFlowStagingInfo
    :param integration_runtime: The integration runtime reference.
    :type integration_runtime: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param compute: Compute properties for data flow activity.
    :type compute: ~azure.mgmt.datafactory.models.ExecuteDataFlowActivityTypePropertiesCompute
    :param trace_level: Trace level setting used for data flow monitoring output. Supported values
     are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string).
    :type trace_level: any
    :param continue_on_error: Continue on error setting used for data flow execution. Enables
     processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean).
    :type continue_on_error: any
    :param run_concurrently: Concurrent run setting used for data flow execution. Allows sinks with
     the same save order to be processed concurrently. Type: boolean (or Expression with resultType
     boolean).
    :type run_concurrently: any
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'data_flow': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'data_flow': {'key': 'typeProperties.dataFlow', 'type': 'DataFlowReference'},
        'staging': {'key': 'typeProperties.staging', 'type': 'DataFlowStagingInfo'},
        'integration_runtime': {'key': 'typeProperties.integrationRuntime', 'type': 'IntegrationRuntimeReference'},
        'compute': {'key': 'typeProperties.compute', 'type': 'ExecuteDataFlowActivityTypePropertiesCompute'},
        'trace_level': {'key': 'typeProperties.traceLevel', 'type': 'object'},
        'continue_on_error': {'key': 'typeProperties.continueOnError', 'type': 'object'},
        'run_concurrently': {'key': 'typeProperties.runConcurrently', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        data_flow: "DataFlowReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        staging: Optional["DataFlowStagingInfo"] = None,
        integration_runtime: Optional["IntegrationRuntimeReference"] = None,
        compute: Optional["ExecuteDataFlowActivityTypePropertiesCompute"] = None,
        trace_level: Optional[Any] = None,
        continue_on_error: Optional[Any] = None,
        run_concurrently: Optional[Any] = None,
        **kwargs
    ):
        super(ExecuteDataFlowActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'ExecuteDataFlow'  # type: str
        self.data_flow = data_flow
        self.staging = staging
        self.integration_runtime = integration_runtime
        self.compute = compute
        self.trace_level = trace_level
        self.continue_on_error = continue_on_error
        self.run_concurrently = run_concurrently


class ExecuteDataFlowActivityTypeProperties(msrest.serialization.Model):
    """Execute data flow activity properties.

    All required parameters must be populated in order to send to Azure.

    :param data_flow: Required. Data flow reference.
    :type data_flow: ~azure.mgmt.datafactory.models.DataFlowReference
    :param staging: Staging info for execute data flow activity.
    :type staging: ~azure.mgmt.datafactory.models.DataFlowStagingInfo
    :param integration_runtime: The integration runtime reference.
    :type integration_runtime: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param compute: Compute properties for data flow activity.
    :type compute: ~azure.mgmt.datafactory.models.ExecuteDataFlowActivityTypePropertiesCompute
    :param trace_level: Trace level setting used for data flow monitoring output. Supported values
     are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string).
    :type trace_level: any
    :param continue_on_error: Continue on error setting used for data flow execution. Enables
     processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean).
    :type continue_on_error: any
    :param run_concurrently: Concurrent run setting used for data flow execution. Allows sinks with
     the same save order to be processed concurrently. Type: boolean (or Expression with resultType
     boolean).
    :type run_concurrently: any
    """

    _validation = {
        'data_flow': {'required': True},
    }

    _attribute_map = {
        'data_flow': {'key': 'dataFlow', 'type': 'DataFlowReference'},
        'staging': {'key': 'staging', 'type': 'DataFlowStagingInfo'},
        'integration_runtime': {'key': 'integrationRuntime', 'type': 'IntegrationRuntimeReference'},
        'compute': {'key': 'compute', 'type': 'ExecuteDataFlowActivityTypePropertiesCompute'},
        'trace_level': {'key': 'traceLevel', 'type': 'object'},
        'continue_on_error': {'key': 'continueOnError', 'type': 'object'},
        'run_concurrently': {'key': 'runConcurrently', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        data_flow: "DataFlowReference",
        staging: Optional["DataFlowStagingInfo"] = None,
        integration_runtime: Optional["IntegrationRuntimeReference"] = None,
        compute: Optional["ExecuteDataFlowActivityTypePropertiesCompute"] = None,
        trace_level: Optional[Any] = None,
        continue_on_error: Optional[Any] = None,
        run_concurrently: Optional[Any] = None,
        **kwargs
    ):
        super(ExecuteDataFlowActivityTypeProperties, self).__init__(**kwargs)
        self.data_flow = data_flow
        self.staging = staging
        self.integration_runtime = integration_runtime
        self.compute = compute
        self.trace_level = trace_level
        self.continue_on_error = continue_on_error
        self.run_concurrently = run_concurrently


class ExecuteDataFlowActivityTypePropertiesCompute(msrest.serialization.Model):
    """Compute properties for data flow activity.

    :param compute_type: Compute type of the cluster which will execute data flow job. Possible
     values include: 'General', 'MemoryOptimized', 'ComputeOptimized'. Type: string (or Expression
     with resultType string).
    :type compute_type: any
    :param core_count: Core count of the cluster which will execute data flow job. Supported values
     are: 8, 16, 32, 48, 80, 144 and 272. Type: integer (or Expression with resultType integer).
    :type core_count: any
    """

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'object'},
        'core_count': {'key': 'coreCount', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        compute_type: Optional[Any] = None,
        core_count: Optional[Any] = None,
        **kwargs
    ):
        super(ExecuteDataFlowActivityTypePropertiesCompute, self).__init__(**kwargs)
        self.compute_type = compute_type
        self.core_count = core_count


class ExecutePipelineActivity(ControlActivity):
    """Execute pipeline activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param pipeline: Required. Pipeline reference.
    :type pipeline: ~azure.mgmt.datafactory.models.PipelineReference
    :param parameters: Pipeline parameters.
    :type parameters: dict[str, any]
    :param wait_on_completion: Defines whether activity execution will wait for the dependent
     pipeline execution to finish. Default is false.
    :type wait_on_completion: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'pipeline': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'pipeline': {'key': 'typeProperties.pipeline', 'type': 'PipelineReference'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '{object}'},
        'wait_on_completion': {'key': 'typeProperties.waitOnCompletion', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        pipeline: "PipelineReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        parameters: Optional[Dict[str, Any]] = None,
        wait_on_completion: Optional[bool] = None,
        **kwargs
    ):
        super(ExecutePipelineActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'ExecutePipeline'  # type: str
        self.pipeline = pipeline
        self.parameters = parameters
        self.wait_on_completion = wait_on_completion


class ExecutePowerQueryActivityTypeProperties(ExecuteDataFlowActivityTypeProperties):
    """Execute power query data flow activity properties.

    All required parameters must be populated in order to send to Azure.

    :param data_flow: Required. Data flow reference.
    :type data_flow: ~azure.mgmt.datafactory.models.DataFlowReference
    :param staging: Staging info for execute data flow activity.
    :type staging: ~azure.mgmt.datafactory.models.DataFlowStagingInfo
    :param integration_runtime: The integration runtime reference.
    :type integration_runtime: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param compute: Compute properties for data flow activity.
    :type compute: ~azure.mgmt.datafactory.models.ExecuteDataFlowActivityTypePropertiesCompute
    :param trace_level: Trace level setting used for data flow monitoring output. Supported values
     are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string).
    :type trace_level: any
    :param continue_on_error: Continue on error setting used for data flow execution. Enables
     processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean).
    :type continue_on_error: any
    :param run_concurrently: Concurrent run setting used for data flow execution. Allows sinks with
     the same save order to be processed concurrently. Type: boolean (or Expression with resultType
     boolean).
    :type run_concurrently: any
    :param sinks: (Deprecated. Please use Queries). List of Power Query activity sinks mapped to a
     queryName.
    :type sinks: dict[str, ~azure.mgmt.datafactory.models.PowerQuerySink]
    :param queries: List of mapping for Power Query mashup query to sink dataset(s).
    :type queries: list[~azure.mgmt.datafactory.models.PowerQuerySinkMapping]
    """

    _validation = {
        'data_flow': {'required': True},
    }

    _attribute_map = {
        'data_flow': {'key': 'dataFlow', 'type': 'DataFlowReference'},
        'staging': {'key': 'staging', 'type': 'DataFlowStagingInfo'},
        'integration_runtime': {'key': 'integrationRuntime', 'type': 'IntegrationRuntimeReference'},
        'compute': {'key': 'compute', 'type': 'ExecuteDataFlowActivityTypePropertiesCompute'},
        'trace_level': {'key': 'traceLevel', 'type': 'object'},
        'continue_on_error': {'key': 'continueOnError', 'type': 'object'},
        'run_concurrently': {'key': 'runConcurrently', 'type': 'object'},
        'sinks': {'key': 'sinks', 'type': '{PowerQuerySink}'},
        'queries': {'key': 'queries', 'type': '[PowerQuerySinkMapping]'},
    }

    def __init__(
        self,
        *,
        data_flow: "DataFlowReference",
        staging: Optional["DataFlowStagingInfo"] = None,
        integration_runtime: Optional["IntegrationRuntimeReference"] = None,
        compute: Optional["ExecuteDataFlowActivityTypePropertiesCompute"] = None,
        trace_level: Optional[Any] = None,
        continue_on_error: Optional[Any] = None,
        run_concurrently: Optional[Any] = None,
        sinks: Optional[Dict[str, "PowerQuerySink"]] = None,
        queries: Optional[List["PowerQuerySinkMapping"]] = None,
        **kwargs
    ):
        super(ExecutePowerQueryActivityTypeProperties, self).__init__(data_flow=data_flow, staging=staging, integration_runtime=integration_runtime, compute=compute, trace_level=trace_level, continue_on_error=continue_on_error, run_concurrently=run_concurrently, **kwargs)
        self.sinks = sinks
        self.queries = queries


class ExecuteSSISPackageActivity(ExecutionActivity):
    """Execute SSIS package activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param package_location: Required. SSIS package location.
    :type package_location: ~azure.mgmt.datafactory.models.SSISPackageLocation
    :param runtime: Specifies the runtime to execute SSIS package. The value should be "x86" or
     "x64". Type: string (or Expression with resultType string).
    :type runtime: any
    :param logging_level: The logging level of SSIS package execution. Type: string (or Expression
     with resultType string).
    :type logging_level: any
    :param environment_path: The environment path to execute the SSIS package. Type: string (or
     Expression with resultType string).
    :type environment_path: any
    :param execution_credential: The package execution credential.
    :type execution_credential: ~azure.mgmt.datafactory.models.SSISExecutionCredential
    :param connect_via: Required. The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param project_parameters: The project level parameters to execute the SSIS package.
    :type project_parameters: dict[str, ~azure.mgmt.datafactory.models.SSISExecutionParameter]
    :param package_parameters: The package level parameters to execute the SSIS package.
    :type package_parameters: dict[str, ~azure.mgmt.datafactory.models.SSISExecutionParameter]
    :param project_connection_managers: The project level connection managers to execute the SSIS
     package.
    :type project_connection_managers: dict[str, dict[str,
     ~azure.mgmt.datafactory.models.SSISExecutionParameter]]
    :param package_connection_managers: The package level connection managers to execute the SSIS
     package.
    :type package_connection_managers: dict[str, dict[str,
     ~azure.mgmt.datafactory.models.SSISExecutionParameter]]
    :param property_overrides: The property overrides to execute the SSIS package.
    :type property_overrides: dict[str, ~azure.mgmt.datafactory.models.SSISPropertyOverride]
    :param log_location: SSIS package execution log location.
    :type log_location: ~azure.mgmt.datafactory.models.SSISLogLocation
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'package_location': {'required': True},
        'connect_via': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'package_location': {'key': 'typeProperties.packageLocation', 'type': 'SSISPackageLocation'},
        'runtime': {'key': 'typeProperties.runtime', 'type': 'object'},
        'logging_level': {'key': 'typeProperties.loggingLevel', 'type': 'object'},
        'environment_path': {'key': 'typeProperties.environmentPath', 'type': 'object'},
        'execution_credential': {'key': 'typeProperties.executionCredential', 'type': 'SSISExecutionCredential'},
        'connect_via': {'key': 'typeProperties.connectVia', 'type': 'IntegrationRuntimeReference'},
        'project_parameters': {'key': 'typeProperties.projectParameters', 'type': '{SSISExecutionParameter}'},
        'package_parameters': {'key': 'typeProperties.packageParameters', 'type': '{SSISExecutionParameter}'},
        'project_connection_managers': {'key': 'typeProperties.projectConnectionManagers', 'type': '{{SSISExecutionParameter}}'},
        'package_connection_managers': {'key': 'typeProperties.packageConnectionManagers', 'type': '{{SSISExecutionParameter}}'},
        'property_overrides': {'key': 'typeProperties.propertyOverrides', 'type': '{SSISPropertyOverride}'},
        'log_location': {'key': 'typeProperties.logLocation', 'type': 'SSISLogLocation'},
    }

    def __init__(
        self,
        *,
        name: str,
        package_location: "SSISPackageLocation",
        connect_via: "IntegrationRuntimeReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        runtime: Optional[Any] = None,
        logging_level: Optional[Any] = None,
        environment_path: Optional[Any] = None,
        execution_credential: Optional["SSISExecutionCredential"] = None,
        project_parameters: Optional[Dict[str, "SSISExecutionParameter"]] = None,
        package_parameters: Optional[Dict[str, "SSISExecutionParameter"]] = None,
        project_connection_managers: Optional[Dict[str, Dict[str, "SSISExecutionParameter"]]] = None,
        package_connection_managers: Optional[Dict[str, Dict[str, "SSISExecutionParameter"]]] = None,
        property_overrides: Optional[Dict[str, "SSISPropertyOverride"]] = None,
        log_location: Optional["SSISLogLocation"] = None,
        **kwargs
    ):
        super(ExecuteSSISPackageActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'ExecuteSSISPackage'  # type: str
        self.package_location = package_location
        self.runtime = runtime
        self.logging_level = logging_level
        self.environment_path = environment_path
        self.execution_credential = execution_credential
        self.connect_via = connect_via
        self.project_parameters = project_parameters
        self.package_parameters = package_parameters
        self.project_connection_managers = project_connection_managers
        self.package_connection_managers = package_connection_managers
        self.property_overrides = property_overrides
        self.log_location = log_location


class ExecuteWranglingDataflowActivity(Activity):
    """Execute power query activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param data_flow: Required. Data flow reference.
    :type data_flow: ~azure.mgmt.datafactory.models.DataFlowReference
    :param staging: Staging info for execute data flow activity.
    :type staging: ~azure.mgmt.datafactory.models.DataFlowStagingInfo
    :param integration_runtime: The integration runtime reference.
    :type integration_runtime: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param compute: Compute properties for data flow activity.
    :type compute: ~azure.mgmt.datafactory.models.ExecuteDataFlowActivityTypePropertiesCompute
    :param trace_level: Trace level setting used for data flow monitoring output. Supported values
     are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string).
    :type trace_level: any
    :param continue_on_error: Continue on error setting used for data flow execution. Enables
     processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean).
    :type continue_on_error: any
    :param run_concurrently: Concurrent run setting used for data flow execution. Allows sinks with
     the same save order to be processed concurrently. Type: boolean (or Expression with resultType
     boolean).
    :type run_concurrently: any
    :param sinks: (Deprecated. Please use Queries). List of Power Query activity sinks mapped to a
     queryName.
    :type sinks: dict[str, ~azure.mgmt.datafactory.models.PowerQuerySink]
    :param queries: List of mapping for Power Query mashup query to sink dataset(s).
    :type queries: list[~azure.mgmt.datafactory.models.PowerQuerySinkMapping]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'data_flow': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'data_flow': {'key': 'typeProperties.dataFlow', 'type': 'DataFlowReference'},
        'staging': {'key': 'typeProperties.staging', 'type': 'DataFlowStagingInfo'},
        'integration_runtime': {'key': 'typeProperties.integrationRuntime', 'type': 'IntegrationRuntimeReference'},
        'compute': {'key': 'typeProperties.compute', 'type': 'ExecuteDataFlowActivityTypePropertiesCompute'},
        'trace_level': {'key': 'typeProperties.traceLevel', 'type': 'object'},
        'continue_on_error': {'key': 'typeProperties.continueOnError', 'type': 'object'},
        'run_concurrently': {'key': 'typeProperties.runConcurrently', 'type': 'object'},
        'sinks': {'key': 'typeProperties.sinks', 'type': '{PowerQuerySink}'},
        'queries': {'key': 'typeProperties.queries', 'type': '[PowerQuerySinkMapping]'},
    }

    def __init__(
        self,
        *,
        name: str,
        data_flow: "DataFlowReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        policy: Optional["ActivityPolicy"] = None,
        staging: Optional["DataFlowStagingInfo"] = None,
        integration_runtime: Optional["IntegrationRuntimeReference"] = None,
        compute: Optional["ExecuteDataFlowActivityTypePropertiesCompute"] = None,
        trace_level: Optional[Any] = None,
        continue_on_error: Optional[Any] = None,
        run_concurrently: Optional[Any] = None,
        sinks: Optional[Dict[str, "PowerQuerySink"]] = None,
        queries: Optional[List["PowerQuerySinkMapping"]] = None,
        **kwargs
    ):
        super(ExecuteWranglingDataflowActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'ExecuteWranglingDataflow'  # type: str
        self.policy = policy
        self.data_flow = data_flow
        self.staging = staging
        self.integration_runtime = integration_runtime
        self.compute = compute
        self.trace_level = trace_level
        self.continue_on_error = continue_on_error
        self.run_concurrently = run_concurrently
        self.sinks = sinks
        self.queries = queries


class ExposureControlBatchRequest(msrest.serialization.Model):
    """A list of exposure control features.

    All required parameters must be populated in order to send to Azure.

    :param exposure_control_requests: Required. List of exposure control features.
    :type exposure_control_requests: list[~azure.mgmt.datafactory.models.ExposureControlRequest]
    """

    _validation = {
        'exposure_control_requests': {'required': True},
    }

    _attribute_map = {
        'exposure_control_requests': {'key': 'exposureControlRequests', 'type': '[ExposureControlRequest]'},
    }

    def __init__(
        self,
        *,
        exposure_control_requests: List["ExposureControlRequest"],
        **kwargs
    ):
        super(ExposureControlBatchRequest, self).__init__(**kwargs)
        self.exposure_control_requests = exposure_control_requests


class ExposureControlBatchResponse(msrest.serialization.Model):
    """A list of exposure control feature values.

    All required parameters must be populated in order to send to Azure.

    :param exposure_control_responses: Required. List of exposure control feature values.
    :type exposure_control_responses: list[~azure.mgmt.datafactory.models.ExposureControlResponse]
    """

    _validation = {
        'exposure_control_responses': {'required': True},
    }

    _attribute_map = {
        'exposure_control_responses': {'key': 'exposureControlResponses', 'type': '[ExposureControlResponse]'},
    }

    def __init__(
        self,
        *,
        exposure_control_responses: List["ExposureControlResponse"],
        **kwargs
    ):
        super(ExposureControlBatchResponse, self).__init__(**kwargs)
        self.exposure_control_responses = exposure_control_responses


class ExposureControlRequest(msrest.serialization.Model):
    """The exposure control request.

    :param feature_name: The feature name.
    :type feature_name: str
    :param feature_type: The feature type.
    :type feature_type: str
    """

    _attribute_map = {
        'feature_name': {'key': 'featureName', 'type': 'str'},
        'feature_type': {'key': 'featureType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        feature_name: Optional[str] = None,
        feature_type: Optional[str] = None,
        **kwargs
    ):
        super(ExposureControlRequest, self).__init__(**kwargs)
        self.feature_name = feature_name
        self.feature_type = feature_type


class ExposureControlResponse(msrest.serialization.Model):
    """The exposure control response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar feature_name: The feature name.
    :vartype feature_name: str
    :ivar value: The feature value.
    :vartype value: str
    """

    _validation = {
        'feature_name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'feature_name': {'key': 'featureName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExposureControlResponse, self).__init__(**kwargs)
        self.feature_name = None
        self.value = None


class Expression(msrest.serialization.Model):
    """Azure Data Factory expression definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Expression type. Has constant value: "Expression".
    :vartype type: str
    :param value: Required. Expression value.
    :type value: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    type = "Expression"

    def __init__(
        self,
        *,
        value: str,
        **kwargs
    ):
        super(Expression, self).__init__(**kwargs)
        self.value = value


class Resource(msrest.serialization.Model):
    """Azure Data Factory top-level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :ivar e_tag: Etag identifies change in the resource.
    :vartype e_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'e_tag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.e_tag = None


class Factory(Resource):
    """Factory resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :ivar e_tag: Etag identifies change in the resource.
    :vartype e_tag: str
    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param identity: Managed service identity of the factory.
    :type identity: ~azure.mgmt.datafactory.models.FactoryIdentity
    :ivar provisioning_state: Factory provisioning state, example Succeeded.
    :vartype provisioning_state: str
    :ivar create_time: Time the factory was created in ISO8601 format.
    :vartype create_time: ~datetime.datetime
    :ivar version: Version of the factory.
    :vartype version: str
    :param repo_configuration: Git repo information of the factory.
    :type repo_configuration: ~azure.mgmt.datafactory.models.FactoryRepoConfiguration
    :param global_parameters: List of parameters for factory.
    :type global_parameters: dict[str, ~azure.mgmt.datafactory.models.GlobalParameterSpecification]
    :param encryption: Properties to enable Customer Managed Key for the factory.
    :type encryption: ~azure.mgmt.datafactory.models.EncryptionConfiguration
    :param public_network_access: Whether or not public network access is allowed for the data
     factory. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.datafactory.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'e_tag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'create_time': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'additional_properties': {'key': '', 'type': '{object}'},
        'identity': {'key': 'identity', 'type': 'FactoryIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'repo_configuration': {'key': 'properties.repoConfiguration', 'type': 'FactoryRepoConfiguration'},
        'global_parameters': {'key': 'properties.globalParameters', 'type': '{GlobalParameterSpecification}'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionConfiguration'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        additional_properties: Optional[Dict[str, Any]] = None,
        identity: Optional["FactoryIdentity"] = None,
        repo_configuration: Optional["FactoryRepoConfiguration"] = None,
        global_parameters: Optional[Dict[str, "GlobalParameterSpecification"]] = None,
        encryption: Optional["EncryptionConfiguration"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(Factory, self).__init__(location=location, tags=tags, **kwargs)
        self.additional_properties = additional_properties
        self.identity = identity
        self.provisioning_state = None
        self.create_time = None
        self.version = None
        self.repo_configuration = repo_configuration
        self.global_parameters = global_parameters
        self.encryption = encryption
        self.public_network_access = public_network_access


class FactoryRepoConfiguration(msrest.serialization.Model):
    """Factory's git repo information.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FactoryGitHubConfiguration, FactoryVSTSConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of repo configuration.Constant filled by server.
    :type type: str
    :param account_name: Required. Account name.
    :type account_name: str
    :param repository_name: Required. Repository name.
    :type repository_name: str
    :param collaboration_branch: Required. Collaboration branch.
    :type collaboration_branch: str
    :param root_folder: Required. Root folder.
    :type root_folder: str
    :param last_commit_id: Last commit id.
    :type last_commit_id: str
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'repository_name': {'required': True},
        'collaboration_branch': {'required': True},
        'root_folder': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'collaboration_branch': {'key': 'collaborationBranch', 'type': 'str'},
        'root_folder': {'key': 'rootFolder', 'type': 'str'},
        'last_commit_id': {'key': 'lastCommitId', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'FactoryGitHubConfiguration': 'FactoryGitHubConfiguration', 'FactoryVSTSConfiguration': 'FactoryVSTSConfiguration'}
    }

    def __init__(
        self,
        *,
        account_name: str,
        repository_name: str,
        collaboration_branch: str,
        root_folder: str,
        last_commit_id: Optional[str] = None,
        **kwargs
    ):
        super(FactoryRepoConfiguration, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.account_name = account_name
        self.repository_name = repository_name
        self.collaboration_branch = collaboration_branch
        self.root_folder = root_folder
        self.last_commit_id = last_commit_id


class FactoryGitHubConfiguration(FactoryRepoConfiguration):
    """Factory's GitHub repo information.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of repo configuration.Constant filled by server.
    :type type: str
    :param account_name: Required. Account name.
    :type account_name: str
    :param repository_name: Required. Repository name.
    :type repository_name: str
    :param collaboration_branch: Required. Collaboration branch.
    :type collaboration_branch: str
    :param root_folder: Required. Root folder.
    :type root_folder: str
    :param last_commit_id: Last commit id.
    :type last_commit_id: str
    :param host_name: GitHub Enterprise host name. For example: https://github.mydomain.com.
    :type host_name: str
    :param client_id: GitHub bring your own app client id.
    :type client_id: str
    :param client_secret: GitHub bring your own app client secret information.
    :type client_secret: ~azure.mgmt.datafactory.models.GitHubClientSecret
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'repository_name': {'required': True},
        'collaboration_branch': {'required': True},
        'root_folder': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'collaboration_branch': {'key': 'collaborationBranch', 'type': 'str'},
        'root_folder': {'key': 'rootFolder', 'type': 'str'},
        'last_commit_id': {'key': 'lastCommitId', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'GitHubClientSecret'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        repository_name: str,
        collaboration_branch: str,
        root_folder: str,
        last_commit_id: Optional[str] = None,
        host_name: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional["GitHubClientSecret"] = None,
        **kwargs
    ):
        super(FactoryGitHubConfiguration, self).__init__(account_name=account_name, repository_name=repository_name, collaboration_branch=collaboration_branch, root_folder=root_folder, last_commit_id=last_commit_id, **kwargs)
        self.type = 'FactoryGitHubConfiguration'  # type: str
        self.host_name = host_name
        self.client_id = client_id
        self.client_secret = client_secret


class FactoryIdentity(msrest.serialization.Model):
    """Identity properties of the factory resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The identity type. Possible values include: "SystemAssigned",
     "UserAssigned", "SystemAssigned,UserAssigned".
    :type type: str or ~azure.mgmt.datafactory.models.FactoryIdentityType
    :ivar principal_id: The principal id of the identity.
    :vartype principal_id: str
    :ivar tenant_id: The client tenant id of the identity.
    :vartype tenant_id: str
    :param user_assigned_identities: List of user assigned identities for the factory.
    :type user_assigned_identities: dict[str, any]
    """

    _validation = {
        'type': {'required': True},
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "FactoryIdentityType"],
        user_assigned_identities: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(FactoryIdentity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None
        self.user_assigned_identities = user_assigned_identities


class FactoryListResponse(msrest.serialization.Model):
    """A list of factory resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of factories.
    :type value: list[~azure.mgmt.datafactory.models.Factory]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Factory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Factory"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(FactoryListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FactoryRepoUpdate(msrest.serialization.Model):
    """Factory's git repo information.

    :param factory_resource_id: The factory resource id.
    :type factory_resource_id: str
    :param repo_configuration: Git repo information of the factory.
    :type repo_configuration: ~azure.mgmt.datafactory.models.FactoryRepoConfiguration
    """

    _attribute_map = {
        'factory_resource_id': {'key': 'factoryResourceId', 'type': 'str'},
        'repo_configuration': {'key': 'repoConfiguration', 'type': 'FactoryRepoConfiguration'},
    }

    def __init__(
        self,
        *,
        factory_resource_id: Optional[str] = None,
        repo_configuration: Optional["FactoryRepoConfiguration"] = None,
        **kwargs
    ):
        super(FactoryRepoUpdate, self).__init__(**kwargs)
        self.factory_resource_id = factory_resource_id
        self.repo_configuration = repo_configuration


class FactoryUpdateParameters(msrest.serialization.Model):
    """Parameters for updating a factory resource.

    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param identity: Managed service identity of the factory.
    :type identity: ~azure.mgmt.datafactory.models.FactoryIdentity
    :param public_network_access: Whether or not public network access is allowed for the data
     factory. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.datafactory.models.PublicNetworkAccess
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'FactoryIdentity'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["FactoryIdentity"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(FactoryUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.public_network_access = public_network_access


class FactoryVSTSConfiguration(FactoryRepoConfiguration):
    """Factory's VSTS repo information.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of repo configuration.Constant filled by server.
    :type type: str
    :param account_name: Required. Account name.
    :type account_name: str
    :param repository_name: Required. Repository name.
    :type repository_name: str
    :param collaboration_branch: Required. Collaboration branch.
    :type collaboration_branch: str
    :param root_folder: Required. Root folder.
    :type root_folder: str
    :param last_commit_id: Last commit id.
    :type last_commit_id: str
    :param project_name: Required. VSTS project name.
    :type project_name: str
    :param tenant_id: VSTS tenant id.
    :type tenant_id: str
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'repository_name': {'required': True},
        'collaboration_branch': {'required': True},
        'root_folder': {'required': True},
        'project_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'collaboration_branch': {'key': 'collaborationBranch', 'type': 'str'},
        'root_folder': {'key': 'rootFolder', 'type': 'str'},
        'last_commit_id': {'key': 'lastCommitId', 'type': 'str'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        repository_name: str,
        collaboration_branch: str,
        root_folder: str,
        project_name: str,
        last_commit_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        super(FactoryVSTSConfiguration, self).__init__(account_name=account_name, repository_name=repository_name, collaboration_branch=collaboration_branch, root_folder=root_folder, last_commit_id=last_commit_id, **kwargs)
        self.type = 'FactoryVSTSConfiguration'  # type: str
        self.project_name = project_name
        self.tenant_id = tenant_id


class FileServerLinkedService(LinkedService):
    """File system linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param host: Required. Host name of the server. Type: string (or Expression with resultType
     string).
    :type host: any
    :param user_id: User ID to logon the server. Type: string (or Expression with resultType
     string).
    :type user_id: any
    :param password: Password to logon the server.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'user_id': {'key': 'typeProperties.userId', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        user_id: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(FileServerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'FileServer'  # type: str
        self.host = host
        self.user_id = user_id
        self.password = password
        self.encrypted_credential = encrypted_credential


class FileServerLocation(DatasetLocation):
    """The location of file server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        **kwargs
    ):
        super(FileServerLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'FileServerLocation'  # type: str


class FileServerReadSettings(StoreReadSettings):
    """File server read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param wildcard_folder_path: FileServer wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: any
    :param wildcard_file_name: FileServer wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: any
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: any
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: any
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: any
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: any
    :param file_filter: Specify a filter to be used to select a subset of files in the folderPath
     rather than all files. Type: string (or Expression with resultType string).
    :type file_filter: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
        'file_filter': {'key': 'fileFilter', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        wildcard_folder_path: Optional[Any] = None,
        wildcard_file_name: Optional[Any] = None,
        file_list_path: Optional[Any] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[Any] = None,
        delete_files_after_completion: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        file_filter: Optional[Any] = None,
        **kwargs
    ):
        super(FileServerReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'FileServerReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.file_filter = file_filter


class FileServerWriteSettings(StoreWriteSettings):
    """File server write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        copy_behavior: Optional[Any] = None,
        **kwargs
    ):
        super(FileServerWriteSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, copy_behavior=copy_behavior, **kwargs)
        self.type = 'FileServerWriteSettings'  # type: str


class FileShareDataset(Dataset):
    """An on-premises file system dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param folder_path: The path of the on-premises file system. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: The name of the on-premises file system. Type: string (or Expression with
     resultType string).
    :type file_name: any
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: any
    :param format: The format of the files.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param file_filter: Specify a filter to be used to select a subset of files in the folderPath
     rather than all files. Type: string (or Expression with resultType string).
    :type file_filter: any
    :param compression: The data compression method used for the file system.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'file_name': {'key': 'typeProperties.fileName', 'type': 'object'},
        'modified_datetime_start': {'key': 'typeProperties.modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'typeProperties.modifiedDatetimeEnd', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'file_filter': {'key': 'typeProperties.fileFilter', 'type': 'object'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        format: Optional["DatasetStorageFormat"] = None,
        file_filter: Optional[Any] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(FileShareDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'FileShare'  # type: str
        self.folder_path = folder_path
        self.file_name = file_name
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.format = format
        self.file_filter = file_filter
        self.compression = compression


class FileSystemSink(CopySink):
    """A copy activity file system sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: any
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: any
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: any
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        write_batch_size: Optional[Any] = None,
        write_batch_timeout: Optional[Any] = None,
        sink_retry_count: Optional[Any] = None,
        sink_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        copy_behavior: Optional[Any] = None,
        **kwargs
    ):
        super(FileSystemSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'FileSystemSink'  # type: str
        self.copy_behavior = copy_behavior


class FileSystemSource(CopySource):
    """A copy activity file system source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        **kwargs
    ):
        super(FileSystemSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'FileSystemSource'  # type: str
        self.recursive = recursive
        self.additional_columns = additional_columns


class FilterActivity(ControlActivity):
    """Filter and return results from input array based on the conditions.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param items: Required. Input array on which filter should be applied.
    :type items: ~azure.mgmt.datafactory.models.Expression
    :param condition: Required. Condition to be used for filtering the input.
    :type condition: ~azure.mgmt.datafactory.models.Expression
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'items': {'required': True},
        'condition': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'items': {'key': 'typeProperties.items', 'type': 'Expression'},
        'condition': {'key': 'typeProperties.condition', 'type': 'Expression'},
    }

    def __init__(
        self,
        *,
        name: str,
        items: "Expression",
        condition: "Expression",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        **kwargs
    ):
        super(FilterActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'Filter'  # type: str
        self.items = items
        self.condition = condition


class ForEachActivity(ControlActivity):
    """This activity is used for iterating over a collection and execute given activities.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param is_sequential: Should the loop be executed in sequence or in parallel (max 50).
    :type is_sequential: bool
    :param batch_count: Batch count to be used for controlling the number of parallel execution
     (when isSequential is set to false).
    :type batch_count: int
    :param items: Required. Collection to iterate.
    :type items: ~azure.mgmt.datafactory.models.Expression
    :param activities: Required. List of activities to execute .
    :type activities: list[~azure.mgmt.datafactory.models.Activity]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'batch_count': {'maximum': 50},
        'items': {'required': True},
        'activities': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'is_sequential': {'key': 'typeProperties.isSequential', 'type': 'bool'},
        'batch_count': {'key': 'typeProperties.batchCount', 'type': 'int'},
        'items': {'key': 'typeProperties.items', 'type': 'Expression'},
        'activities': {'key': 'typeProperties.activities', 'type': '[Activity]'},
    }

    def __init__(
        self,
        *,
        name: str,
        items: "Expression",
        activities: List["Activity"],
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        is_sequential: Optional[bool] = None,
        batch_count: Optional[int] = None,
        **kwargs
    ):
        super(ForEachActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'ForEach'  # type: str
        self.is_sequential = is_sequential
        self.batch_count = batch_count
        self.items = items
        self.activities = activities


class FtpReadSettings(StoreReadSettings):
    """Ftp read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param wildcard_folder_path: Ftp wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: any
    :param wildcard_file_name: Ftp wildcardFileName. Type: string (or Expression with resultType
     string).
    :type wildcard_file_name: any
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: any
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: any
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: any
    :param use_binary_transfer: Specify whether to use binary transfer mode for FTP stores.
    :type use_binary_transfer: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'use_binary_transfer': {'key': 'useBinaryTransfer', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        wildcard_folder_path: Optional[Any] = None,
        wildcard_file_name: Optional[Any] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[Any] = None,
        delete_files_after_completion: Optional[Any] = None,
        file_list_path: Optional[Any] = None,
        use_binary_transfer: Optional[bool] = None,
        **kwargs
    ):
        super(FtpReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'FtpReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.file_list_path = file_list_path
        self.use_binary_transfer = use_binary_transfer


class FtpServerLinkedService(LinkedService):
    """A FTP server Linked Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param host: Required. Host name of the FTP server. Type: string (or Expression with resultType
     string).
    :type host: any
    :param port: The TCP port number that the FTP server uses to listen for client connections.
     Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
    :type port: any
    :param authentication_type: The authentication type to be used to connect to the FTP server.
     Possible values include: "Basic", "Anonymous".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.FtpAuthenticationType
    :param user_name: Username to logon the FTP server. Type: string (or Expression with resultType
     string).
    :type user_name: any
    :param password: Password to logon the FTP server.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param enable_ssl: If true, connect to the FTP server over SSL/TLS channel. Default value is
     true. Type: boolean (or Expression with resultType boolean).
    :type enable_ssl: any
    :param enable_server_certificate_validation: If true, validate the FTP server SSL certificate
     when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with
     resultType boolean).
    :type enable_server_certificate_validation: any
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'enable_server_certificate_validation': {'key': 'typeProperties.enableServerCertificateValidation', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        port: Optional[Any] = None,
        authentication_type: Optional[Union[str, "FtpAuthenticationType"]] = None,
        user_name: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[Any] = None,
        enable_ssl: Optional[Any] = None,
        enable_server_certificate_validation: Optional[Any] = None,
        **kwargs
    ):
        super(FtpServerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'FtpServer'  # type: str
        self.host = host
        self.port = port
        self.authentication_type = authentication_type
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential
        self.enable_ssl = enable_ssl
        self.enable_server_certificate_validation = enable_server_certificate_validation


class FtpServerLocation(DatasetLocation):
    """The location of ftp server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        **kwargs
    ):
        super(FtpServerLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'FtpServerLocation'  # type: str


class GetDataFactoryOperationStatusResponse(msrest.serialization.Model):
    """Response body structure for get data factory operation status.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param status: Status of the operation.
    :type status: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(GetDataFactoryOperationStatusResponse, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.status = status


class GetMetadataActivity(ExecutionActivity):
    """Activity to get metadata of dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param dataset: Required. GetMetadata activity dataset reference.
    :type dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :param field_list: Fields of metadata to get from dataset.
    :type field_list: list[any]
    :param store_settings: GetMetadata activity store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :param format_settings: GetMetadata activity format settings.
    :type format_settings: ~azure.mgmt.datafactory.models.FormatReadSettings
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
        'field_list': {'key': 'typeProperties.fieldList', 'type': '[object]'},
        'store_settings': {'key': 'typeProperties.storeSettings', 'type': 'StoreReadSettings'},
        'format_settings': {'key': 'typeProperties.formatSettings', 'type': 'FormatReadSettings'},
    }

    def __init__(
        self,
        *,
        name: str,
        dataset: "DatasetReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        field_list: Optional[List[Any]] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        format_settings: Optional["FormatReadSettings"] = None,
        **kwargs
    ):
        super(GetMetadataActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'GetMetadata'  # type: str
        self.dataset = dataset
        self.field_list = field_list
        self.store_settings = store_settings
        self.format_settings = format_settings


class GetSsisObjectMetadataRequest(msrest.serialization.Model):
    """The request payload of get SSIS object metadata.

    :param metadata_path: Metadata path.
    :type metadata_path: str
    """

    _attribute_map = {
        'metadata_path': {'key': 'metadataPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metadata_path: Optional[str] = None,
        **kwargs
    ):
        super(GetSsisObjectMetadataRequest, self).__init__(**kwargs)
        self.metadata_path = metadata_path


class GitHubAccessTokenRequest(msrest.serialization.Model):
    """Get GitHub access token request definition.

    All required parameters must be populated in order to send to Azure.

    :param git_hub_access_code: Required. GitHub access code.
    :type git_hub_access_code: str
    :param git_hub_client_id: GitHub application client ID.
    :type git_hub_client_id: str
    :param git_hub_client_secret: GitHub bring your own app client secret information.
    :type git_hub_client_secret: ~azure.mgmt.datafactory.models.GitHubClientSecret
    :param git_hub_access_token_base_url: Required. GitHub access token base URL.
    :type git_hub_access_token_base_url: str
    """

    _validation = {
        'git_hub_access_code': {'required': True},
        'git_hub_access_token_base_url': {'required': True},
    }

    _attribute_map = {
        'git_hub_access_code': {'key': 'gitHubAccessCode', 'type': 'str'},
        'git_hub_client_id': {'key': 'gitHubClientId', 'type': 'str'},
        'git_hub_client_secret': {'key': 'gitHubClientSecret', 'type': 'GitHubClientSecret'},
        'git_hub_access_token_base_url': {'key': 'gitHubAccessTokenBaseUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        git_hub_access_code: str,
        git_hub_access_token_base_url: str,
        git_hub_client_id: Optional[str] = None,
        git_hub_client_secret: Optional["GitHubClientSecret"] = None,
        **kwargs
    ):
        super(GitHubAccessTokenRequest, self).__init__(**kwargs)
        self.git_hub_access_code = git_hub_access_code
        self.git_hub_client_id = git_hub_client_id
        self.git_hub_client_secret = git_hub_client_secret
        self.git_hub_access_token_base_url = git_hub_access_token_base_url


class GitHubAccessTokenResponse(msrest.serialization.Model):
    """Get GitHub access token response definition.

    :param git_hub_access_token: GitHub access token.
    :type git_hub_access_token: str
    """

    _attribute_map = {
        'git_hub_access_token': {'key': 'gitHubAccessToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        git_hub_access_token: Optional[str] = None,
        **kwargs
    ):
        super(GitHubAccessTokenResponse, self).__init__(**kwargs)
        self.git_hub_access_token = git_hub_access_token


class GitHubClientSecret(msrest.serialization.Model):
    """Client secret information for factory's bring your own app repository configuration.

    :param byoa_secret_akv_url: Bring your own app client secret AKV URL.
    :type byoa_secret_akv_url: str
    :param byoa_secret_name: Bring your own app client secret name in AKV.
    :type byoa_secret_name: str
    """

    _attribute_map = {
        'byoa_secret_akv_url': {'key': 'byoaSecretAkvUrl', 'type': 'str'},
        'byoa_secret_name': {'key': 'byoaSecretName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        byoa_secret_akv_url: Optional[str] = None,
        byoa_secret_name: Optional[str] = None,
        **kwargs
    ):
        super(GitHubClientSecret, self).__init__(**kwargs)
        self.byoa_secret_akv_url = byoa_secret_akv_url
        self.byoa_secret_name = byoa_secret_name


class GlobalParameterSpecification(msrest.serialization.Model):
    """Definition of a single parameter for an entity.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Global Parameter type. Possible values include: "Object", "String",
     "Int", "Float", "Bool", "Array".
    :type type: str or ~azure.mgmt.datafactory.models.GlobalParameterType
    :param value: Required. Value of parameter.
    :type value: any
    """

    _validation = {
        'type': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "GlobalParameterType"],
        value: Any,
        **kwargs
    ):
        super(GlobalParameterSpecification, self).__init__(**kwargs)
        self.type = type
        self.value = value


class GoogleAdWordsLinkedService(LinkedService):
    """Google AdWords service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param client_customer_id: Required. The Client customer ID of the AdWords account that you
     want to fetch report data for.
    :type client_customer_id: any
    :param developer_token: Required. The developer token associated with the manager account that
     you use to grant access to the AdWords API.
    :type developer_token: ~azure.mgmt.datafactory.models.SecretBase
    :param authentication_type: Required. The OAuth 2.0 authentication mechanism used for
     authentication. ServiceAuthentication can only be used on self-hosted IR. Possible values
     include: "ServiceAuthentication", "UserAuthentication".
    :type authentication_type: str or
     ~azure.mgmt.datafactory.models.GoogleAdWordsAuthenticationType
    :param refresh_token: The refresh token obtained from Google for authorizing access to AdWords
     for UserAuthentication.
    :type refresh_token: ~azure.mgmt.datafactory.models.SecretBase
    :param client_id: The client id of the google application used to acquire the refresh token.
     Type: string (or Expression with resultType string).
    :type client_id: any
    :param client_secret: The client secret of the google application used to acquire the refresh
     token.
    :type client_secret: ~azure.mgmt.datafactory.models.SecretBase
    :param email: The service account email ID that is used for ServiceAuthentication and can only
     be used on self-hosted IR.
    :type email: any
    :param key_file_path: The full path to the .p12 key file that is used to authenticate the
     service account email address and can only be used on self-hosted IR.
    :type key_file_path: any
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: any
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'client_customer_id': {'required': True},
        'developer_token': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'client_customer_id': {'key': 'typeProperties.clientCustomerID', 'type': 'object'},
        'developer_token': {'key': 'typeProperties.developerToken', 'type': 'SecretBase'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'refresh_token': {'key': 'typeProperties.refreshToken', 'type': 'SecretBase'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'email': {'key': 'typeProperties.email', 'type': 'object'},
        'key_file_path': {'key': 'typeProperties.keyFilePath', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        client_customer_id: Any,
        developer_token: "SecretBase",
        authentication_type: Union[str, "GoogleAdWordsAuthenticationType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        refresh_token: Optional["SecretBase"] = None,
        client_id: Optional[Any] = None,
        client_secret: Optional["SecretBase"] = None,
        email: Optional[Any] = None,
        key_file_path: Optional[Any] = None,
        trusted_cert_path: Optional[Any] = None,
        use_system_trust_store: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(GoogleAdWordsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'GoogleAdWords'  # type: str
        self.client_customer_id = client_customer_id
        self.developer_token = developer_token
        self.authentication_type = authentication_type
        self.refresh_token = refresh_token
        self.client_id = client_id
        self.client_secret = client_secret
        self.email = email
        self.key_file_path = key_file_path
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.encrypted_credential = encrypted_credential


class GoogleAdWordsObjectDataset(Dataset):
    """Google AdWords service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        **kwargs
    ):
        super(GoogleAdWordsObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'GoogleAdWordsObject'  # type: str
        self.table_name = table_name


class GoogleAdWordsSource(TabularSource):
    """A copy activity Google AdWords service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(GoogleAdWordsSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'GoogleAdWordsSource'  # type: str
        self.query = query


class GoogleBigQueryLinkedService(LinkedService):
    """Google BigQuery service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param project: Required. The default BigQuery project to query against.
    :type project: any
    :param additional_projects: A comma-separated list of public BigQuery projects to access.
    :type additional_projects: any
    :param request_google_drive_scope: Whether to request access to Google Drive. Allowing Google
     Drive access enables support for federated tables that combine BigQuery data with data from
     Google Drive. The default value is false.
    :type request_google_drive_scope: any
    :param authentication_type: Required. The OAuth 2.0 authentication mechanism used for
     authentication. ServiceAuthentication can only be used on self-hosted IR. Possible values
     include: "ServiceAuthentication", "UserAuthentication".
    :type authentication_type: str or
     ~azure.mgmt.datafactory.models.GoogleBigQueryAuthenticationType
    :param refresh_token: The refresh token obtained from Google for authorizing access to BigQuery
     for UserAuthentication.
    :type refresh_token: ~azure.mgmt.datafactory.models.SecretBase
    :param client_id: The client id of the google application used to acquire the refresh token.
     Type: string (or Expression with resultType string).
    :type client_id: any
    :param client_secret: The client secret of the google application used to acquire the refresh
     token.
    :type client_secret: ~azure.mgmt.datafactory.models.SecretBase
    :param email: The service account email ID that is used for ServiceAuthentication and can only
     be used on self-hosted IR.
    :type email: any
    :param key_file_path: The full path to the .p12 key file that is used to authenticate the
     service account email address and can only be used on self-hosted IR.
    :type key_file_path: any
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: any
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'project': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'project': {'key': 'typeProperties.project', 'type': 'object'},
        'additional_projects': {'key': 'typeProperties.additionalProjects', 'type': 'object'},
        'request_google_drive_scope': {'key': 'typeProperties.requestGoogleDriveScope', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'refresh_token': {'key': 'typeProperties.refreshToken', 'type': 'SecretBase'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'email': {'key': 'typeProperties.email', 'type': 'object'},
        'key_file_path': {'key': 'typeProperties.keyFilePath', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        project: Any,
        authentication_type: Union[str, "GoogleBigQueryAuthenticationType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        additional_projects: Optional[Any] = None,
        request_google_drive_scope: Optional[Any] = None,
        refresh_token: Optional["SecretBase"] = None,
        client_id: Optional[Any] = None,
        client_secret: Optional["SecretBase"] = None,
        email: Optional[Any] = None,
        key_file_path: Optional[Any] = None,
        trusted_cert_path: Optional[Any] = None,
        use_system_trust_store: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(GoogleBigQueryLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'GoogleBigQuery'  # type: str
        self.project = project
        self.additional_projects = additional_projects
        self.request_google_drive_scope = request_google_drive_scope
        self.authentication_type = authentication_type
        self.refresh_token = refresh_token
        self.client_id = client_id
        self.client_secret = client_secret
        self.email = email
        self.key_file_path = key_file_path
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.encrypted_credential = encrypted_credential


class GoogleBigQueryObjectDataset(Dataset):
    """Google BigQuery service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using database + table
     properties instead.
    :type table_name: any
    :param table: The table name of the Google BigQuery. Type: string (or Expression with
     resultType string).
    :type table: any
    :param dataset: The database name of the Google BigQuery. Type: string (or Expression with
     resultType string).
    :type dataset: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        table: Optional[Any] = None,
        dataset: Optional[Any] = None,
        **kwargs
    ):
        super(GoogleBigQueryObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'GoogleBigQueryObject'  # type: str
        self.table_name = table_name
        self.table = table
        self.dataset = dataset


class GoogleBigQuerySource(TabularSource):
    """A copy activity Google BigQuery service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(GoogleBigQuerySource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'GoogleBigQuerySource'  # type: str
        self.query = query


class GoogleCloudStorageLinkedService(LinkedService):
    """Linked service for Google Cloud Storage.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param access_key_id: The access key identifier of the Google Cloud Storage Identity and Access
     Management (IAM) user. Type: string (or Expression with resultType string).
    :type access_key_id: any
    :param secret_access_key: The secret access key of the Google Cloud Storage Identity and Access
     Management (IAM) user.
    :type secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the Google Cloud Storage
     Connector. This is an optional property; change it only if you want to try a different service
     endpoint or want to switch between https and http. Type: string (or Expression with resultType
     string).
    :type service_url: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        access_key_id: Optional[Any] = None,
        secret_access_key: Optional["SecretBase"] = None,
        service_url: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(GoogleCloudStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'GoogleCloudStorage'  # type: str
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.service_url = service_url
        self.encrypted_credential = encrypted_credential


class GoogleCloudStorageLocation(DatasetLocation):
    """The location of Google Cloud Storage dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    :param bucket_name: Specify the bucketName of Google Cloud Storage. Type: string (or Expression
     with resultType string).
    :type bucket_name: any
    :param version: Specify the version of Google Cloud Storage. Type: string (or Expression with
     resultType string).
    :type version: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'bucket_name': {'key': 'bucketName', 'type': 'object'},
        'version': {'key': 'version', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        bucket_name: Optional[Any] = None,
        version: Optional[Any] = None,
        **kwargs
    ):
        super(GoogleCloudStorageLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'GoogleCloudStorageLocation'  # type: str
        self.bucket_name = bucket_name
        self.version = version


class GoogleCloudStorageReadSettings(StoreReadSettings):
    """Google Cloud Storage read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param wildcard_folder_path: Google Cloud Storage wildcardFolderPath. Type: string (or
     Expression with resultType string).
    :type wildcard_folder_path: any
    :param wildcard_file_name: Google Cloud Storage wildcardFileName. Type: string (or Expression
     with resultType string).
    :type wildcard_file_name: any
    :param prefix: The prefix filter for the Google Cloud Storage object name. Type: string (or
     Expression with resultType string).
    :type prefix: any
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: any
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: any
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: any
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        wildcard_folder_path: Optional[Any] = None,
        wildcard_file_name: Optional[Any] = None,
        prefix: Optional[Any] = None,
        file_list_path: Optional[Any] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[Any] = None,
        delete_files_after_completion: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        **kwargs
    ):
        super(GoogleCloudStorageReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'GoogleCloudStorageReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class GreenplumLinkedService(LinkedService):
    """Greenplum Database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: any
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        connection_string: Optional[Any] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(GreenplumLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Greenplum'  # type: str
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class GreenplumSource(TabularSource):
    """A copy activity Greenplum Database source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(GreenplumSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'GreenplumSource'  # type: str
        self.query = query


class GreenplumTableDataset(Dataset):
    """Greenplum Database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: any
    :param table: The table name of Greenplum. Type: string (or Expression with resultType string).
    :type table: any
    :param schema_type_properties_schema: The schema name of Greenplum. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        table: Optional[Any] = None,
        schema_type_properties_schema: Optional[Any] = None,
        **kwargs
    ):
        super(GreenplumTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'GreenplumTable'  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class HBaseLinkedService(LinkedService):
    """HBase server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param host: Required. The IP address or host name of the HBase server. (i.e. 192.168.222.160).
    :type host: any
    :param port: The TCP port that the HBase instance uses to listen for client connections. The
     default value is 9090.
    :type port: any
    :param http_path: The partial URL corresponding to the HBase server. (i.e.
     /gateway/sandbox/hbase/version).
    :type http_path: any
    :param authentication_type: Required. The authentication mechanism to use to connect to the
     HBase server. Possible values include: "Anonymous", "Basic".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.HBaseAuthenticationType
    :param username: The user name used to connect to the HBase instance.
    :type username: any
    :param password: The password corresponding to the user name.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: any
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: any
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: any
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'http_path': {'key': 'typeProperties.httpPath', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: Any,
        authentication_type: Union[str, "HBaseAuthenticationType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        port: Optional[Any] = None,
        http_path: Optional[Any] = None,
        username: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        enable_ssl: Optional[Any] = None,
        trusted_cert_path: Optional[Any] = None,
        allow_host_name_cn_mismatch: Optional[Any] = None,
        allow_self_signed_server_cert: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        **kwargs
    ):
        super(HBaseLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'HBase'  # type: str
        self.host = host
        self.port = port
        self.http_path = http_path
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.enable_ssl = enable_ssl
        self.trusted_cert_path = trusted_cert_path
        self.allow_host_name_cn_mismatch = allow_host_name_cn_mismatch
        self.allow_self_signed_server_cert = allow_self_signed_server_cert
        self.encrypted_credential = encrypted_credential


class HBaseObjectDataset(Dataset):
    """HBase server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: any
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: any
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[any]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: any
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        structure: Optional[Any] = None,
        schema: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[Any] = None,
        **kwargs
    ):
        super(HBaseObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'HBaseObject'  # type: str
        self.table_name = table_name


class HBaseSource(TabularSource):
    """A copy activity HBase server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: any
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :type additional_columns: any
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        query_timeout: Optional[Any] = None,
        additional_columns: Optional[Any] = None,
        query: Optional[Any] = None,
        **kwargs
    ):
        super(HBaseSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'HBaseSource'  # type: str
        self.query = query


class HdfsLinkedService(LinkedService):
    """Hadoop Distributed File System (HDFS) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[any]
    :param url: Required. The URL of the HDFS service endpoint, e.g.
     http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with resultType string).
    :type url: any
    :param authentication_type: Type of authentication used to connect to the HDFS. Possible values
     are: Anonymous and Windows. Type: string (or Expression with resultType string).
    :type authentication_type: any
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: any
    :param user_name: User name for Windows authentication. Type: string (or Expression with
     resultType string).
    :type user_name: any
    :param password: Password for Windows authentication.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
    }

    def __init__(
        self,
        *,
        url: Any,
        additional_properties: Optional[Dict[str, Any]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[Any]] = None,
        authentication_type: Optional[Any] = None,
        encrypted_credential: Optional[Any] = None,
        user_name: Optional[Any] = None,
        password: Optional["SecretBase"] = None,
        **kwargs
    ):
        super(HdfsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Hdfs'  # type: str
        self.url = url
        self.authentication_type = authentication_type
        self.encrypted_credential = encrypted_credential
        self.user_name = user_name
        self.password = password


class HdfsLocation(DatasetLocation):
    """The location of HDFS.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: any
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        folder_path: Optional[Any] = None,
        file_name: Optional[Any] = None,
        **kwargs
    ):
        super(HdfsLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'HdfsLocation'  # type: str


class HdfsReadSettings(StoreReadSettings):
    """HDFS read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param wildcard_folder_path: HDFS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: any
    :param wildcard_file_name: HDFS wildcardFileName. Type: string (or Expression with resultType
     string).
    :type wildcard_file_name: any
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: any
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: any
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: any
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: any
    :param distcp_settings: Specifies Distcp-related settings.
    :type distcp_settings: ~azure.mgmt.datafactory.models.DistcpSettings
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
        'distcp_settings': {'key': 'distcpSettings', 'type': 'DistcpSettings'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        wildcard_folder_path: Optional[Any] = None,
        wildcard_file_name: Optional[Any] = None,
        file_list_path: Optional[Any] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[Any] = None,
        modified_datetime_start: Optional[Any] = None,
        modified_datetime_end: Optional[Any] = None,
        distcp_settings: Optional["DistcpSettings"] = None,
        delete_files_after_completion: Optional[Any] = None,
        **kwargs
    ):
        super(HdfsReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'HdfsReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.distcp_settings = distcp_settings
        self.delete_files_after_completion = delete_files_after_completion


class HdfsSource(CopySource):
    """A copy activity HDFS source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: any
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: any
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: any
    :param disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :type disable_metrics_collection: any
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: any
    :param distcp_settings: Specifies Distcp-related settings.
    :type distcp_settings: ~azure.mgmt.datafactory.models.DistcpSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'disable_metrics_collection': {'key': 'disableMetricsCollection', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'distcp_settings': {'key': 'distcpSettings', 'type': 'DistcpSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        source_retry_count: Optional[Any] = None,
        source_retry_wait: Optional[Any] = None,
        max_concurrent_connections: Optional[Any] = None,
        disable_metrics_collection: Optional[Any] = None,
        recursive: Optional[Any] = None,
        distcp_settings: Optional["DistcpSettings"] = None,
        **kwargs
    ):
        super(HdfsSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, disable_metrics_collection=disable_metrics_collection, **kwargs)
        self.type = 'HdfsSource'  # type: str
        self.recursive = recursive
        self.distcp_settings = distcp_settings


class HDInsightHiveActivity(ExecutionActivity):
    """HDInsight Hive activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity.
    :type arguments: list[any]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.mgmt.datafactory.models.HDInsightActivityDebugInfoOption
    :param script_path: Script path. Type: string (or Expression with resultType string).
    :type script_path: any
    :param script_linked_service: Script linked service reference.
    :type script_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param defines: Allows user to specify defines for Hive job request.
    :type defines: dict[str, any]
    :param variables: User specified arguments under hivevar namespace.
    :type variables: list[any]
    :param query_timeout: Query timeout value (in minutes).  Effective when the HDInsight cluster
     is with ESP (Enterprise Security Package).
    :type query_timeout: int
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
        'variables': {'key': 'typeProperties.variables', 'type': '[object]'},
        'query_timeout': {'key': 'typeProperties.queryTimeout', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        storage_linked_services: Optional[List["LinkedServiceReference"]] = None,
        arguments: Optional[List[Any]] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        script_path: Optional[Any] = None,
        script_linked_service: Optional["LinkedServiceReference"] = None,
        defines: Optional[Dict[str, Any]] = None,
        variables: Optional[List[Any]] = None,
        query_timeout: Optional[int] = None,
        **kwargs
    ):
        super(HDInsightHiveActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'HDInsightHive'  # type: str
        self.storage_linked_services = storage_linked_services
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.script_path = script_path
        self.script_linked_service = script_linked_service
        self.defines = defines
        self.variables = variables
        self.query_timeout = query_timeout


class HDInsightLinkedService(LinkedService):
    "