# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING

from azure.core.rest import HttpRequest
from msrest import Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, List, Optional

_SERIALIZER = Serializer()

# fmt: off

def build_publish_events_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Publishes a batch of events to an Azure Event Grid topic.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder
    into your code flow.

    :keyword json: Pass in a JSON-serializable object (usually a dictionary). See the template in
     our example to find the input shape. An array of events to be published to Event Grid.
    :paramtype json: any
    :keyword content: Pass in binary content you want in the body of the request (typically bytes,
     a byte iterator, or stream input). An array of events to be published to Event Grid.
    :paramtype content: any
    :return: Returns an :class:`~azure.core.rest.HttpRequest` that you will pass to the client's
     `send_request` method. See https://aka.ms/azsdk/python/protocol/quickstart for how to
     incorporate this response into your code flow.
    :rtype: ~azure.core.rest.HttpRequest

    Example:
        .. code-block:: python

            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "data": "any",
                    "dataVersion": "str",
                    "eventTime": "datetime",
                    "eventType": "str",
                    "id": "str",
                    "metadataVersion": "str (optional)",
                    "subject": "str",
                    "topic": "str (optional)"
                }
            ]
    """

    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2018-01-01"
    # Construct URL
    url = kwargs.pop("template_url", '/api/events')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_publish_cloud_event_events_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Publishes a batch of events to an Azure Event Grid topic.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder
    into your code flow.

    :keyword json: Pass in a JSON-serializable object (usually a dictionary). See the template in
     our example to find the input shape. An array of events to be published to Event Grid.
    :paramtype json: any
    :keyword content: Pass in binary content you want in the body of the request (typically bytes,
     a byte iterator, or stream input). An array of events to be published to Event Grid.
    :paramtype content: any
    :return: Returns an :class:`~azure.core.rest.HttpRequest` that you will pass to the client's
     `send_request` method. See https://aka.ms/azsdk/python/protocol/quickstart for how to
     incorporate this response into your code flow.
    :rtype: ~azure.core.rest.HttpRequest

    Example:
        .. code-block:: python

            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "": {
                        "str": "any (optional)"
                    },
                    "data": "any (optional)",
                    "data_base64": "bytearray (optional)",
                    "datacontenttype": "str (optional)",
                    "dataschema": "str (optional)",
                    "id": "str",
                    "source": "str",
                    "specversion": "str",
                    "subject": "str (optional)",
                    "time": "datetime (optional)",
                    "type": "str"
                }
            ]
    """

    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2018-01-01"
    # Construct URL
    url = kwargs.pop("template_url", '/api/events')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_publish_custom_event_events_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Publishes a batch of events to an Azure Event Grid topic.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder
    into your code flow.

    :keyword json: Pass in a JSON-serializable object (usually a dictionary). See the template in
     our example to find the input shape. An array of events to be published to Event Grid.
    :paramtype json: any
    :keyword content: Pass in binary content you want in the body of the request (typically bytes,
     a byte iterator, or stream input). An array of events to be published to Event Grid.
    :paramtype content: any
    :return: Returns an :class:`~azure.core.rest.HttpRequest` that you will pass to the client's
     `send_request` method. See https://aka.ms/azsdk/python/protocol/quickstart for how to
     incorporate this response into your code flow.
    :rtype: ~azure.core.rest.HttpRequest

    Example:
        .. code-block:: python

            # JSON input template you can fill out and use as your `json` input.
            json = [
                "any (optional)"
            ]
    """

    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2018-01-01"
    # Construct URL
    url = kwargs.pop("template_url", '/api/events')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

