# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._network_management_client_enums import *


class ActiveBaseSecurityAdminRule(msrest.serialization.Model):
    """Network base admin rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ActiveSecurityAdminRule, ActiveDefaultSecurityAdminRule.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param commit_time: Deployment time string.
    :type commit_time: ~datetime.datetime
    :param region: Deployment region.
    :type region: str
    :param configuration_display_name: A display name of the security admin configuration.
    :type configuration_display_name: str
    :param configuration_description: A description of the security admin configuration.
    :type configuration_description: str
    :param rule_collection_display_name: A display name of the rule collection.
    :type rule_collection_display_name: str
    :param rule_collection_description: A description of the rule collection.
    :type rule_collection_description: str
    :param rule_collection_applies_to_groups: Groups for rule collection.
    :type rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :param rule_groups: Effective configuration groups.
    :type rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'commit_time': {'key': 'commitTime', 'type': 'iso-8601'},
        'region': {'key': 'region', 'type': 'str'},
        'configuration_display_name': {'key': 'configurationDisplayName', 'type': 'str'},
        'configuration_description': {'key': 'configurationDescription', 'type': 'str'},
        'rule_collection_display_name': {'key': 'ruleCollectionDisplayName', 'type': 'str'},
        'rule_collection_description': {'key': 'ruleCollectionDescription', 'type': 'str'},
        'rule_collection_applies_to_groups': {'key': 'ruleCollectionAppliesToGroups', 'type': '[NetworkManagerSecurityGroupItem]'},
        'rule_groups': {'key': 'ruleGroups', 'type': '[ConfigurationGroup]'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Custom': 'ActiveSecurityAdminRule', 'Default': 'ActiveDefaultSecurityAdminRule'}
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["ConfigurationGroup"]] = None,
        **kwargs
    ):
        super(ActiveBaseSecurityAdminRule, self).__init__(**kwargs)
        self.id = id
        self.commit_time = commit_time
        self.region = region
        self.configuration_display_name = configuration_display_name
        self.configuration_description = configuration_description
        self.rule_collection_display_name = rule_collection_display_name
        self.rule_collection_description = rule_collection_description
        self.rule_collection_applies_to_groups = rule_collection_applies_to_groups
        self.rule_groups = rule_groups
        self.kind = None  # type: Optional[str]


class ActiveBaseSecurityUserRule(msrest.serialization.Model):
    """Network base rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ActiveSecurityUserRule, ActiveDefaultSecurityUserRule.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param commit_time: Deployment time string.
    :type commit_time: ~datetime.datetime
    :param region: Deployment region.
    :type region: str
    :param configuration_display_name: A display name of the security user configuration.
    :type configuration_display_name: str
    :param configuration_description: A description of the security user configuration.
    :type configuration_description: str
    :param rule_collection_display_name: A display name of the rule collection.
    :type rule_collection_display_name: str
    :param rule_collection_description: A description of the rule collection.
    :type rule_collection_description: str
    :param rule_collection_applies_to_groups: Groups for rule collection.
    :type rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :param rule_groups: Effective configuration groups.
    :type rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveUserRuleKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'commit_time': {'key': 'commitTime', 'type': 'iso-8601'},
        'region': {'key': 'region', 'type': 'str'},
        'configuration_display_name': {'key': 'configurationDisplayName', 'type': 'str'},
        'configuration_description': {'key': 'configurationDescription', 'type': 'str'},
        'rule_collection_display_name': {'key': 'ruleCollectionDisplayName', 'type': 'str'},
        'rule_collection_description': {'key': 'ruleCollectionDescription', 'type': 'str'},
        'rule_collection_applies_to_groups': {'key': 'ruleCollectionAppliesToGroups', 'type': '[NetworkManagerSecurityGroupItem]'},
        'rule_groups': {'key': 'ruleGroups', 'type': '[ConfigurationGroup]'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Custom': 'ActiveSecurityUserRule', 'Default': 'ActiveDefaultSecurityUserRule'}
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["ConfigurationGroup"]] = None,
        **kwargs
    ):
        super(ActiveBaseSecurityUserRule, self).__init__(**kwargs)
        self.id = id
        self.commit_time = commit_time
        self.region = region
        self.configuration_display_name = configuration_display_name
        self.configuration_description = configuration_description
        self.rule_collection_display_name = rule_collection_display_name
        self.rule_collection_description = rule_collection_description
        self.rule_collection_applies_to_groups = rule_collection_applies_to_groups
        self.rule_groups = rule_groups
        self.kind = None  # type: Optional[str]


class ActiveConfigurationParameter(msrest.serialization.Model):
    """Effective Virtual Networks Parameter.

    :param regions: List of regions.
    :type regions: list[str]
    :param skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :type skip_token: str
    """

    _attribute_map = {
        'regions': {'key': 'regions', 'type': '[str]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        regions: Optional[List[str]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(ActiveConfigurationParameter, self).__init__(**kwargs)
        self.regions = regions
        self.skip_token = skip_token


class EffectiveConnectivityConfiguration(msrest.serialization.Model):
    """The network manager effective connectivity configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param configuration_groups: Effective configuration groups.
    :type configuration_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param display_name: A friendly name for the resource.
    :type display_name: str
    :param description: A description of the connectivity configuration.
    :type description: str
    :param connectivity_topology: Connectivity topology type. Possible values include:
     "HubAndSpoke", "Mesh".
    :type connectivity_topology: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityTopology
    :param hubs: List of hubItems.
    :type hubs: list[~azure.mgmt.network.v2021_02_01_preview.models.Hub]
    :param is_global: Flag if global mesh is supported. Possible values include: "False", "True".
    :type is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
    :param applies_to_groups: Groups for configuration.
    :type applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityGroupItem]
    :ivar provisioning_state: The provisioning state of the connectivity configuration resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    :param delete_existing_peering: Flag if need to remove current existing peerings. Possible
     values include: "False", "True".
    :type delete_existing_peering: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingPeering
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'configuration_groups': {'key': 'configurationGroups', 'type': '[ConfigurationGroup]'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'connectivity_topology': {'key': 'properties.connectivityTopology', 'type': 'str'},
        'hubs': {'key': 'properties.hubs', 'type': '[Hub]'},
        'is_global': {'key': 'properties.isGlobal', 'type': 'str'},
        'applies_to_groups': {'key': 'properties.appliesToGroups', 'type': '[ConnectivityGroupItem]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'delete_existing_peering': {'key': 'properties.deleteExistingPeering', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        configuration_groups: Optional[List["ConfigurationGroup"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        connectivity_topology: Optional[Union[str, "ConnectivityTopology"]] = None,
        hubs: Optional[List["Hub"]] = None,
        is_global: Optional[Union[str, "IsGlobal"]] = None,
        applies_to_groups: Optional[List["ConnectivityGroupItem"]] = None,
        delete_existing_peering: Optional[Union[str, "DeleteExistingPeering"]] = None,
        **kwargs
    ):
        super(EffectiveConnectivityConfiguration, self).__init__(**kwargs)
        self.id = id
        self.configuration_groups = configuration_groups
        self.display_name = display_name
        self.description = description
        self.connectivity_topology = connectivity_topology
        self.hubs = hubs
        self.is_global = is_global
        self.applies_to_groups = applies_to_groups
        self.provisioning_state = None
        self.delete_existing_peering = delete_existing_peering


class ActiveConnectivityConfiguration(EffectiveConnectivityConfiguration):
    """Active connectivity configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param configuration_groups: Effective configuration groups.
    :type configuration_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param display_name: A friendly name for the resource.
    :type display_name: str
    :param description: A description of the connectivity configuration.
    :type description: str
    :param connectivity_topology: Connectivity topology type. Possible values include:
     "HubAndSpoke", "Mesh".
    :type connectivity_topology: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityTopology
    :param hubs: List of hubItems.
    :type hubs: list[~azure.mgmt.network.v2021_02_01_preview.models.Hub]
    :param is_global: Flag if global mesh is supported. Possible values include: "False", "True".
    :type is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
    :param applies_to_groups: Groups for configuration.
    :type applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityGroupItem]
    :ivar provisioning_state: The provisioning state of the connectivity configuration resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    :param delete_existing_peering: Flag if need to remove current existing peerings. Possible
     values include: "False", "True".
    :type delete_existing_peering: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingPeering
    :param commit_time: Deployment time string.
    :type commit_time: ~datetime.datetime
    :param region: Deployment region.
    :type region: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'configuration_groups': {'key': 'configurationGroups', 'type': '[ConfigurationGroup]'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'connectivity_topology': {'key': 'properties.connectivityTopology', 'type': 'str'},
        'hubs': {'key': 'properties.hubs', 'type': '[Hub]'},
        'is_global': {'key': 'properties.isGlobal', 'type': 'str'},
        'applies_to_groups': {'key': 'properties.appliesToGroups', 'type': '[ConnectivityGroupItem]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'delete_existing_peering': {'key': 'properties.deleteExistingPeering', 'type': 'str'},
        'commit_time': {'key': 'commitTime', 'type': 'iso-8601'},
        'region': {'key': 'region', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        configuration_groups: Optional[List["ConfigurationGroup"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        connectivity_topology: Optional[Union[str, "ConnectivityTopology"]] = None,
        hubs: Optional[List["Hub"]] = None,
        is_global: Optional[Union[str, "IsGlobal"]] = None,
        applies_to_groups: Optional[List["ConnectivityGroupItem"]] = None,
        delete_existing_peering: Optional[Union[str, "DeleteExistingPeering"]] = None,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        **kwargs
    ):
        super(ActiveConnectivityConfiguration, self).__init__(id=id, configuration_groups=configuration_groups, display_name=display_name, description=description, connectivity_topology=connectivity_topology, hubs=hubs, is_global=is_global, applies_to_groups=applies_to_groups, delete_existing_peering=delete_existing_peering, **kwargs)
        self.commit_time = commit_time
        self.region = region


class ActiveConnectivityConfigurationsListResult(msrest.serialization.Model):
    """Result of the request to list active connectivity configurations. It contains a list of active connectivity configurations and a skiptoken to get the next set of results.

    :param value: Gets a page of active connectivity configurations.
    :type value:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ActiveConnectivityConfiguration]
    :param skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :type skip_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ActiveConnectivityConfiguration]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ActiveConnectivityConfiguration"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(ActiveConnectivityConfigurationsListResult, self).__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class ActiveDefaultSecurityAdminRule(ActiveBaseSecurityAdminRule):
    """Network default admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param commit_time: Deployment time string.
    :type commit_time: ~datetime.datetime
    :param region: Deployment region.
    :type region: str
    :param configuration_display_name: A display name of the security admin configuration.
    :type configuration_display_name: str
    :param configuration_description: A description of the security admin configuration.
    :type configuration_description: str
    :param rule_collection_display_name: A display name of the rule collection.
    :type rule_collection_display_name: str
    :param rule_collection_description: A description of the rule collection.
    :type rule_collection_description: str
    :param rule_collection_applies_to_groups: Groups for rule collection.
    :type rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :param rule_groups: Effective configuration groups.
    :type rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :param flag: Default rule flag.
    :type flag: str
    :ivar protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "Any", "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Possible values include:
     "Allow", "Deny", "AlwaysAllow".
    :vartype access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Possible values include: "Inbound", "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'kind': {'required': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'protocol': {'readonly': True},
        'sources': {'readonly': True},
        'destinations': {'readonly': True},
        'source_port_ranges': {'readonly': True},
        'destination_port_ranges': {'readonly': True},
        'access': {'readonly': True},
        'priority': {'readonly': True},
        'direction': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'commit_time': {'key': 'commitTime', 'type': 'iso-8601'},
        'region': {'key': 'region', 'type': 'str'},
        'configuration_display_name': {'key': 'configurationDisplayName', 'type': 'str'},
        'configuration_description': {'key': 'configurationDescription', 'type': 'str'},
        'rule_collection_display_name': {'key': 'ruleCollectionDisplayName', 'type': 'str'},
        'rule_collection_description': {'key': 'ruleCollectionDescription', 'type': 'str'},
        'rule_collection_applies_to_groups': {'key': 'ruleCollectionAppliesToGroups', 'type': '[NetworkManagerSecurityGroupItem]'},
        'rule_groups': {'key': 'ruleGroups', 'type': '[ConfigurationGroup]'},
        'kind': {'key': 'kind', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'flag': {'key': 'properties.flag', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'sources': {'key': 'properties.sources', 'type': '[AddressPrefixItem]'},
        'destinations': {'key': 'properties.destinations', 'type': '[AddressPrefixItem]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["ConfigurationGroup"]] = None,
        flag: Optional[str] = None,
        **kwargs
    ):
        super(ActiveDefaultSecurityAdminRule, self).__init__(id=id, commit_time=commit_time, region=region, configuration_display_name=configuration_display_name, configuration_description=configuration_description, rule_collection_display_name=rule_collection_display_name, rule_collection_description=rule_collection_description, rule_collection_applies_to_groups=rule_collection_applies_to_groups, rule_groups=rule_groups, **kwargs)
        self.kind = 'Default'  # type: str
        self.display_name = None
        self.description = None
        self.flag = flag
        self.protocol = None
        self.sources = None
        self.destinations = None
        self.source_port_ranges = None
        self.destination_port_ranges = None
        self.access = None
        self.priority = None
        self.direction = None
        self.provisioning_state = None


class ActiveDefaultSecurityUserRule(ActiveBaseSecurityUserRule):
    """Network security default user rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param commit_time: Deployment time string.
    :type commit_time: ~datetime.datetime
    :param region: Deployment region.
    :type region: str
    :param configuration_display_name: A display name of the security user configuration.
    :type configuration_display_name: str
    :param configuration_description: A description of the security user configuration.
    :type configuration_description: str
    :param rule_collection_display_name: A display name of the rule collection.
    :type rule_collection_display_name: str
    :param rule_collection_description: A description of the rule collection.
    :type rule_collection_description: str
    :param rule_collection_applies_to_groups: Groups for rule collection.
    :type rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :param rule_groups: Effective configuration groups.
    :type rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveUserRuleKind
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :param flag: Default rule flag.
    :type flag: str
    :ivar protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "Any", "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Possible values include: "Inbound", "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the security configuration user rule
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'kind': {'required': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'protocol': {'readonly': True},
        'sources': {'readonly': True},
        'destinations': {'readonly': True},
        'source_port_ranges': {'readonly': True},
        'destination_port_ranges': {'readonly': True},
        'direction': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'commit_time': {'key': 'commitTime', 'type': 'iso-8601'},
        'region': {'key': 'region', 'type': 'str'},
        'configuration_display_name': {'key': 'configurationDisplayName', 'type': 'str'},
        'configuration_description': {'key': 'configurationDescription', 'type': 'str'},
        'rule_collection_display_name': {'key': 'ruleCollectionDisplayName', 'type': 'str'},
        'rule_collection_description': {'key': 'ruleCollectionDescription', 'type': 'str'},
        'rule_collection_applies_to_groups': {'key': 'ruleCollectionAppliesToGroups', 'type': '[NetworkManagerSecurityGroupItem]'},
        'rule_groups': {'key': 'ruleGroups', 'type': '[ConfigurationGroup]'},
        'kind': {'key': 'kind', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'flag': {'key': 'properties.flag', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'sources': {'key': 'properties.sources', 'type': '[AddressPrefixItem]'},
        'destinations': {'key': 'properties.destinations', 'type': '[AddressPrefixItem]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["ConfigurationGroup"]] = None,
        flag: Optional[str] = None,
        **kwargs
    ):
        super(ActiveDefaultSecurityUserRule, self).__init__(id=id, commit_time=commit_time, region=region, configuration_display_name=configuration_display_name, configuration_description=configuration_description, rule_collection_display_name=rule_collection_display_name, rule_collection_description=rule_collection_description, rule_collection_applies_to_groups=rule_collection_applies_to_groups, rule_groups=rule_groups, **kwargs)
        self.kind = 'Default'  # type: str
        self.display_name = None
        self.description = None
        self.flag = flag
        self.protocol = None
        self.sources = None
        self.destinations = None
        self.source_port_ranges = None
        self.destination_port_ranges = None
        self.direction = None
        self.provisioning_state = None


class ActiveSecurityAdminRule(ActiveBaseSecurityAdminRule):
    """Network admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param commit_time: Deployment time string.
    :type commit_time: ~datetime.datetime
    :param region: Deployment region.
    :type region: str
    :param configuration_display_name: A display name of the security admin configuration.
    :type configuration_display_name: str
    :param configuration_description: A description of the security admin configuration.
    :type configuration_description: str
    :param rule_collection_display_name: A display name of the rule collection.
    :type rule_collection_display_name: str
    :param rule_collection_description: A description of the rule collection.
    :type rule_collection_description: str
    :param rule_collection_applies_to_groups: Groups for rule collection.
    :type rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :param rule_groups: Effective configuration groups.
    :type rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    :param display_name: A friendly name for the rule.
    :type display_name: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "Any", "Ah".
    :type protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :param sources: The CIDR or source IP ranges.
    :type sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :param destinations: The destination address prefixes. CIDR or destination IP ranges.
    :type destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :param source_port_ranges: The source port ranges.
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges.
    :type destination_port_ranges: list[str]
    :param access: Indicates the access allowed for this particular rule. Possible values include:
     "Allow", "Deny", "AlwaysAllow".
    :type access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :param priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :type priority: int
    :param direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Possible values include: "Inbound", "Outbound".
    :type direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'kind': {'required': True},
        'priority': {'maximum': 4096, 'minimum': 1},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'commit_time': {'key': 'commitTime', 'type': 'iso-8601'},
        'region': {'key': 'region', 'type': 'str'},
        'configuration_display_name': {'key': 'configurationDisplayName', 'type': 'str'},
        'configuration_description': {'key': 'configurationDescription', 'type': 'str'},
        'rule_collection_display_name': {'key': 'ruleCollectionDisplayName', 'type': 'str'},
        'rule_collection_description': {'key': 'ruleCollectionDescription', 'type': 'str'},
        'rule_collection_applies_to_groups': {'key': 'ruleCollectionAppliesToGroups', 'type': '[NetworkManagerSecurityGroupItem]'},
        'rule_groups': {'key': 'ruleGroups', 'type': '[ConfigurationGroup]'},
        'kind': {'key': 'kind', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'sources': {'key': 'properties.sources', 'type': '[AddressPrefixItem]'},
        'destinations': {'key': 'properties.destinations', 'type': '[AddressPrefixItem]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["ConfigurationGroup"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[List["AddressPrefixItem"]] = None,
        destinations: Optional[List["AddressPrefixItem"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        access: Optional[Union[str, "SecurityConfigurationRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "SecurityConfigurationRuleDirection"]] = None,
        **kwargs
    ):
        super(ActiveSecurityAdminRule, self).__init__(id=id, commit_time=commit_time, region=region, configuration_display_name=configuration_display_name, configuration_description=configuration_description, rule_collection_display_name=rule_collection_display_name, rule_collection_description=rule_collection_description, rule_collection_applies_to_groups=rule_collection_applies_to_groups, rule_groups=rule_groups, **kwargs)
        self.kind = 'Custom'  # type: str
        self.display_name = display_name
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = None


class ActiveSecurityAdminRulesListResult(msrest.serialization.Model):
    """Result of the request to list active security admin rules. It contains a list of active security admin rules and a skiptoken to get the next set of results.

    :param value: Gets a page of active security admin rules.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.ActiveBaseSecurityAdminRule]
    :param skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :type skip_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ActiveBaseSecurityAdminRule]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ActiveBaseSecurityAdminRule"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(ActiveSecurityAdminRulesListResult, self).__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class ActiveSecurityUserRule(ActiveBaseSecurityUserRule):
    """Network security user rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param commit_time: Deployment time string.
    :type commit_time: ~datetime.datetime
    :param region: Deployment region.
    :type region: str
    :param configuration_display_name: A display name of the security user configuration.
    :type configuration_display_name: str
    :param configuration_description: A description of the security user configuration.
    :type configuration_description: str
    :param rule_collection_display_name: A display name of the rule collection.
    :type rule_collection_display_name: str
    :param rule_collection_description: A description of the rule collection.
    :type rule_collection_description: str
    :param rule_collection_applies_to_groups: Groups for rule collection.
    :type rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :param rule_groups: Effective configuration groups.
    :type rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveUserRuleKind
    :param display_name: A friendly name for the rule.
    :type display_name: str
    :param description: A description for this rule.
    :type description: str
    :param protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "Any", "Ah".
    :type protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :param sources: The CIDR or source IP ranges.
    :type sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :param destinations: The destination address prefixes. CIDR or destination IP ranges.
    :type destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :param source_port_ranges: The source port ranges.
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges.
    :type destination_port_ranges: list[str]
    :param direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Possible values include: "Inbound", "Outbound".
    :type direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the security configuration user rule
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'commit_time': {'key': 'commitTime', 'type': 'iso-8601'},
        'region': {'key': 'region', 'type': 'str'},
        'configuration_display_name': {'key': 'configurationDisplayName', 'type': 'str'},
        'configuration_description': {'key': 'configurationDescription', 'type': 'str'},
        'rule_collection_display_name': {'key': 'ruleCollectionDisplayName', 'type': 'str'},
        'rule_collection_description': {'key': 'ruleCollectionDescription', 'type': 'str'},
        'rule_collection_applies_to_groups': {'key': 'ruleCollectionAppliesToGroups', 'type': '[NetworkManagerSecurityGroupItem]'},
        'rule_groups': {'key': 'ruleGroups', 'type': '[ConfigurationGroup]'},
        'kind': {'key': 'kind', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'sources': {'key': 'properties.sources', 'type': '[AddressPrefixItem]'},
        'destinations': {'key': 'properties.destinations', 'type': '[AddressPrefixItem]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["ConfigurationGroup"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[List["AddressPrefixItem"]] = None,
        destinations: Optional[List["AddressPrefixItem"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        direction: Optional[Union[str, "SecurityConfigurationRuleDirection"]] = None,
        **kwargs
    ):
        super(ActiveSecurityUserRule, self).__init__(id=id, commit_time=commit_time, region=region, configuration_display_name=configuration_display_name, configuration_description=configuration_description, rule_collection_display_name=rule_collection_display_name, rule_collection_description=rule_collection_description, rule_collection_applies_to_groups=rule_collection_applies_to_groups, rule_groups=rule_groups, **kwargs)
        self.kind = 'Custom'  # type: str
        self.display_name = display_name
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.direction = direction
        self.provisioning_state = None


class ActiveSecurityUserRulesListResult(msrest.serialization.Model):
    """Result of the request to list active security user rules. It contains a list of active security user rules and a skiptoken to get the next set of results.

    :param value: Gets a page of active security user rules.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.ActiveBaseSecurityUserRule]
    :param skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :type skip_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ActiveBaseSecurityUserRule]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ActiveBaseSecurityUserRule"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(ActiveSecurityUserRulesListResult, self).__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class AddressPrefixItem(msrest.serialization.Model):
    """Address prefix item.

    :param address_prefix: Address prefix.
    :type address_prefix: str
    :param address_prefix_type: Address prefix type. Possible values include: "IPPrefix",
     "ServiceTag".
    :type address_prefix_type: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixType
    """

    _attribute_map = {
        'address_prefix': {'key': 'addressPrefix', 'type': 'str'},
        'address_prefix_type': {'key': 'addressPrefixType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        address_prefix: Optional[str] = None,
        address_prefix_type: Optional[Union[str, "AddressPrefixType"]] = None,
        **kwargs
    ):
        super(AddressPrefixItem, self).__init__(**kwargs)
        self.address_prefix = address_prefix
        self.address_prefix_type = address_prefix_type


class ProxyResource(msrest.serialization.Model):
    """Proxy resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class BaseAdminRule(ProxyResource):
    """Network base admin rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AdminRule, DefaultAdminRule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.AdminRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    _subtype_map = {
        'kind': {'Custom': 'AdminRule', 'Default': 'DefaultAdminRule'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseAdminRule, self).__init__(**kwargs)
        self.kind = 'BaseAdminRule'  # type: str
        self.system_data = None


class AdminRule(BaseAdminRule):
    """Network admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.AdminRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :param display_name: A friendly name for the rule.
    :type display_name: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "Any", "Ah".
    :type protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :param sources: The CIDR or source IP ranges.
    :type sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :param destinations: The destination address prefixes. CIDR or destination IP ranges.
    :type destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :param source_port_ranges: The source port ranges.
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges.
    :type destination_port_ranges: list[str]
    :param access: Indicates the access allowed for this particular rule. Possible values include:
     "Allow", "Deny", "AlwaysAllow".
    :type access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :param priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :type priority: int
    :param direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Possible values include: "Inbound", "Outbound".
    :type direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
        'priority': {'maximum': 4096, 'minimum': 1},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'sources': {'key': 'properties.sources', 'type': '[AddressPrefixItem]'},
        'destinations': {'key': 'properties.destinations', 'type': '[AddressPrefixItem]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[List["AddressPrefixItem"]] = None,
        destinations: Optional[List["AddressPrefixItem"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        access: Optional[Union[str, "SecurityConfigurationRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "SecurityConfigurationRuleDirection"]] = None,
        **kwargs
    ):
        super(AdminRule, self).__init__(**kwargs)
        self.kind = 'Custom'  # type: str
        self.display_name = display_name
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = None


class AdminRuleListResult(msrest.serialization.Model):
    """security configuration admin rule list result.

    :param value: A list of admin rules.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.BaseAdminRule]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BaseAdminRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BaseAdminRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AdminRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BaseUserRule(ProxyResource):
    """Network base rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: UserRule, DefaultUserRule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.UserRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    _subtype_map = {
        'kind': {'Custom': 'UserRule', 'Default': 'DefaultUserRule'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseUserRule, self).__init__(**kwargs)
        self.kind = 'BaseUserRule'  # type: str
        self.system_data = None


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.network.v2021_02_01_preview.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ConfigurationGroup(msrest.serialization.Model):
    """The network configuration group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param display_name: A friendly name for the network group.
    :type display_name: str
    :param description: A description of the network group.
    :type description: str
    :param member_type: Group member type.
    :type member_type: str
    :param group_members: Group members of network group.
    :type group_members: list[~azure.mgmt.network.v2021_02_01_preview.models.GroupMembersItem]
    :param conditional_membership: Network group conditional filter.
    :type conditional_membership: str
    :ivar provisioning_state: The provisioning state of the scope assignment resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'member_type': {'key': 'properties.memberType', 'type': 'str'},
        'group_members': {'key': 'properties.groupMembers', 'type': '[GroupMembersItem]'},
        'conditional_membership': {'key': 'properties.conditionalMembership', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        member_type: Optional[str] = None,
        group_members: Optional[List["GroupMembersItem"]] = None,
        conditional_membership: Optional[str] = None,
        **kwargs
    ):
        super(ConfigurationGroup, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.description = description
        self.member_type = member_type
        self.group_members = group_members
        self.conditional_membership = conditional_membership
        self.provisioning_state = None


class ConnectivityConfiguration(ProxyResource):
    """The network manager connectivity configuration resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :param display_name: A friendly name for the resource.
    :type display_name: str
    :param description: A description of the connectivity configuration.
    :type description: str
    :param connectivity_topology: Connectivity topology type. Possible values include:
     "HubAndSpoke", "Mesh".
    :type connectivity_topology: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityTopology
    :param hubs: List of hubItems.
    :type hubs: list[~azure.mgmt.network.v2021_02_01_preview.models.Hub]
    :param is_global: Flag if global mesh is supported. Possible values include: "False", "True".
    :type is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
    :param applies_to_groups: Groups for configuration.
    :type applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityGroupItem]
    :ivar provisioning_state: The provisioning state of the connectivity configuration resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    :param delete_existing_peering: Flag if need to remove current existing peerings. Possible
     values include: "False", "True".
    :type delete_existing_peering: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingPeering
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'connectivity_topology': {'key': 'properties.connectivityTopology', 'type': 'str'},
        'hubs': {'key': 'properties.hubs', 'type': '[Hub]'},
        'is_global': {'key': 'properties.isGlobal', 'type': 'str'},
        'applies_to_groups': {'key': 'properties.appliesToGroups', 'type': '[ConnectivityGroupItem]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'delete_existing_peering': {'key': 'properties.deleteExistingPeering', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        connectivity_topology: Optional[Union[str, "ConnectivityTopology"]] = None,
        hubs: Optional[List["Hub"]] = None,
        is_global: Optional[Union[str, "IsGlobal"]] = None,
        applies_to_groups: Optional[List["ConnectivityGroupItem"]] = None,
        delete_existing_peering: Optional[Union[str, "DeleteExistingPeering"]] = None,
        **kwargs
    ):
        super(ConnectivityConfiguration, self).__init__(**kwargs)
        self.system_data = None
        self.display_name = display_name
        self.description = description
        self.connectivity_topology = connectivity_topology
        self.hubs = hubs
        self.is_global = is_global
        self.applies_to_groups = applies_to_groups
        self.provisioning_state = None
        self.delete_existing_peering = delete_existing_peering


class ConnectivityConfigurationListResult(msrest.serialization.Model):
    """Result of the request to list network manager connectivity configurations. It contains a list of configurations and a link to get the next set of results.

    :param value: Gets a page of Connectivity Configurations.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityConfiguration]
    :param next_link: Gets the URL to get the next page of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConnectivityConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ConnectivityConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ConnectivityConfigurationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConnectivityGroupItem(msrest.serialization.Model):
    """ConnectivityGroupItem.

    :param network_group_id: Network group Id.
    :type network_group_id: str
    :param use_hub_gateway: Flag if need to use hub gateway. Possible values include: "False",
     "True".
    :type use_hub_gateway: str or ~azure.mgmt.network.v2021_02_01_preview.models.UseHubGateway
    :param is_global: Flag if global is supported. Possible values include: "False", "True".
    :type is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
    :param group_connectivity: Group connectivity type. Possible values include: "None",
     "DirectlyConnected".
    :type group_connectivity: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.GroupConnectivity
    """

    _attribute_map = {
        'network_group_id': {'key': 'networkGroupId', 'type': 'str'},
        'use_hub_gateway': {'key': 'useHubGateway', 'type': 'str'},
        'is_global': {'key': 'isGlobal', 'type': 'str'},
        'group_connectivity': {'key': 'groupConnectivity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        network_group_id: Optional[str] = None,
        use_hub_gateway: Optional[Union[str, "UseHubGateway"]] = None,
        is_global: Optional[Union[str, "IsGlobal"]] = None,
        group_connectivity: Optional[Union[str, "GroupConnectivity"]] = None,
        **kwargs
    ):
        super(ConnectivityGroupItem, self).__init__(**kwargs)
        self.network_group_id = network_group_id
        self.use_hub_gateway = use_hub_gateway
        self.is_global = is_global
        self.group_connectivity = group_connectivity


class DefaultAdminRule(BaseAdminRule):
    """Network default admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.AdminRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :param flag: Default rule flag.
    :type flag: str
    :ivar protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "Any", "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Possible values include:
     "Allow", "Deny", "AlwaysAllow".
    :vartype access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Possible values include: "Inbound", "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'protocol': {'readonly': True},
        'sources': {'readonly': True},
        'destinations': {'readonly': True},
        'source_port_ranges': {'readonly': True},
        'destination_port_ranges': {'readonly': True},
        'access': {'readonly': True},
        'priority': {'readonly': True},
        'direction': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'flag': {'key': 'properties.flag', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'sources': {'key': 'properties.sources', 'type': '[AddressPrefixItem]'},
        'destinations': {'key': 'properties.destinations', 'type': '[AddressPrefixItem]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        flag: Optional[str] = None,
        **kwargs
    ):
        super(DefaultAdminRule, self).__init__(**kwargs)
        self.kind = 'Default'  # type: str
        self.display_name = None
        self.description = None
        self.flag = flag
        self.protocol = None
        self.sources = None
        self.destinations = None
        self.source_port_ranges = None
        self.destination_port_ranges = None
        self.access = None
        self.priority = None
        self.direction = None
        self.provisioning_state = None


class DefaultUserRule(BaseUserRule):
    """Network security default user rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.UserRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :param flag: Default rule flag.
    :type flag: str
    :ivar protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "Any", "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Possible values include: "Inbound", "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the security configuration user rule
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'protocol': {'readonly': True},
        'sources': {'readonly': True},
        'destinations': {'readonly': True},
        'source_port_ranges': {'readonly': True},
        'destination_port_ranges': {'readonly': True},
        'direction': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'flag': {'key': 'properties.flag', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'sources': {'key': 'properties.sources', 'type': '[AddressPrefixItem]'},
        'destinations': {'key': 'properties.destinations', 'type': '[AddressPrefixItem]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        flag: Optional[str] = None,
        **kwargs
    ):
        super(DefaultUserRule, self).__init__(**kwargs)
        self.kind = 'Default'  # type: str
        self.display_name = None
        self.description = None
        self.flag = flag
        self.protocol = None
        self.sources = None
        self.destinations = None
        self.source_port_ranges = None
        self.destination_port_ranges = None
        self.direction = None
        self.provisioning_state = None


class EffectiveBaseSecurityAdminRule(msrest.serialization.Model):
    """Network base admin rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EffectiveSecurityAdminRule, EffectiveDefaultSecurityAdminRule.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param configuration_display_name: A display name of the security admin configuration.
    :type configuration_display_name: str
    :param configuration_description: A description of the security admin configuration.
    :type configuration_description: str
    :param rule_collection_display_name: A display name of the rule collection.
    :type rule_collection_display_name: str
    :param rule_collection_description: A description of the rule collection.
    :type rule_collection_description: str
    :param rule_collection_applies_to_groups: Groups for rule collection.
    :type rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :param rule_groups: Effective configuration groups.
    :type rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'configuration_display_name': {'key': 'configurationDisplayName', 'type': 'str'},
        'configuration_description': {'key': 'configurationDescription', 'type': 'str'},
        'rule_collection_display_name': {'key': 'ruleCollectionDisplayName', 'type': 'str'},
        'rule_collection_description': {'key': 'ruleCollectionDescription', 'type': 'str'},
        'rule_collection_applies_to_groups': {'key': 'ruleCollectionAppliesToGroups', 'type': '[NetworkManagerSecurityGroupItem]'},
        'rule_groups': {'key': 'ruleGroups', 'type': '[ConfigurationGroup]'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Custom': 'EffectiveSecurityAdminRule', 'Default': 'EffectiveDefaultSecurityAdminRule'}
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["ConfigurationGroup"]] = None,
        **kwargs
    ):
        super(EffectiveBaseSecurityAdminRule, self).__init__(**kwargs)
        self.id = id
        self.configuration_display_name = configuration_display_name
        self.configuration_description = configuration_description
        self.rule_collection_display_name = rule_collection_display_name
        self.rule_collection_description = rule_collection_description
        self.rule_collection_applies_to_groups = rule_collection_applies_to_groups
        self.rule_groups = rule_groups
        self.kind = None  # type: Optional[str]


class EffectiveDefaultSecurityAdminRule(EffectiveBaseSecurityAdminRule):
    """Network default admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param configuration_display_name: A display name of the security admin configuration.
    :type configuration_display_name: str
    :param configuration_description: A description of the security admin configuration.
    :type configuration_description: str
    :param rule_collection_display_name: A display name of the rule collection.
    :type rule_collection_display_name: str
    :param rule_collection_description: A description of the rule collection.
    :type rule_collection_description: str
    :param rule_collection_applies_to_groups: Groups for rule collection.
    :type rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :param rule_groups: Effective configuration groups.
    :type rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :param flag: Default rule flag.
    :type flag: str
    :ivar protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "Any", "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Possible values include:
     "Allow", "Deny", "AlwaysAllow".
    :vartype access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Possible values include: "Inbound", "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'kind': {'required': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'protocol': {'readonly': True},
        'sources': {'readonly': True},
        'destinations': {'readonly': True},
        'source_port_ranges': {'readonly': True},
        'destination_port_ranges': {'readonly': True},
        'access': {'readonly': True},
        'priority': {'readonly': True},
        'direction': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'configuration_display_name': {'key': 'configurationDisplayName', 'type': 'str'},
        'configuration_description': {'key': 'configurationDescription', 'type': 'str'},
        'rule_collection_display_name': {'key': 'ruleCollectionDisplayName', 'type': 'str'},
        'rule_collection_description': {'key': 'ruleCollectionDescription', 'type': 'str'},
        'rule_collection_applies_to_groups': {'key': 'ruleCollectionAppliesToGroups', 'type': '[NetworkManagerSecurityGroupItem]'},
        'rule_groups': {'key': 'ruleGroups', 'type': '[ConfigurationGroup]'},
        'kind': {'key': 'kind', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'flag': {'key': 'properties.flag', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'sources': {'key': 'properties.sources', 'type': '[AddressPrefixItem]'},
        'destinations': {'key': 'properties.destinations', 'type': '[AddressPrefixItem]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["ConfigurationGroup"]] = None,
        flag: Optional[str] = None,
        **kwargs
    ):
        super(EffectiveDefaultSecurityAdminRule, self).__init__(id=id, configuration_display_name=configuration_display_name, configuration_description=configuration_description, rule_collection_display_name=rule_collection_display_name, rule_collection_description=rule_collection_description, rule_collection_applies_to_groups=rule_collection_applies_to_groups, rule_groups=rule_groups, **kwargs)
        self.kind = 'Default'  # type: str
        self.display_name = None
        self.description = None
        self.flag = flag
        self.protocol = None
        self.sources = None
        self.destinations = None
        self.source_port_ranges = None
        self.destination_port_ranges = None
        self.access = None
        self.priority = None
        self.direction = None
        self.provisioning_state = None


class EffectiveSecurityAdminRule(EffectiveBaseSecurityAdminRule):
    """Network admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param configuration_display_name: A display name of the security admin configuration.
    :type configuration_display_name: str
    :param configuration_description: A description of the security admin configuration.
    :type configuration_description: str
    :param rule_collection_display_name: A display name of the rule collection.
    :type rule_collection_display_name: str
    :param rule_collection_description: A description of the rule collection.
    :type rule_collection_description: str
    :param rule_collection_applies_to_groups: Groups for rule collection.
    :type rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :param rule_groups: Effective configuration groups.
    :type rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    :param display_name: A friendly name for the rule.
    :type display_name: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "Any", "Ah".
    :type protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :param sources: The CIDR or source IP ranges.
    :type sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :param destinations: The destination address prefixes. CIDR or destination IP ranges.
    :type destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :param source_port_ranges: The source port ranges.
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges.
    :type destination_port_ranges: list[str]
    :param access: Indicates the access allowed for this particular rule. Possible values include:
     "Allow", "Deny", "AlwaysAllow".
    :type access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :param priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :type priority: int
    :param direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Possible values include: "Inbound", "Outbound".
    :type direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'kind': {'required': True},
        'priority': {'maximum': 4096, 'minimum': 1},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'configuration_display_name': {'key': 'configurationDisplayName', 'type': 'str'},
        'configuration_description': {'key': 'configurationDescription', 'type': 'str'},
        'rule_collection_display_name': {'key': 'ruleCollectionDisplayName', 'type': 'str'},
        'rule_collection_description': {'key': 'ruleCollectionDescription', 'type': 'str'},
        'rule_collection_applies_to_groups': {'key': 'ruleCollectionAppliesToGroups', 'type': '[NetworkManagerSecurityGroupItem]'},
        'rule_groups': {'key': 'ruleGroups', 'type': '[ConfigurationGroup]'},
        'kind': {'key': 'kind', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'sources': {'key': 'properties.sources', 'type': '[AddressPrefixItem]'},
        'destinations': {'key': 'properties.destinations', 'type': '[AddressPrefixItem]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["ConfigurationGroup"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[List["AddressPrefixItem"]] = None,
        destinations: Optional[List["AddressPrefixItem"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        access: Optional[Union[str, "SecurityConfigurationRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "SecurityConfigurationRuleDirection"]] = None,
        **kwargs
    ):
        super(EffectiveSecurityAdminRule, self).__init__(id=id, configuration_display_name=configuration_display_name, configuration_description=configuration_description, rule_collection_display_name=rule_collection_display_name, rule_collection_description=rule_collection_description, rule_collection_applies_to_groups=rule_collection_applies_to_groups, rule_groups=rule_groups, **kwargs)
        self.kind = 'Custom'  # type: str
        self.display_name = display_name
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = None


class EffectiveVirtualNetwork(msrest.serialization.Model):
    """Effective Virtual Network.

    :param id: Effective vnet Id.
    :type id: str
    :param location: Location of vnet.
    :type location: str
    :param membership_type: Membership Type. Possible values include: "Static", "Dynamic".
    :type membership_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.MembershipType
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'membership_type': {'key': 'membershipType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        membership_type: Optional[Union[str, "MembershipType"]] = None,
        **kwargs
    ):
        super(EffectiveVirtualNetwork, self).__init__(**kwargs)
        self.id = id
        self.location = location
        self.membership_type = membership_type


class EffectiveVirtualNetworksListResult(msrest.serialization.Model):
    """Result of the request to list Effective Virtual Network. It contains a list of groups and a URL link to get the next set of results.

    :param value: Gets a page of EffectiveVirtualNetwork.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.EffectiveVirtualNetwork]
    :param skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :type skip_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveVirtualNetwork]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EffectiveVirtualNetwork"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(EffectiveVirtualNetworksListResult, self).__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class EffectiveVirtualNetworksParameter(msrest.serialization.Model):
    """Effective Virtual Networks Parameter.

    :param conditional_members: Conditional Members.
    :type conditional_members: str
    :param skip_token: Continuation token for pagination, capturing the next page size and offset,
     as well as the context of the query.
    :type skip_token: str
    """

    _attribute_map = {
        'conditional_members': {'key': 'conditionalMembers', 'type': 'str'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        conditional_members: Optional[str] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(EffectiveVirtualNetworksParameter, self).__init__(**kwargs)
        self.conditional_members = conditional_members
        self.skip_token = skip_token


class GroupMembersItem(msrest.serialization.Model):
    """GroupMembers Item.

    :param resource_id: Resource Id.
    :type resource_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        super(GroupMembersItem, self).__init__(**kwargs)
        self.resource_id = resource_id


class Hub(msrest.serialization.Model):
    """Hub Item.

    :param resource_id: Resource Id.
    :type resource_id: str
    :param resource_type: Resource Type.
    :type resource_type: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        resource_type: Optional[str] = None,
        **kwargs
    ):
        super(Hub, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.resource_type = resource_type


class NetworkGroup(ProxyResource):
    """The network group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :param display_name: A friendly name for the network group.
    :type display_name: str
    :param description: A description of the network group.
    :type description: str
    :param member_type: Group member type.
    :type member_type: str
    :param group_members: Group members of network group.
    :type group_members: list[~azure.mgmt.network.v2021_02_01_preview.models.GroupMembersItem]
    :param conditional_membership: Network group conditional filter.
    :type conditional_membership: str
    :ivar provisioning_state: The provisioning state of the scope assignment resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'member_type': {'key': 'properties.memberType', 'type': 'str'},
        'group_members': {'key': 'properties.groupMembers', 'type': '[GroupMembersItem]'},
        'conditional_membership': {'key': 'properties.conditionalMembership', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        member_type: Optional[str] = None,
        group_members: Optional[List["GroupMembersItem"]] = None,
        conditional_membership: Optional[str] = None,
        **kwargs
    ):
        super(NetworkGroup, self).__init__(**kwargs)
        self.system_data = None
        self.display_name = display_name
        self.description = description
        self.member_type = member_type
        self.group_members = group_members
        self.conditional_membership = conditional_membership
        self.provisioning_state = None


class NetworkGroupListResult(msrest.serialization.Model):
    """Result of the request to list NetworkGroup. It contains a list of groups and a URL link to get the next set of results.

    :param value: Gets a page of NetworkGroup.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkGroup]
    :param next_link: Gets the URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkGroup"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NetworkGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Resource(msrest.serialization.Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class NetworkManager(Resource):
    """The Managed Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :param display_name: A friendly name for the network manager.
    :type display_name: str
    :param description: A description of the network manager.
    :type description: str
    :param network_manager_scopes: Scope of Network Manager.
    :type network_manager_scopes:
     ~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerPropertiesNetworkManagerScopes
    :param network_manager_scope_accesses: Scope Access.
    :type network_manager_scope_accesses: list[str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType]
    :ivar provisioning_state: The provisioning state of the scope assignment resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'network_manager_scopes': {'key': 'properties.networkManagerScopes', 'type': 'NetworkManagerPropertiesNetworkManagerScopes'},
        'network_manager_scope_accesses': {'key': 'properties.networkManagerScopeAccesses', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        network_manager_scopes: Optional["NetworkManagerPropertiesNetworkManagerScopes"] = None,
        network_manager_scope_accesses: Optional[List[Union[str, "ConfigurationType"]]] = None,
        **kwargs
    ):
        super(NetworkManager, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.system_data = None
        self.display_name = display_name
        self.description = description
        self.network_manager_scopes = network_manager_scopes
        self.network_manager_scope_accesses = network_manager_scope_accesses
        self.provisioning_state = None


class NetworkManagerCommit(msrest.serialization.Model):
    """Network Manager Commit.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar commit_id: Commit Id.
    :vartype commit_id: str
    :param target_locations: List of target locations.
    :type target_locations: list[str]
    :param configuration_ids: List of configuration ids.
    :type configuration_ids: list[str]
    :param commit_type: Commit Type. Possible values include: "SecurityAdmin", "SecurityUser",
     "Connectivity".
    :type commit_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType
    """

    _validation = {
        'commit_id': {'readonly': True},
    }

    _attribute_map = {
        'commit_id': {'key': 'commitId', 'type': 'str'},
        'target_locations': {'key': 'targetLocations', 'type': '[str]'},
        'configuration_ids': {'key': 'configurationIds', 'type': '[str]'},
        'commit_type': {'key': 'commitType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_locations: Optional[List[str]] = None,
        configuration_ids: Optional[List[str]] = None,
        commit_type: Optional[Union[str, "ConfigurationType"]] = None,
        **kwargs
    ):
        super(NetworkManagerCommit, self).__init__(**kwargs)
        self.commit_id = None
        self.target_locations = target_locations
        self.configuration_ids = configuration_ids
        self.commit_type = commit_type


class NetworkManagerDeploymentStatus(msrest.serialization.Model):
    """Network Manager Deployment Status.

    :param commit_time: Commit Time.
    :type commit_time: ~datetime.datetime
    :param region: Region Name.
    :type region: str
    :param deployment_status: Deployment Status. Possible values include: "NotStarted",
     "Deploying", "Deployed", "Failed".
    :type deployment_status: str or ~azure.mgmt.network.v2021_02_01_preview.models.DeploymentStatus
    :param configuration_ids: List of configuration ids.
    :type configuration_ids: list[str]
    :param deployment_type: Configuration Deployment Type. Possible values include:
     "SecurityAdmin", "SecurityUser", "Connectivity".
    :type deployment_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType
    :param error_message: Error Message.
    :type error_message: str
    """

    _attribute_map = {
        'commit_time': {'key': 'commitTime', 'type': 'iso-8601'},
        'region': {'key': 'region', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'configuration_ids': {'key': 'configurationIds', 'type': '[str]'},
        'deployment_type': {'key': 'deploymentType', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        deployment_status: Optional[Union[str, "DeploymentStatus"]] = None,
        configuration_ids: Optional[List[str]] = None,
        deployment_type: Optional[Union[str, "ConfigurationType"]] = None,
        error_message: Optional[str] = None,
        **kwargs
    ):
        super(NetworkManagerDeploymentStatus, self).__init__(**kwargs)
        self.commit_time = commit_time
        self.region = region
        self.deployment_status = deployment_status
        self.configuration_ids = configuration_ids
        self.deployment_type = deployment_type
        self.error_message = error_message


class NetworkManagerDeploymentStatusListResult(msrest.serialization.Model):
    """A list of Network Manager Deployment Status.

    :param value: Gets a page of Network Manager Deployment Status.
    :type value:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerDeploymentStatus]
    :param skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :type skip_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkManagerDeploymentStatus]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkManagerDeploymentStatus"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(NetworkManagerDeploymentStatusListResult, self).__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class NetworkManagerDeploymentStatusParameter(msrest.serialization.Model):
    """Network Manager Deployment Status Parameter.

    :param regions: List of locations.
    :type regions: list[str]
    :param deployment_types: List of deployment types.
    :type deployment_types: list[str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType]
    :param skip_token: Continuation token for pagination, capturing the next page size and offset,
     as well as the context of the query.
    :type skip_token: str
    """

    _attribute_map = {
        'regions': {'key': 'regions', 'type': '[str]'},
        'deployment_types': {'key': 'deploymentTypes', 'type': '[str]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        regions: Optional[List[str]] = None,
        deployment_types: Optional[List[Union[str, "ConfigurationType"]]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(NetworkManagerDeploymentStatusParameter, self).__init__(**kwargs)
        self.regions = regions
        self.deployment_types = deployment_types
        self.skip_token = skip_token


class NetworkManagerEffectiveConnectivityConfigurationListResult(msrest.serialization.Model):
    """Result of the request to list networkManagerEffectiveConnectivityConfiguration. It contains a list of groups and a skiptoken to get the next set of results.

    :param value: Gets a page of NetworkManagerEffectiveConnectivityConfiguration.
    :type value:
     list[~azure.mgmt.network.v2021_02_01_preview.models.EffectiveConnectivityConfiguration]
    :param skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :type skip_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveConnectivityConfiguration]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EffectiveConnectivityConfiguration"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(NetworkManagerEffectiveConnectivityConfigurationListResult, self).__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class NetworkManagerEffectiveSecurityAdminRulesListResult(msrest.serialization.Model):
    """Result of the request to list networkManagerEffectiveSecurityAdminRules. It contains a list of groups and a skiptoken to get the next set of results.

    :param value: Gets a page of NetworkManagerEffectiveSecurityAdminRules.
    :type value:
     list[~azure.mgmt.network.v2021_02_01_preview.models.EffectiveBaseSecurityAdminRule]
    :param skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :type skip_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveBaseSecurityAdminRule]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EffectiveBaseSecurityAdminRule"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(NetworkManagerEffectiveSecurityAdminRulesListResult, self).__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class NetworkManagerListResult(msrest.serialization.Model):
    """Result of the request to list NetworkManager. It contains a list of network managers and a URL link to get the next set of results.

    :param value: Gets a page of NetworkManager.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManager]
    :param next_link: Gets the URL to get the next page of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkManager]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkManager"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NetworkManagerListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkManagerPropertiesNetworkManagerScopes(msrest.serialization.Model):
    """Scope of Network Manager.

    :param management_groups: List of management groups.
    :type management_groups: list[str]
    :param subscriptions: List of subscriptions.
    :type subscriptions: list[str]
    """

    _attribute_map = {
        'management_groups': {'key': 'managementGroups', 'type': '[str]'},
        'subscriptions': {'key': 'subscriptions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        management_groups: Optional[List[str]] = None,
        subscriptions: Optional[List[str]] = None,
        **kwargs
    ):
        super(NetworkManagerPropertiesNetworkManagerScopes, self).__init__(**kwargs)
        self.management_groups = management_groups
        self.subscriptions = subscriptions


class NetworkManagerSecurityGroupItem(msrest.serialization.Model):
    """Network manager security group item.

    :param network_group_id: Network manager group Id.
    :type network_group_id: str
    """

    _attribute_map = {
        'network_group_id': {'key': 'networkGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        network_group_id: Optional[str] = None,
        **kwargs
    ):
        super(NetworkManagerSecurityGroupItem, self).__init__(**kwargs)
        self.network_group_id = network_group_id


class NetworkSecurityPerimeter(Resource):
    """The Network Security Perimeter resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param display_name: A friendly name for the network security perimeter.
    :type display_name: str
    :param description: A description of the network security perimeter.
    :type description: str
    :ivar provisioning_state: The provisioning state of the scope assignment resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(NetworkSecurityPerimeter, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.display_name = display_name
        self.description = description
        self.provisioning_state = None


class NetworkSecurityPerimeterListResult(msrest.serialization.Model):
    """Result of the request to list NetworkSecurityPerimeter. It contains a list of network security perimeters and a URL link to get the next set of results.

    :param value: Gets a page of NetworkSecurityPerimeter.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkSecurityPerimeter]
    :param next_link: Gets the URL to get the next page of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkSecurityPerimeter]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkSecurityPerimeter"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NetworkSecurityPerimeterListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PerimeterAssociableResource(Resource):
    """Resource that is onboarded to use network security perimeter. Also referred as perimeter associable resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar display_name: A friendly name for the properties of perimeter associable resources.
    :vartype display_name: str
    :ivar resource_type: Resource type/provider name.
    :vartype resource_type: str
    :ivar public_dns_zones: Public DNS zone names of the resources.
    :vartype public_dns_zones: list[str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'resource_type': {'readonly': True},
        'public_dns_zones': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'resource_type': {'key': 'properties.resourceType', 'type': 'str'},
        'public_dns_zones': {'key': 'properties.publicDnsZones', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(PerimeterAssociableResource, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.display_name = None
        self.resource_type = None
        self.public_dns_zones = None


class PerimeterAssociableResourcesListResult(msrest.serialization.Model):
    """Paged list of perimeter associable resources.

    :param value: Gets paged list of perimeter associable resources.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.PerimeterAssociableResource]
    :param next_link: Gets the URL to get the next page of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PerimeterAssociableResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PerimeterAssociableResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PerimeterAssociableResourcesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QueryRequestOptions(msrest.serialization.Model):
    """Query Request Options.

    :param skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :type skip_token: str
    """

    _attribute_map = {
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        super(QueryRequestOptions, self).__init__(**kwargs)
        self.skip_token = skip_token


class RuleCollection(ProxyResource):
    """Defines the rule collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :param display_name: A display name of the rule collection.
    :type display_name: str
    :param description: A description of the rule collection.
    :type description: str
    :param applies_to_groups: Groups for configuration.
    :type applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'applies_to_groups': {'key': 'properties.appliesToGroups', 'type': '[NetworkManagerSecurityGroupItem]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        applies_to_groups: Optional[List["NetworkManagerSecurityGroupItem"]] = None,
        **kwargs
    ):
        super(RuleCollection, self).__init__(**kwargs)
        self.system_data = None
        self.display_name = display_name
        self.description = description
        self.applies_to_groups = applies_to_groups
        self.provisioning_state = None


class RuleCollectionListResult(msrest.serialization.Model):
    """Security configuration rule collection list result.

    :param value: A list of network manager security configuration rule collections.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.RuleCollection]
    :param next_link: Gets the URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RuleCollection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RuleCollection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RuleCollectionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SecurityConfiguration(ProxyResource):
    """Defines the security configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :param display_name: A display name of the security configuration.
    :type display_name: str
    :param description: A description of the security configuration.
    :type description: str
    :param security_type: Security Type. Possible values include: "AdminPolicy", "UserPolicy".
    :type security_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.SecurityType
    :param delete_existing_ns_gs: Flag if need to delete existing network security groups. Possible
     values include: "False", "True".
    :type delete_existing_ns_gs: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingNSGs
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'security_type': {'key': 'properties.securityType', 'type': 'str'},
        'delete_existing_ns_gs': {'key': 'properties.deleteExistingNSGs', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        security_type: Optional[Union[str, "SecurityType"]] = None,
        delete_existing_ns_gs: Optional[Union[str, "DeleteExistingNSGs"]] = None,
        **kwargs
    ):
        super(SecurityConfiguration, self).__init__(**kwargs)
        self.system_data = None
        self.display_name = display_name
        self.description = description
        self.security_type = security_type
        self.delete_existing_ns_gs = delete_existing_ns_gs
        self.provisioning_state = None


class SecurityConfigurationListResult(msrest.serialization.Model):
    """A list of network manager security configurations.

    :param value: Gets a page of security configurations.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfiguration]
    :param next_link: Gets the URL to get the next page of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SecurityConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SecurityConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SecurityConfigurationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.CreatedByType
    :param last_modified_at: The type of identity that last modified the resource.
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags


class UserRule(BaseUserRule):
    """Network security user rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param kind: Required. Whether the rule is custom or default.Constant filled by server.
     Possible values include: "Custom", "Default".
    :type kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.UserRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :param display_name: A friendly name for the rule.
    :type display_name: str
    :param description: A description for this rule.
    :type description: str
    :param protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "Any", "Ah".
    :type protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :param sources: The CIDR or source IP ranges.
    :type sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :param destinations: The destination address prefixes. CIDR or destination IP ranges.
    :type destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :param source_port_ranges: The source port ranges.
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges.
    :type destination_port_ranges: list[str]
    :param direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Possible values include: "Inbound", "Outbound".
    :type direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the security configuration user rule
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'sources': {'key': 'properties.sources', 'type': '[AddressPrefixItem]'},
        'destinations': {'key': 'properties.destinations', 'type': '[AddressPrefixItem]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[List["AddressPrefixItem"]] = None,
        destinations: Optional[List["AddressPrefixItem"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        direction: Optional[Union[str, "SecurityConfigurationRuleDirection"]] = None,
        **kwargs
    ):
        super(UserRule, self).__init__(**kwargs)
        self.kind = 'Custom'  # type: str
        self.display_name = display_name
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.direction = direction
        self.provisioning_state = None


class UserRuleListResult(msrest.serialization.Model):
    """security user rule list result.

    :param value: A list of user rules.
    :type value: list[~azure.mgmt.network.v2021_02_01_preview.models.BaseUserRule]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BaseUserRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BaseUserRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(UserRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link
