# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ConnectionState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the connection.
    """

    NONE = "None"
    PENDING_APPROVAL = "PendingApproval"
    APPROVED = "Approved"
    PROVISIONING_STARTED = "ProvisioningStarted"
    PROVISIONING_FAILED = "ProvisioningFailed"
    PROVISIONING_COMPLETED = "ProvisioningCompleted"
    VALIDATING = "Validating"
    ACTIVE = "Active"

class DirectPeeringType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of direct peering.
    """

    EDGE = "Edge"
    TRANSIT = "Transit"
    CDN = "Cdn"
    INTERNAL = "Internal"

class Enum0(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    AVAILABLE = "Available"
    UN_AVAILABLE = "UnAvailable"

class Enum1(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DIRECT = "Direct"
    EXCHANGE = "Exchange"

class Enum14(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DIRECT = "Direct"
    EXCHANGE = "Exchange"

class Enum15(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    EDGE = "Edge"
    TRANSIT = "Transit"
    CDN = "Cdn"
    INTERNAL = "Internal"

class Family(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The family of the peering SKU.
    """

    DIRECT = "Direct"
    EXCHANGE = "Exchange"

class Kind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of the peering.
    """

    DIRECT = "Direct"
    EXCHANGE = "Exchange"

class LearnedType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The prefix learned type
    """

    NONE = "None"
    VIA_PARTNER = "ViaPartner"
    VIA_SESSION = "ViaSession"

class Name(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the peering SKU.
    """

    BASIC_EXCHANGE_FREE = "Basic_Exchange_Free"
    BASIC_DIRECT_FREE = "Basic_Direct_Free"
    PREMIUM_DIRECT_FREE = "Premium_Direct_Free"
    PREMIUM_EXCHANGE_METERED = "Premium_Exchange_Metered"
    PREMIUM_DIRECT_METERED = "Premium_Direct_Metered"
    PREMIUM_DIRECT_UNLIMITED = "Premium_Direct_Unlimited"

class PrefixValidationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The prefix validation state
    """

    NONE = "None"
    INVALID = "Invalid"
    VERIFIED = "Verified"
    FAILED = "Failed"
    PENDING = "Pending"
    UNKNOWN = "Unknown"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the resource.
    """

    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"
    DELETING = "Deleting"
    FAILED = "Failed"

class SessionAddressProvider(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The field indicating if Microsoft provides session ip addresses.
    """

    MICROSOFT = "Microsoft"
    PEER = "Peer"

class SessionStateV4(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the IPv4 session.
    """

    NONE = "None"
    IDLE = "Idle"
    CONNECT = "Connect"
    ACTIVE = "Active"
    OPEN_SENT = "OpenSent"
    OPEN_CONFIRM = "OpenConfirm"
    OPEN_RECEIVED = "OpenReceived"
    ESTABLISHED = "Established"
    PENDING_ADD = "PendingAdd"
    PENDING_UPDATE = "PendingUpdate"
    PENDING_REMOVE = "PendingRemove"

class SessionStateV6(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the IPv6 session.
    """

    NONE = "None"
    IDLE = "Idle"
    CONNECT = "Connect"
    ACTIVE = "Active"
    OPEN_SENT = "OpenSent"
    OPEN_CONFIRM = "OpenConfirm"
    OPEN_RECEIVED = "OpenReceived"
    ESTABLISHED = "Established"
    PENDING_ADD = "PendingAdd"
    PENDING_UPDATE = "PendingUpdate"
    PENDING_REMOVE = "PendingRemove"

class Size(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The size of the peering SKU.
    """

    FREE = "Free"
    METERED = "Metered"
    UNLIMITED = "Unlimited"

class Tier(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The tier of the peering SKU.
    """

    BASIC = "Basic"
    PREMIUM = "Premium"

class ValidationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The validation state of the ASN associated with the peer.
    """

    NONE = "None"
    PENDING = "Pending"
    APPROVED = "Approved"
    FAILED = "Failed"
