# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class LiftrResourceCategories(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LiftrResourceCategories."""

    UNKNOWN = "Unknown"
    MONITOR_LOGS = "MonitorLogs"


class ManagedIdentityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identity type."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"


class MarketplaceSubscriptionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in
    time, the resource will go in Suspended state.
    """

    PROVISIONING = "Provisioning"
    ACTIVE = "Active"
    SUSPENDED = "Suspended"
    UNSUBSCRIBED = "Unsubscribed"


class MonitoringStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag specifying if the resource monitoring is enabled or disabled."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ProvisioningState."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"
    NOT_SPECIFIED = "NotSpecified"


class SingleSignOnStates(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Various states of the SSO resource."""

    INITIAL = "Initial"
    ENABLE = "Enable"
    DISABLE = "Disable"
    EXISTING = "Existing"


class TagAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Valid actions for a filtering tag. Exclusion takes priority over inclusion."""

    INCLUDE = "Include"
    EXCLUDE = "Exclude"
