# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core import PipelineClient
from azure.core.rest import HttpRequest, HttpResponse

from . import models as _models
from ._configuration import ServiceBusManagementClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    EntityOperations,
    NamespaceOperations,
    RuleOperations,
    ServiceBusManagementClientOperationsMixin,
    SubscriptionOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class ServiceBusManagementClient(
    ServiceBusManagementClientOperationsMixin
):  # pylint: disable=client-accepts-api-version-keyword
    """Azure Service Bus client for managing Queues, Topics, and Subscriptions.

    :ivar entity: EntityOperations operations
    :vartype entity: azure.servicebus.management._generated.operations.EntityOperations
    :ivar subscription: SubscriptionOperations operations
    :vartype subscription: azure.servicebus.management._generated.operations.SubscriptionOperations
    :ivar rule: RuleOperations operations
    :vartype rule: azure.servicebus.management._generated.operations.RuleOperations
    :ivar namespace: NamespaceOperations operations
    :vartype namespace: azure.servicebus.management._generated.operations.NamespaceOperations
    :param endpoint: The Service Bus fully qualified domain name. Required.
    :type endpoint: str
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :keyword api_version: Api Version. Default value is "2021-05". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    """

    def __init__(self, endpoint: str, credential: "TokenCredential", **kwargs: Any) -> None:
        _endpoint = "https://{endpoint}"
        self._config = ServiceBusManagementClientConfiguration(endpoint=endpoint, credential=credential, **kwargs)
        self._client: PipelineClient = PipelineClient(base_url=_endpoint, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.entity = EntityOperations(self._client, self._config, self._serialize, self._deserialize)
        self.subscription = SubscriptionOperations(self._client, self._config, self._serialize, self._deserialize)
        self.rule = RuleOperations(self._client, self._config, self._serialize, self._deserialize)
        self.namespace = NamespaceOperations(self._client, self._config, self._serialize, self._deserialize)

    def send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client.send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        request_copy.url = self._client.format_url(request_copy.url, **path_format_arguments)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "ServiceBusManagementClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
