# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.servicefabricmanagedclusters import ServiceFabricManagedClustersManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-servicefabricmanagedclusters
# USAGE
    python application_put_operation_example_max.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ServiceFabricManagedClustersManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.applications.begin_create_or_update(
        resource_group_name="resRg",
        cluster_name="myCluster",
        application_name="myApp",
        parameters={
            "location": "eastus",
            "properties": {
                "parameters": {"param1": "value1"},
                "upgradePolicy": {
                    "applicationHealthPolicy": {
                        "considerWarningAsError": True,
                        "defaultServiceTypeHealthPolicy": {
                            "maxPercentUnhealthyPartitionsPerService": 0,
                            "maxPercentUnhealthyReplicasPerPartition": 0,
                            "maxPercentUnhealthyServices": 0,
                        },
                        "maxPercentUnhealthyDeployedApplications": 0,
                        "serviceTypeHealthPolicyMap": {
                            "myService": {
                                "maxPercentUnhealthyPartitionsPerService": 30,
                                "maxPercentUnhealthyReplicasPerPartition": 30,
                                "maxPercentUnhealthyServices": 30,
                            }
                        },
                    },
                    "forceRestart": False,
                    "instanceCloseDelayDuration": 600,
                    "recreateApplication": False,
                    "rollingUpgradeMonitoringPolicy": {
                        "failureAction": "Rollback",
                        "healthCheckRetryTimeout": "00:10:00",
                        "healthCheckStableDuration": "00:05:00",
                        "healthCheckWaitDuration": "00:02:00",
                        "upgradeDomainTimeout": "00:15:00",
                        "upgradeTimeout": "01:00:00",
                    },
                    "upgradeMode": "UnmonitoredAuto",
                    "upgradeReplicaSetCheckTimeout": 3600,
                },
                "version": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0",
            },
            "tags": {"a": "b"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/servicefabricmanagedclusters/resource-manager/Microsoft.ServiceFabric/preview/2023-02-01-preview/examples/ApplicationPutOperation_example_max.json
if __name__ == "__main__":
    main()
