# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._endpoints_operations import (
    build_create_or_update_request,
    build_delete_request,
    build_get_request,
    build_list_credentials_request,
    build_list_ingress_gateway_credentials_request,
    build_list_managed_proxy_details_request,
    build_list_request,
    build_update_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class EndpointsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.hybridconnectivity.aio.HybridConnectivityMgmtClient`'s
        :attr:`endpoints` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, resource_uri: str, **kwargs: Any) -> AsyncIterable["_models.EndpointResource"]:
        """List of endpoints to the target resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either EndpointResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.hybridconnectivity.models.EndpointResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.EndpointsList] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    resource_uri=resource_uri,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("EndpointsList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {"url": "/{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints"}

    @distributed_trace_async
    async def get(self, resource_uri: str, endpoint_name: str, **kwargs: Any) -> _models.EndpointResource:
        """Gets the endpoint to the resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EndpointResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.EndpointResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.EndpointResource] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_uri=resource_uri,
            endpoint_name=endpoint_name,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("EndpointResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}"}

    @overload
    async def create_or_update(
        self,
        resource_uri: str,
        endpoint_name: str,
        endpoint_resource: _models.EndpointResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EndpointResource:
        """Create or update the endpoint to the target resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param endpoint_resource: Endpoint details. Required.
        :type endpoint_resource: ~azure.mgmt.hybridconnectivity.models.EndpointResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EndpointResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.EndpointResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_uri: str,
        endpoint_name: str,
        endpoint_resource: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EndpointResource:
        """Create or update the endpoint to the target resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param endpoint_resource: Endpoint details. Required.
        :type endpoint_resource: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EndpointResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.EndpointResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_uri: str,
        endpoint_name: str,
        endpoint_resource: Union[_models.EndpointResource, IO],
        **kwargs: Any
    ) -> _models.EndpointResource:
        """Create or update the endpoint to the target resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param endpoint_resource: Endpoint details. Is either a EndpointResource type or a IO type.
         Required.
        :type endpoint_resource: ~azure.mgmt.hybridconnectivity.models.EndpointResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EndpointResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.EndpointResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EndpointResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(endpoint_resource, (IOBase, bytes)):
            _content = endpoint_resource
        else:
            _json = self._serialize.body(endpoint_resource, "EndpointResource")

        request = build_create_or_update_request(
            resource_uri=resource_uri,
            endpoint_name=endpoint_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("EndpointResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {
        "url": "/{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}"
    }

    @overload
    async def update(
        self,
        resource_uri: str,
        endpoint_name: str,
        endpoint_resource: _models.EndpointResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EndpointResource:
        """Update the endpoint to the target resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param endpoint_resource: Endpoint details. Required.
        :type endpoint_resource: ~azure.mgmt.hybridconnectivity.models.EndpointResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EndpointResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.EndpointResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_uri: str,
        endpoint_name: str,
        endpoint_resource: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EndpointResource:
        """Update the endpoint to the target resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param endpoint_resource: Endpoint details. Required.
        :type endpoint_resource: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EndpointResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.EndpointResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_uri: str,
        endpoint_name: str,
        endpoint_resource: Union[_models.EndpointResource, IO],
        **kwargs: Any
    ) -> _models.EndpointResource:
        """Update the endpoint to the target resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param endpoint_resource: Endpoint details. Is either a EndpointResource type or a IO type.
         Required.
        :type endpoint_resource: ~azure.mgmt.hybridconnectivity.models.EndpointResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EndpointResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.EndpointResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EndpointResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(endpoint_resource, (IOBase, bytes)):
            _content = endpoint_resource
        else:
            _json = self._serialize.body(endpoint_resource, "EndpointResource")

        request = build_update_request(
            resource_uri=resource_uri,
            endpoint_name=endpoint_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("EndpointResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {"url": "/{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}"}

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_uri: str, endpoint_name: str, **kwargs: Any
    ) -> None:
        """Deletes the endpoint access to the target resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_uri=resource_uri,
            endpoint_name=endpoint_name,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {"url": "/{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}"}

    @overload
    async def list_credentials(
        self,
        resource_uri: str,
        endpoint_name: str,
        expiresin: int = 10800,
        list_credentials_request: Optional[_models.ListCredentialsRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EndpointAccessResource:
        """Gets the endpoint access credentials to the resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param expiresin: The is how long the endpoint access token is valid (in seconds). Default
         value is 10800.
        :type expiresin: int
        :param list_credentials_request: Object of type ListCredentialsRequest. Default value is None.
        :type list_credentials_request: ~azure.mgmt.hybridconnectivity.models.ListCredentialsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EndpointAccessResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.EndpointAccessResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_credentials(
        self,
        resource_uri: str,
        endpoint_name: str,
        expiresin: int = 10800,
        list_credentials_request: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EndpointAccessResource:
        """Gets the endpoint access credentials to the resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param expiresin: The is how long the endpoint access token is valid (in seconds). Default
         value is 10800.
        :type expiresin: int
        :param list_credentials_request: Object of type ListCredentialsRequest. Default value is None.
        :type list_credentials_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EndpointAccessResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.EndpointAccessResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_credentials(
        self,
        resource_uri: str,
        endpoint_name: str,
        expiresin: int = 10800,
        list_credentials_request: Optional[Union[_models.ListCredentialsRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.EndpointAccessResource:
        """Gets the endpoint access credentials to the resource.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param expiresin: The is how long the endpoint access token is valid (in seconds). Default
         value is 10800.
        :type expiresin: int
        :param list_credentials_request: Object of type ListCredentialsRequest. Is either a
         ListCredentialsRequest type or a IO type. Default value is None.
        :type list_credentials_request: ~azure.mgmt.hybridconnectivity.models.ListCredentialsRequest or
         IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EndpointAccessResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.EndpointAccessResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EndpointAccessResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(list_credentials_request, (IOBase, bytes)):
            _content = list_credentials_request
        else:
            if list_credentials_request is not None:
                _json = self._serialize.body(list_credentials_request, "ListCredentialsRequest")
            else:
                _json = None

        request = build_list_credentials_request(
            resource_uri=resource_uri,
            endpoint_name=endpoint_name,
            expiresin=expiresin,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_credentials.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("EndpointAccessResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_credentials.metadata = {
        "url": "/{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}/listCredentials"
    }

    @overload
    async def list_ingress_gateway_credentials(
        self,
        resource_uri: str,
        endpoint_name: str,
        expiresin: int = 10800,
        list_ingress_gateway_credentials_request: Optional[_models.ListIngressGatewayCredentialsRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IngressGatewayResource:
        """Gets the ingress gateway endpoint credentials.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param expiresin: The is how long the endpoint access token is valid (in seconds). Default
         value is 10800.
        :type expiresin: int
        :param list_ingress_gateway_credentials_request: Object of type
         ListIngressGatewayCredentialsRequest. Default value is None.
        :type list_ingress_gateway_credentials_request:
         ~azure.mgmt.hybridconnectivity.models.ListIngressGatewayCredentialsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IngressGatewayResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.IngressGatewayResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_ingress_gateway_credentials(
        self,
        resource_uri: str,
        endpoint_name: str,
        expiresin: int = 10800,
        list_ingress_gateway_credentials_request: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IngressGatewayResource:
        """Gets the ingress gateway endpoint credentials.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param expiresin: The is how long the endpoint access token is valid (in seconds). Default
         value is 10800.
        :type expiresin: int
        :param list_ingress_gateway_credentials_request: Object of type
         ListIngressGatewayCredentialsRequest. Default value is None.
        :type list_ingress_gateway_credentials_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IngressGatewayResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.IngressGatewayResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_ingress_gateway_credentials(
        self,
        resource_uri: str,
        endpoint_name: str,
        expiresin: int = 10800,
        list_ingress_gateway_credentials_request: Optional[
            Union[_models.ListIngressGatewayCredentialsRequest, IO]
        ] = None,
        **kwargs: Any
    ) -> _models.IngressGatewayResource:
        """Gets the ingress gateway endpoint credentials.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param expiresin: The is how long the endpoint access token is valid (in seconds). Default
         value is 10800.
        :type expiresin: int
        :param list_ingress_gateway_credentials_request: Object of type
         ListIngressGatewayCredentialsRequest. Is either a ListIngressGatewayCredentialsRequest type or
         a IO type. Default value is None.
        :type list_ingress_gateway_credentials_request:
         ~azure.mgmt.hybridconnectivity.models.ListIngressGatewayCredentialsRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IngressGatewayResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.IngressGatewayResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IngressGatewayResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(list_ingress_gateway_credentials_request, (IOBase, bytes)):
            _content = list_ingress_gateway_credentials_request
        else:
            if list_ingress_gateway_credentials_request is not None:
                _json = self._serialize.body(
                    list_ingress_gateway_credentials_request, "ListIngressGatewayCredentialsRequest"
                )
            else:
                _json = None

        request = build_list_ingress_gateway_credentials_request(
            resource_uri=resource_uri,
            endpoint_name=endpoint_name,
            expiresin=expiresin,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_ingress_gateway_credentials.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("IngressGatewayResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_ingress_gateway_credentials.metadata = {
        "url": "/{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}/listIngressGatewayCredentials"
    }

    @overload
    async def list_managed_proxy_details(
        self,
        resource_uri: str,
        endpoint_name: str,
        managed_proxy_request: _models.ManagedProxyRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ManagedProxyResource:
        """Fetches the managed proxy details.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param managed_proxy_request: Object of type ManagedProxyRequest. Required.
        :type managed_proxy_request: ~azure.mgmt.hybridconnectivity.models.ManagedProxyRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagedProxyResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.ManagedProxyResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_managed_proxy_details(
        self,
        resource_uri: str,
        endpoint_name: str,
        managed_proxy_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ManagedProxyResource:
        """Fetches the managed proxy details.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param managed_proxy_request: Object of type ManagedProxyRequest. Required.
        :type managed_proxy_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagedProxyResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.ManagedProxyResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_managed_proxy_details(
        self,
        resource_uri: str,
        endpoint_name: str,
        managed_proxy_request: Union[_models.ManagedProxyRequest, IO],
        **kwargs: Any
    ) -> _models.ManagedProxyResource:
        """Fetches the managed proxy details.

        :param resource_uri: The fully qualified Azure Resource manager identifier of the resource to
         be connected. Required.
        :type resource_uri: str
        :param endpoint_name: The endpoint name. Required.
        :type endpoint_name: str
        :param managed_proxy_request: Object of type ManagedProxyRequest. Is either a
         ManagedProxyRequest type or a IO type. Required.
        :type managed_proxy_request: ~azure.mgmt.hybridconnectivity.models.ManagedProxyRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagedProxyResource or the result of cls(response)
        :rtype: ~azure.mgmt.hybridconnectivity.models.ManagedProxyResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ManagedProxyResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(managed_proxy_request, (IOBase, bytes)):
            _content = managed_proxy_request
        else:
            _json = self._serialize.body(managed_proxy_request, "ManagedProxyRequest")

        request = build_list_managed_proxy_details_request(
            resource_uri=resource_uri,
            endpoint_name=endpoint_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_managed_proxy_details.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ManagedProxyResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_managed_proxy_details.metadata = {
        "url": "/{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}/listManagedProxyDetails"
    }
