# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicenetworking.aio import ServiceNetworkingMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceNetworkingMgmtTrafficControllerInterfaceOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceNetworkingMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_traffic_controller_interface_get(self, resource_group):
        response = await self.client.traffic_controller_interface.get(
            resource_group_name=resource_group.name,
            traffic_controller_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_traffic_controller_interface_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.traffic_controller_interface.begin_create_or_update(
                resource_group_name=resource_group.name,
                traffic_controller_name="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "associations": [{"id": "str"}],
                        "configurationEndpoints": ["str"],
                        "frontends": [{"id": "str"}],
                        "provisioningState": "str",
                        "securityPolicies": [{"id": "str"}],
                        "securityPolicyConfigurations": {"wafSecurityPolicy": {"id": "str"}},
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_traffic_controller_interface_update(self, resource_group):
        response = await self.client.traffic_controller_interface.update(
            resource_group_name=resource_group.name,
            traffic_controller_name="str",
            properties={
                "properties": {"securityPolicyConfigurations": {"wafSecurityPolicy": {"id": "str"}}},
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_traffic_controller_interface_begin_delete(self, resource_group):
        response = await (
            await self.client.traffic_controller_interface.begin_delete(
                resource_group_name=resource_group.name,
                traffic_controller_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_traffic_controller_interface_list_by_resource_group(self, resource_group):
        response = self.client.traffic_controller_interface.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_traffic_controller_interface_list_by_subscription(self, resource_group):
        response = self.client.traffic_controller_interface.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
