# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementServersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_check_name_availability(self, resource_group):
        response = self.client.servers.check_name_availability(
            parameters={"name": "str", "type": "Microsoft.Sql/servers"},
            api_version="2023-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.servers.list(
            api_version="2023-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.servers.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.servers.get(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2023-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.servers.begin_create_or_update(
            resource_group_name=resource_group.name,
            server_name="str",
            parameters={
                "location": "str",
                "administratorLogin": "str",
                "administratorLoginPassword": "str",
                "administrators": {
                    "administratorType": "str",
                    "azureADOnlyAuthentication": bool,
                    "login": "str",
                    "principalType": "str",
                    "sid": "str",
                    "tenantId": "str",
                },
                "externalGovernanceStatus": "str",
                "federatedClientId": "str",
                "fullyQualifiedDomainName": "str",
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "isIPv6Enabled": "str",
                "keyId": "str",
                "kind": "str",
                "minimalTlsVersion": "str",
                "name": "str",
                "primaryUserAssignedIdentityId": "str",
                "privateEndpointConnections": [
                    {
                        "id": "str",
                        "properties": {
                            "groupIds": ["str"],
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "description": "str",
                                "status": "str",
                                "actionsRequired": "str",
                            },
                            "provisioningState": "str",
                        },
                    }
                ],
                "publicNetworkAccess": "str",
                "restrictOutboundNetworkAccess": "str",
                "state": "str",
                "tags": {"str": "str"},
                "type": "str",
                "version": "str",
                "workspaceFeature": "str",
            },
            api_version="2023-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.servers.begin_delete(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2023-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update(self, resource_group):
        response = self.client.servers.begin_update(
            resource_group_name=resource_group.name,
            server_name="str",
            parameters={
                "administratorLogin": "str",
                "administratorLoginPassword": "str",
                "administrators": {
                    "administratorType": "str",
                    "azureADOnlyAuthentication": bool,
                    "login": "str",
                    "principalType": "str",
                    "sid": "str",
                    "tenantId": "str",
                },
                "externalGovernanceStatus": "str",
                "federatedClientId": "str",
                "fullyQualifiedDomainName": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "isIPv6Enabled": "str",
                "keyId": "str",
                "minimalTlsVersion": "str",
                "primaryUserAssignedIdentityId": "str",
                "privateEndpointConnections": [
                    {
                        "id": "str",
                        "properties": {
                            "groupIds": ["str"],
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "description": "str",
                                "status": "str",
                                "actionsRequired": "str",
                            },
                            "provisioningState": "str",
                        },
                    }
                ],
                "publicNetworkAccess": "str",
                "restrictOutboundNetworkAccess": "str",
                "state": "str",
                "tags": {"str": "str"},
                "version": "str",
                "workspaceFeature": "str",
            },
            api_version="2023-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_import_database(self, resource_group):
        response = self.client.servers.begin_import_database(
            resource_group_name=resource_group.name,
            server_name="str",
            parameters={
                "administratorLogin": "str",
                "administratorLoginPassword": "str",
                "storageKey": "str",
                "storageKeyType": "str",
                "storageUri": "str",
                "authenticationType": "str",
                "databaseName": "str",
                "edition": "str",
                "maxSizeBytes": "str",
                "networkIsolation": {"sqlServerResourceId": "str", "storageAccountResourceId": "str"},
                "serviceObjectiveName": "str",
            },
            api_version="2023-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_refresh_status(self, resource_group):
        response = self.client.servers.begin_refresh_status(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2023-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
