# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.communication import CommunicationServiceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCommunicationServiceManagementEmailServicesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CommunicationServiceManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_email_services_get(self, resource_group):
        response = self.client.email_services.get(
            resource_group_name=resource_group.name,
            email_service_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_email_services_begin_create_or_update(self, resource_group):
        response = self.client.email_services.begin_create_or_update(
            resource_group_name=resource_group.name,
            email_service_name="str",
            parameters={
                "location": "str",
                "dataLocation": "str",
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_email_services_begin_delete(self, resource_group):
        response = self.client.email_services.begin_delete(
            resource_group_name=resource_group.name,
            email_service_name="str",
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_email_services_begin_update(self, resource_group):
        response = self.client.email_services.begin_update(
            resource_group_name=resource_group.name,
            email_service_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_email_services_list_by_subscription(self, resource_group):
        response = self.client.email_services.list_by_subscription(
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_email_services_list_by_resource_group(self, resource_group):
        response = self.client.email_services.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_email_services_list_verified_exchange_online_domains(self, resource_group):
        response = self.client.email_services.list_verified_exchange_online_domains(
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...
